/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.java.TypeVariableResolver;

public class TypeVariableResolverFromOuters
implements TypeVariableResolver {
    @NotNull
    private final DeclarationDescriptor outer;

    public TypeVariableResolverFromOuters(@NotNull DeclarationDescriptor outer) {
        this.outer = outer;
    }

    @Override
    @NotNull
    public TypeParameterDescriptor getTypeVariable(@NotNull String name) {
        DeclarationDescriptor outer = this.outer;
        while (true) {
            if (outer instanceof NamespaceDescriptor) {
                throw new IllegalStateException("unresolve type parameter: " + name);
            }
            if (!(outer instanceof ClassDescriptor)) break;
            for (TypeParameterDescriptor typeParameter : ((ClassDescriptor)outer).getTypeConstructor().getParameters()) {
                if (!typeParameter.getName().equals(name)) continue;
                return typeParameter;
            }
            outer = outer.getContainingDeclaration();
        }
        throw new IllegalStateException("unknown outer: " + outer.getClass().getName());
    }
}

