/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiType;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.PsiMemberWrapper;
import org.jetbrains.jet.lang.resolve.java.PsiParameterWrapper;
import org.jetbrains.jet.lang.resolve.java.kt.JetConstructorAnnotation;
import org.jetbrains.jet.lang.resolve.java.kt.JetMethodAnnotation;

public class PsiMethodWrapper
extends PsiMemberWrapper {
    private List<PsiParameterWrapper> parameters;
    private JetMethodAnnotation jetMethod;
    private JetConstructorAnnotation jetConstructor;

    public PsiMethodWrapper(@NotNull PsiMethod psiMethod) {
        super((PsiMember)psiMethod);
    }

    @NotNull
    public List<PsiParameterWrapper> getParameters() {
        if (this.parameters == null) {
            PsiParameter[] psiParameters = this.getPsiMethod().getParameterList().getParameters();
            this.parameters = new ArrayList<PsiParameterWrapper>(psiParameters.length);
            for (int i = 0; i < psiParameters.length; ++i) {
                this.parameters.add(new PsiParameterWrapper(psiParameters[i]));
            }
        }
        return this.parameters;
    }

    @NotNull
    public PsiParameterWrapper getParameter(int i) {
        return this.getParameters().get(i);
    }

    @NotNull
    public JetMethodAnnotation getJetMethod() {
        if (this.jetMethod == null) {
            this.jetMethod = JetMethodAnnotation.get(this.getPsiMethod());
        }
        return this.jetMethod;
    }

    @NotNull
    public JetConstructorAnnotation getJetConstructor() {
        if (this.jetConstructor == null) {
            this.jetConstructor = JetConstructorAnnotation.get(this.getPsiMethod());
        }
        return this.jetConstructor;
    }

    public boolean isAbstract() {
        return this.psiMember.hasModifierProperty("abstract");
    }

    @NotNull
    public PsiMethod getPsiMethod() {
        return (PsiMethod)this.psiMember;
    }

    @Nullable
    public PsiType getReturnType() {
        return this.getPsiMethod().getReturnType();
    }
}

