/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.java.PsiFieldWrapper;
import org.jetbrains.jet.lang.resolve.java.PsiMethodWrapper;
import org.jetbrains.jet.lang.resolve.java.kt.JetClassAnnotation;

public class PsiClassWrapper {
    @NotNull
    private final PsiClass psiClass;
    private List<PsiMethodWrapper> ownMethods;
    private List<PsiFieldWrapper> ownFields;
    private JetClassAnnotation jetClass;

    public PsiClassWrapper(@NotNull PsiClass psiClass) {
        this.psiClass = psiClass;
    }

    @NotNull
    public List<PsiMethodWrapper> getOwnMethods() {
        if (this.ownMethods == null) {
            PsiMethod[] psiMethods = this.psiClass.getMethods();
            ArrayList<PsiMethodWrapper> methods = new ArrayList<PsiMethodWrapper>(psiMethods.length);
            for (PsiMethod psiMethod : psiMethods) {
                if (psiMethod.getContainingClass() != this.psiClass) continue;
                methods.add(new PsiMethodWrapper(psiMethod));
            }
            this.ownMethods = methods;
        }
        return this.ownMethods;
    }

    @NotNull
    public List<PsiFieldWrapper> getOwnFields() {
        if (this.ownFields == null) {
            PsiField[] psiFields = this.psiClass.getFields();
            ArrayList<PsiFieldWrapper> fields = new ArrayList<PsiFieldWrapper>(psiFields.length);
            for (PsiField psiField : psiFields) {
                if (psiField.getContainingClass() != this.psiClass) continue;
                fields.add(new PsiFieldWrapper((PsiMember)psiField));
            }
            this.ownFields = fields;
        }
        return this.ownFields;
    }

    public String getQualifiedName() {
        return this.psiClass.getQualifiedName();
    }

    @NotNull
    public PsiClass getPsiClass() {
        return this.psiClass;
    }

    @NotNull
    public JetClassAnnotation getJetClass() {
        if (this.jetClass == null) {
            this.jetClass = JetClassAnnotation.get(this.psiClass);
        }
        return this.jetClass;
    }
}

