/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.resolve.java.PsiFieldWrapper;
import org.jetbrains.jet.lang.resolve.java.PsiMemberWrapper;
import org.jetbrains.jet.lang.resolve.java.PsiMethodWrapper;
import org.jetbrains.jet.lang.resolve.java.TypeSource;

class PropertyAccessorData {
    @NotNull
    private final PsiMemberWrapper member;
    private final boolean getter;
    @NotNull
    private final TypeSource type;
    @Nullable
    private final TypeSource receiverType;

    PropertyAccessorData(@NotNull PsiMethodWrapper method, boolean getter, @NotNull TypeSource type, @Nullable TypeSource receiverType) {
        this.member = method;
        this.type = type;
        this.receiverType = receiverType;
        this.getter = getter;
    }

    PropertyAccessorData(@NotNull PsiFieldWrapper field, @NotNull TypeSource type, @Nullable TypeSource receiverType) {
        this.member = field;
        this.type = type;
        this.receiverType = receiverType;
        this.getter = false;
    }

    @NotNull
    public PsiMemberWrapper getMember() {
        return this.member;
    }

    @NotNull
    public TypeSource getType() {
        return this.type;
    }

    @Nullable
    public TypeSource getReceiverType() {
        return this.receiverType;
    }

    public boolean isGetter() {
        return this.member instanceof PsiMethodWrapper && this.getter;
    }

    public boolean isSetter() {
        return this.member instanceof PsiMethodWrapper && !this.getter;
    }

    public boolean isField() {
        return this.member instanceof PsiFieldWrapper;
    }
}

