/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import org.jetbrains.annotations.NotNull;
import org.objectweb.asm.Type;

public class JvmClassName {
    private final String fqName;
    private String internalName;
    private String descriptor;
    private Type asmType;

    public JvmClassName(@NotNull String fqName) {
        this.fqName = fqName;
    }

    public static JvmClassName byInternalName(@NotNull String internalName) {
        JvmClassName r = new JvmClassName(internalName.replace('/', '.'));
        r.internalName = internalName;
        return r;
    }

    public String getFqName() {
        return this.fqName;
    }

    public String getInternalName() {
        if (this.internalName == null) {
            String descriptor = this.getDescriptor();
            this.internalName = descriptor.substring(1, descriptor.length() - 1);
        }
        return this.internalName;
    }

    public String getDescriptor() {
        if (this.descriptor == null) {
            StringBuilder sb = new StringBuilder(this.fqName.length() + 2);
            sb.append('L');
            sb.append(this.fqName.replace('.', '/'));
            sb.append(';');
            this.descriptor = sb.toString();
        }
        return this.descriptor;
    }

    public Type getAsmType() {
        if (this.asmType == null) {
            this.asmType = Type.getType((String)this.getDescriptor());
        }
        return this.asmType;
    }
}

