/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.JavaSemanticServices;
import org.jetbrains.jet.lang.resolve.java.JvmPrimitiveType;
import org.jetbrains.jet.lang.resolve.java.TypeVariableResolver;
import org.jetbrains.jet.lang.types.JetStandardClasses;
import org.jetbrains.jet.lang.types.JetStandardLibrary;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.rt.signature.JetSignatureExceptionsAdapter;
import org.jetbrains.jet.rt.signature.JetSignatureVariance;
import org.jetbrains.jet.rt.signature.JetSignatureVisitor;

public abstract class JetTypeJetSignatureReader
extends JetSignatureExceptionsAdapter {
    private final JavaSemanticServices javaSemanticServices;
    private final JavaDescriptorResolver javaDescriptorResolver;
    private final JetStandardLibrary jetStandardLibrary;
    private final TypeVariableResolver typeVariableResolver;
    private ClassDescriptor classDescriptor;
    private boolean nullable;
    private List<TypeProjection> typeArguments;

    public JetTypeJetSignatureReader(JavaSemanticServices javaSemanticServices, JetStandardLibrary jetStandardLibrary, TypeVariableResolver typeVariableResolver) {
        this.javaSemanticServices = javaSemanticServices;
        this.javaDescriptorResolver = javaSemanticServices.getDescriptorResolver();
        this.jetStandardLibrary = jetStandardLibrary;
        this.typeVariableResolver = typeVariableResolver;
    }

    private JetType getPrimitiveType(char descriptor, boolean nullable) {
        if (!nullable) {
            for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
                if (jvmPrimitiveType.getJvmLetter() != descriptor) continue;
                return this.jetStandardLibrary.getPrimitiveJetType(jvmPrimitiveType.getPrimitiveType());
            }
            if (descriptor == 'V') {
                return JetStandardClasses.getUnitType();
            }
        } else {
            for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
                if (jvmPrimitiveType.getJvmLetter() != descriptor) continue;
                return this.jetStandardLibrary.getNullablePrimitiveJetType(jvmPrimitiveType.getPrimitiveType());
            }
            if (descriptor == 'V') {
                throw new IllegalStateException("incorrect signature: nullable void");
            }
        }
        throw new IllegalStateException("incorrect signature");
    }

    public void visitBaseType(char descriptor, boolean nullable) {
        this.done(this.getPrimitiveType(descriptor, nullable));
    }

    public void visitClassType(String name, boolean nullable, boolean forceReal) {
        Matcher matcher;
        String ourName = name.replace('/', '.');
        this.classDescriptor = null;
        if (this.classDescriptor == null && !forceReal) {
            this.classDescriptor = this.javaSemanticServices.getTypeTransformer().getPrimitiveWrappersClassDescriptorMap().get(ourName);
        }
        if (this.classDescriptor == null && ourName.equals("java.lang.Object") && !forceReal) {
            this.classDescriptor = JetStandardClasses.getAny();
        }
        if (this.classDescriptor == null && (matcher = Pattern.compile("jet\\.Function(\\d+)").matcher(ourName)).matches()) {
            this.classDescriptor = JetStandardClasses.getFunction(Integer.parseInt(matcher.group(1)));
        }
        if (this.classDescriptor == null && (matcher = Pattern.compile("jet\\.Tuple(\\d+)").matcher(ourName)).matches()) {
            this.classDescriptor = JetStandardClasses.getTuple(Integer.parseInt(matcher.group(1)));
        }
        if (this.classDescriptor == null) {
            this.classDescriptor = this.javaDescriptorResolver.resolveClass(ourName);
        }
        if (this.classDescriptor == null) {
            throw new IllegalStateException("class not found by name: " + ourName);
        }
        this.nullable = nullable;
        this.typeArguments = new ArrayList<TypeProjection>();
    }

    private static Variance parseVariance(JetSignatureVariance variance) {
        switch (variance) {
            case INVARIANT: {
                return Variance.INVARIANT;
            }
            case OUT: {
                return Variance.OUT_VARIANCE;
            }
            case IN: {
                return Variance.IN_VARIANCE;
            }
        }
        throw new IllegalStateException();
    }

    public JetSignatureVisitor visitTypeArgument(final JetSignatureVariance variance) {
        return new JetTypeJetSignatureReader(this.javaSemanticServices, this.jetStandardLibrary, this.typeVariableResolver){

            @Override
            protected void done(@NotNull JetType jetType) {
                JetTypeJetSignatureReader.this.typeArguments.add(new TypeProjection(JetTypeJetSignatureReader.parseVariance(variance), jetType));
            }
        };
    }

    public JetSignatureVisitor visitArrayType(final boolean nullable) {
        return new JetTypeJetSignatureReader(this.javaSemanticServices, this.jetStandardLibrary, this.typeVariableResolver){

            @Override
            public void visitBaseType(char descriptor, boolean nullable2) {
                JetType primitiveType = JetTypeJetSignatureReader.this.getPrimitiveType(descriptor, nullable2);
                JetType arrayType = !nullable2 ? JetTypeJetSignatureReader.this.jetStandardLibrary.getPrimitiveArrayJetTypeByPrimitiveJetType(primitiveType) : TypeUtils.makeNullableAsSpecified(JetTypeJetSignatureReader.this.jetStandardLibrary.getArrayType(primitiveType), nullable2);
                JetTypeJetSignatureReader.this.done(arrayType);
            }

            @Override
            protected void done(@NotNull JetType jetType) {
                JetType arrayType = TypeUtils.makeNullableAsSpecified(JetTypeJetSignatureReader.this.jetStandardLibrary.getArrayType(jetType), nullable);
                JetTypeJetSignatureReader.this.done(arrayType);
            }
        };
    }

    public void visitTypeVariable(String name, boolean nullable) {
        JetType r = TypeUtils.makeNullableAsSpecified(this.typeVariableResolver.getTypeVariable(name).getDefaultType(), nullable);
        this.done(r);
    }

    public void visitEnd() {
        JetTypeImpl jetType = new JetTypeImpl(Collections.<AnnotationDescriptor>emptyList(), this.classDescriptor.getTypeConstructor(), this.nullable, this.typeArguments, this.classDescriptor.getMemberScope(this.typeArguments));
        this.done(jetType);
    }

    protected abstract void done(@NotNull JetType var1);
}

