/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.google.common.collect.Lists;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.PsiWildcardType;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.JavaSemanticServices;
import org.jetbrains.jet.lang.resolve.java.JetTypeJetSignatureReader;
import org.jetbrains.jet.lang.resolve.java.JvmPrimitiveType;
import org.jetbrains.jet.lang.resolve.java.TypeVariableResolver;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetStandardClasses;
import org.jetbrains.jet.lang.types.JetStandardLibrary;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.JetTypeImpl;
import org.jetbrains.jet.lang.types.PrimitiveType;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.rt.signature.JetSignatureReader;
import org.jetbrains.jet.rt.signature.JetSignatureVisitor;

public class JavaTypeTransformer {
    private final JavaSemanticServices javaSemanticServices;
    private final JavaDescriptorResolver resolver;
    private final JetStandardLibrary standardLibrary;
    private Map<String, JetType> primitiveTypesMap;
    private Map<String, JetType> classTypesMap;
    private Map<String, ClassDescriptor> classDescriptorMap;

    public JavaTypeTransformer(JavaSemanticServices javaSemanticServices, JetStandardLibrary standardLibrary, JavaDescriptorResolver resolver) {
        this.javaSemanticServices = javaSemanticServices;
        this.resolver = resolver;
        this.standardLibrary = standardLibrary;
    }

    @NotNull
    public TypeProjection transformToTypeProjection(@NotNull PsiType javaType, final @NotNull TypeParameterDescriptor typeParameterDescriptor, final @NotNull TypeVariableResolver typeVariableByPsiResolver) {
        TypeProjection result = (TypeProjection)javaType.accept((PsiTypeVisitor)new PsiTypeVisitor<TypeProjection>(){

            public TypeProjection visitCapturedWildcardType(PsiCapturedWildcardType capturedWildcardType) {
                throw new UnsupportedOperationException();
            }

            public TypeProjection visitWildcardType(PsiWildcardType wildcardType) {
                if (!wildcardType.isBounded()) {
                    return TypeUtils.makeStarProjection(typeParameterDescriptor);
                }
                Variance variance = wildcardType.isExtends() ? Variance.OUT_VARIANCE : Variance.IN_VARIANCE;
                PsiType bound = wildcardType.getBound();
                assert (bound != null);
                return new TypeProjection(variance, JavaTypeTransformer.this.transformToType(bound, typeVariableByPsiResolver));
            }

            public TypeProjection visitType(PsiType type) {
                return new TypeProjection(JavaTypeTransformer.this.transformToType(type, typeVariableByPsiResolver));
            }
        });
        return result;
    }

    @NotNull
    public JetType transformToType(@NotNull String kotlinSignature, TypeVariableResolver typeVariableResolver) {
        final JetType[] r = new JetType[1];
        JetTypeJetSignatureReader reader = new JetTypeJetSignatureReader(this.javaSemanticServices, this.standardLibrary, typeVariableResolver){

            @Override
            protected void done(@NotNull JetType jetType) {
                r[0] = jetType;
            }
        };
        new JetSignatureReader(kotlinSignature).acceptType((JetSignatureVisitor)reader);
        return r[0];
    }

    @NotNull
    public JetType transformToType(@NotNull PsiType javaType, final @NotNull TypeVariableResolver typeVariableResolver) {
        return (JetType)javaType.accept((PsiTypeVisitor)new PsiTypeVisitor<JetType>(){

            public JetType visitClassType(PsiClassType classType) {
                PsiClassType.ClassResolveResult classResolveResult = classType.resolveGenerics();
                PsiClass psiClass = classResolveResult.getElement();
                if (psiClass == null) {
                    return ErrorUtils.createErrorType("Unresolved java class: " + classType.getPresentableText());
                }
                if (psiClass instanceof PsiTypeParameter) {
                    PsiTypeParameter typeParameter = (PsiTypeParameter)psiClass;
                    TypeParameterDescriptor typeParameterDescriptor = typeVariableResolver.getTypeVariable(typeParameter.getName());
                    return typeParameterDescriptor.getDefaultType();
                }
                JetType jetAnalog = JavaTypeTransformer.this.getClassTypesMap().get(psiClass.getQualifiedName());
                if (jetAnalog != null) {
                    return jetAnalog;
                }
                JavaDescriptorResolver.ResolverClassData classData = JavaTypeTransformer.this.resolver.resolveClassData(psiClass);
                if (classData == null) {
                    return ErrorUtils.createErrorType("Unresolve java class: " + classType.getPresentableText());
                }
                ArrayList arguments = Lists.newArrayList();
                if (classType.isRaw()) {
                    List<TypeParameterDescriptor> parameters = classData.getClassDescriptor().getTypeConstructor().getParameters();
                    for (TypeParameterDescriptor parameter : parameters) {
                        arguments.add(TypeUtils.makeStarProjection(parameter));
                    }
                } else {
                    List<TypeParameterDescriptor> parameters = classData.getClassDescriptor().getTypeConstructor().getParameters();
                    PsiType[] psiArguments = classType.getParameters();
                    if (parameters.size() != psiArguments.length) {
                        throw new IllegalStateException();
                    }
                    for (int i = 0; i < parameters.size(); ++i) {
                        PsiType psiArgument = psiArguments[i];
                        TypeParameterDescriptor typeParameterDescriptor = parameters.get(i);
                        arguments.add(JavaTypeTransformer.this.transformToTypeProjection(psiArgument, typeParameterDescriptor, typeVariableResolver));
                    }
                }
                return new JetTypeImpl(Collections.<AnnotationDescriptor>emptyList(), classData.getClassDescriptor().getTypeConstructor(), true, arguments, classData.getClassDescriptor().getMemberScope(arguments));
            }

            public JetType visitPrimitiveType(PsiPrimitiveType primitiveType) {
                String canonicalText = primitiveType.getCanonicalText();
                JetType type = JavaTypeTransformer.this.getPrimitiveTypesMap().get(canonicalText);
                assert (type != null) : canonicalText;
                return type;
            }

            public JetType visitArrayType(PsiArrayType arrayType) {
                JetType jetType;
                PsiType componentType = arrayType.getComponentType();
                if (componentType instanceof PsiPrimitiveType && (jetType = JavaTypeTransformer.this.getPrimitiveTypesMap().get("[" + componentType.getCanonicalText())) != null) {
                    return TypeUtils.makeNullable(jetType);
                }
                JetType type = JavaTypeTransformer.this.transformToType(componentType, typeVariableResolver);
                return TypeUtils.makeNullable(JavaTypeTransformer.this.standardLibrary.getArrayType(type));
            }

            public JetType visitType(PsiType type) {
                throw new UnsupportedOperationException("Unsupported type: " + type.getPresentableText());
            }
        });
    }

    public Map<String, JetType> getPrimitiveTypesMap() {
        if (this.primitiveTypesMap == null) {
            this.primitiveTypesMap = new HashMap<String, JetType>();
            for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
                PrimitiveType primitiveType = jvmPrimitiveType.getPrimitiveType();
                this.primitiveTypesMap.put(jvmPrimitiveType.getName(), this.standardLibrary.getPrimitiveJetType(primitiveType));
                this.primitiveTypesMap.put("[" + jvmPrimitiveType.getName(), this.standardLibrary.getPrimitiveArrayJetType(primitiveType));
                this.primitiveTypesMap.put(jvmPrimitiveType.getWrapper().getFqName(), this.standardLibrary.getNullablePrimitiveJetType(primitiveType));
            }
            this.primitiveTypesMap.put("void", JetStandardClasses.getUnitType());
        }
        return this.primitiveTypesMap;
    }

    public Map<String, JetType> getClassTypesMap() {
        if (this.classTypesMap == null) {
            this.classTypesMap = new HashMap<String, JetType>();
            for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
                PrimitiveType primitiveType = jvmPrimitiveType.getPrimitiveType();
                this.classTypesMap.put(jvmPrimitiveType.getWrapper().getFqName(), this.standardLibrary.getNullablePrimitiveJetType(primitiveType));
            }
            this.classTypesMap.put("java.lang.Object", JetStandardClasses.getNullableAnyType());
            this.classTypesMap.put("java.lang.String", this.standardLibrary.getNullableStringType());
            this.classTypesMap.put("java.lang.CharSequence", this.standardLibrary.getNullableCharSequenceType());
            this.classTypesMap.put("java.lang.Throwable", this.standardLibrary.getThrowableType());
        }
        return this.classTypesMap;
    }

    public Map<String, ClassDescriptor> getPrimitiveWrappersClassDescriptorMap() {
        if (this.classDescriptorMap == null) {
            this.classDescriptorMap = new HashMap<String, ClassDescriptor>();
            for (JvmPrimitiveType jvmPrimitiveType : JvmPrimitiveType.values()) {
                PrimitiveType primitiveType = jvmPrimitiveType.getPrimitiveType();
                this.classDescriptorMap.put(jvmPrimitiveType.getWrapper().getFqName(), this.standardLibrary.getPrimitiveClassDescriptor(primitiveType));
            }
            this.classDescriptorMap.put("java.lang.String", this.standardLibrary.getString());
            this.classDescriptorMap.put("java.lang.CharSequence", this.standardLibrary.getCharSequence());
            this.classDescriptorMap.put("java.lang.Throwable", this.standardLibrary.getThrowable());
        }
        return this.classDescriptorMap;
    }
}

