/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.intellij.openapi.project.Project;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.JetSemanticServices;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.JavaTypeTransformer;

public class JavaSemanticServices {
    private final JavaTypeTransformer typeTransformer;
    private final JavaDescriptorResolver descriptorResolver;
    private final BindingTrace trace;
    private final JetSemanticServices jetSemanticServices;

    public JavaSemanticServices(Project project, JetSemanticServices jetSemanticServices, BindingTrace trace) {
        this.trace = trace;
        this.descriptorResolver = new JavaDescriptorResolver(project, this);
        this.typeTransformer = new JavaTypeTransformer(this, jetSemanticServices.getStandardLibrary(), this.descriptorResolver);
        this.jetSemanticServices = jetSemanticServices;
    }

    @NotNull
    public JavaTypeTransformer getTypeTransformer() {
        return this.typeTransformer;
    }

    @NotNull
    public JavaDescriptorResolver getDescriptorResolver() {
        return this.descriptorResolver;
    }

    @NotNull
    public BindingTrace getTrace() {
        return this.trace;
    }

    public JetSemanticServices getJetSemanticServices() {
        return this.jetSemanticServices;
    }

    @Nullable
    public ClassDescriptor getKotlinClassDescriptor(String qualifiedName) {
        if (qualifiedName.startsWith("jet.")) {
            ClassDescriptor r = (ClassDescriptor)this.jetSemanticServices.getStandardLibrary().getLibraryScope().getClassifier(qualifiedName.substring("jet.".length()));
            if (r == null) {
                // empty if block
            }
            return r;
        }
        return this.getTrace().get(BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, qualifiedName);
    }

    @Nullable
    public NamespaceDescriptor getKotlinNamespaceDescriptor(String qualifiedName) {
        return this.getTrace().get(BindingContext.FQNAME_TO_NAMESPACE_DESCRIPTOR, qualifiedName);
    }
}

