/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.google.common.collect.Sets;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiPackage;
import java.util.Collection;
import java.util.HashSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.java.JavaClassOrPackageScope;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.JavaSemanticServices;
import org.jetbrains.jet.lang.resolve.java.PsiClassWrapper;

public class JavaPackageScope
extends JavaClassOrPackageScope {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.migration.PsiMigrationImpl");
    private final String packageFQN;
    private Collection<DeclarationDescriptor> allDescriptors;

    public JavaPackageScope(@NotNull String packageFQN, @NotNull NamespaceDescriptor containingDescriptor, @NotNull JavaSemanticServices semanticServices) {
        super(containingDescriptor, semanticServices);
        this.packageFQN = packageFQN;
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull String name) {
        return this.semanticServices.getDescriptorResolver().resolveClass(this.getQualifiedName(name));
    }

    @Override
    public ClassDescriptor getObjectDescriptor(@NotNull String name) {
        return null;
    }

    @Override
    public NamespaceDescriptor getNamespace(@NotNull String name) {
        return this.semanticServices.getDescriptorResolver().resolveNamespace(this.getQualifiedName(name));
    }

    @Override
    protected PsiClassWrapper psiClass() {
        NamespaceDescriptor kotlinNamespaceDescriptor = this.semanticServices.getKotlinNamespaceDescriptor(this.packageFQN);
        if (kotlinNamespaceDescriptor != null) {
            return null;
        }
        PsiClass psiClass = this.semanticServices.getDescriptorResolver().javaFacade.findClass(this.getQualifiedName("namespace"));
        if (psiClass == null) {
            return null;
        }
        return new PsiClassWrapper(psiClass);
    }

    @Override
    protected boolean staticMembers() {
        return true;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getAllDescriptors() {
        if (this.allDescriptors == null) {
            this.allDescriptors = Sets.newHashSet();
            PsiPackage javaPackage = this.semanticServices.getDescriptorResolver().findPackage(this.packageFQN);
            if (javaPackage != null) {
                boolean isKotlinNamespace = this.semanticServices.getKotlinNamespaceDescriptor(javaPackage.getQualifiedName()) != null;
                JavaDescriptorResolver descriptorResolver = this.semanticServices.getDescriptorResolver();
                for (PsiPackage psiPackage : javaPackage.getSubPackages()) {
                    if (this.semanticServices.getKotlinNamespaceDescriptor(psiPackage.getQualifiedName()) != null) continue;
                    this.allDescriptors.add(descriptorResolver.resolveNamespace(psiPackage.getQualifiedName()));
                }
                for (PsiPackage psiPackage : javaPackage.getClasses()) {
                    ClassDescriptor classDescriptor;
                    ClassDescriptor kotlinClassDescriptor;
                    if (isKotlinNamespace && "namespace".equals(psiPackage.getName()) || (kotlinClassDescriptor = this.semanticServices.getKotlinClassDescriptor(psiPackage.getQualifiedName())) != null) continue;
                    if ("namespace".equals(psiPackage.getName())) {
                        HashSet<String> methodNames = new HashSet<String>();
                        for (PsiMethod psiMethod : psiPackage.getMethods()) {
                            methodNames.add(psiMethod.getName());
                        }
                        for (String methodName : methodNames) {
                            try {
                                this.allDescriptors.addAll(this.getFunctions(methodName));
                            }
                            catch (ProcessCanceledException cancelException) {
                                throw cancelException;
                            }
                            catch (RuntimeException ex) {
                                LOG.error((Throwable)ex);
                            }
                        }
                    }
                    if (!psiPackage.hasModifierProperty("public") || (classDescriptor = descriptorResolver.resolveClass((PsiClass)psiPackage)) == null) continue;
                    this.allDescriptors.add(classDescriptor);
                }
            }
        }
        return this.allDescriptors;
    }

    private String getQualifiedName(String name) {
        return (this.packageFQN.isEmpty() ? "" : this.packageFQN + ".") + name;
    }
}

