/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.java.NamedMembers;
import org.jetbrains.jet.lang.resolve.java.PropertyAccessorData;
import org.jetbrains.jet.lang.resolve.java.PsiClassWrapper;
import org.jetbrains.jet.lang.resolve.java.PsiFieldWrapper;
import org.jetbrains.jet.lang.resolve.java.PsiMemberWrapper;
import org.jetbrains.jet.lang.resolve.java.PsiMethodWrapper;
import org.jetbrains.jet.lang.resolve.java.PsiParameterWrapper;
import org.jetbrains.jet.lang.resolve.java.TypeSource;

class JavaDescriptorResolverHelper {
    private JavaDescriptorResolverHelper() {
    }

    static Map<String, NamedMembers> getNamedMembers(@NotNull PsiClassWrapper psiClass, boolean staticMembers, boolean kotlin) {
        Builder builder = new Builder(psiClass, staticMembers, kotlin);
        builder.run();
        return builder.namedMembersMap;
    }

    private static class Builder {
        private final PsiClassWrapper psiClass;
        private final boolean staticMembers;
        private final boolean kotlin;
        private Map<String, NamedMembers> namedMembersMap = new HashMap<String, NamedMembers>();

        private Builder(PsiClassWrapper psiClass, boolean staticMembers, boolean kotlin) {
            this.psiClass = psiClass;
            this.staticMembers = staticMembers;
            this.kotlin = kotlin;
        }

        public void run() {
            this.processFields();
            this.processMethods();
        }

        private NamedMembers getNamedMembers(String name) {
            NamedMembers r = this.namedMembersMap.get(name);
            if (r == null) {
                r = new NamedMembers();
                r.name = name;
                this.namedMembersMap.put(name, r);
            }
            return r;
        }

        private boolean includeMember(PsiMemberWrapper member) {
            if (member.isStatic() != this.staticMembers) {
                return false;
            }
            if (!this.staticMembers && member.getPsiMember().getContainingClass() != this.psiClass.getPsiClass()) {
                return false;
            }
            return !member.isPrivate();
        }

        private void processFields() {
            if (!this.kotlin) {
                for (PsiField field0 : this.psiClass.getPsiClass().getFields()) {
                    PsiFieldWrapper field = new PsiFieldWrapper((PsiMember)field0);
                    if (!this.includeMember(field)) continue;
                    NamedMembers namedMembers = this.getNamedMembers(field.getName());
                    TypeSource type = new TypeSource("", field.getType(), (PsiModifierListOwner)field0);
                    namedMembers.addPropertyAccessor(new PropertyAccessorData(field, type, null));
                }
            }
        }

        private void processMethods() {
            for (PsiMethod method : this.psiClass.getPsiClass().getAllMethods()) {
                this.getNamedMembers(method.getName());
            }
            for (PsiMethod method0 : this.psiClass.getPsiClass().getMethods()) {
                TypeSource receiverType;
                NamedMembers members;
                String propertyName;
                PsiMethodWrapper method = new PsiMethodWrapper(method0);
                if (!this.includeMember(method)) continue;
                if (method.getName().startsWith("get")) {
                    propertyName = StringUtil.decapitalize((String)method.getName().substring("get".length()));
                    members = this.getNamedMembers(propertyName);
                    if (method.getJetMethod().kind() == 1) {
                        int i = 0;
                        if (i < method.getParameters().size() && method.getParameter(i).getJetValueParameter().receiver()) {
                            PsiParameterWrapper receiverParameter = method.getParameter(i);
                            receiverType = new TypeSource(receiverParameter.getJetValueParameter().type(), receiverParameter.getPsiParameter().getType(), (PsiModifierListOwner)receiverParameter.getPsiParameter());
                            ++i;
                        } else {
                            receiverType = null;
                        }
                        while (i < method.getParameters().size() && method.getParameter(i).getJetTypeParameter().isDefined()) {
                            ++i;
                        }
                        if (i != method.getParameters().size()) {
                            throw new IllegalStateException();
                        }
                        TypeSource propertyType = new TypeSource(method.getJetMethod().propertyType(), method.getReturnType(), (PsiModifierListOwner)method.getPsiMethod());
                        members.addPropertyAccessor(new PropertyAccessorData(method, true, propertyType, receiverType));
                    } else if (!this.kotlin && method.getParameters().size() == 0) {
                        TypeSource propertyType = new TypeSource("", method.getReturnType(), (PsiModifierListOwner)method.getPsiMethod());
                        members.addPropertyAccessor(new PropertyAccessorData(method, true, propertyType, null));
                    }
                } else if (method.getName().startsWith("set")) {
                    propertyName = StringUtil.decapitalize((String)method.getName().substring("set".length()));
                    members = this.getNamedMembers(propertyName);
                    if (method.getJetMethod().kind() == 1) {
                        if (method.getParameters().size() == 0) {
                            throw new IllegalStateException();
                        }
                        int i = 0;
                        receiverType = null;
                        PsiParameterWrapper p1 = method.getParameter(0);
                        if (p1.getJetValueParameter().receiver()) {
                            receiverType = new TypeSource(p1.getJetValueParameter().type(), p1.getPsiParameter().getType(), (PsiModifierListOwner)p1.getPsiParameter());
                            ++i;
                        }
                        while (i < method.getParameters().size() && method.getParameter(i).getJetTypeParameter().isDefined()) {
                            ++i;
                        }
                        if (i + 1 != method.getParameters().size()) {
                            throw new IllegalStateException();
                        }
                        PsiParameterWrapper propertyTypeParameter = method.getParameter(i);
                        TypeSource propertyType = new TypeSource(method.getJetMethod().propertyType(), propertyTypeParameter.getPsiParameter().getType(), (PsiModifierListOwner)propertyTypeParameter.getPsiParameter());
                        members.addPropertyAccessor(new PropertyAccessorData(method, false, propertyType, receiverType));
                    } else if (!this.kotlin && method.getParameters().size() == 1) {
                        PsiParameter psiParameter = method.getParameters().get(0).getPsiParameter();
                        TypeSource propertyType = new TypeSource("", psiParameter.getType(), (PsiModifierListOwner)psiParameter);
                        members.addPropertyAccessor(new PropertyAccessorData(method, false, propertyType, null));
                    }
                }
                if (method.getJetMethod().kind() == 1) continue;
                NamedMembers namedMembers = this.getNamedMembers(method.getName());
                namedMembers.addMethod(method);
            }
        }
    }
}

