/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMethod;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.impl.compiled.ClsClassImpl;
import com.intellij.psi.search.DelegatingGlobalSearchScope;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import jet.typeinfo.TypeInfoVariance;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptorVisitor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.MutableClassDescriptorLite;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.OverrideResolver;
import org.jetbrains.jet.lang.resolve.constants.StringValue;
import org.jetbrains.jet.lang.resolve.java.JavaClassMembersScope;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolverHelper;
import org.jetbrains.jet.lang.resolve.java.JavaNamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.java.JavaPackageScope;
import org.jetbrains.jet.lang.resolve.java.JavaSemanticServices;
import org.jetbrains.jet.lang.resolve.java.JetJavaMirrorMarker;
import org.jetbrains.jet.lang.resolve.java.JetSignatureUtils;
import org.jetbrains.jet.lang.resolve.java.JetTypeJetSignatureReader;
import org.jetbrains.jet.lang.resolve.java.JvmAbi;
import org.jetbrains.jet.lang.resolve.java.JvmStdlibNames;
import org.jetbrains.jet.lang.resolve.java.NamedMembers;
import org.jetbrains.jet.lang.resolve.java.PropertyAccessorData;
import org.jetbrains.jet.lang.resolve.java.PsiClassWrapper;
import org.jetbrains.jet.lang.resolve.java.PsiMethodWrapper;
import org.jetbrains.jet.lang.resolve.java.PsiParameterWrapper;
import org.jetbrains.jet.lang.resolve.java.TypeSource;
import org.jetbrains.jet.lang.resolve.java.TypeVariableResolver;
import org.jetbrains.jet.lang.resolve.java.TypeVariableResolverFromOuters;
import org.jetbrains.jet.lang.resolve.java.TypeVariableResolverFromTypeDescriptors;
import org.jetbrains.jet.lang.resolve.java.TypeVariableResolvers;
import org.jetbrains.jet.lang.resolve.java.alt.AltClassFinder;
import org.jetbrains.jet.lang.resolve.java.kt.JetClassAnnotation;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetStandardClasses;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.plugin.JetFileType;
import org.jetbrains.jet.rt.signature.JetSignatureAdapter;
import org.jetbrains.jet.rt.signature.JetSignatureExceptionsAdapter;
import org.jetbrains.jet.rt.signature.JetSignatureReader;
import org.jetbrains.jet.rt.signature.JetSignatureVisitor;

public class JavaDescriptorResolver {
    public static String JAVA_ROOT = "<java_root>";
    static final DeclarationDescriptor JAVA_METHOD_TYPE_PARAMETER_PARENT = new DeclarationDescriptorImpl(null, Collections.emptyList(), "<java_generic_method>"){

        @Override
        public DeclarationDescriptor substitute(TypeSubstitutor substitutor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data) {
            return visitor.visitDeclarationDescriptor(this, data);
        }
    };
    static final DeclarationDescriptor JAVA_CLASS_OBJECT = new DeclarationDescriptorImpl(null, Collections.emptyList(), "<java_class_object_emulation>"){

        @Override
        @NotNull
        public DeclarationDescriptor substitute(TypeSubstitutor substitutor) {
            throw new UnsupportedOperationException();
        }

        @Override
        public <R, D> R accept(DeclarationDescriptorVisitor<R, D> visitor, D data) {
            return visitor.visitDeclarationDescriptor(this, data);
        }
    };
    protected final Map<String, ResolverBinaryClassData> classDescriptorCache = Maps.newHashMap();
    protected final Map<String, ResolverNamespaceData> namespaceDescriptorCacheByFqn = Maps.newHashMap();
    protected final Map<PsiElement, ResolverNamespaceData> namespaceDescriptorCache = Maps.newHashMap();
    protected final JavaPsiFacade javaFacade;
    protected final GlobalSearchScope javaSearchScope;
    protected final JavaSemanticServices semanticServices;
    private final AltClassFinder altClassFinder;
    protected ClassDescriptor javaLangObject;

    public JavaDescriptorResolver(Project project, JavaSemanticServices semanticServices) {
        this.javaFacade = JavaPsiFacade.getInstance((Project)project);
        this.javaSearchScope = new DelegatingGlobalSearchScope(GlobalSearchScope.allScope((Project)project)){

            public boolean contains(VirtualFile file) {
                return this.myBaseScope.contains(file) && file.getFileType() != JetFileType.INSTANCE;
            }
        };
        this.semanticServices = semanticServices;
        this.altClassFinder = new AltClassFinder(project);
    }

    @Nullable
    ResolverClassData resolveClassData(@NotNull PsiClass psiClass) {
        ResolverBinaryClassData classData;
        String qualifiedName = psiClass.getQualifiedName();
        if (qualifiedName.endsWith("$$TImpl")) {
            return null;
        }
        ClassDescriptor kotlinClassDescriptor = this.semanticServices.getKotlinClassDescriptor(qualifiedName);
        if (kotlinClassDescriptor != null) {
            return new ResolverSrcClassData(kotlinClassDescriptor);
        }
        PsiClass containingClass = psiClass.getContainingClass();
        if (containingClass != null) {
            this.resolveClass(containingClass);
        }
        if ((classData = this.classDescriptorCache.get(qualifiedName)) == null) {
            classData = this.createJavaClassDescriptor(psiClass);
            this.classDescriptorCache.put(qualifiedName, classData);
        }
        return classData;
    }

    @Nullable
    public ClassDescriptor resolveClass(@NotNull PsiClass psiClass) {
        ResolverClassData classData = this.resolveClassData(psiClass);
        if (classData != null) {
            return classData.getClassDescriptor();
        }
        return null;
    }

    @Nullable
    public ClassDescriptor resolveClass(@NotNull String qualifiedName) {
        if (qualifiedName.endsWith("$$TImpl")) {
            return null;
        }
        ClassDescriptor kotlinClassDescriptor = this.semanticServices.getKotlinClassDescriptor(qualifiedName);
        if (kotlinClassDescriptor != null) {
            return kotlinClassDescriptor;
        }
        ResolverBinaryClassData classData = this.classDescriptorCache.get(qualifiedName);
        if (classData == null) {
            PsiClass psiClass = this.findClass(qualifiedName);
            if (psiClass == null) {
                return null;
            }
            classData = this.createJavaClassDescriptor(psiClass);
        }
        return classData.getClassDescriptor();
    }

    private ResolverBinaryClassData createJavaClassDescriptor(@NotNull PsiClass psiClass) {
        MutableClassDescriptorLite classObject;
        if (this.classDescriptorCache.containsKey(psiClass.getQualifiedName())) {
            throw new IllegalStateException(psiClass.getQualifiedName());
        }
        this.checkPsiClassIsNotJet(psiClass);
        String name = psiClass.getName();
        ResolverBinaryClassData classData = new ResolverBinaryClassData();
        this.classDescriptorCache.put(psiClass.getQualifiedName(), classData);
        ClassKind kind = psiClass.isInterface() ? (psiClass.isAnnotationType() ? ClassKind.ANNOTATION_CLASS : ClassKind.TRAIT) : ClassKind.CLASS;
        DeclarationDescriptor containingDeclaration = this.resolveParentDescriptor(psiClass);
        classData.classDescriptor = new MutableClassDescriptorLite(containingDeclaration, kind);
        classData.classDescriptor.setName(name);
        classData.classDescriptor.setAnnotations(this.resolveAnnotations((PsiModifierListOwner)psiClass));
        ArrayList<JetType> supertypes = new ArrayList<JetType>();
        TypeVariableResolverFromOuters outerTypeVariableByNameResolver = new TypeVariableResolverFromOuters(containingDeclaration);
        classData.typeParameters = this.createUninitializedClassTypeParameters(psiClass, classData, outerTypeVariableByNameResolver);
        ArrayList<TypeParameterDescriptor> typeParameters = new ArrayList<TypeParameterDescriptor>();
        for (TypeParameterDescriptorInitialization typeParameter : classData.typeParameters) {
            typeParameters.add(typeParameter.descriptor);
        }
        classData.classDescriptor.setTypeParameterDescriptors(typeParameters);
        classData.classDescriptor.setSupertypes(supertypes);
        classData.classDescriptor.setVisibility(JavaDescriptorResolver.resolveVisibilityFromPsiModifiers((PsiModifierListOwner)psiClass));
        Modality modality = classData.classDescriptor.getKind() == ClassKind.ANNOTATION_CLASS ? Modality.FINAL : Modality.convertFromFlags(psiClass.hasModifierProperty("abstract") || psiClass.isInterface(), !psiClass.hasModifierProperty("final"));
        classData.classDescriptor.setModality(modality);
        classData.classDescriptor.createTypeConstructor();
        classData.classDescriptor.setScopeForMemberLookup(new JavaClassMembersScope(classData.classDescriptor, psiClass, this.semanticServices, false));
        this.initializeTypeParameters(classData.typeParameters, new TypeVariableResolverFromTypeDescriptors(new ArrayList<TypeParameterDescriptor>(), outerTypeVariableByNameResolver));
        TypeVariableResolverFromTypeDescriptors resolverForTypeParameters = new TypeVariableResolverFromTypeDescriptors(classData.getTypeParameters(), null);
        supertypes.addAll(this.getSupertypes(new PsiClassWrapper(psiClass), classData.classDescriptor, classData.getTypeParameters()));
        PsiMethod[] psiConstructors = psiClass.getConstructors();
        if (psiConstructors.length == 0) {
            ConstructorDescriptorImpl constructorDescriptor;
            if (!psiClass.isInterface()) {
                constructorDescriptor = new ConstructorDescriptorImpl(classData.classDescriptor, Collections.<AnnotationDescriptor>emptyList(), false);
                constructorDescriptor.initialize(typeParameters, Collections.<ValueParameterDescriptor>emptyList(), classData.classDescriptor.getVisibility());
                constructorDescriptor.setReturnType(classData.classDescriptor.getDefaultType());
                classData.classDescriptor.addConstructor(constructorDescriptor, null);
                this.semanticServices.getTrace().record(BindingContext.CONSTRUCTOR, psiClass, constructorDescriptor);
            }
            if (psiClass.isAnnotationType()) {
                constructorDescriptor = new ConstructorDescriptorImpl(classData.classDescriptor, Collections.<AnnotationDescriptor>emptyList(), false);
                ArrayList valueParameters = Lists.newArrayList();
                PsiMethod[] methods = psiClass.getMethods();
                for (int i = 0; i < methods.length; ++i) {
                    PsiMethod method = methods[i];
                    if (!(method instanceof PsiAnnotationMethod)) continue;
                    PsiAnnotationMethod annotationMethod = (PsiAnnotationMethod)method;
                    assert (annotationMethod.getParameterList().getParameters().length == 0);
                    PsiType returnType = annotationMethod.getReturnType();
                    JetType varargElementType = null;
                    if (i == methods.length - 1 && returnType instanceof PsiArrayType) {
                        varargElementType = this.semanticServices.getTypeTransformer().transformToType(((PsiArrayType)returnType).getComponentType(), (TypeVariableResolver)resolverForTypeParameters);
                    }
                    valueParameters.add(new ValueParameterDescriptorImpl(constructorDescriptor, i, Collections.<AnnotationDescriptor>emptyList(), method.getName(), false, this.semanticServices.getTypeTransformer().transformToType(returnType, (TypeVariableResolver)resolverForTypeParameters), annotationMethod.getDefaultValue() != null, varargElementType));
                }
                constructorDescriptor.initialize(typeParameters, valueParameters, classData.classDescriptor.getVisibility());
                constructorDescriptor.setReturnType(classData.classDescriptor.getDefaultType());
                classData.classDescriptor.addConstructor(constructorDescriptor, null);
                this.semanticServices.getTrace().record(BindingContext.CONSTRUCTOR, psiClass, constructorDescriptor);
            }
        } else {
            for (PsiMethod psiConstructor : psiConstructors) {
                PsiMethodWrapper constructor = new PsiMethodWrapper(psiConstructor);
                if (constructor.getJetConstructor().hidden()) continue;
                ConstructorDescriptorImpl constructorDescriptor = new ConstructorDescriptorImpl(classData.classDescriptor, Collections.<AnnotationDescriptor>emptyList(), false);
                ValueParameterDescriptors valueParameterDescriptors = this.resolveParameterDescriptors(constructorDescriptor, constructor.getParameters(), new TypeVariableResolverFromTypeDescriptors(classData.getTypeParameters(), null));
                if (valueParameterDescriptors.receiverType != null) {
                    throw new IllegalStateException();
                }
                constructorDescriptor.initialize(typeParameters, valueParameterDescriptors.descriptors, JavaDescriptorResolver.resolveVisibilityFromPsiModifiers((PsiModifierListOwner)psiConstructor));
                constructorDescriptor.setReturnType(classData.classDescriptor.getDefaultType());
                classData.classDescriptor.addConstructor(constructorDescriptor, null);
                this.semanticServices.getTrace().record(BindingContext.CONSTRUCTOR, psiConstructor, constructorDescriptor);
            }
        }
        if ((classObject = this.createClassObjectDescriptor(classData.classDescriptor, psiClass)) != null) {
            classData.classDescriptor.setClassObjectDescriptor(classObject);
        }
        this.semanticServices.getTrace().record(BindingContext.CLASS, psiClass, classData.classDescriptor);
        return classData;
    }

    private void checkPsiClassIsNotJet(PsiClass psiClass) {
        if (psiClass instanceof JetJavaMirrorMarker) {
            throw new IllegalStateException("trying to resolve fake jet PsiClass as regular PsiClass");
        }
    }

    @Nullable
    private PsiClass getInnerClassClassObject(@NotNull PsiClass outer) {
        for (PsiClass inner : outer.getInnerClasses()) {
            if (!inner.getName().equals("ClassObject$")) continue;
            return inner;
        }
        return null;
    }

    @Nullable
    private MutableClassDescriptorLite createClassObjectDescriptor(@NotNull ClassDescriptor containing, @NotNull PsiClass psiClass) {
        PsiClass classObjectPsiClass = this.getInnerClassClassObject(psiClass);
        if (classObjectPsiClass == null) {
            return null;
        }
        ResolverBinaryClassData classData = new ResolverBinaryClassData();
        classData.kotlin = true;
        classData.classDescriptor = new MutableClassDescriptorLite(containing, ClassKind.OBJECT);
        this.classDescriptorCache.put(classObjectPsiClass.getQualifiedName(), classData);
        classData.classDescriptor.setSupertypes(this.getSupertypes(new PsiClassWrapper(classObjectPsiClass), classData.classDescriptor, new ArrayList<TypeParameterDescriptor>(0)));
        classData.classDescriptor.setName("<no name provided>");
        classData.classDescriptor.setModality(Modality.FINAL);
        classData.classDescriptor.setTypeParameterDescriptors(new ArrayList<TypeParameterDescriptor>(0));
        classData.classDescriptor.createTypeConstructor();
        classData.classDescriptor.setScopeForMemberLookup(new JavaClassMembersScope(classData.classDescriptor, classObjectPsiClass, this.semanticServices, false));
        ConstructorDescriptorImpl constructor = new ConstructorDescriptorImpl(classData.classDescriptor, new ArrayList<AnnotationDescriptor>(0), true);
        constructor.setReturnType(classData.classDescriptor.getDefaultType());
        constructor.initialize(new ArrayList<TypeParameterDescriptor>(0), new ArrayList<ValueParameterDescriptor>(0), Visibility.PUBLIC);
        classData.classDescriptor.addConstructor(constructor, null);
        return classData.classDescriptor;
    }

    private List<TypeParameterDescriptorInitialization> createUninitializedClassTypeParameters(PsiClass psiClass, ResolverBinaryClassData classData, TypeVariableResolver typeVariableResolver) {
        JetClassAnnotation jetClassAnnotation = JetClassAnnotation.get(psiClass);
        classData.kotlin = jetClassAnnotation.isDefined();
        if (jetClassAnnotation.signature().length() > 0) {
            return this.resolveClassTypeParametersFromJetSignature(jetClassAnnotation.signature(), psiClass, classData.classDescriptor, typeVariableResolver);
        }
        return this.makeUninitializedTypeParameters(classData.classDescriptor, psiClass.getTypeParameters());
    }

    @NotNull
    private PsiTypeParameter getPsiTypeParameterByName(PsiTypeParameterListOwner clazz, String name) {
        for (PsiTypeParameter typeParameter : clazz.getTypeParameters()) {
            if (!typeParameter.getName().equals(name)) continue;
            return typeParameter;
        }
        throw new IllegalStateException("PsiTypeParameter '" + name + "' is not found");
    }

    @NotNull
    private ClassDescriptor getJavaLangObject() {
        if (this.javaLangObject == null) {
            this.javaLangObject = this.resolveClass("java.lang.Object");
        }
        return this.javaLangObject;
    }

    private boolean isJavaLangObject(JetType type) {
        return type.getConstructor().getDeclarationDescriptor() == this.getJavaLangObject();
    }

    private List<TypeParameterDescriptorInitialization> resolveClassTypeParametersFromJetSignature(String jetSignature, PsiClass clazz, ClassDescriptor classDescriptor, TypeVariableResolver outerClassTypeVariableResolver) {
        JetSignatureTypeParametersVisitor jetSignatureTypeParametersVisitor = new JetSignatureTypeParametersVisitor(outerClassTypeVariableResolver, classDescriptor, (PsiTypeParameterListOwner)clazz){

            public JetSignatureVisitor visitSuperclass() {
                return new JetSignatureAdapter();
            }

            public JetSignatureVisitor visitInterface() {
                return new JetSignatureAdapter();
            }
        };
        new JetSignatureReader(jetSignature).accept((JetSignatureVisitor)jetSignatureTypeParametersVisitor);
        return jetSignatureTypeParametersVisitor.r;
    }

    private DeclarationDescriptor resolveParentDescriptor(PsiClass psiClass) {
        PsiClass containingClass = psiClass.getContainingClass();
        if (containingClass != null) {
            return this.resolveClass(containingClass);
        }
        return this.resolveNamespace(JavaDescriptorResolver.packageNameOfClass(psiClass.getQualifiedName()));
    }

    private static String packageNameOfClass(@NotNull String qualifiedName) {
        int lastDot = qualifiedName.lastIndexOf(46);
        if (lastDot < 0) {
            return "";
        }
        return qualifiedName.substring(0, lastDot);
    }

    private List<TypeParameterDescriptorInitialization> makeUninitializedTypeParameters(@NotNull DeclarationDescriptor containingDeclaration, @NotNull PsiTypeParameter[] typeParameters) {
        ArrayList result = Lists.newArrayList();
        for (PsiTypeParameter typeParameter : typeParameters) {
            TypeParameterDescriptorInitialization typeParameterDescriptor = this.makeUninitializedTypeParameter(containingDeclaration, typeParameter);
            result.add(typeParameterDescriptor);
        }
        return result;
    }

    @NotNull
    private TypeParameterDescriptorInitialization makeUninitializedTypeParameter(@NotNull DeclarationDescriptor containingDeclaration, @NotNull PsiTypeParameter psiTypeParameter) {
        TypeParameterDescriptor typeParameterDescriptor = TypeParameterDescriptor.createForFurtherModification(containingDeclaration, Collections.<AnnotationDescriptor>emptyList(), false, Variance.INVARIANT, psiTypeParameter.getName(), psiTypeParameter.getIndex());
        return new TypeParameterDescriptorInitialization(typeParameterDescriptor, psiTypeParameter);
    }

    private void initializeTypeParameter(TypeParameterDescriptorInitialization typeParameter, TypeVariableResolver typeVariableByPsiResolver) {
        TypeParameterDescriptor typeParameterDescriptor = typeParameter.descriptor;
        if (typeParameter.origin == TypeParameterDescriptorOrigin.KOTLIN) {
            List upperBounds = typeParameter.upperBoundsForKotlin;
            if (upperBounds.size() == 0) {
                typeParameterDescriptor.addUpperBound(JetStandardClasses.getNullableAnyType());
            } else {
                for (JetType upperBound : typeParameter.upperBoundsForKotlin) {
                    typeParameterDescriptor.addUpperBound(upperBound);
                }
            }
        } else {
            PsiClassType[] referencedTypes = typeParameter.psiTypeParameter.getExtendsList().getReferencedTypes();
            if (referencedTypes.length == 0) {
                typeParameterDescriptor.addUpperBound(JetStandardClasses.getNullableAnyType());
            } else if (referencedTypes.length == 1) {
                typeParameterDescriptor.addUpperBound(this.semanticServices.getTypeTransformer().transformToType((PsiType)referencedTypes[0], typeVariableByPsiResolver));
            } else {
                for (PsiClassType referencedType : referencedTypes) {
                    typeParameterDescriptor.addUpperBound(this.semanticServices.getTypeTransformer().transformToType((PsiType)referencedType, typeVariableByPsiResolver));
                }
            }
        }
        typeParameterDescriptor.setInitialized();
    }

    private void initializeTypeParameters(List<TypeParameterDescriptorInitialization> typeParametersInitialization, TypeVariableResolver typeVariableByPsiResolver) {
        ArrayList<TypeParameterDescriptor> prevTypeParameters = new ArrayList<TypeParameterDescriptor>();
        for (TypeParameterDescriptorInitialization psiTypeParameter : typeParametersInitialization) {
            prevTypeParameters.add(psiTypeParameter.descriptor);
            this.initializeTypeParameter(psiTypeParameter, new TypeVariableResolverFromTypeDescriptors(prevTypeParameters, typeVariableByPsiResolver));
        }
    }

    private Collection<JetType> getSupertypes(PsiClassWrapper psiClass, ClassDescriptor classDescriptor, List<TypeParameterDescriptor> typeParameters) {
        final ArrayList<JetType> result = new ArrayList<JetType>();
        if (psiClass.getJetClass().signature().length() > 0) {
            final TypeVariableResolverFromTypeDescriptors typeVariableResolver = new TypeVariableResolverFromTypeDescriptors(typeParameters, null);
            new JetSignatureReader(psiClass.getJetClass().signature()).accept((JetSignatureVisitor)new JetSignatureExceptionsAdapter(){

                public JetSignatureVisitor visitFormalTypeParameter(String name, TypeInfoVariance variance, boolean reified) {
                    return new JetSignatureAdapter();
                }

                public JetSignatureVisitor visitSuperclass() {
                    return new JetTypeJetSignatureReader(JavaDescriptorResolver.this.semanticServices, JavaDescriptorResolver.this.semanticServices.getJetSemanticServices().getStandardLibrary(), typeVariableResolver){

                        @Override
                        protected void done(@NotNull JetType jetType) {
                            if (!((Object)jetType).equals(JetStandardClasses.getAnyType())) {
                                result.add(jetType);
                            }
                        }
                    };
                }

                public JetSignatureVisitor visitInterface() {
                    return this.visitSuperclass();
                }
            });
        } else {
            this.transformSupertypeList(result, psiClass.getPsiClass().getExtendsListTypes(), new TypeVariableResolverFromTypeDescriptors(typeParameters, null), classDescriptor.getKind() == ClassKind.ANNOTATION_CLASS);
            this.transformSupertypeList(result, psiClass.getPsiClass().getImplementsListTypes(), new TypeVariableResolverFromTypeDescriptors(typeParameters, null), classDescriptor.getKind() == ClassKind.ANNOTATION_CLASS);
        }
        for (JetType supertype : result) {
            if (!ErrorUtils.isErrorType(supertype)) continue;
            this.semanticServices.getTrace().record(BindingContext.INCOMPLETE_HIERARCHY, classDescriptor);
        }
        if (result.isEmpty()) {
            result.add(JetStandardClasses.getAnyType());
        }
        return result;
    }

    private void transformSupertypeList(List<JetType> result, PsiClassType[] extendsListTypes, TypeVariableResolver typeVariableResolver, boolean annotation) {
        for (PsiClassType type : extendsListTypes) {
            PsiClass resolved = type.resolve();
            if (resolved != null && resolved.getQualifiedName().equals(JvmStdlibNames.JET_OBJECT.getFqName()) || annotation && resolved.getQualifiedName().equals("java.lang.annotation.Annotation")) continue;
            JetType transform = this.semanticServices.getTypeTransformer().transformToType((PsiType)type, typeVariableResolver);
            result.add(TypeUtils.makeNotNullable(transform));
        }
    }

    @Nullable
    public NamespaceDescriptor resolveNamespace(@NotNull String qualifiedName) {
        NamespaceDescriptor kotlinNamespaceDescriptor = this.semanticServices.getKotlinNamespaceDescriptor(qualifiedName);
        if (kotlinNamespaceDescriptor != null) {
            return kotlinNamespaceDescriptor;
        }
        PsiPackage psiPackage = this.findPackage(qualifiedName);
        if (psiPackage == null) {
            PsiClass psiClass = this.findClass(qualifiedName);
            if (psiClass == null) {
                return null;
            }
            return this.resolveNamespace(psiClass);
        }
        return this.resolveNamespace(psiPackage);
    }

    public PsiClass findClass(String qualifiedName) {
        PsiClass original = this.javaFacade.findClass(qualifiedName, this.javaSearchScope);
        PsiClass altClass = this.altClassFinder.findClass(qualifiedName);
        if (altClass != null) {
            if (altClass instanceof ClsClassImpl) {
                altClass.putUserData(ClsClassImpl.DELEGATE_KEY, (Object)original);
            }
            return altClass;
        }
        return original;
    }

    PsiPackage findPackage(String qualifiedName) {
        return this.javaFacade.findPackage(qualifiedName);
    }

    private NamespaceDescriptor resolveNamespace(@NotNull PsiPackage psiPackage) {
        ResolverNamespaceData namespaceData = this.namespaceDescriptorCache.get(psiPackage);
        if (namespaceData == null) {
            namespaceData = this.createJavaNamespaceDescriptor(psiPackage);
            this.namespaceDescriptorCache.put((PsiElement)psiPackage, namespaceData);
            this.namespaceDescriptorCacheByFqn.put(psiPackage.getQualifiedName(), namespaceData);
        }
        return namespaceData.namespaceDescriptor;
    }

    private NamespaceDescriptor resolveNamespace(@NotNull PsiClass psiClass) {
        ResolverNamespaceData namespaceData = this.namespaceDescriptorCache.get(psiClass);
        if (namespaceData == null) {
            namespaceData = this.createJavaNamespaceDescriptor(psiClass);
            this.namespaceDescriptorCache.put((PsiElement)psiClass, namespaceData);
            this.namespaceDescriptorCacheByFqn.put(psiClass.getQualifiedName(), namespaceData);
        }
        return namespaceData.namespaceDescriptor;
    }

    private ResolverNamespaceData createJavaNamespaceDescriptor(@NotNull PsiPackage psiPackage) {
        ResolverNamespaceData namespaceData = new ResolverNamespaceData();
        String name = psiPackage.getName();
        namespaceData.namespaceDescriptor = new JavaNamespaceDescriptor(this.resolveParentDescriptor(psiPackage), Collections.<AnnotationDescriptor>emptyList(), name == null ? JavaDescriptorResolver.JAVA_ROOT : name, name == null ? JavaDescriptorResolver.JAVA_ROOT : psiPackage.getQualifiedName(), true);
        namespaceData.namespaceDescriptor.setMemberScope(new JavaPackageScope(psiPackage.getQualifiedName(), namespaceData.namespaceDescriptor, this.semanticServices));
        this.semanticServices.getTrace().record(BindingContext.NAMESPACE, psiPackage, namespaceData.namespaceDescriptor);
        namespaceData.kotlin = true;
        return namespaceData;
    }

    private DeclarationDescriptor resolveParentDescriptor(@NotNull PsiPackage psiPackage) {
        PsiPackage parentPackage = psiPackage.getParentPackage();
        if (parentPackage == null) {
            return null;
        }
        return this.resolveNamespace(parentPackage);
    }

    private ResolverNamespaceData createJavaNamespaceDescriptor(@NotNull PsiClass psiClass) {
        this.checkPsiClassIsNotJet(psiClass);
        ResolverNamespaceData namespaceData = new ResolverNamespaceData();
        namespaceData.namespaceDescriptor = new JavaNamespaceDescriptor(this.resolveParentDescriptor(psiClass), Collections.<AnnotationDescriptor>emptyList(), psiClass.getName(), psiClass.getQualifiedName(), false);
        namespaceData.namespaceDescriptor.setMemberScope(new JavaClassMembersScope(namespaceData.namespaceDescriptor, psiClass, this.semanticServices, true));
        this.semanticServices.getTrace().record(BindingContext.NAMESPACE, psiClass, namespaceData.namespaceDescriptor);
        return namespaceData;
    }

    @NotNull
    private JvmMethodParameterMeaning resolveParameterDescriptor(DeclarationDescriptor containingDeclaration, int i, PsiParameterWrapper parameter, TypeVariableResolver typeVariableResolver) {
        String name;
        if (parameter.getJetTypeParameter().isDefined()) {
            return JvmMethodParameterMeaning.typeInfo(new Object());
        }
        PsiType psiType = parameter.getPsiParameter().getType();
        String string = name = parameter.getPsiParameter().getName() != null ? parameter.getPsiParameter().getName() : "p" + i;
        if (parameter.getJetValueParameter().name().length() > 0) {
            name = parameter.getJetValueParameter().name();
        }
        String typeFromAnnotation = parameter.getJetValueParameter().type();
        boolean receiver = parameter.getJetValueParameter().receiver();
        boolean hasDefaultValue = parameter.getJetValueParameter().hasDefaultValue();
        JetType outType = typeFromAnnotation.length() > 0 ? this.semanticServices.getTypeTransformer().transformToType(typeFromAnnotation, typeVariableResolver) : this.semanticServices.getTypeTransformer().transformToType(psiType, typeVariableResolver);
        JetType varargElementType = psiType instanceof PsiEllipsisType ? this.semanticServices.getJetSemanticServices().getStandardLibrary().getArrayElementType(outType) : null;
        if (receiver) {
            return JvmMethodParameterMeaning.receiver(outType);
        }
        JetType transformedType = parameter.getJetValueParameter().nullable() ? TypeUtils.makeNullableAsSpecified(outType, parameter.getJetValueParameter().nullable()) : (parameter.getPsiParameter().getModifierList().findAnnotation(JvmAbi.JETBRAINS_NOT_NULL_ANNOTATION.getFqName()) != null ? TypeUtils.makeNullableAsSpecified(outType, false) : outType);
        return JvmMethodParameterMeaning.regular(new ValueParameterDescriptorImpl(containingDeclaration, i, Collections.<AnnotationDescriptor>emptyList(), name, false, transformedType, hasDefaultValue, varargElementType));
    }

    public Set<VariableDescriptor> resolveFieldGroupByName(@NotNull ClassOrNamespaceDescriptor owner, PsiClass psiClass, String fieldName, boolean staticMembers) {
        ResolverScopeData scopeData = this.getResolverScopeData(owner, new PsiClassWrapper(psiClass));
        NamedMembers namedMembers = (NamedMembers)scopeData.namedMembersMap.get(fieldName);
        if (namedMembers == null) {
            return Collections.emptySet();
        }
        HashSet<VariableDescriptor> r = new HashSet<VariableDescriptor>();
        this.resolveNamedGroupProperties(owner, scopeData, staticMembers, namedMembers, fieldName);
        r.addAll(namedMembers.propertyDescriptors);
        for (JetType supertype : this.getSupertypes(scopeData)) {
            r.addAll(supertype.getMemberScope().getProperties(fieldName));
        }
        return r;
    }

    @NotNull
    public Set<VariableDescriptor> resolveFieldGroup(@NotNull ClassOrNamespaceDescriptor owner, PsiClass psiClass, boolean staticMembers) {
        ResolverScopeData scopeData = this.getResolverScopeData(owner, new PsiClassWrapper(psiClass));
        HashSet descriptors = Sets.newHashSet();
        Map membersForProperties = scopeData.namedMembersMap;
        for (Map.Entry entry : membersForProperties.entrySet()) {
            NamedMembers namedMembers = (NamedMembers)entry.getValue();
            if (namedMembers.propertyAccessors == null) continue;
            String propertyName = (String)entry.getKey();
            this.resolveNamedGroupProperties(owner, scopeData, staticMembers, namedMembers, propertyName);
            descriptors.addAll(namedMembers.propertyDescriptors);
        }
        for (JetType supertype : this.getSupertypes(scopeData)) {
            for (DeclarationDescriptor descriptor : supertype.getMemberScope().getAllDescriptors()) {
                if (!(descriptor instanceof VariableDescriptor)) continue;
                descriptors.add((VariableDescriptor)descriptor);
            }
        }
        return descriptors;
    }

    private Object key(TypeSource typeSource) {
        if (typeSource == null) {
            return "";
        }
        if (typeSource.getTypeString().length() > 0) {
            return typeSource.getTypeString();
        }
        return this.psiTypeToKey(typeSource.getPsiType());
    }

    private Object psiTypeToKey(PsiType psiType) {
        if (psiType instanceof PsiClassType) {
            return ((PsiClassType)psiType).getClassName();
        }
        if (psiType instanceof PsiPrimitiveType) {
            return psiType.getPresentableText();
        }
        if (psiType instanceof PsiArrayType) {
            return Pair.create((Object)"[", (Object)this.psiTypeToKey(((PsiArrayType)psiType).getComponentType()));
        }
        throw new IllegalStateException("" + psiType.getClass());
    }

    private Object propertyKeyForGrouping(PropertyAccessorData propertyAccessor) {
        Object type = this.key(propertyAccessor.getType());
        Object receiverType = this.key(propertyAccessor.getReceiverType());
        return Pair.create((Object)type, (Object)receiverType);
    }

    private void resolveNamedGroupProperties(@NotNull ClassOrNamespaceDescriptor owner, @NotNull ResolverScopeData scopeData, boolean staticMembers, NamedMembers namedMembers, String propertyName) {
        if (namedMembers.propertyDescriptors != null) {
            return;
        }
        if (namedMembers.propertyAccessors == null) {
            namedMembers.propertyDescriptors = Collections.emptySet();
            return;
        }
        List<TypeParameterDescriptor> classTypeParameterDescriptorInitialization = scopeData.getTypeParameters();
        TypeVariableResolverFromTypeDescriptors typeVariableResolver = new TypeVariableResolverFromTypeDescriptors(scopeData.getTypeParameters(), null);
        class GroupingValue {
            PropertyAccessorData getter;
            PropertyAccessorData setter;
            PropertyAccessorData field;
            boolean ext;

            GroupingValue() {
            }
        }
        HashMap<Object, GroupingValue> map = new HashMap<Object, GroupingValue>();
        for (PropertyAccessorData propertyAccessor : namedMembers.propertyAccessors) {
            Object key = this.propertyKeyForGrouping(propertyAccessor);
            GroupingValue value = (GroupingValue)map.get(key);
            if (value == null) {
                value = new GroupingValue();
                value.ext = propertyAccessor.getReceiverType() != null;
                map.put(key, value);
            }
            if (value.ext != (propertyAccessor.getReceiverType() != null)) {
                throw new IllegalStateException("internal error, incorrect key");
            }
            if (propertyAccessor.isGetter()) {
                if (value.getter != null) {
                    throw new IllegalStateException("oops, duplicate key");
                }
                value.getter = propertyAccessor;
                continue;
            }
            if (propertyAccessor.isSetter()) {
                if (value.setter != null) {
                    throw new IllegalStateException("oops, duplicate key");
                }
                value.setter = propertyAccessor;
                continue;
            }
            if (propertyAccessor.isField()) {
                if (value.field != null) {
                    throw new IllegalStateException("oops, duplicate key");
                }
                value.field = propertyAccessor;
                continue;
            }
            throw new IllegalStateException();
        }
        HashSet<VariableDescriptor> r = new HashSet<VariableDescriptor>(1);
        int regularProperitesCount = 0;
        for (GroupingValue members : map.values()) {
            if (members.ext) continue;
            ++regularProperitesCount;
        }
        for (GroupingValue members : map.values()) {
            JetType propertyType;
            PsiMethodWrapper method;
            PropertyAccessorData anyMember;
            if (!members.ext && regularProperitesCount > 1) continue;
            boolean isFinal = members.setter == null && members.getter == null ? false : (members.getter != null ? members.getter.getMember().isFinal() : (members.setter != null ? members.setter.getMember().isFinal() : false));
            if (members.getter != null) {
                anyMember = members.getter;
            } else if (members.field != null) {
                anyMember = members.field;
            } else if (members.setter != null) {
                anyMember = members.setter;
            } else {
                throw new IllegalStateException();
            }
            boolean isVar = members.getter == null && members.setter == null ? !members.field.getMember().isFinal() : members.setter != null;
            PropertyDescriptor propertyDescriptor = new PropertyDescriptor(owner, Collections.<AnnotationDescriptor>emptyList(), isFinal && !staticMembers ? Modality.FINAL : Modality.OPEN, JavaDescriptorResolver.resolveVisibilityFromPsiModifiers((PsiModifierListOwner)anyMember.getMember().psiMember), isVar, false, propertyName, CallableMemberDescriptor.Kind.DECLARATION);
            PropertyGetterDescriptor getterDescriptor = null;
            PropertySetterDescriptor setterDescriptor = null;
            if (members.getter != null) {
                getterDescriptor = new PropertyGetterDescriptor(propertyDescriptor, Collections.<AnnotationDescriptor>emptyList(), Modality.OPEN, Visibility.PUBLIC, true, false, CallableMemberDescriptor.Kind.DECLARATION);
            }
            if (members.setter != null) {
                setterDescriptor = new PropertySetterDescriptor(propertyDescriptor, Collections.<AnnotationDescriptor>emptyList(), Modality.OPEN, Visibility.PUBLIC, true, false, CallableMemberDescriptor.Kind.DECLARATION);
            }
            propertyDescriptor.initialize(getterDescriptor, setterDescriptor);
            List<Object> typeParametersInitialization = new ArrayList(0);
            if (members.setter != null) {
                method = (PsiMethodWrapper)members.setter.getMember();
                if (anyMember == members.setter) {
                    typeParametersInitialization = this.resolveMethodTypeParameters(method, setterDescriptor, typeVariableResolver);
                }
            }
            if (members.getter != null) {
                method = (PsiMethodWrapper)members.getter.getMember();
                if (anyMember == members.getter) {
                    typeParametersInitialization = this.resolveMethodTypeParameters(method, getterDescriptor, typeVariableResolver);
                }
            }
            ArrayList<TypeParameterDescriptor> typeParameters = new ArrayList<TypeParameterDescriptor>();
            for (TypeParameterDescriptor typeParameter : typeParametersInitialization) {
                typeParameters.add(typeParameter);
            }
            ArrayList<TypeParameterDescriptor> typeParametersForReceiver = new ArrayList<TypeParameterDescriptor>();
            typeParametersForReceiver.addAll(classTypeParameterDescriptorInitialization);
            typeParametersForReceiver.addAll(typeParametersInitialization);
            TypeVariableResolverFromTypeDescriptors typeVariableResolverForPropertyInternals = new TypeVariableResolverFromTypeDescriptors(typeParametersForReceiver, null);
            if (anyMember.getType().getTypeString().length() > 0) {
                propertyType = this.semanticServices.getTypeTransformer().transformToType(anyMember.getType().getTypeString(), (TypeVariableResolver)typeVariableResolverForPropertyInternals);
            } else {
                propertyType = this.semanticServices.getTypeTransformer().transformToType(anyMember.getType().getPsiType(), (TypeVariableResolver)typeVariableResolverForPropertyInternals);
                if (anyMember.getType().getPsiNotNullOwner().getModifierList().findAnnotation(JvmAbi.JETBRAINS_NOT_NULL_ANNOTATION.getFqName()) != null) {
                    propertyType = TypeUtils.makeNullableAsSpecified(propertyType, false);
                }
            }
            JetType receiverType = anyMember.getReceiverType() == null ? null : (anyMember.getReceiverType().getTypeString().length() > 0 ? this.semanticServices.getTypeTransformer().transformToType(anyMember.getReceiverType().getTypeString(), (TypeVariableResolver)typeVariableResolverForPropertyInternals) : this.semanticServices.getTypeTransformer().transformToType(anyMember.getReceiverType().getPsiType(), (TypeVariableResolver)typeVariableResolverForPropertyInternals));
            propertyDescriptor.setType(propertyType, typeParameters, DescriptorUtils.getExpectedThisObjectIfNeeded(owner), receiverType);
            if (getterDescriptor != null) {
                getterDescriptor.initialize(propertyType);
            }
            if (setterDescriptor != null) {
                setterDescriptor.initialize(new ValueParameterDescriptorImpl(setterDescriptor, 0, Collections.<AnnotationDescriptor>emptyList(), "p0", false, propertyDescriptor.getType(), false, null));
            }
            this.semanticServices.getTrace().record(BindingContext.VARIABLE, anyMember.getMember().psiMember, propertyDescriptor);
            r.add(propertyDescriptor);
        }
        namedMembers.propertyDescriptors = r;
    }

    private void resolveNamedGroupFunctions(ClassOrNamespaceDescriptor owner, PsiClass psiClass, TypeSubstitutor typeSubstitutorForGenericSuperclasses, NamedMembers namedMembers, String methodName, ResolverScopeData scopeData) {
        if (namedMembers.functionDescriptors != null) {
            return;
        }
        final HashSet<FunctionDescriptor> functions = new HashSet<FunctionDescriptor>();
        HashSet functionsFromCurrent = Sets.newHashSet();
        for (PsiMethodWrapper method : namedMembers.methods) {
            FunctionDescriptorImpl function = this.resolveMethodToFunctionDescriptor(owner, psiClass, method);
            if (function == null) continue;
            functionsFromCurrent.add((SimpleFunctionDescriptor)((Object)function));
        }
        if (owner instanceof ClassDescriptor) {
            ClassDescriptor classDescriptor = (ClassDescriptor)owner;
            Set<SimpleFunctionDescriptor> functionsFromSupertypes = this.getFunctionsFromSupertypes(scopeData, methodName);
            OverrideResolver.generateOverridesInFunctionGroup(methodName, functionsFromSupertypes, functionsFromCurrent, classDescriptor, new OverrideResolver.DescriptorSink(){

                @Override
                public void addToScope(@NotNull CallableMemberDescriptor fakeOverride) {
                    functions.add((FunctionDescriptor)fakeOverride);
                }

                @Override
                public void conflict(@NotNull CallableMemberDescriptor fromSuper, @NotNull CallableMemberDescriptor fromCurrent) {
                }
            });
        }
        functions.addAll(functionsFromCurrent);
        namedMembers.functionDescriptors = functions;
    }

    private Set<SimpleFunctionDescriptor> getFunctionsFromSupertypes(ResolverScopeData scopeData, String methodName) {
        HashSet<SimpleFunctionDescriptor> r = new HashSet<SimpleFunctionDescriptor>();
        for (JetType supertype : this.getSupertypes(scopeData)) {
            for (FunctionDescriptor function : supertype.getMemberScope().getFunctions(methodName)) {
                r.add((SimpleFunctionDescriptor)function);
            }
        }
        return r;
    }

    private ResolverScopeData getResolverScopeData(@NotNull ClassOrNamespaceDescriptor owner, PsiClassWrapper psiClass) {
        boolean staticMembers;
        ResolverScopeData scopeData;
        if (owner instanceof JavaNamespaceDescriptor) {
            scopeData = this.namespaceDescriptorCacheByFqn.get(((JavaNamespaceDescriptor)owner).getQualifiedName());
            staticMembers = true;
        } else if (owner instanceof ClassDescriptor) {
            scopeData = this.classDescriptorCache.get(psiClass.getQualifiedName());
            staticMembers = false;
        } else {
            throw new IllegalStateException("unknown owner: " + owner.getClass().getName());
        }
        if (scopeData == null) {
            throw new IllegalStateException();
        }
        if (scopeData.namedMembersMap == null) {
            scopeData.namedMembersMap = JavaDescriptorResolverHelper.getNamedMembers(psiClass, staticMembers, scopeData.kotlin);
        }
        return scopeData;
    }

    @NotNull
    public Set<FunctionDescriptor> resolveFunctionGroup(@NotNull ClassOrNamespaceDescriptor descriptor, @NotNull PsiClass psiClass, @NotNull String methodName, boolean staticMembers) {
        ResolverScopeData resolverScopeData = this.getResolverScopeData(descriptor, new PsiClassWrapper(psiClass));
        Map namedMembersMap = resolverScopeData.namedMembersMap;
        NamedMembers namedMembers = (NamedMembers)namedMembersMap.get(methodName);
        if (namedMembers != null && namedMembers.methods != null) {
            TypeSubstitutor typeSubstitutor = this.typeSubstitutorForGenericSupertypes(resolverScopeData);
            this.resolveNamedGroupFunctions(descriptor, psiClass, typeSubstitutor, namedMembers, methodName, resolverScopeData);
            return namedMembers.functionDescriptors;
        }
        return Collections.emptySet();
    }

    private TypeSubstitutor createSubstitutorForGenericSupertypes(@Nullable ClassDescriptor classDescriptor) {
        TypeSubstitutor typeSubstitutor = classDescriptor != null ? TypeUtils.buildDeepSubstitutor(classDescriptor.getDefaultType()) : TypeSubstitutor.EMPTY;
        return typeSubstitutor;
    }

    private ValueParameterDescriptors resolveParameterDescriptors(DeclarationDescriptor containingDeclaration, List<PsiParameterWrapper> parameters, TypeVariableResolver typeVariableResolver) {
        ArrayList<ValueParameterDescriptor> result = new ArrayList<ValueParameterDescriptor>();
        JetType receiverType = null;
        int indexDelta = 0;
        int parametersLength = parameters.size();
        for (int i = 0; i < parametersLength; ++i) {
            PsiParameterWrapper parameter = parameters.get(i);
            JvmMethodParameterMeaning meaning = this.resolveParameterDescriptor(containingDeclaration, i + indexDelta, parameter, typeVariableResolver);
            if (meaning.kind == JvmMethodParameterKind.TYPE_INFO) {
                --indexDelta;
                continue;
            }
            if (meaning.kind == JvmMethodParameterKind.REGULAR) {
                result.add(meaning.valueParameterDescriptor);
                continue;
            }
            if (meaning.kind != JvmMethodParameterKind.RECEIVER) continue;
            if (receiverType != null) {
                throw new IllegalStateException("more then one receiver");
            }
            --indexDelta;
            receiverType = meaning.receiverType;
        }
        return new ValueParameterDescriptors(receiverType, result);
    }

    @Nullable
    private FunctionDescriptorImpl resolveMethodToFunctionDescriptor(ClassOrNamespaceDescriptor owner, PsiClass psiClass, PsiMethodWrapper method) {
        ClassOrNamespaceDescriptor classDescriptor;
        String ownerClassName;
        boolean kotlin;
        PsiType returnType = method.getReturnType();
        if (returnType == null) {
            return null;
        }
        ResolverScopeData scopeData = this.getResolverScopeData(owner, new PsiClassWrapper(psiClass));
        if (owner instanceof JavaNamespaceDescriptor) {
            JavaNamespaceDescriptor javaNamespaceDescriptor = (JavaNamespaceDescriptor)owner;
            ResolverNamespaceData namespaceData = this.namespaceDescriptorCacheByFqn.get(javaNamespaceDescriptor.getQualifiedName());
            if (namespaceData == null) {
                throw new IllegalStateException("namespaceData not found by name " + javaNamespaceDescriptor.getQualifiedName());
            }
            kotlin = namespaceData.kotlin;
        } else {
            ResolverBinaryClassData classData = this.classDescriptorCache.get(psiClass.getQualifiedName());
            if (classData == null) {
                throw new IllegalStateException("classData not found by name " + psiClass.getQualifiedName());
            }
            kotlin = classData.kotlin;
        }
        if (method.getJetMethod().kind() == 1) {
            return null;
        }
        if (kotlin && (ownerClassName = method.getPsiMethod().getContainingClass().getQualifiedName()).equals("java.lang.Object")) {
            return null;
        }
        if (scopeData instanceof ResolverBinaryClassData) {
            ClassDescriptor classClassDescriptor = this.resolveClass(method.getPsiMethod().getContainingClass());
            classDescriptor = classClassDescriptor;
        } else {
            classDescriptor = this.resolveNamespace(method.getPsiMethod().getContainingClass());
        }
        if (classDescriptor == null) {
            return null;
        }
        SimpleFunctionDescriptorImpl functionDescriptorImpl = new SimpleFunctionDescriptorImpl(owner, this.resolveAnnotations((PsiModifierListOwner)method.getPsiMethod()), method.getName(), CallableMemberDescriptor.Kind.DECLARATION);
        TypeVariableResolver typeVariableResolverForParameters = TypeVariableResolvers.classTypeVariableResolver(classDescriptor);
        List<TypeParameterDescriptor> methodTypeParameters = this.resolveMethodTypeParameters(method, functionDescriptorImpl, typeVariableResolverForParameters);
        TypeVariableResolverFromTypeDescriptors methodTypeVariableResolver = new TypeVariableResolverFromTypeDescriptors(methodTypeParameters, typeVariableResolverForParameters);
        ValueParameterDescriptors valueParameterDescriptors = this.resolveParameterDescriptors(functionDescriptorImpl, method.getParameters(), methodTypeVariableResolver);
        functionDescriptorImpl.initialize(valueParameterDescriptors.receiverType, DescriptorUtils.getExpectedThisObjectIfNeeded(classDescriptor), methodTypeParameters, valueParameterDescriptors.descriptors, this.makeReturnType(returnType, method, methodTypeVariableResolver), Modality.convertFromFlags(method.getPsiMethod().hasModifierProperty("abstract"), !method.isFinal()), JavaDescriptorResolver.resolveVisibilityFromPsiModifiers((PsiModifierListOwner)method.getPsiMethod()));
        this.semanticServices.getTrace().record(BindingContext.FUNCTION, method.getPsiMethod(), functionDescriptorImpl);
        SimpleFunctionDescriptorImpl substitutedFunctionDescriptor = functionDescriptorImpl;
        if (method.getPsiMethod().getContainingClass() != psiClass && !method.isStatic()) {
            throw new IllegalStateException("non-static method in subclass");
        }
        return substitutedFunctionDescriptor;
    }

    private List<AnnotationDescriptor> resolveAnnotations(PsiModifierListOwner owner) {
        PsiAnnotation[] psiAnnotations = owner.getModifierList().getAnnotations();
        ArrayList r = Lists.newArrayListWithCapacity((int)psiAnnotations.length);
        for (PsiAnnotation psiAnnotation : psiAnnotations) {
            AnnotationDescriptor annotation = this.resolveAnnotation(psiAnnotation);
            if (annotation == null) continue;
            r.add(annotation);
        }
        return r;
    }

    @Nullable
    private AnnotationDescriptor resolveAnnotation(PsiAnnotation psiAnnotation) {
        AnnotationDescriptor annotation = new AnnotationDescriptor();
        String qname = psiAnnotation.getQualifiedName();
        if (qname.startsWith("java.lang.annotation.") || qname.startsWith("jet.runtime.typeinfo.") || qname.equals(JvmAbi.JETBRAINS_NOT_NULL_ANNOTATION.getFqName())) {
            return null;
        }
        ClassDescriptor clazz = this.resolveClass(psiAnnotation.getQualifiedName());
        if (clazz == null) {
            return null;
        }
        annotation.setAnnotationType(clazz.getDefaultType());
        ArrayList valueArguments = new ArrayList();
        if ("jet.runtime.Intrinsic".equals(psiAnnotation.getQualifiedName())) {
            valueArguments.add(new StringValue(psiAnnotation.findAttributeValue("value").getText()));
            annotation.setValueArguments(valueArguments);
        } else {
            annotation.setValueArguments(valueArguments);
        }
        return annotation;
    }

    public List<FunctionDescriptor> resolveMethods(PsiClass psiClass, ClassOrNamespaceDescriptor containingDeclaration) {
        ResolverScopeData scopeData = this.getResolverScopeData(containingDeclaration, new PsiClassWrapper(psiClass));
        TypeSubstitutor substitutorForGenericSupertypes = this.typeSubstitutorForGenericSupertypes(scopeData);
        ArrayList<FunctionDescriptor> functions = new ArrayList<FunctionDescriptor>();
        for (Map.Entry entry : scopeData.namedMembersMap.entrySet()) {
            String methodName = (String)entry.getKey();
            NamedMembers namedMembers = (NamedMembers)entry.getValue();
            this.resolveNamedGroupFunctions(containingDeclaration, psiClass, substitutorForGenericSupertypes, namedMembers, methodName, scopeData);
            functions.addAll(namedMembers.functionDescriptors);
        }
        return functions;
    }

    private Collection<JetType> getSupertypes(ResolverScopeData scope) {
        if (scope instanceof ResolverBinaryClassData) {
            return ((ResolverBinaryClassData)scope).classDescriptor.getSupertypes();
        }
        if (scope instanceof ResolverNamespaceData) {
            return Collections.emptyList();
        }
        throw new IllegalStateException();
    }

    private TypeSubstitutor typeSubstitutorForGenericSupertypes(ResolverScopeData scopeData) {
        if (scopeData instanceof ResolverClassData) {
            return this.createSubstitutorForGenericSupertypes(((ResolverClassData)scopeData).getClassDescriptor());
        }
        return TypeSubstitutor.EMPTY;
    }

    private List<TypeParameterDescriptor> resolveMethodTypeParameters(@NotNull PsiMethodWrapper method, @NotNull DeclarationDescriptor functionDescriptor, @NotNull TypeVariableResolver classTypeVariableResolver) {
        List<TypeParameterDescriptorInitialization> typeParametersIntialization = method.getJetMethod().typeParameters().length() > 0 ? this.resolveMethodTypeParametersFromJetSignature(method.getJetMethod().typeParameters(), method.getPsiMethod(), functionDescriptor, classTypeVariableResolver) : this.makeUninitializedTypeParameters(functionDescriptor, method.getPsiMethod().getTypeParameters());
        this.initializeTypeParameters(typeParametersIntialization, classTypeVariableResolver);
        ArrayList typeParameters = Lists.newArrayListWithCapacity((int)typeParametersIntialization.size());
        for (TypeParameterDescriptorInitialization tpdi : typeParametersIntialization) {
            typeParameters.add(tpdi.descriptor);
        }
        return typeParameters;
    }

    private List<TypeParameterDescriptorInitialization> resolveMethodTypeParametersFromJetSignature(String jetSignature, PsiMethod method, DeclarationDescriptor functionDescriptor, TypeVariableResolver classTypeVariableResolver) {
        JetSignatureTypeParametersVisitor jetSignatureTypeParametersVisitor = new JetSignatureTypeParametersVisitor(classTypeVariableResolver, functionDescriptor, (PsiTypeParameterListOwner)method);
        new JetSignatureReader(jetSignature).acceptFormalTypeParametersOnly((JetSignatureVisitor)jetSignatureTypeParametersVisitor);
        return jetSignatureTypeParametersVisitor.r;
    }

    private JetType makeReturnType(PsiType returnType, PsiMethodWrapper method, @NotNull TypeVariableResolver typeVariableResolver) {
        String returnTypeFromAnnotation = method.getJetMethod().returnType();
        JetType transformedType = returnTypeFromAnnotation.length() > 0 ? this.semanticServices.getTypeTransformer().transformToType(returnTypeFromAnnotation, typeVariableResolver) : this.semanticServices.getTypeTransformer().transformToType(returnType, typeVariableResolver);
        if (method.getJetMethod().returnTypeNullable()) {
            return TypeUtils.makeNullableAsSpecified(transformedType, true);
        }
        if (method.getPsiMethod().getModifierList().findAnnotation(JvmAbi.JETBRAINS_NOT_NULL_ANNOTATION.getFqName()) != null) {
            return TypeUtils.makeNullableAsSpecified(transformedType, false);
        }
        return transformedType;
    }

    private static Visibility resolveVisibilityFromPsiModifiers(PsiModifierListOwner modifierListOwner) {
        return modifierListOwner.hasModifierProperty("public") ? Visibility.PUBLIC : (modifierListOwner.hasModifierProperty("private") ? Visibility.PRIVATE : (modifierListOwner.hasModifierProperty("protected") ? Visibility.PROTECTED : Visibility.INTERNAL));
    }

    public List<ClassDescriptor> resolveInnerClasses(DeclarationDescriptor owner, PsiClass psiClass, boolean staticMembers) {
        if (staticMembers) {
            return new ArrayList<ClassDescriptor>(0);
        }
        PsiClass[] innerPsiClasses = psiClass.getInnerClasses();
        ArrayList<ClassDescriptor> r = new ArrayList<ClassDescriptor>(innerPsiClasses.length);
        for (PsiClass innerPsiClass : innerPsiClasses) {
            if (innerPsiClass.hasModifierProperty("private") || innerPsiClass.getName().equals("ClassObject$")) continue;
            r.add(this.resolveClass(innerPsiClass));
        }
        return r;
    }

    private static class JvmMethodParameterMeaning {
        private final JvmMethodParameterKind kind;
        private final JetType receiverType;
        private final ValueParameterDescriptor valueParameterDescriptor;
        private final Object typeInfo;

        private JvmMethodParameterMeaning(JvmMethodParameterKind kind, JetType receiverType, ValueParameterDescriptor valueParameterDescriptor, Object typeInfo) {
            this.kind = kind;
            this.receiverType = receiverType;
            this.valueParameterDescriptor = valueParameterDescriptor;
            this.typeInfo = typeInfo;
        }

        public static JvmMethodParameterMeaning receiver(@NotNull JetType receiverType) {
            return new JvmMethodParameterMeaning(JvmMethodParameterKind.RECEIVER, receiverType, null, null);
        }

        public static JvmMethodParameterMeaning regular(@NotNull ValueParameterDescriptor valueParameterDescriptor) {
            return new JvmMethodParameterMeaning(JvmMethodParameterKind.REGULAR, null, valueParameterDescriptor, null);
        }

        public static JvmMethodParameterMeaning typeInfo(@NotNull Object typeInfo) {
            return new JvmMethodParameterMeaning(JvmMethodParameterKind.TYPE_INFO, null, null, typeInfo);
        }
    }

    private static enum JvmMethodParameterKind {
        REGULAR,
        RECEIVER,
        TYPE_INFO;

    }

    private static class ValueParameterDescriptors {
        private final JetType receiverType;
        private final List<ValueParameterDescriptor> descriptors;

        private ValueParameterDescriptors(@Nullable JetType receiverType, List<ValueParameterDescriptor> descriptors) {
            this.receiverType = receiverType;
            this.descriptors = descriptors;
        }
    }

    private class JetSignatureTypeParametersVisitor
    extends JetSignatureExceptionsAdapter {
        @NotNull
        private final DeclarationDescriptor containingDeclaration;
        @NotNull
        private final PsiTypeParameterListOwner psiOwner;
        private final List<TypeParameterDescriptor> previousTypeParameters = new ArrayList<TypeParameterDescriptor>();
        private final TypeVariableResolver typeVariableResolver;
        private int formalTypeParameterIndex = 0;
        List<TypeParameterDescriptorInitialization> r = new ArrayList<TypeParameterDescriptorInitialization>();

        private JetSignatureTypeParametersVisitor(@NotNull TypeVariableResolver containerTypeVariableResolver, @NotNull DeclarationDescriptor containingDeclaration, PsiTypeParameterListOwner psiOwner) {
            this.containingDeclaration = containingDeclaration;
            this.psiOwner = psiOwner;
            this.typeVariableResolver = new TypeVariableResolverFromTypeDescriptors(this.previousTypeParameters, containerTypeVariableResolver);
        }

        public JetSignatureVisitor visitFormalTypeParameter(String name, TypeInfoVariance variance, boolean reified) {
            TypeParameterDescriptor typeParameter = TypeParameterDescriptor.createForFurtherModification(this.containingDeclaration, Collections.<AnnotationDescriptor>emptyList(), reified, JetSignatureUtils.translateVariance(variance), name, this.formalTypeParameterIndex++);
            this.previousTypeParameters.add(typeParameter);
            return new JetSignatureTypeParameterVisitor(this.psiOwner, name, this.typeVariableResolver, typeParameter){

                @Override
                protected void done(@NotNull TypeParameterDescriptorInitialization typeParameterDescriptor) {
                    JetSignatureTypeParametersVisitor.this.r.add(typeParameterDescriptor);
                    JetSignatureTypeParametersVisitor.this.previousTypeParameters.add(typeParameterDescriptor.descriptor);
                }
            };
        }
    }

    private abstract class JetSignatureTypeParameterVisitor
    extends JetSignatureExceptionsAdapter {
        @NotNull
        private final PsiTypeParameterListOwner psiOwner;
        @NotNull
        private final String name;
        @NotNull
        private final TypeVariableResolver typeVariableResolver;
        @NotNull
        private final TypeParameterDescriptor typeParameterDescriptor;
        List<JetType> upperBounds = new ArrayList<JetType>();
        List<JetType> lowerBounds = new ArrayList<JetType>();

        protected JetSignatureTypeParameterVisitor(PsiTypeParameterListOwner psiOwner, String name, TypeVariableResolver typeVariableResolver, TypeParameterDescriptor typeParameterDescriptor) {
            if (name.isEmpty()) {
                throw new IllegalStateException();
            }
            this.psiOwner = psiOwner;
            this.name = name;
            this.typeVariableResolver = typeVariableResolver;
            this.typeParameterDescriptor = typeParameterDescriptor;
        }

        public JetSignatureVisitor visitClassBound() {
            return new JetTypeJetSignatureReader(JavaDescriptorResolver.this.semanticServices, JavaDescriptorResolver.this.semanticServices.getJetSemanticServices().getStandardLibrary(), this.typeVariableResolver){

                @Override
                protected void done(@NotNull JetType jetType) {
                    if (JavaDescriptorResolver.this.isJavaLangObject(jetType)) {
                        return;
                    }
                    JetSignatureTypeParameterVisitor.this.upperBounds.add(jetType);
                }
            };
        }

        public JetSignatureVisitor visitInterfaceBound() {
            return new JetTypeJetSignatureReader(JavaDescriptorResolver.this.semanticServices, JavaDescriptorResolver.this.semanticServices.getJetSemanticServices().getStandardLibrary(), this.typeVariableResolver){

                @Override
                protected void done(@NotNull JetType jetType) {
                    JetSignatureTypeParameterVisitor.this.upperBounds.add(jetType);
                }
            };
        }

        public void visitFormalTypeParameterEnd() {
            PsiTypeParameter psiTypeParameter = JavaDescriptorResolver.this.getPsiTypeParameterByName(this.psiOwner, this.name);
            TypeParameterDescriptorInitialization typeParameterDescriptorInitialization = new TypeParameterDescriptorInitialization(this.typeParameterDescriptor, psiTypeParameter, this.upperBounds, this.lowerBounds);
            this.done(typeParameterDescriptorInitialization);
        }

        protected abstract void done(@NotNull TypeParameterDescriptorInitialization var1);
    }

    private static class ResolverNamespaceData
    extends ResolverScopeData {
        private JavaNamespaceDescriptor namespaceDescriptor;

        private ResolverNamespaceData() {
        }

        @NotNull
        public NamespaceDescriptor getNamespaceDescriptor() {
            return this.namespaceDescriptor;
        }

        @Override
        @NotNull
        public List<TypeParameterDescriptor> getTypeParameters() {
            return new ArrayList<TypeParameterDescriptor>(0);
        }
    }

    static class ResolverSrcClassData
    extends ResolverClassData {
        @NotNull
        private final ClassDescriptor classDescriptor;

        ResolverSrcClassData(@NotNull ClassDescriptor classDescriptor) {
            this.classDescriptor = classDescriptor;
        }

        @Override
        @NotNull
        public ClassDescriptor getClassDescriptor() {
            return this.classDescriptor;
        }
    }

    static class ResolverBinaryClassData
    extends ResolverClassData {
        private MutableClassDescriptorLite classDescriptor;
        List<TypeParameterDescriptorInitialization> typeParameters;

        ResolverBinaryClassData() {
        }

        @Override
        @NotNull
        public ClassDescriptor getClassDescriptor() {
            return this.classDescriptor;
        }
    }

    static abstract class ResolverClassData
    extends ResolverScopeData {
        ResolverClassData() {
        }

        @NotNull
        public abstract ClassDescriptor getClassDescriptor();

        @Override
        @NotNull
        public List<TypeParameterDescriptor> getTypeParameters() {
            return this.getClassDescriptor().getTypeConstructor().getParameters();
        }
    }

    private static abstract class ResolverScopeData {
        protected boolean kotlin;
        private Map<String, NamedMembers> namedMembersMap;

        private ResolverScopeData() {
        }

        @NotNull
        public abstract List<TypeParameterDescriptor> getTypeParameters();
    }

    public static class TypeParameterDescriptorInitialization {
        @NotNull
        private final TypeParameterDescriptorOrigin origin;
        @NotNull
        final TypeParameterDescriptor descriptor;
        final PsiTypeParameter psiTypeParameter;
        @Nullable
        private final List<JetType> upperBoundsForKotlin;
        @Nullable
        private final List<JetType> lowerBoundsForKotlin;

        private TypeParameterDescriptorInitialization(@NotNull TypeParameterDescriptor descriptor, @NotNull PsiTypeParameter psiTypeParameter) {
            this.origin = TypeParameterDescriptorOrigin.JAVA;
            this.descriptor = descriptor;
            this.psiTypeParameter = psiTypeParameter;
            this.upperBoundsForKotlin = null;
            this.lowerBoundsForKotlin = null;
        }

        private TypeParameterDescriptorInitialization(@NotNull TypeParameterDescriptor descriptor, @NotNull PsiTypeParameter psiTypeParameter, List<JetType> upperBoundsForKotlin, List<JetType> lowerBoundsForKotlin) {
            this.origin = TypeParameterDescriptorOrigin.KOTLIN;
            this.descriptor = descriptor;
            this.psiTypeParameter = psiTypeParameter;
            this.upperBoundsForKotlin = upperBoundsForKotlin;
            this.lowerBoundsForKotlin = lowerBoundsForKotlin;
        }
    }

    private static enum TypeParameterDescriptorOrigin {
        JAVA,
        KOTLIN;

    }
}

