/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.intellij.openapi.util.Ref;
import java.util.Collections;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.java.JavaSemanticServices;
import org.jetbrains.jet.lang.resolve.java.PsiClassWrapper;
import org.jetbrains.jet.lang.resolve.scopes.JetScopeImpl;

public abstract class JavaClassOrPackageScope
extends JetScopeImpl {
    @NotNull
    protected final ClassOrNamespaceDescriptor descriptor;
    protected final JavaSemanticServices semanticServices;
    private Ref<PsiClassWrapper> myPsiClassMemo;

    protected JavaClassOrPackageScope(@NotNull ClassOrNamespaceDescriptor descriptor, @NotNull JavaSemanticServices semanticServices) {
        this.descriptor = descriptor;
        this.semanticServices = semanticServices;
    }

    @Override
    @NotNull
    public DeclarationDescriptor getContainingDeclaration() {
        return this.descriptor;
    }

    @Nullable
    protected abstract PsiClassWrapper psiClass();

    protected abstract boolean staticMembers();

    @Override
    @NotNull
    public Set<VariableDescriptor> getProperties(@NotNull String name) {
        PsiClassWrapper psiClass = this.memoPsiClass();
        if (psiClass == null) {
            return Collections.emptySet();
        }
        return this.semanticServices.getDescriptorResolver().resolveFieldGroupByName(this.descriptor, psiClass.getPsiClass(), name, this.staticMembers());
    }

    private PsiClassWrapper memoPsiClass() {
        if (this.myPsiClassMemo != null) {
            return (PsiClassWrapper)this.myPsiClassMemo.get();
        }
        PsiClassWrapper answer = this.psiClass();
        this.myPsiClassMemo = new Ref((Object)answer);
        return answer;
    }

    @Override
    @NotNull
    public Set<FunctionDescriptor> getFunctions(@NotNull String name) {
        PsiClassWrapper psiClassForPackage = this.memoPsiClass();
        if (psiClassForPackage == null) {
            return Collections.emptySet();
        }
        return this.semanticServices.getDescriptorResolver().resolveFunctionGroup(this.descriptor, psiClassForPackage.getPsiClass(), name, this.staticMembers());
    }
}

