/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiClass;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassOrNamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.java.JavaClassOrPackageScope;
import org.jetbrains.jet.lang.resolve.java.JavaSemanticServices;
import org.jetbrains.jet.lang.resolve.java.PsiClassWrapper;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;

public class JavaClassMembersScope
extends JavaClassOrPackageScope {
    private final PsiClassWrapper psiClass;
    private final boolean staticMembers;
    private final Map<String, ClassifierDescriptor> classifiers = Maps.newHashMap();
    private Collection<DeclarationDescriptor> allDescriptors;

    public JavaClassMembersScope(@NotNull ClassOrNamespaceDescriptor classOrNamespaceDescriptor, @NotNull PsiClass psiClass, @NotNull JavaSemanticServices semanticServices, boolean staticMembers) {
        super(classOrNamespaceDescriptor, semanticServices);
        this.psiClass = new PsiClassWrapper(psiClass);
        this.staticMembers = staticMembers;
    }

    @Override
    protected PsiClassWrapper psiClass() {
        return this.psiClass;
    }

    @Override
    protected boolean staticMembers() {
        return this.staticMembers;
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getDeclarationsByLabel(String labelName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public ClassifierDescriptor getClassifier(@NotNull String name) {
        ClassifierDescriptor classifierDescriptor = this.classifiers.get(name);
        if (classifierDescriptor == null) {
            classifierDescriptor = this.doGetClassifierDescriptor(name);
            this.classifiers.put(name, classifierDescriptor);
        }
        return classifierDescriptor;
    }

    @Override
    public ClassDescriptor getObjectDescriptor(@NotNull String name) {
        return null;
    }

    @Override
    @NotNull
    public Set<ClassDescriptor> getObjectDescriptors() {
        return Collections.emptySet();
    }

    @Override
    @NotNull
    public Collection<DeclarationDescriptor> getAllDescriptors() {
        if (this.allDescriptors == null) {
            this.allDescriptors = Sets.newHashSet();
            this.allDescriptors.addAll(this.semanticServices.getDescriptorResolver().resolveMethods(this.psiClass.getPsiClass(), this.descriptor));
            this.allDescriptors.addAll(this.semanticServices.getDescriptorResolver().resolveFieldGroup(this.descriptor, this.psiClass.getPsiClass(), this.staticMembers));
            this.allDescriptors.addAll(this.semanticServices.getDescriptorResolver().resolveInnerClasses(this.descriptor, this.psiClass.getPsiClass(), this.staticMembers));
        }
        return this.allDescriptors;
    }

    private ClassifierDescriptor doGetClassifierDescriptor(String name) {
        for (PsiClass innerClass : this.psiClass.getPsiClass().getAllInnerClasses()) {
            if (!name.equals(innerClass.getName())) continue;
            if (innerClass.hasModifierProperty("static") != this.staticMembers) {
                return null;
            }
            ClassDescriptor classDescriptor = this.semanticServices.getDescriptorResolver().resolveClass(innerClass);
            if (classDescriptor == null) continue;
            return classDescriptor;
        }
        return null;
    }

    @Override
    public NamespaceDescriptor getNamespace(@NotNull String name) {
        return null;
    }

    @Override
    @NotNull
    public ReceiverDescriptor getImplicitReceiver() {
        return ReceiverDescriptor.NO_RECEIVER;
    }

    @Override
    public void getImplicitReceiversHierarchy(@NotNull List<ReceiverDescriptor> result) {
    }
}

