/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.intellij.openapi.project.Project;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.Configuration;
import org.jetbrains.jet.lang.JetSemanticServices;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.Importer;
import org.jetbrains.jet.lang.resolve.java.JavaDescriptorResolver;
import org.jetbrains.jet.lang.resolve.java.JavaNamespaceDescriptor;
import org.jetbrains.jet.lang.resolve.java.JavaPackageScope;
import org.jetbrains.jet.lang.resolve.java.JavaSemanticServices;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;

public class JavaBridgeConfiguration
implements Configuration {
    public static final String[] DEFAULT_JAVA_IMPORTS = new String[]{"java.lang"};
    private final JavaSemanticServices javaSemanticServices;
    private final Configuration delegateConfiguration;

    public static Configuration createJavaBridgeConfiguration(@NotNull Project project, @NotNull BindingTrace trace, Configuration delegateConfiguration) {
        return new JavaBridgeConfiguration(project, trace, delegateConfiguration);
    }

    private JavaBridgeConfiguration(Project project, BindingTrace trace, Configuration delegateConfiguration) {
        this.javaSemanticServices = new JavaSemanticServices(project, JetSemanticServices.createSemanticServices(project), trace);
        this.delegateConfiguration = delegateConfiguration;
    }

    @Override
    public void addDefaultImports(@NotNull BindingTrace trace, @NotNull WritableScope rootScope, @NotNull Importer importer) {
        rootScope.importScope(new JavaPackageScope("", JavaBridgeConfiguration.createNamespaceDescriptor(JavaDescriptorResolver.JAVA_ROOT, ""), this.javaSemanticServices));
        for (String importFQN : DEFAULT_JAVA_IMPORTS) {
            NamespaceDescriptor namespaceDescriptor = this.javaSemanticServices.getDescriptorResolver().resolveNamespace(importFQN);
            if (namespaceDescriptor == null) continue;
            importer.addScopeImport(namespaceDescriptor.getMemberScope());
        }
        this.delegateConfiguration.addDefaultImports(trace, rootScope, importer);
    }

    public static JavaNamespaceDescriptor createNamespaceDescriptor(String name, String qualifiedName) {
        return new JavaNamespaceDescriptor(null, Collections.<AnnotationDescriptor>emptyList(), name, qualifiedName, true);
    }

    @Override
    public void extendNamespaceScope(@NotNull BindingTrace trace, @NotNull NamespaceDescriptor namespaceDescriptor, @NotNull WritableScope namespaceMemberScope) {
        namespaceMemberScope.importScope(new JavaPackageScope(DescriptorUtils.getFQName(namespaceDescriptor), namespaceDescriptor, this.javaSemanticServices));
        this.delegateConfiguration.extendNamespaceScope(trace, namespaceDescriptor, namespaceMemberScope);
    }
}

