/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.java;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.Function;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.JetSemanticServices;
import org.jetbrains.jet.lang.StandardConfiguration;
import org.jetbrains.jet.lang.cfg.pseudocode.JetControlFlowDataTraceFactory;
import org.jetbrains.jet.lang.diagnostics.DiagnosticUtils;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.resolve.AnalyzingUtils;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.java.JavaBridgeConfiguration;

public class AnalyzerFacade {
    public static final Function<JetFile, Collection<JetFile>> SINGLE_DECLARATION_PROVIDER = new Function<JetFile, Collection<JetFile>>(){

        public Collection<JetFile> fun(JetFile file) {
            return Collections.singleton(file);
        }
    };
    private static final Key<CachedValue<BindingContext>> BINDING_CONTEXT = Key.create((String)"BINDING_CONTEXT");
    private static final Object lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BindingContext analyzeFileWithCache(final @NotNull JetFile file, final @NotNull Function<JetFile, Collection<JetFile>> declarationProvider) {
        Object object = lock;
        synchronized (object) {
            CachedValue bindingContextCachedValue = (CachedValue)file.getUserData(BINDING_CONTEXT);
            if (bindingContextCachedValue == null) {
                bindingContextCachedValue = CachedValuesManager.getManager((Project)file.getProject()).createCachedValue((CachedValueProvider)new CachedValueProvider<BindingContext>(){

                    public CachedValueProvider.Result<BindingContext> compute() {
                        try {
                            BindingContext bindingContext = AnalyzerFacade.analyzeFilesWithJavaIntegration(file.getProject(), (Collection)declarationProvider.fun((Object)file), (Predicate<PsiFile>)Predicates.equalTo((Object)((Object)file)), JetControlFlowDataTraceFactory.EMPTY);
                            return new CachedValueProvider.Result((Object)bindingContext, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                        }
                        catch (ProcessCanceledException e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            DiagnosticUtils.throwIfRunningOnServer(e);
                            e.printStackTrace();
                            BindingTraceContext bindingTraceContext = new BindingTraceContext();
                            bindingTraceContext.report(Errors.EXCEPTION_WHILE_ANALYZING.on(file, e));
                            return new CachedValueProvider.Result((Object)bindingTraceContext.getBindingContext(), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                        }
                    }
                }, false);
                file.putUserData(BINDING_CONTEXT, bindingContextCachedValue);
            }
            return (BindingContext)bindingContextCachedValue.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BindingContext analyzeProjectWithCache(final @NotNull Project project, final @NotNull Collection<JetFile> files) {
        Object object = lock;
        synchronized (object) {
            CachedValue bindingContextCachedValue = (CachedValue)project.getUserData(BINDING_CONTEXT);
            if (bindingContextCachedValue == null) {
                bindingContextCachedValue = CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)new CachedValueProvider<BindingContext>(){

                    public CachedValueProvider.Result<BindingContext> compute() {
                        try {
                            BindingContext bindingContext = AnalyzerFacade.analyzeFilesWithJavaIntegration(project, files, (Predicate<PsiFile>)Predicates.alwaysFalse(), JetControlFlowDataTraceFactory.EMPTY);
                            return new CachedValueProvider.Result((Object)bindingContext, new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                        }
                        catch (ProcessCanceledException e) {
                            throw e;
                        }
                        catch (Throwable e) {
                            DiagnosticUtils.throwIfRunningOnServer(e);
                            e.printStackTrace();
                            BindingTraceContext bindingTraceContext = new BindingTraceContext();
                            return new CachedValueProvider.Result((Object)bindingTraceContext.getBindingContext(), new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
                        }
                    }
                }, false);
                project.putUserData(BINDING_CONTEXT, (Object)bindingContextCachedValue);
            }
            return (BindingContext)bindingContextCachedValue.getValue();
        }
    }

    public static BindingContext analyzeOneFileWithJavaIntegration(JetFile file, JetControlFlowDataTraceFactory flowDataTraceFactory) {
        return AnalyzerFacade.analyzeFilesWithJavaIntegration(file.getProject(), Collections.singleton(file), (Predicate<PsiFile>)Predicates.alwaysTrue(), flowDataTraceFactory);
    }

    public static BindingContext analyzeFilesWithJavaIntegration(Project project, Collection<JetFile> files, Predicate<PsiFile> filesToAnalyzeCompletely, JetControlFlowDataTraceFactory flowDataTraceFactory) {
        BindingTraceContext bindingTraceContext = new BindingTraceContext();
        JetSemanticServices semanticServices = JetSemanticServices.createSemanticServices(project);
        return AnalyzingUtils.analyzeFilesWithGivenTrace(project, JavaBridgeConfiguration.createJavaBridgeConfiguration(project, bindingTraceContext, StandardConfiguration.createStandardConfiguration(project)), files, filesToAnalyzeCompletely, flowDataTraceFactory, bindingTraceContext, semanticServices);
    }

    public static BindingContext shallowAnalyzeFiles(Collection<JetFile> files) {
        assert (files.size() > 0);
        Project project = files.iterator().next().getProject();
        return AnalyzerFacade.analyzeFilesWithJavaIntegration(project, files, (Predicate<PsiFile>)Predicates.alwaysFalse(), JetControlFlowDataTraceFactory.EMPTY);
    }
}

