/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.inference;

import com.google.common.collect.Sets;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.calls.inference.BoundsOwner;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.Variance;

public class TypeValue
implements BoundsOwner {
    private final Set<TypeValue> upperBounds = Sets.newLinkedHashSet();
    private final Set<TypeValue> lowerBounds = Sets.newLinkedHashSet();
    private final Variance positionVariance;
    private final TypeParameterDescriptor typeParameterDescriptor;
    private final JetType originalType;
    private JetType value;

    public TypeValue(@NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull Variance positionVariance) {
        this.positionVariance = positionVariance;
        this.typeParameterDescriptor = typeParameterDescriptor;
        this.originalType = typeParameterDescriptor.getDefaultType();
    }

    public TypeValue(@NotNull JetType knownType) {
        this.positionVariance = null;
        this.typeParameterDescriptor = null;
        this.originalType = knownType;
        this.value = knownType;
    }

    public boolean isKnown() {
        return this.typeParameterDescriptor == null;
    }

    public TypeParameterDescriptor getTypeParameterDescriptor() {
        return this.typeParameterDescriptor;
    }

    @NotNull
    public Variance getPositionVariance() {
        return this.positionVariance;
    }

    @Override
    @NotNull
    public Set<TypeValue> getUpperBounds() {
        return this.upperBounds;
    }

    @Override
    @NotNull
    public Set<TypeValue> getLowerBounds() {
        return this.lowerBounds;
    }

    @NotNull
    public JetType getType() {
        return this.value;
    }

    @NotNull
    public JetType getOriginalType() {
        return this.originalType;
    }

    public void addUpperBound(@NotNull TypeValue bound) {
        this.upperBounds.add(bound);
    }

    public void addLowerBound(@NotNull TypeValue bound) {
        this.lowerBounds.add(bound);
    }

    public void setValue(@NotNull JetType value) {
        this.value = value;
    }

    public boolean hasValue() {
        return this.value != null;
    }

    public String toString() {
        return this.isKnown() ? this.getType().toString() : this.getTypeParameterDescriptor() + (this.hasValue() ? " |-> " + this.getType() : "");
    }
}

