/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls.inference;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintResolutionListener;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystem;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemSolution;
import org.jetbrains.jet.lang.resolve.calls.inference.SolutionStatus;
import org.jetbrains.jet.lang.resolve.calls.inference.SubtypingConstraint;
import org.jetbrains.jet.lang.types.CommonSupertypes;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lang.types.checker.TypeCheckingProcedure;
import org.jetbrains.jet.lang.types.checker.TypingConstraints;

public class ConstraintSystemImpl
implements ConstraintSystem {
    private final Map<JetType, KnownType> knownTypes = Maps.newHashMap();
    private final Map<TypeParameterDescriptor, UnknownType> unknownTypes = Maps.newHashMap();
    private final JetTypeChecker typeChecker = JetTypeChecker.INSTANCE;
    private final TypeCheckingProcedure constraintExpander;
    private final ConstraintResolutionListener listener;

    public static TypeSubstitutor makeConstantSubstitutor(Collection<TypeParameterDescriptor> typeParameterDescriptors, JetType type) {
        final HashSet constructors = Sets.newHashSet();
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameterDescriptors) {
            constructors.add(typeParameterDescriptor.getTypeConstructor());
        }
        final TypeProjection projection = new TypeProjection(type);
        return TypeSubstitutor.create(new TypeSubstitutor.TypeSubstitution(){

            @Override
            public TypeProjection get(TypeConstructor key) {
                if (constructors.contains(key)) {
                    return projection;
                }
                return null;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }
        });
    }

    public ConstraintSystemImpl(ConstraintResolutionListener listener) {
        this.listener = listener;
        this.constraintExpander = this.createConstraintExpander();
    }

    private TypeCheckingProcedure createConstraintExpander() {
        return new TypeCheckingProcedure(new TypeConstraintBuilderAdapter(new TypingConstraints(){

            @Override
            public boolean assertEqualTypes(@NotNull JetType a, @NotNull JetType b, @NotNull TypeCheckingProcedure typeCheckingProcedure) {
                TypeValue aValue = ConstraintSystemImpl.this.getTypeValueFor(a);
                TypeValue bValue = ConstraintSystemImpl.this.getTypeValueFor(b);
                return aValue.equate(bValue);
            }

            @Override
            public boolean assertEqualTypeConstructors(@NotNull TypeConstructor a, @NotNull TypeConstructor b) {
                return a.equals(b) || ConstraintSystemImpl.this.unknownTypes.containsKey(a.getDeclarationDescriptor()) || ConstraintSystemImpl.this.unknownTypes.containsKey(b.getDeclarationDescriptor());
            }

            @Override
            public boolean assertSubtype(@NotNull JetType subtype, @NotNull JetType supertype, @NotNull TypeCheckingProcedure typeCheckingProcedure) {
                TypeValue supertypeValue;
                TypeValue subtypeValue = ConstraintSystemImpl.this.getTypeValueFor(subtype);
                if (this.someUnknown(subtypeValue, supertypeValue = ConstraintSystemImpl.this.getTypeValueFor(supertype))) {
                    ConstraintSystemImpl.this.addSubtypingConstraintOnTypeValues(subtypeValue, supertypeValue);
                }
                return true;
            }

            @Override
            public boolean noCorrespondingSupertype(@NotNull JetType subtype, @NotNull JetType supertype) {
                TypeValue superTypeValue;
                TypeValue subTypeValue = ConstraintSystemImpl.this.getTypeValueFor(subtype);
                boolean someUnknown = this.someUnknown(subTypeValue, superTypeValue = ConstraintSystemImpl.this.getTypeValueFor(supertype));
                if (someUnknown) {
                    ConstraintSystemImpl.this.addSubtypingConstraintOnTypeValues(subTypeValue, superTypeValue);
                }
                return someUnknown;
            }

            private boolean someUnknown(TypeValue subtypeValue, TypeValue supertypeValue) {
                return subtypeValue instanceof UnknownType || supertypeValue instanceof UnknownType;
            }
        }, this.listener));
    }

    @NotNull
    private TypeValue getTypeValueFor(@NotNull JetType type) {
        UnknownType unknownType;
        TypeParameterDescriptor typeParameterDescriptor;
        ClassifierDescriptor declarationDescriptor = type.getConstructor().getDeclarationDescriptor();
        if (declarationDescriptor instanceof TypeParameterDescriptor && (typeParameterDescriptor = (TypeParameterDescriptor)declarationDescriptor).getDefaultType().isNullable() == type.isNullable() && (unknownType = this.unknownTypes.get(typeParameterDescriptor)) != null) {
            return unknownType;
        }
        KnownType typeValue = this.knownTypes.get(type);
        if (typeValue == null) {
            typeValue = new KnownType(type);
            this.knownTypes.put(type, typeValue);
        }
        return typeValue;
    }

    @Override
    public void registerTypeVariable(@NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull Variance positionVariance) {
        assert (!this.unknownTypes.containsKey(typeParameterDescriptor));
        UnknownType typeValue = new UnknownType(typeParameterDescriptor, positionVariance);
        this.unknownTypes.put(typeParameterDescriptor, typeValue);
    }

    @NotNull
    private UnknownType getTypeVariable(TypeParameterDescriptor typeParameterDescriptor) {
        UnknownType unknownType = this.unknownTypes.get(typeParameterDescriptor);
        if (unknownType == null) {
            throw new IllegalArgumentException("This type parameter is not an unknown in this constraint system: " + typeParameterDescriptor);
        }
        return unknownType;
    }

    private void mergeUnknowns(@NotNull UnknownType a, @NotNull UnknownType b) {
        this.listener.error("!!!mergeUnknowns() is not implemented!!!");
    }

    @Override
    public void addSubtypingConstraint(@NotNull SubtypingConstraint constraint) {
        TypeValue typeValueForLower = this.getTypeValueFor(constraint.getSubtype());
        TypeValue typeValueForUpper = this.getTypeValueFor(constraint.getSupertype());
        this.addSubtypingConstraintOnTypeValues(typeValueForLower, typeValueForUpper);
    }

    private void addSubtypingConstraintOnTypeValues(TypeValue typeValueForLower, TypeValue typeValueForUpper) {
        this.listener.log("Constraint added: ", typeValueForLower, " :< ", typeValueForUpper);
        if (typeValueForLower != typeValueForUpper) {
            typeValueForLower.addUpperBound(typeValueForUpper);
            typeValueForUpper.addLowerBound(typeValueForLower);
        }
    }

    @Override
    @NotNull
    public ConstraintSystemSolution solve() {
        TypeValue typeValue;
        for (Map.Entry entry : Sets.newHashSet(this.knownTypes.entrySet())) {
            KnownType knownBoundType;
            boolean ok;
            JetType jetType = (JetType)entry.getKey();
            typeValue = (KnownType)entry.getValue();
            for (TypeValue typeValue2 : typeValue.getUpperBounds()) {
                if (!(typeValue2 instanceof KnownType) || (ok = this.constraintExpander.isSubtypeOf(jetType, (knownBoundType = (KnownType)typeValue2).getType()))) continue;
                this.listener.error("Error while expanding '", jetType, " :< ", knownBoundType.getType(), "'");
                return new Solution().registerError("Mismatch while expanding constraints");
            }
            for (TypeValue typeValue3 : typeValue.getLowerBounds()) {
                if (!(typeValue3 instanceof KnownType) || (ok = this.constraintExpander.isSubtypeOf((knownBoundType = (KnownType)typeValue3).getType(), jetType))) continue;
                this.listener.error("Error while expanding '" + knownBoundType.getType() + " :< " + jetType + "'");
                return new Solution().registerError("Mismatch while expanding constraints");
            }
        }
        for (Map.Entry entry : Sets.newHashSet(this.unknownTypes.entrySet())) {
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)entry.getKey();
            typeValue = (UnknownType)entry.getValue();
            for (JetType jetType : typeParameterDescriptor.getUpperBounds()) {
                this.addSubtypingConstraintOnTypeValues(typeValue, this.getTypeValueFor(jetType));
            }
        }
        HashSet visited = Sets.newHashSet();
        for (UnknownType unknownType : this.unknownTypes.values()) {
            this.transitiveClosure(unknownType, visited);
        }
        for (UnknownType unknownType : this.unknownTypes.values()) {
        }
        for (KnownType knownType : this.knownTypes.values()) {
        }
        Solution solution = new Solution();
        for (UnknownType unknownType : this.unknownTypes.values()) {
            this.check(unknownType, solution);
        }
        for (KnownType knownType : this.knownTypes.values()) {
            this.check(knownType, solution);
        }
        this.listener.done(solution, this.unknownTypes.keySet());
        return solution;
    }

    private void check(TypeValue typeValue, Solution solution) {
        try {
            JetType boundingType;
            KnownType resultingValue = typeValue.getValue();
            JetType type = solution.getSubstitutor().substitute(resultingValue.getType(), Variance.INVARIANT);
            for (TypeValue upperBound : typeValue.getUpperBounds()) {
                boundingType = solution.getSubstitutor().substitute(upperBound.getValue().getType(), Variance.INVARIANT);
                if (this.typeChecker.isSubtypeOf(type, boundingType)) continue;
                solution.registerError("Constraint violation: " + type + " is not a subtype of " + boundingType);
                this.listener.error("Constraint violation: ", type, " :< ", boundingType);
            }
            for (TypeValue lowerBound : typeValue.getLowerBounds()) {
                boundingType = solution.getSubstitutor().substitute(lowerBound.getValue().getType(), Variance.INVARIANT);
                if (this.typeChecker.isSubtypeOf(boundingType, type)) continue;
                solution.registerError("Constraint violation: " + boundingType + " is not a subtype of " + type);
                this.listener.error("Constraint violation: ", boundingType, " :< ", type);
            }
        }
        catch (LoopInTypeVariableConstraintsException e) {
            this.listener.error("Loop detected");
            solution.registerError("[TODO] Loop in constraints");
        }
    }

    private void transitiveClosure(TypeValue current, Set<TypeValue> visited) {
        if (!visited.add(current)) {
            return;
        }
        for (TypeValue upperBound : Sets.newHashSet(current.getUpperBounds())) {
            if (upperBound instanceof KnownType) continue;
            this.transitiveClosure(upperBound, visited);
            Set<TypeValue> upperBounds = upperBound.getUpperBounds();
            for (TypeValue transitiveBound : upperBounds) {
                this.addSubtypingConstraintOnTypeValues(current, transitiveBound);
            }
        }
    }

    public class Solution
    implements ConstraintSystemSolution {
        private final TypeSubstitutor typeSubstitutor = TypeSubstitutor.create(new TypeSubstitutor.TypeSubstitution(){

            @Override
            public TypeProjection get(TypeConstructor key) {
                ClassifierDescriptor declarationDescriptor = key.getDeclarationDescriptor();
                if (declarationDescriptor instanceof TypeParameterDescriptor) {
                    TypeParameterDescriptor descriptor = (TypeParameterDescriptor)declarationDescriptor;
                    if (!ConstraintSystemImpl.this.unknownTypes.containsKey(descriptor)) {
                        return null;
                    }
                    TypeProjection typeProjection = new TypeProjection(Solution.this.getValue(descriptor));
                    ConstraintSystemImpl.this.listener.log(descriptor, " |-> ", typeProjection);
                    return typeProjection;
                }
                return null;
            }

            @Override
            public boolean isEmpty() {
                return false;
            }
        });
        private SolutionStatus status = SolutionStatus.SUCCESS;

        private Solution registerError(String message) {
            this.status = new Error(message);
            return this;
        }

        @Override
        @NotNull
        public SolutionStatus getStatus() {
            return this.status;
        }

        @Override
        public JetType getValue(TypeParameterDescriptor typeParameterDescriptor) {
            KnownType value = ConstraintSystemImpl.this.getTypeVariable(typeParameterDescriptor).getValue();
            return value == null ? null : value.getType();
        }

        @Override
        @NotNull
        public TypeSubstitutor getSubstitutor() {
            return this.typeSubstitutor;
        }
    }

    private static class Error
    implements SolutionStatus {
        private final String message;

        private Error(String message) {
            this.message = message;
        }

        @Override
        public boolean isSuccessful() {
            return false;
        }

        public String toString() {
            return this.message;
        }
    }

    private static final class TypeConstraintBuilderAdapter
    implements TypingConstraints {
        private final TypingConstraints delegate;
        private final ConstraintResolutionListener listener;

        private TypeConstraintBuilderAdapter(TypingConstraints delegate, ConstraintResolutionListener listener) {
            this.delegate = delegate;
            this.listener = listener;
        }

        @Override
        public boolean assertEqualTypes(@NotNull JetType a, @NotNull JetType b, @NotNull TypeCheckingProcedure typeCheckingProcedure) {
            boolean result = this.delegate.assertEqualTypes(a, b, typeCheckingProcedure);
            if (!result) {
                this.listener.error("-- Failed to equate ", a, " and ", b);
            }
            return result;
        }

        @Override
        public boolean assertEqualTypeConstructors(@NotNull TypeConstructor a, @NotNull TypeConstructor b) {
            boolean result = this.delegate.assertEqualTypeConstructors(a, b);
            if (!result) {
                this.listener.error("-- Type constructors are not equal: ", a, " and ", b);
            }
            return result;
        }

        @Override
        public boolean assertSubtype(@NotNull JetType subtype, @NotNull JetType supertype, @NotNull TypeCheckingProcedure typeCheckingProcedure) {
            boolean result = this.delegate.assertSubtype(subtype, supertype, typeCheckingProcedure);
            if (!result) {
                this.listener.error("-- ", subtype, " can't be a subtype of ", supertype);
            }
            return result;
        }

        @Override
        public boolean noCorrespondingSupertype(@NotNull JetType subtype, @NotNull JetType supertype) {
            boolean result = this.delegate.noCorrespondingSupertype(subtype, supertype);
            if (!result) {
                this.listener.error("-- ", subtype, " has no supertype corresponding to ", supertype);
            }
            return result;
        }
    }

    private class KnownType
    extends TypeValue {
        private final JetType type;

        public KnownType(JetType type) {
            this.type = type;
        }

        @NotNull
        public JetType getType() {
            return this.type;
        }

        @Override
        public KnownType getValue() {
            return this;
        }

        public String toString() {
            return this.type.toString();
        }

        @Override
        public boolean equate(TypeValue other) {
            if (other instanceof KnownType) {
                KnownType knownType = (KnownType)other;
                return ConstraintSystemImpl.this.constraintExpander.equalTypes(this.type, knownType.getType());
            }
            return other.equate(this);
        }
    }

    private class UnknownType
    extends TypeValue {
        private final TypeParameterDescriptor typeParameterDescriptor;
        private final Variance positionVariance;
        private KnownType value;
        private boolean beingComputed = false;

        private UnknownType(TypeParameterDescriptor typeParameterDescriptor, Variance positionVariance) {
            this.typeParameterDescriptor = typeParameterDescriptor;
            this.positionVariance = positionVariance;
        }

        @Override
        public void addUpperBound(@NotNull TypeValue bound) {
            this.addBound(bound, this.getLowerBounds());
            super.addUpperBound(bound);
        }

        @Override
        public void addLowerBound(@NotNull TypeValue bound) {
            this.addBound(bound, this.getUpperBounds());
            super.addLowerBound(bound);
        }

        private void addBound(TypeValue bound, Set<TypeValue> oppositeBounds) {
            if (oppositeBounds.contains(bound)) {
                this.equate(bound);
            }
        }

        @NotNull
        public TypeParameterDescriptor getTypeParameterDescriptor() {
            return this.typeParameterDescriptor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public KnownType getValue() {
            if (this.beingComputed) {
                throw new LoopInTypeVariableConstraintsException();
            }
            if (this.value == null) {
                this.beingComputed = true;
                JetTypeChecker typeChecker = JetTypeChecker.INSTANCE;
                try {
                    if (this.positionVariance == Variance.IN_VARIANCE) {
                        throw new UnsupportedOperationException();
                    }
                    Set<TypeValue> lowerBounds = this.getLowerBounds();
                    if (!lowerBounds.isEmpty()) {
                        Set<JetType> types = this.getTypes(lowerBounds);
                        JetType commonSupertype = CommonSupertypes.commonSupertype(types);
                        for (TypeValue upperBound : this.getUpperBounds()) {
                            if (typeChecker.isSubtypeOf(commonSupertype, upperBound.getValue().getType())) continue;
                            this.value = null;
                        }
                        ConstraintSystemImpl.this.listener.log("minimal solution from lowerbounds for ", this, " is ", commonSupertype);
                        this.value = new KnownType(commonSupertype);
                    } else {
                        Set<TypeValue> upperBounds = this.getUpperBounds();
                        Set<JetType> types = this.getTypes(upperBounds);
                        JetType intersect = TypeUtils.intersect(typeChecker, types);
                        this.value = new KnownType(intersect);
                    }
                }
                finally {
                    this.beingComputed = false;
                }
            }
            return this.value;
        }

        @Override
        public boolean equate(TypeValue other) {
            if (other instanceof KnownType) {
                KnownType knownType = (KnownType)other;
                return this.setValue(knownType);
            }
            assert (other instanceof UnknownType);
            ConstraintSystemImpl.this.mergeUnknowns((UnknownType)other, this);
            return true;
        }

        public boolean setValue(@NotNull KnownType value) {
            if (this.value != null) {
                return TypeUtils.equalTypes(this.value.getType(), value.getType());
            }
            this.value = value;
            return true;
        }

        private Set<JetType> getTypes(Set<TypeValue> lowerBounds) {
            HashSet types = Sets.newHashSet();
            for (TypeValue lowerBound : lowerBounds) {
                types.add(lowerBound.getValue().getType());
            }
            return types;
        }

        public String toString() {
            return "?" + this.typeParameterDescriptor;
        }
    }

    public static abstract class TypeValue {
        private final Set<TypeValue> mutableUpperBounds = Sets.newHashSet();
        private final Set<TypeValue> upperBounds = Collections.unmodifiableSet(this.mutableUpperBounds);
        private final Set<TypeValue> mutableLowerBounds = Sets.newHashSet();
        private final Set<TypeValue> lowerBounds = Collections.unmodifiableSet(this.mutableLowerBounds);

        public void addUpperBound(@NotNull TypeValue bound) {
            this.mutableUpperBounds.add(bound);
        }

        public void addLowerBound(@NotNull TypeValue bound) {
            this.mutableLowerBounds.add(bound);
        }

        @NotNull
        public Set<TypeValue> getUpperBounds() {
            return this.upperBounds;
        }

        @NotNull
        public Set<TypeValue> getLowerBounds() {
            return this.lowerBounds;
        }

        @Nullable
        public abstract KnownType getValue();

        public abstract boolean equate(TypeValue var1);
    }

    private static class LoopInTypeVariableConstraintsException
    extends RuntimeException {
    }
}

