/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.resolve.calls.ResolvedValueArgument;

public class VarargValueArgument
implements ResolvedValueArgument {
    private final List<JetExpression> values = Lists.newArrayList();

    @Override
    @NotNull
    public List<JetExpression> getArgumentExpressions() {
        return this.values;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("vararg:{");
        Iterator<JetExpression> iterator = this.values.iterator();
        while (iterator.hasNext()) {
            JetExpression expression = iterator.next();
            builder.append(expression.getText());
            if (!iterator.hasNext()) continue;
            builder.append(", ");
        }
        return builder.append("}").toString();
    }
}

