/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetLabelQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.CallMaker;
import org.jetbrains.jet.lang.resolve.calls.DefaultValueArgument;
import org.jetbrains.jet.lang.resolve.calls.ExpressionValueArgument;
import org.jetbrains.jet.lang.resolve.calls.ResolutionTask;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCallImpl;
import org.jetbrains.jet.lang.resolve.calls.TracingStrategy;
import org.jetbrains.jet.lang.resolve.calls.VarargValueArgument;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;

class ValueArgumentsToParametersMapper {
    ValueArgumentsToParametersMapper() {
    }

    public static <D extends CallableDescriptor> boolean mapValueArgumentsToParameters(@NotNull ResolutionTask<D> task, @NotNull TracingStrategy tracing, @NotNull ResolvedCallImpl<D> candidateCall) {
        ValueParameterDescriptor valueParameterDescriptor;
        TemporaryBindingTrace temporaryTrace = candidateCall.getTrace();
        HashMap varargs = Maps.newHashMap();
        HashSet usedParameters = Sets.newHashSet();
        D candidate = candidateCall.getCandidateDescriptor();
        D base = ValueArgumentsToParametersMapper.getDescriptorForValueArgumentsResolving(candidate);
        List<ValueParameterDescriptor> valueParameters = base.getValueParameters();
        HashMap parameterByName = Maps.newHashMap();
        for (ValueParameterDescriptor valueParameter : valueParameters) {
            parameterByName.put(valueParameter.getName(), valueParameter);
        }
        List<? extends ValueArgument> valueArguments = task.getCall().getValueArguments();
        boolean error = false;
        boolean someNamed = false;
        boolean somePositioned = false;
        for (int i = 0; i < valueArguments.size(); ++i) {
            ValueArgument valueArgument = valueArguments.get(i);
            if (valueArgument.isNamed()) {
                someNamed = true;
                JetSimpleNameExpression nameReference = valueArgument.getArgumentName().getReferenceExpression();
                valueParameterDescriptor = (ValueParameterDescriptor)parameterByName.get(valueArgument.getArgumentName().getReferenceExpression().getReferencedName());
                if (valueParameterDescriptor == null) {
                    temporaryTrace.report(Errors.NAMED_PARAMETER_NOT_FOUND.on(nameReference));
                    error = true;
                } else {
                    if (!usedParameters.add(valueParameterDescriptor)) {
                        temporaryTrace.report(Errors.ARGUMENT_PASSED_TWICE.on(nameReference));
                    }
                    temporaryTrace.record(BindingContext.REFERENCE_TARGET, nameReference, valueParameterDescriptor);
                    ValueArgumentsToParametersMapper.put(candidateCall, valueParameterDescriptor, valueArgument, varargs);
                }
                if (!somePositioned) continue;
                temporaryTrace.report(Errors.MIXING_NAMED_AND_POSITIONED_ARGUMENTS.on((PsiElement)nameReference));
                error = true;
                continue;
            }
            somePositioned = true;
            if (someNamed) {
                temporaryTrace.report(Errors.MIXING_NAMED_AND_POSITIONED_ARGUMENTS.on(valueArgument.asElement()));
                error = true;
                continue;
            }
            int parameterCount = valueParameters.size();
            if (i < parameterCount) {
                valueParameterDescriptor = valueParameters.get(i);
                usedParameters.add(valueParameterDescriptor);
                ValueArgumentsToParametersMapper.put(candidateCall, valueParameterDescriptor, valueArgument, varargs);
                continue;
            }
            if (!valueParameters.isEmpty()) {
                valueParameterDescriptor = valueParameters.get(valueParameters.size() - 1);
                if (valueParameterDescriptor.getVarargElementType() != null) {
                    ValueArgumentsToParametersMapper.put(candidateCall, valueParameterDescriptor, valueArgument, varargs);
                    usedParameters.add(valueParameterDescriptor);
                    continue;
                }
                temporaryTrace.report(Errors.TOO_MANY_ARGUMENTS.on(valueArgument.asElement(), (CallableDescriptor)candidate));
                error = true;
                continue;
            }
            temporaryTrace.report(Errors.TOO_MANY_ARGUMENTS.on(valueArgument.asElement(), (CallableDescriptor)candidate));
            error = true;
        }
        List<JetExpression> functionLiteralArguments = task.getCall().getFunctionLiteralArguments();
        if (!functionLiteralArguments.isEmpty()) {
            JetExpression possiblyLabeledFunctionLiteral = functionLiteralArguments.get(0);
            if (valueParameters.isEmpty()) {
                temporaryTrace.report(Errors.TOO_MANY_ARGUMENTS.on((PsiElement)possiblyLabeledFunctionLiteral, (CallableDescriptor)candidate));
                error = true;
            } else {
                JetFunctionLiteralExpression functionLiteral;
                if (possiblyLabeledFunctionLiteral instanceof JetLabelQualifiedExpression) {
                    JetLabelQualifiedExpression labeledFunctionLiteral = (JetLabelQualifiedExpression)possiblyLabeledFunctionLiteral;
                    functionLiteral = (JetFunctionLiteralExpression)labeledFunctionLiteral.getLabeledExpression();
                } else {
                    functionLiteral = (JetFunctionLiteralExpression)possiblyLabeledFunctionLiteral;
                }
                valueParameterDescriptor = valueParameters.get(valueParameters.size() - 1);
                if (valueParameterDescriptor.getVarargElementType() != null) {
                    temporaryTrace.report(Errors.VARARG_OUTSIDE_PARENTHESES.on(possiblyLabeledFunctionLiteral));
                    error = true;
                } else if (!usedParameters.add(valueParameterDescriptor)) {
                    temporaryTrace.report(Errors.TOO_MANY_ARGUMENTS.on((PsiElement)possiblyLabeledFunctionLiteral, (CallableDescriptor)candidate));
                    error = true;
                } else {
                    ValueArgumentsToParametersMapper.put(candidateCall, valueParameterDescriptor, CallMaker.makeValueArgument(functionLiteral), varargs);
                }
            }
            for (int i = 1; i < functionLiteralArguments.size(); ++i) {
                JetExpression argument = functionLiteralArguments.get(i);
                temporaryTrace.report(Errors.MANY_FUNCTION_LITERAL_ARGUMENTS.on(argument));
                error = true;
            }
        }
        for (ValueParameterDescriptor valueParameter : valueParameters) {
            if (usedParameters.contains(valueParameter)) continue;
            if (valueParameter.hasDefaultValue()) {
                candidateCall.recordValueArgument(valueParameter, DefaultValueArgument.DEFAULT);
                continue;
            }
            if (valueParameter.getVarargElementType() != null) {
                candidateCall.recordValueArgument(valueParameter, new VarargValueArgument());
                continue;
            }
            tracing.noValueForParameter(temporaryTrace, valueParameter);
            error = true;
        }
        ReceiverDescriptor receiverParameter = candidate.getReceiverParameter();
        ReceiverDescriptor receiverArgument = candidateCall.getReceiverArgument();
        if (receiverParameter.exists() && !receiverArgument.exists()) {
            tracing.missingReceiver(temporaryTrace, receiverParameter);
            error = true;
        }
        if (!receiverParameter.exists() && receiverArgument.exists()) {
            tracing.noReceiverAllowed(temporaryTrace);
            error = true;
        }
        assert (candidateCall.getThisObject().exists() == candidateCall.getResultingDescriptor().getExpectedThisObject().exists()) : "Shouldn't happen because of TaskPrioritizer: " + candidateCall.getCandidateDescriptor();
        return error;
    }

    private static <D extends CallableDescriptor> void put(ResolvedCallImpl<D> candidateCall, ValueParameterDescriptor valueParameterDescriptor, ValueArgument valueArgument, Map<ValueParameterDescriptor, VarargValueArgument> varargs) {
        if (valueParameterDescriptor.getVarargElementType() != null) {
            VarargValueArgument vararg = varargs.get(valueParameterDescriptor);
            if (vararg == null) {
                vararg = new VarargValueArgument();
                varargs.put(valueParameterDescriptor, vararg);
                candidateCall.recordValueArgument(valueParameterDescriptor, vararg);
            }
            vararg.getArgumentExpressions().add(valueArgument.getArgumentExpression());
        } else {
            ExpressionValueArgument argument = new ExpressionValueArgument(valueArgument.getArgumentExpression());
            candidateCall.recordValueArgument(valueParameterDescriptor, argument);
        }
    }

    @NotNull
    private static <D extends CallableDescriptor> D getDescriptorForValueArgumentsResolving(D descriptor) {
        HashSet allBases = new HashSet();
        ValueArgumentsToParametersMapper.getAllDescriptorsForValueArgumentsResolving(descriptor, allBases);
        if (allBases.size() == 1) {
            return (D)((CallableDescriptor)allBases.iterator().next());
        }
        return descriptor;
    }

    private static <D extends CallableDescriptor> void getAllDescriptorsForValueArgumentsResolving(D descriptor, Set<D> dest) {
        if (descriptor.getOverriddenDescriptors().isEmpty()) {
            dest.add(descriptor);
        } else {
            for (CallableDescriptor callableDescriptor : descriptor.getOverriddenDescriptors()) {
                ValueArgumentsToParametersMapper.getAllDescriptorsForValueArgumentsResolving(callableDescriptor, dest);
            }
        }
    }
}

