/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableAsFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.TaskPrioritizer;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetStandardClasses;
import org.jetbrains.jet.lang.types.JetType;

public class TaskPrioritizers {
    static TaskPrioritizer<FunctionDescriptor> FUNCTION_TASK_PRIORITIZER = new TaskPrioritizer<FunctionDescriptor>(){

        @Override
        @NotNull
        protected Collection<FunctionDescriptor> getNonExtensionsByName(JetScope scope, String name) {
            LinkedHashSet functions = Sets.newLinkedHashSet(scope.getFunctions(name));
            Iterator iterator = functions.iterator();
            while (iterator.hasNext()) {
                FunctionDescriptor functionDescriptor = (FunctionDescriptor)iterator.next();
                if (!functionDescriptor.getReceiverParameter().exists()) continue;
                iterator.remove();
            }
            this.addConstructors(scope, name, functions);
            this.addVariableAsFunction(scope, name, functions, false);
            return functions;
        }

        @Override
        @NotNull
        protected Collection<FunctionDescriptor> getMembersByName(@NotNull JetType receiverType, String name) {
            JetScope receiverScope = receiverType.getMemberScope();
            HashSet members = Sets.newHashSet(receiverScope.getFunctions(name));
            this.addConstructors(receiverScope, name, members);
            this.addVariableAsFunction(receiverScope, name, members, false);
            return members;
        }

        @Override
        @NotNull
        protected Collection<FunctionDescriptor> getExtensionsByName(JetScope scope, String name) {
            HashSet extensionFunctions = Sets.newHashSet(scope.getFunctions(name));
            Iterator iterator = extensionFunctions.iterator();
            while (iterator.hasNext()) {
                FunctionDescriptor descriptor = (FunctionDescriptor)iterator.next();
                if (descriptor.getReceiverParameter().exists()) continue;
                iterator.remove();
            }
            this.addVariableAsFunction(scope, name, extensionFunctions, true);
            return extensionFunctions;
        }

        private void addConstructors(JetScope scope, String name, Collection<FunctionDescriptor> functions) {
            ClassifierDescriptor classifier = scope.getClassifier(name);
            if (classifier instanceof ClassDescriptor && !ErrorUtils.isError(classifier.getTypeConstructor())) {
                ClassDescriptor classDescriptor = (ClassDescriptor)classifier;
                functions.addAll(classDescriptor.getConstructors());
            }
        }

        private void addVariableAsFunction(JetScope scope, String name, Set<FunctionDescriptor> functions, boolean receiverNeeded) {
            VariableAsFunctionDescriptor functionDescriptor;
            JetType outType;
            VariableDescriptor variable = scope.getLocalVariable(name);
            if (variable == null) {
                variable = DescriptorUtils.filterNonExtensionProperty(scope.getProperties(name));
            }
            if (variable != null && (outType = variable.getType()) != null && JetStandardClasses.isFunctionType(outType) && (functionDescriptor = VariableAsFunctionDescriptor.create(variable)).getReceiverParameter().exists() == receiverNeeded) {
                functions.add(functionDescriptor);
            }
        }
    };
    static TaskPrioritizer<VariableDescriptor> VARIABLE_TASK_PRIORITIZER = new TaskPrioritizer<VariableDescriptor>(){

        @Override
        @NotNull
        protected Collection<VariableDescriptor> getNonExtensionsByName(JetScope scope, String name) {
            VariableDescriptor descriptor = scope.getLocalVariable(name);
            if (descriptor == null) {
                descriptor = DescriptorUtils.filterNonExtensionProperty(scope.getProperties(name));
            }
            if (descriptor == null) {
                return Collections.emptyList();
            }
            return Collections.singleton(descriptor);
        }

        @Override
        @NotNull
        protected Collection<VariableDescriptor> getMembersByName(@NotNull JetType receiverType, String name) {
            return receiverType.getMemberScope().getProperties(name);
        }

        @Override
        @NotNull
        protected Collection<VariableDescriptor> getExtensionsByName(JetScope scope, String name) {
            return Collections2.filter(scope.getProperties(name), (Predicate)new Predicate<VariableDescriptor>(){

                public boolean apply(@Nullable VariableDescriptor variableDescriptor) {
                    return variableDescriptor != null && variableDescriptor.getReceiverParameter().exists();
                }
            });
        }
    };
    static TaskPrioritizer<VariableDescriptor> PROPERTY_TASK_PRIORITIZER = new TaskPrioritizer<VariableDescriptor>(){

        private Collection<VariableDescriptor> filterProperties(Collection<? extends VariableDescriptor> variableDescriptors) {
            ArrayList properties = Lists.newArrayList();
            for (VariableDescriptor variableDescriptor : variableDescriptors) {
                if (!(variableDescriptor instanceof PropertyDescriptor)) continue;
                properties.add(variableDescriptor);
            }
            return properties;
        }

        @Override
        @NotNull
        protected Collection<VariableDescriptor> getNonExtensionsByName(JetScope scope, String name) {
            return this.filterProperties(VARIABLE_TASK_PRIORITIZER.getNonExtensionsByName(scope, name));
        }

        @Override
        @NotNull
        protected Collection<VariableDescriptor> getMembersByName(@NotNull JetType receiver, String name) {
            return this.filterProperties(VARIABLE_TASK_PRIORITIZER.getMembersByName(receiver, name));
        }

        @Override
        @NotNull
        protected Collection<VariableDescriptor> getExtensionsByName(JetScope scope, String name) {
            return this.filterProperties(VARIABLE_TASK_PRIORITIZER.getExtensionsByName(scope, name));
        }
    };
}

