/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetSuperExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.calls.ResolutionTask;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCallImpl;
import org.jetbrains.jet.lang.resolve.calls.autocasts.AutoCastService;
import org.jetbrains.jet.lang.resolve.calls.autocasts.AutoCastServiceImpl;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ClassReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.NamespaceType;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;

abstract class TaskPrioritizer<D extends CallableDescriptor> {
    TaskPrioritizer() {
    }

    public static <D extends CallableDescriptor> void splitLexicallyLocalDescriptors(@NotNull Collection<ResolvedCallImpl<D>> allDescriptors, @NotNull DeclarationDescriptor containerOfTheCurrentLocality, @NotNull Collection<ResolvedCallImpl<D>> local, @NotNull Collection<ResolvedCallImpl<D>> nonlocal) {
        for (ResolvedCallImpl<D> resolvedCall : allDescriptors) {
            if (DescriptorUtils.isLocal(containerOfTheCurrentLocality, resolvedCall.getCandidateDescriptor())) {
                local.add(resolvedCall);
                continue;
            }
            nonlocal.add(resolvedCall);
        }
    }

    @Nullable
    static JetSuperExpression getReceiverSuper(@NotNull ReceiverDescriptor receiver) {
        ExpressionReceiver expressionReceiver;
        JetExpression expression;
        if (receiver instanceof ExpressionReceiver && (expression = (expressionReceiver = (ExpressionReceiver)receiver).getExpression()) instanceof JetSuperExpression) {
            return (JetSuperExpression)expression;
        }
        return null;
    }

    @NotNull
    public List<ResolutionTask<D>> computePrioritizedTasks(@NotNull JetScope scope, @NotNull Call call, @NotNull String name, @NotNull BindingContext bindingContext, @NotNull DataFlowInfo dataFlowInfo) {
        ArrayList result = Lists.newArrayList();
        ReceiverDescriptor explicitReceiver = call.getExplicitReceiver();
        if (explicitReceiver.exists() && explicitReceiver.getType() instanceof NamespaceType) {
            scope = explicitReceiver.getType().getMemberScope();
            explicitReceiver = ReceiverDescriptor.NO_RECEIVER;
        }
        this.doComputeTasks(scope, explicitReceiver, call, name, result, new AutoCastServiceImpl(dataFlowInfo, bindingContext));
        return result;
    }

    private void doComputeTasks(JetScope scope, ReceiverDescriptor receiver, Call call, String name, List<ResolutionTask<D>> result, @NotNull AutoCastService autoCastService) {
        DataFlowInfo dataFlowInfo = autoCastService.getDataFlowInfo();
        ArrayList implicitReceivers = Lists.newArrayList();
        scope.getImplicitReceiversHierarchy(implicitReceivers);
        if (receiver.exists()) {
            List<ReceiverDescriptor> variantsForExplicitReceiver = autoCastService.getVariantsForReceiver(receiver);
            Collection<ResolvedCallImpl<D>> extensionFunctions = TaskPrioritizer.convertWithImpliedThis(scope, variantsForExplicitReceiver, this.getExtensionsByName(scope, name));
            ArrayList nonlocals = Lists.newArrayList();
            ArrayList locals = Lists.newArrayList();
            TaskPrioritizer.splitLexicallyLocalDescriptors(extensionFunctions, scope.getContainingDeclaration(), locals, nonlocals);
            ArrayList members = Lists.newArrayList();
            for (ReceiverDescriptor variant : variantsForExplicitReceiver) {
                Collection<D> membersForThisVariant = this.getMembersByName(variant.getType(), name);
                this.convertWithReceivers(membersForThisVariant, Collections.singletonList(variant), Collections.singletonList(ReceiverDescriptor.NO_RECEIVER), members);
            }
            if (TaskPrioritizer.getReceiverSuper(receiver) != null) {
                this.addTask(result, call, members, dataFlowInfo);
                this.addTask(result, call, locals, dataFlowInfo);
            } else {
                this.addTask(result, call, locals, dataFlowInfo);
                this.addTask(result, call, members, dataFlowInfo);
            }
            for (ReceiverDescriptor implicitReceiver : implicitReceivers) {
                Collection<D> memberExtensions = this.getExtensionsByName(implicitReceiver.getType().getMemberScope(), name);
                List<ReceiverDescriptor> variantsForImplicitReceiver = autoCastService.getVariantsForReceiver(implicitReceiver);
                this.addTask(result, call, this.convertWithReceivers(memberExtensions, variantsForImplicitReceiver, variantsForExplicitReceiver), dataFlowInfo);
            }
            this.addTask(result, call, nonlocals, dataFlowInfo);
        } else {
            Collection<ResolvedCallImpl<D>> functions = TaskPrioritizer.convertWithImpliedThis(scope, Collections.singletonList(receiver), this.getNonExtensionsByName(scope, name));
            ArrayList nonlocals = Lists.newArrayList();
            ArrayList locals = Lists.newArrayList();
            TaskPrioritizer.splitLexicallyLocalDescriptors(functions, scope.getContainingDeclaration(), locals, nonlocals);
            this.addTask(result, call, locals, dataFlowInfo);
            for (ReceiverDescriptor implicitReceiver : implicitReceivers) {
                this.doComputeTasks(scope, implicitReceiver, call, name, result, autoCastService);
            }
            this.addTask(result, call, nonlocals, dataFlowInfo);
        }
    }

    private Collection<ResolvedCallImpl<D>> convertWithReceivers(Collection<D> descriptors, Iterable<ReceiverDescriptor> thisObjects, Iterable<ReceiverDescriptor> receiverParameters) {
        ArrayList result = Lists.newArrayList();
        this.convertWithReceivers(descriptors, thisObjects, receiverParameters, result);
        return result;
    }

    private void convertWithReceivers(Collection<D> descriptors, Iterable<ReceiverDescriptor> thisObjects, Iterable<ReceiverDescriptor> receiverParameters, Collection<ResolvedCallImpl<D>> result) {
        for (ReceiverDescriptor thisObject : thisObjects) {
            for (ReceiverDescriptor receiverParameter : receiverParameters) {
                for (CallableDescriptor extension : descriptors) {
                    ResolvedCallImpl<CallableDescriptor> resolvedCall = ResolvedCallImpl.create(extension);
                    resolvedCall.setThisObject(thisObject);
                    resolvedCall.setReceiverArgument(receiverParameter);
                    result.add(resolvedCall);
                }
            }
        }
    }

    public static <D extends CallableDescriptor> Collection<ResolvedCallImpl<D>> convertWithImpliedThis(JetScope scope, Iterable<ReceiverDescriptor> receiverParameters, Collection<? extends D> descriptors) {
        ArrayList result = Lists.newArrayList();
        for (ReceiverDescriptor receiverParameter : receiverParameters) {
            for (CallableDescriptor descriptor : descriptors) {
                ResolvedCallImpl<CallableDescriptor> resolvedCall = ResolvedCallImpl.create(descriptor);
                resolvedCall.setReceiverArgument(receiverParameter);
                if (!TaskPrioritizer.setImpliedThis(scope, resolvedCall)) continue;
                result.add(resolvedCall);
            }
        }
        for (CallableDescriptor descriptor : descriptors) {
            if (!descriptor.getExpectedThisObject().exists()) continue;
            DeclarationDescriptor containingDeclaration = descriptor.getContainingDeclaration();
            if (descriptor instanceof ConstructorDescriptor) {
                assert (containingDeclaration != null);
                containingDeclaration = containingDeclaration.getContainingDeclaration();
            }
            if (!(containingDeclaration instanceof ClassDescriptor) || ((ClassDescriptor)containingDeclaration).getKind() != ClassKind.OBJECT) continue;
            ResolvedCallImpl<CallableDescriptor> resolvedCall = ResolvedCallImpl.create(descriptor);
            resolvedCall.setThisObject(new ClassReceiver((ClassDescriptor)containingDeclaration));
            result.add(resolvedCall);
        }
        return result;
    }

    private static <D extends CallableDescriptor> boolean setImpliedThis(@NotNull JetScope scope, ResolvedCallImpl<D> resolvedCall) {
        ReceiverDescriptor expectedThisObject = resolvedCall.getCandidateDescriptor().getExpectedThisObject();
        if (!expectedThisObject.exists()) {
            return true;
        }
        ArrayList receivers = Lists.newArrayList();
        scope.getImplicitReceiversHierarchy(receivers);
        for (ReceiverDescriptor receiver : receivers) {
            if (!JetTypeChecker.INSTANCE.isSubtypeOf(receiver.getType(), expectedThisObject.getType())) continue;
            resolvedCall.setThisObject(expectedThisObject);
            return true;
        }
        return false;
    }

    private void addTask(@NotNull List<ResolutionTask<D>> result, @NotNull Call call, @NotNull Collection<ResolvedCallImpl<D>> candidates, @NotNull DataFlowInfo dataFlowInfo) {
        if (candidates.isEmpty()) {
            return;
        }
        result.add(new ResolutionTask<D>(candidates, call, dataFlowInfo));
    }

    @NotNull
    protected abstract Collection<D> getNonExtensionsByName(JetScope var1, String var2);

    @NotNull
    protected abstract Collection<D> getMembersByName(@NotNull JetType var1, String var2);

    @NotNull
    protected abstract Collection<D> getExtensionsByName(JetScope var1, String var2);
}

