/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.calls.ResolutionStatus;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.JetType;

public class ResolvedCallImpl<D extends CallableDescriptor>
implements ResolvedCall<D> {
    public static final Function<ResolvedCallImpl<? extends CallableDescriptor>, CallableDescriptor> MAP_TO_CANDIDATE = new Function<ResolvedCallImpl<? extends CallableDescriptor>, CallableDescriptor>(){

        public CallableDescriptor fun(ResolvedCallImpl<? extends CallableDescriptor> resolvedCall) {
            return resolvedCall.getCandidateDescriptor();
        }
    };
    public static final Function<ResolvedCallImpl<? extends CallableDescriptor>, CallableDescriptor> MAP_TO_RESULT = new Function<ResolvedCallImpl<? extends CallableDescriptor>, CallableDescriptor>(){

        public CallableDescriptor fun(ResolvedCallImpl<? extends CallableDescriptor> resolvedCall) {
            return resolvedCall.getResultingDescriptor();
        }
    };
    private final D candidateDescriptor;
    private D resultingDescriptor;
    private ReceiverDescriptor thisObject = ReceiverDescriptor.NO_RECEIVER;
    private ReceiverDescriptor receiverArgument = ReceiverDescriptor.NO_RECEIVER;
    private final Map<TypeParameterDescriptor, JetType> typeArguments = Maps.newLinkedHashMap();
    private final Map<ValueParameterDescriptor, JetType> autoCasts = Maps.newHashMap();
    private final Map<ValueParameterDescriptor, ResolvedValueArgument> valueArguments = Maps.newHashMap();
    private boolean someArgumentHasNoType = false;
    private TemporaryBindingTrace trace;
    private ResolutionStatus status = ResolutionStatus.UNKNOWN_STATUS;

    @NotNull
    public static <D extends CallableDescriptor> ResolvedCallImpl<D> create(@NotNull D descriptor) {
        return new ResolvedCallImpl<D>(descriptor);
    }

    @NotNull
    public static <D extends CallableDescriptor> List<ResolvedCallImpl<D>> convertCollection(@NotNull Collection<? extends D> descriptors) {
        ArrayList result = Lists.newArrayList();
        for (CallableDescriptor descriptor : descriptors) {
            result.add(ResolvedCallImpl.create(descriptor));
        }
        return result;
    }

    private ResolvedCallImpl(@NotNull D candidateDescriptor) {
        this.candidateDescriptor = candidateDescriptor;
    }

    @NotNull
    public ResolutionStatus getStatus() {
        return this.status;
    }

    public void setStatus(@NotNull ResolutionStatus status) {
        this.status = status;
    }

    @NotNull
    public TemporaryBindingTrace getTrace() {
        return this.trace;
    }

    public void setTrace(@NotNull TemporaryBindingTrace trace) {
        this.trace = trace;
    }

    @Override
    @NotNull
    public D getCandidateDescriptor() {
        return this.candidateDescriptor;
    }

    @Override
    @NotNull
    public D getResultingDescriptor() {
        return this.resultingDescriptor == null ? this.candidateDescriptor : this.resultingDescriptor;
    }

    public ResolvedCallImpl<D> setResultingDescriptor(@NotNull D resultingDescriptor) {
        this.resultingDescriptor = resultingDescriptor;
        return this;
    }

    public void recordTypeArgument(@NotNull TypeParameterDescriptor typeParameter, @NotNull JetType typeArgument) {
        assert (!this.typeArguments.containsKey(typeParameter));
        this.typeArguments.put(typeParameter, typeArgument);
    }

    public void recordValueArgument(@NotNull ValueParameterDescriptor valueParameter, @NotNull ResolvedValueArgument valueArgument) {
        assert (!this.valueArguments.containsKey(valueParameter));
        this.valueArguments.put(valueParameter, valueArgument);
    }

    public void autoCastValueArgument(@NotNull ValueParameterDescriptor parameter, @NotNull JetType target) {
        assert (!this.autoCasts.containsKey(parameter));
        this.autoCasts.put(parameter, target);
    }

    @Override
    @NotNull
    public ReceiverDescriptor getReceiverArgument() {
        return this.receiverArgument;
    }

    public void setReceiverArgument(@NotNull ReceiverDescriptor receiverParameter) {
        this.receiverArgument = receiverParameter;
    }

    @Override
    @NotNull
    public ReceiverDescriptor getThisObject() {
        return this.thisObject;
    }

    public void setThisObject(@NotNull ReceiverDescriptor thisObject) {
        this.thisObject = thisObject;
    }

    @Override
    @NotNull
    public Map<ValueParameterDescriptor, ResolvedValueArgument> getValueArguments() {
        return this.valueArguments;
    }

    @Override
    @NotNull
    public List<ResolvedValueArgument> getValueArgumentsByIndex() {
        ArrayList<ResolvedValueArgument> arguments = new ArrayList<ResolvedValueArgument>(this.candidateDescriptor.getValueParameters().size());
        for (int i = 0; i < this.candidateDescriptor.getValueParameters().size(); ++i) {
            arguments.add(null);
        }
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : this.valueArguments.entrySet()) {
            if (arguments.set(entry.getKey().getIndex(), entry.getValue()) == null) continue;
            throw new IllegalStateException();
        }
        for (ResolvedValueArgument o : arguments) {
            if (o != null) continue;
            throw new IllegalStateException();
        }
        return arguments;
    }

    public void argumentHasNoType() {
        this.someArgumentHasNoType = true;
    }

    public boolean isDirty() {
        return this.someArgumentHasNoType;
    }

    @Override
    @NotNull
    public Map<TypeParameterDescriptor, JetType> getTypeArguments() {
        return this.typeArguments;
    }
}

