/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCallImpl;
import org.jetbrains.jet.lang.resolve.calls.TracingStrategy;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;

public class ResolutionTask<D extends CallableDescriptor> {
    private final Call call;
    private final Collection<ResolvedCallImpl<D>> candidates;
    private final DataFlowInfo dataFlowInfo;
    private DescriptorCheckStrategy checkingStrategy;

    public ResolutionTask(@NotNull Collection<ResolvedCallImpl<D>> candidates, @NotNull Call call, @NotNull DataFlowInfo dataFlowInfo) {
        this.candidates = candidates;
        this.call = call;
        this.dataFlowInfo = dataFlowInfo;
    }

    @NotNull
    public DataFlowInfo getDataFlowInfo() {
        return this.dataFlowInfo;
    }

    @NotNull
    public Collection<ResolvedCallImpl<D>> getCandidates() {
        return this.candidates;
    }

    @NotNull
    public Call getCall() {
        return this.call;
    }

    public void setCheckingStrategy(DescriptorCheckStrategy strategy) {
        this.checkingStrategy = strategy;
    }

    public boolean performAdvancedChecks(D descriptor, BindingTrace trace, TracingStrategy tracing) {
        return this.checkingStrategy == null || this.checkingStrategy.performAdvancedChecks(descriptor, trace, tracing);
    }

    public static interface DescriptorCheckStrategy {
        public <D extends CallableDescriptor> boolean performAdvancedChecks(D var1, BindingTrace var2, TracingStrategy var3);
    }
}

