/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.resolve.calls.ResolutionTask;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCall;
import org.jetbrains.jet.lang.resolve.calls.inference.BoundsOwner;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemSolution;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.util.slicedmap.BasicWritableSlice;
import org.jetbrains.jet.util.slicedmap.MutableSlicedMap;
import org.jetbrains.jet.util.slicedmap.ReadOnlySlice;
import org.jetbrains.jet.util.slicedmap.SlicedMap;
import org.jetbrains.jet.util.slicedmap.SlicedMapImpl;
import org.jetbrains.jet.util.slicedmap.Slices;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public class ResolutionDebugInfo {
    public static final WritableSlice<One, List<? extends ResolutionTask<? extends CallableDescriptor>>> TASKS = Slices.createSimpleSlice();
    public static final WritableSlice<One, ResolvedCall<? extends CallableDescriptor>> RESULT = Slices.createSimpleSlice();
    public static final WritableSlice<ResolvedCall<? extends CallableDescriptor>, StringBuilder> ERRORS = Slices.createSimpleSlice();
    public static final WritableSlice<ResolvedCall<? extends CallableDescriptor>, StringBuilder> LOG = Slices.createSimpleSlice();
    public static final WritableSlice<ResolvedCall<? extends CallableDescriptor>, Map<TypeParameterDescriptor, BoundsOwner>> BOUNDS_FOR_UNKNOWNS = Slices.createSimpleSlice();
    public static final WritableSlice<ResolvedCall<? extends CallableDescriptor>, Map<JetType, BoundsOwner>> BOUNDS_FOR_KNOWNS = Slices.createSimpleSlice();
    public static final WritableSlice<ResolvedCall<? extends CallableDescriptor>, ConstraintSystemSolution> SOLUTION = Slices.createSimpleSlice();
    public static final WritableSlice<ResolvedCall<? extends CallableDescriptor>, Collection<TypeParameterDescriptor>> UNKNOWNS = Slices.createSimpleSlice();
    public static boolean RESOLUTION_DEBUG_INFO_ENABLED = false;
    public static final Data NO_DEBUG_INFO = new AbstractData(){

        public String toString() {
            return "NO_DEBUG_INFO";
        }

        @Override
        public <K, V> V getByKey(ReadOnlySlice<K, V> slice, K key) {
            return SlicedMap.DO_NOTHING.get(slice, key);
        }

        @Override
        public <K, V> void putByKey(WritableSlice<K, V> slice, K key, V value) {
        }
    };
    public static final WritableSlice<PsiElement, Data> RESOLUTION_DEBUG_INFO = new BasicWritableSlice<PsiElement, Data>(Slices.ONLY_REWRITE_TO_EQUAL){

        @Override
        public boolean check(PsiElement key, Data value) {
            return ResolutionDebugInfo.isResolutionDebugEnabled();
        }

        @Override
        public Data computeValue(SlicedMap map, PsiElement key, Data value, boolean valueNotFound) {
            if (valueNotFound) {
                return NO_DEBUG_INFO;
            }
            return super.computeValue(map, key, value, valueNotFound);
        }
    };

    public static boolean isResolutionDebugEnabled() {
        Application application = ApplicationManager.getApplication();
        return (RESOLUTION_DEBUG_INFO_ENABLED || application.isInternal()) && !application.isUnitTestMode();
    }

    public static Data create() {
        return ResolutionDebugInfo.isResolutionDebugEnabled() ? new DataImpl() : NO_DEBUG_INFO;
    }

    public static void println(Object message) {
        if (ResolutionDebugInfo.isResolutionDebugEnabled()) {
            System.out.println(message);
        }
    }

    static {
        BasicWritableSlice.initSliceDebugNames(ResolutionDebugInfo.class);
    }

    private static class DataImpl
    extends AbstractData {
        private final MutableSlicedMap map = SlicedMapImpl.create();

        private DataImpl() {
        }

        @Override
        public <K, V> V getByKey(ReadOnlySlice<K, V> slice, K key) {
            return this.map.get(slice, key);
        }

        @Override
        public <K, V> void putByKey(WritableSlice<K, V> slice, K key, V value) {
            this.map.put(slice, key, value);
        }
    }

    private static abstract class AbstractData
    implements Data {
        private AbstractData() {
        }

        @Override
        public <V> void set(WritableSlice<One, ? super V> slice, V value) {
            this.putByKey(slice, One.KEY, value);
        }

        @Override
        public <V> V get(ReadOnlySlice<One, V> slice) {
            return this.getByKey(slice, One.KEY);
        }
    }

    public static interface Data {
        public <K, V> V getByKey(ReadOnlySlice<K, V> var1, K var2);

        public <K, V> void putByKey(WritableSlice<K, V> var1, K var2, V var3);

        public <V> void set(WritableSlice<One, ? super V> var1, V var2);

        public <V> V get(ReadOnlySlice<One, V> var1);
    }

    public static enum One {
        KEY;

    }
}

