/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.JetSemanticServices;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCallImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.JetStandardLibrary;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;

public class OverloadingConflictResolver {
    private final JetSemanticServices semanticServices;

    public OverloadingConflictResolver(@NotNull JetSemanticServices semanticServices) {
        this.semanticServices = semanticServices;
    }

    @Nullable
    public <D extends CallableDescriptor> ResolvedCallImpl<D> findMaximallySpecific(Set<ResolvedCallImpl<D>> candidates, boolean discriminateGenericDescriptors) {
        THashSet maximallySpecific = new THashSet(new TObjectHashingStrategy<ResolvedCallImpl<D>>(){

            public boolean equals(ResolvedCallImpl<D> o1, ResolvedCallImpl<D> o2) {
                return o1 == null ? o2 == null : o1.getResultingDescriptor().equals(o2.getResultingDescriptor());
            }

            public int computeHashCode(ResolvedCallImpl<D> object) {
                return object == null ? 0 : object.getResultingDescriptor().hashCode();
            }
        });
        block0: for (ResolvedCallImpl<D> candidateCall : candidates) {
            D me = candidateCall.getResultingDescriptor();
            for (ResolvedCallImpl<D> otherCall : candidates) {
                D other = otherCall.getResultingDescriptor();
                if (other == me || this.moreSpecific((CallableDescriptor)me, (CallableDescriptor)other, discriminateGenericDescriptors) && !this.moreSpecific((CallableDescriptor)other, (CallableDescriptor)me, discriminateGenericDescriptors)) continue;
                continue block0;
            }
            maximallySpecific.add(candidateCall);
        }
        if (maximallySpecific.size() == 1) {
            ResolvedCallImpl result = (ResolvedCallImpl)maximallySpecific.iterator().next();
            result.getTrace().commit();
            return result;
        }
        return null;
    }

    private <Descriptor extends CallableDescriptor> boolean moreSpecific(Descriptor f, Descriptor g, boolean discriminateGenericDescriptors) {
        if (discriminateGenericDescriptors && !this.isGeneric(f) && this.isGeneric(g)) {
            return true;
        }
        if (OverridingUtil.overrides(f, g)) {
            return true;
        }
        if (OverridingUtil.overrides(g, f)) {
            return false;
        }
        ReceiverDescriptor receiverOfF = f.getReceiverParameter();
        ReceiverDescriptor receiverOfG = g.getReceiverParameter();
        if (f.getReceiverParameter().exists() && g.getReceiverParameter().exists() && !this.typeMoreSpecific(receiverOfF.getType(), receiverOfG.getType())) {
            return false;
        }
        List<ValueParameterDescriptor> fParams = f.getValueParameters();
        List<ValueParameterDescriptor> gParams = g.getValueParameters();
        int fSize = fParams.size();
        if (fSize != gParams.size()) {
            return false;
        }
        for (int i = 0; i < fSize; ++i) {
            JetType gParamType;
            JetType fParamType = fParams.get(i).getType();
            if (this.typeMoreSpecific(fParamType, gParamType = gParams.get(i).getType())) continue;
            return false;
        }
        if (discriminateGenericDescriptors && this.isGeneric(f)) {
            if (!this.isGeneric(g)) {
                return false;
            }
            return this.moreSpecific(DescriptorUtils.substituteBounds(f), DescriptorUtils.substituteBounds(g), false);
        }
        return true;
    }

    private boolean isGeneric(CallableDescriptor f) {
        return !f.getOriginal().getTypeParameters().isEmpty();
    }

    private boolean typeMoreSpecific(@NotNull JetType specific, @NotNull JetType general) {
        return this.semanticServices.getTypeChecker().isSubtypeOf(specific, general) || this.numericTypeMoreSpecific(specific, general);
    }

    private boolean numericTypeMoreSpecific(@NotNull JetType specific, @NotNull JetType general) {
        JetStandardLibrary standardLibrary = this.semanticServices.getStandardLibrary();
        JetType _double = standardLibrary.getDoubleType();
        JetType _float = standardLibrary.getFloatType();
        JetType _long = standardLibrary.getLongType();
        JetType _int = standardLibrary.getIntType();
        JetType _byte = standardLibrary.getByteType();
        JetType _short = standardLibrary.getShortType();
        if (TypeUtils.equalTypes(specific, _double) && TypeUtils.equalTypes(general, _float)) {
            return true;
        }
        if (TypeUtils.equalTypes(specific, _int)) {
            if (TypeUtils.equalTypes(general, _long)) {
                return true;
            }
            if (TypeUtils.equalTypes(general, _byte)) {
                return true;
            }
            if (TypeUtils.equalTypes(general, _short)) {
                return true;
            }
        }
        return TypeUtils.equalTypes(specific, _short) && TypeUtils.equalTypes(general, _byte);
    }
}

