/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.resolve.calls.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCallImpl;

class OverloadResolutionResultsImpl<D extends CallableDescriptor>
implements OverloadResolutionResults<D> {
    private final Collection<ResolvedCallImpl<D>> results;
    private final OverloadResolutionResults.Code resultCode;

    public static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> success(@NotNull ResolvedCallImpl<D> descriptor) {
        return new OverloadResolutionResultsImpl<D>(OverloadResolutionResults.Code.SUCCESS, Collections.singleton(descriptor));
    }

    public static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> nameNotFound() {
        return new OverloadResolutionResultsImpl<D>(OverloadResolutionResults.Code.NAME_NOT_FOUND, Collections.<ResolvedCallImpl<D>>emptyList());
    }

    public static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> singleFailedCandidate(ResolvedCallImpl<D> candidate) {
        return new OverloadResolutionResultsImpl<D>(OverloadResolutionResults.Code.SINGLE_CANDIDATE_ARGUMENT_MISMATCH, Collections.singleton(candidate));
    }

    public static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> manyFailedCandidates(Collection<ResolvedCallImpl<D>> failedCandidates) {
        return new OverloadResolutionResultsImpl<D>(OverloadResolutionResults.Code.MANY_FAILED_CANDIDATES, failedCandidates);
    }

    public static <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> ambiguity(Collection<ResolvedCallImpl<D>> descriptors) {
        return new OverloadResolutionResultsImpl<D>(OverloadResolutionResults.Code.AMBIGUITY, descriptors);
    }

    private OverloadResolutionResultsImpl(@NotNull OverloadResolutionResults.Code resultCode, @NotNull Collection<ResolvedCallImpl<D>> results) {
        this.results = results;
        this.resultCode = resultCode;
    }

    @Override
    @NotNull
    public Collection<ResolvedCallImpl<D>> getResultingCalls() {
        return this.results;
    }

    @Override
    @NotNull
    public ResolvedCallImpl<D> getResultingCall() {
        assert (this.singleResult());
        return this.results.iterator().next();
    }

    @Override
    @NotNull
    public D getResultingDescriptor() {
        return ((ResolvedCallImpl)this.getResultingCall()).getResultingDescriptor();
    }

    @Override
    @NotNull
    public OverloadResolutionResults.Code getResultCode() {
        return this.resultCode;
    }

    @Override
    public boolean isSuccess() {
        return this.resultCode.isSuccess();
    }

    @Override
    public boolean singleResult() {
        return this.isSuccess() || this.resultCode == OverloadResolutionResults.Code.SINGLE_CANDIDATE_ARGUMENT_MISMATCH;
    }

    @Override
    public boolean isNothing() {
        return this.resultCode == OverloadResolutionResults.Code.NAME_NOT_FOUND;
    }

    @Override
    public boolean isAmbiguity() {
        return this.resultCode == OverloadResolutionResults.Code.AMBIGUITY;
    }
}

