/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.JetSemanticServices;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptorUtil;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetConstructorCalleeExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetProjectionKind;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetSuperExpression;
import org.jetbrains.jet.lang.psi.JetThisReferenceExpression;
import org.jetbrains.jet.lang.psi.JetTypeArgumentList;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.BindingTraceContext;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.TypeResolver;
import org.jetbrains.jet.lang.resolve.calls.AutoCastReceiver;
import org.jetbrains.jet.lang.resolve.calls.DelegatingCall;
import org.jetbrains.jet.lang.resolve.calls.ExpressionAsFunctionDescriptor;
import org.jetbrains.jet.lang.resolve.calls.JetFakeReference;
import org.jetbrains.jet.lang.resolve.calls.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.OverloadResolutionResultsImpl;
import org.jetbrains.jet.lang.resolve.calls.OverloadingConflictResolver;
import org.jetbrains.jet.lang.resolve.calls.ResolutionDebugInfo;
import org.jetbrains.jet.lang.resolve.calls.ResolutionStatus;
import org.jetbrains.jet.lang.resolve.calls.ResolutionTask;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCallImpl;
import org.jetbrains.jet.lang.resolve.calls.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.calls.TaskPrioritizer;
import org.jetbrains.jet.lang.resolve.calls.TaskPrioritizers;
import org.jetbrains.jet.lang.resolve.calls.TracingStrategy;
import org.jetbrains.jet.lang.resolve.calls.ValueArgumentsToParametersMapper;
import org.jetbrains.jet.lang.resolve.calls.autocasts.AutoCastServiceImpl;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemImpl;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemSolution;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintSystemWithPriorities;
import org.jetbrains.jet.lang.resolve.calls.inference.ConstraintType;
import org.jetbrains.jet.lang.resolve.calls.inference.DebugConstraintResolutionListener;
import org.jetbrains.jet.lang.resolve.calls.inference.SolutionStatus;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExpressionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetStandardClasses;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;
import org.jetbrains.jet.lang.types.expressions.OperatorConventions;
import org.jetbrains.jet.lexer.JetToken;
import org.jetbrains.jet.lexer.JetTokens;

public class CallResolver {
    private static final JetType DONT_CARE = ErrorUtils.createErrorTypeWithCustomDebugName("DONT_CARE");
    private final JetSemanticServices semanticServices;
    private final OverloadingConflictResolver overloadingConflictResolver;
    private final DataFlowInfo dataFlowInfo;

    public CallResolver(JetSemanticServices semanticServices, DataFlowInfo dataFlowInfo) {
        this.semanticServices = semanticServices;
        this.overloadingConflictResolver = new OverloadingConflictResolver(semanticServices);
        this.dataFlowInfo = dataFlowInfo;
    }

    @NotNull
    public OverloadResolutionResults<VariableDescriptor> resolveSimpleProperty(@NotNull BindingTrace trace, @NotNull JetScope scope, @NotNull Call call, @NotNull JetType expectedType) {
        TaskPrioritizer<VariableDescriptor> task_prioritizer;
        JetExpression calleeExpression = call.getCalleeExpression();
        assert (calleeExpression instanceof JetSimpleNameExpression);
        JetSimpleNameExpression nameExpression = (JetSimpleNameExpression)calleeExpression;
        String referencedName = nameExpression.getReferencedName();
        if (referencedName == null) {
            return OverloadResolutionResultsImpl.nameNotFound();
        }
        if (nameExpression.getReferencedNameElementType() == JetTokens.FIELD_IDENTIFIER) {
            referencedName = referencedName.substring(1);
            task_prioritizer = TaskPrioritizers.PROPERTY_TASK_PRIORITIZER;
        } else {
            task_prioritizer = TaskPrioritizers.VARIABLE_TASK_PRIORITIZER;
        }
        List prioritizedTasks = task_prioritizer.computePrioritizedTasks(scope, call, referencedName, trace.getBindingContext(), this.dataFlowInfo);
        return this.resolveCallToDescriptor(trace, scope, call, expectedType, prioritizedTasks, nameExpression);
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCall(@NotNull BindingTrace trace, @NotNull JetScope scope, @NotNull Call call, @NotNull JetType expectedType) {
        return this.resolveSimpleCallToFunctionDescriptor(trace, scope, call, expectedType);
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveCallWithGivenName(@NotNull BindingTrace trace, @NotNull JetScope scope, @NotNull Call call, @NotNull JetReferenceExpression functionReference, @NotNull String name, @NotNull JetType expectedType) {
        List tasks = TaskPrioritizers.FUNCTION_TASK_PRIORITIZER.computePrioritizedTasks(scope, call, name, trace.getBindingContext(), this.dataFlowInfo);
        return this.doResolveCall(trace, scope, call, expectedType, tasks, functionReference);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @NotNull
    private OverloadResolutionResults<FunctionDescriptor> resolveSimpleCallToFunctionDescriptor(@NotNull BindingTrace trace, @NotNull JetScope scope, @NotNull Call call, @NotNull JetType expectedType) {
        JetValueArgumentList reportAbsenceOn;
        void var7_12;
        List<Object> prioritizedTasks;
        JetExpression calleeExpression = call.getCalleeExpression();
        if (calleeExpression instanceof JetSimpleNameExpression) {
            JetSimpleNameExpression expression;
            JetSimpleNameExpression jetSimpleNameExpression = expression = (JetSimpleNameExpression)calleeExpression;
            String name = expression.getReferencedName();
            if (name == null) {
                return this.checkArgumentTypesAndFail(trace, scope, call);
            }
            prioritizedTasks = TaskPrioritizers.FUNCTION_TASK_PRIORITIZER.computePrioritizedTasks(scope, call, name, trace.getBindingContext(), this.dataFlowInfo);
            ResolutionTask.DescriptorCheckStrategy abstractConstructorCheck = new ResolutionTask.DescriptorCheckStrategy(){

                @Override
                public <D extends CallableDescriptor> boolean performAdvancedChecks(D descriptor, BindingTrace trace, TracingStrategy tracing) {
                    Modality modality;
                    if (descriptor instanceof ConstructorDescriptor && (modality = ((ConstructorDescriptor)descriptor).getContainingDeclaration().getModality()) == Modality.ABSTRACT) {
                        tracing.instantiationOfAbstractClass(trace);
                        return false;
                    }
                    return true;
                }
            };
            Iterator<Object> i$ = prioritizedTasks.iterator();
            while (i$.hasNext()) {
                ResolutionTask resolutionTask = (ResolutionTask)i$.next();
                resolutionTask.setCheckingStrategy(abstractConstructorCheck);
            }
            return this.resolveCallToDescriptor(trace, scope, call, expectedType, prioritizedTasks, (JetReferenceExpression)var7_12);
        }
        JetValueArgumentList valueArgumentList = call.getValueArgumentList();
        JetValueArgumentList jetValueArgumentList = reportAbsenceOn = valueArgumentList == null ? call.getCallElement() : valueArgumentList;
        if (calleeExpression instanceof JetConstructorCalleeExpression) {
            assert (!call.getExplicitReceiver().exists());
            prioritizedTasks = Lists.newArrayList();
            JetConstructorCalleeExpression expression = (JetConstructorCalleeExpression)calleeExpression;
            JetReferenceExpression jetReferenceExpression = expression.getConstructorReferenceExpression();
            if (jetReferenceExpression == null) {
                return this.checkArgumentTypesAndFail(trace, scope, call);
            }
            JetTypeReference typeReference = expression.getTypeReference();
            assert (typeReference != null);
            JetType jetType = new TypeResolver(this.semanticServices, trace, true).resolveType(scope, typeReference);
            ClassifierDescriptor declarationDescriptor = jetType.getConstructor().getDeclarationDescriptor();
            if (!(declarationDescriptor instanceof ClassDescriptor)) {
                trace.report(Errors.NOT_A_CLASS.on(calleeExpression));
                return this.checkArgumentTypesAndFail(trace, scope, call);
            }
            ClassDescriptor classDescriptor = (ClassDescriptor)declarationDescriptor;
            Set<ConstructorDescriptor> constructors = classDescriptor.getConstructors();
            if (constructors.isEmpty()) {
                trace.report(Errors.NO_CONSTRUCTOR.on((PsiElement)reportAbsenceOn));
                return this.checkArgumentTypesAndFail(trace, scope, call);
            }
            prioritizedTasks.add(new ResolutionTask(TaskPrioritizer.convertWithImpliedThis(scope, Collections.singletonList(ReceiverDescriptor.NO_RECEIVER), constructors), call, DataFlowInfo.EMPTY));
            return this.resolveCallToDescriptor(trace, scope, call, expectedType, prioritizedTasks, (JetReferenceExpression)var7_12);
        }
        if (calleeExpression instanceof JetThisReferenceExpression) {
            JetThisReferenceExpression jetThisReferenceExpression = (JetThisReferenceExpression)calleeExpression;
            DeclarationDescriptor containingDeclaration = scope.getContainingDeclaration();
            if (containingDeclaration instanceof ConstructorDescriptor) {
                containingDeclaration = containingDeclaration.getContainingDeclaration();
            }
            assert (containingDeclaration instanceof ClassDescriptor);
            ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
            Set<ConstructorDescriptor> set = classDescriptor.getConstructors();
            if (set.isEmpty()) {
                trace.report(Errors.NO_CONSTRUCTOR.on((PsiElement)reportAbsenceOn));
                return this.checkArgumentTypesAndFail(trace, scope, call);
            }
            prioritizedTasks = Collections.singletonList(new ResolutionTask(ResolvedCallImpl.convertCollection(set), call, DataFlowInfo.EMPTY));
            return this.resolveCallToDescriptor(trace, scope, call, expectedType, prioritizedTasks, (JetReferenceExpression)var7_12);
        }
        if (calleeExpression == null) return this.checkArgumentTypesAndFail(trace, scope, call);
        ExpressionTypingServices typingServices = new ExpressionTypingServices(this.semanticServices, trace);
        JetType calleeType = typingServices.safeGetType(scope, calleeExpression, TypeUtils.NO_EXPECTED_TYPE);
        if (!JetStandardClasses.isFunctionType(calleeType)) {
            if (ErrorUtils.isErrorType(calleeType)) return this.checkArgumentTypesAndFail(trace, scope, call);
            trace.report(Errors.CALLEE_NOT_A_FUNCTION.on(calleeExpression, calleeType));
            return this.checkArgumentTypesAndFail(trace, scope, call);
        }
        ExpressionAsFunctionDescriptor expressionAsFunctionDescriptor = new ExpressionAsFunctionDescriptor(scope.getContainingDeclaration(), "[for expression " + calleeExpression.getText() + "]");
        FunctionDescriptorUtil.initializeFromFunctionType(expressionAsFunctionDescriptor, calleeType, ReceiverDescriptor.NO_RECEIVER);
        ResolvedCallImpl<ExpressionAsFunctionDescriptor> resolvedCall = ResolvedCallImpl.create(expressionAsFunctionDescriptor);
        resolvedCall.setReceiverArgument(call.getExplicitReceiver());
        prioritizedTasks = Collections.singletonList(new ResolutionTask(Collections.singleton(resolvedCall), call, this.dataFlowInfo));
        JetFakeReference jetFakeReference = new JetFakeReference(calleeExpression);
        return this.resolveCallToDescriptor(trace, scope, call, expectedType, prioritizedTasks, (JetReferenceExpression)var7_12);
    }

    private <D extends CallableDescriptor> OverloadResolutionResults<D> checkArgumentTypesAndFail(BindingTrace trace, JetScope scope, Call call) {
        this.checkTypesWithNoCallee(trace, scope, call);
        return OverloadResolutionResultsImpl.nameNotFound();
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResults<D> resolveCallToDescriptor(@NotNull BindingTrace trace, @NotNull JetScope scope, @NotNull Call call, @NotNull JetType expectedType, @NotNull List<ResolutionTask<D>> prioritizedTasks, @NotNull JetReferenceExpression reference) {
        return this.doResolveCall(trace, scope, call, expectedType, prioritizedTasks, reference);
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResults<D> doResolveCall(@NotNull BindingTrace trace, @NotNull JetScope scope, final @NotNull Call call, @NotNull JetType expectedType, @NotNull List<ResolutionTask<D>> prioritizedTasks, final @NotNull JetReferenceExpression reference) {
        ResolutionDebugInfo.Data debugInfo = ResolutionDebugInfo.create();
        trace.record(ResolutionDebugInfo.RESOLUTION_DEBUG_INFO, call.getCallElement(), debugInfo);
        trace.record(BindingContext.RESOLUTION_SCOPE, call.getCalleeExpression(), scope);
        debugInfo.set(ResolutionDebugInfo.TASKS, prioritizedTasks);
        TracingStrategy tracing = new TracingStrategy(){

            @Override
            public <D extends CallableDescriptor> void bindReference(@NotNull BindingTrace trace, @NotNull ResolvedCallImpl<D> resolvedCall) {
                D descriptor = resolvedCall.getCandidateDescriptor();
                trace.record(BindingContext.RESOLVED_CALL, call.getCalleeExpression(), resolvedCall);
                trace.record(BindingContext.REFERENCE_TARGET, reference, descriptor);
            }

            @Override
            public <D extends CallableDescriptor> void recordAmbiguity(BindingTrace trace, Collection<ResolvedCallImpl<D>> candidates) {
                HashSet descriptors = Sets.newHashSet();
                for (ResolvedCallImpl<D> candidate : candidates) {
                    descriptors.add(candidate.getCandidateDescriptor());
                }
                trace.record(BindingContext.AMBIGUOUS_REFERENCE_TARGET, reference, descriptors);
            }

            @Override
            public void unresolvedReference(@NotNull BindingTrace trace) {
                trace.report(Errors.UNRESOLVED_REFERENCE.on(reference));
            }

            @Override
            public void noValueForParameter(@NotNull BindingTrace trace, @NotNull ValueParameterDescriptor valueParameter) {
                JetValueArgumentList valueArgumentList = call.getValueArgumentList();
                JetElement reportOn = valueArgumentList != null ? valueArgumentList : reference;
                trace.report(Errors.NO_VALUE_FOR_PARAMETER.on((PsiElement)reportOn, valueParameter));
            }

            @Override
            public void missingReceiver(@NotNull BindingTrace trace, @NotNull ReceiverDescriptor expectedReceiver) {
                trace.report(Errors.MISSING_RECEIVER.on(reference, expectedReceiver.getType()));
            }

            @Override
            public void wrongReceiverType(@NotNull BindingTrace trace, @NotNull ReceiverDescriptor receiverParameter, @NotNull ReceiverDescriptor receiverArgument) {
                if (receiverArgument instanceof ExpressionReceiver) {
                    ExpressionReceiver expressionReceiver = (ExpressionReceiver)receiverArgument;
                    trace.report(Errors.TYPE_MISMATCH.on((PsiElement)expressionReceiver.getExpression(), receiverParameter.getType(), receiverArgument.getType()));
                } else {
                    trace.report(Errors.TYPE_MISMATCH.on((PsiElement)reference, receiverParameter.getType(), receiverArgument.getType()));
                }
            }

            @Override
            public void noReceiverAllowed(@NotNull BindingTrace trace) {
                trace.report(Errors.NO_RECEIVER_ADMITTED.on(reference));
            }

            @Override
            public void wrongNumberOfTypeArguments(@NotNull BindingTrace trace, int expectedTypeArgumentCount) {
                JetTypeArgumentList typeArgumentList = call.getTypeArgumentList();
                if (typeArgumentList != null) {
                    trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on(typeArgumentList, expectedTypeArgumentCount));
                } else {
                    trace.report(Errors.WRONG_NUMBER_OF_TYPE_ARGUMENTS.on(reference, expectedTypeArgumentCount));
                }
            }

            @Override
            public <D extends CallableDescriptor> void ambiguity(@NotNull BindingTrace trace, @NotNull Collection<ResolvedCallImpl<D>> descriptors) {
                trace.report(Errors.OVERLOAD_RESOLUTION_AMBIGUITY.on(call.getCallElement(), descriptors));
            }

            @Override
            public <D extends CallableDescriptor> void noneApplicable(@NotNull BindingTrace trace, @NotNull Collection<ResolvedCallImpl<D>> descriptors) {
                trace.report(Errors.NONE_APPLICABLE.on(reference, descriptors));
            }

            @Override
            public void instantiationOfAbstractClass(@NotNull BindingTrace trace) {
                trace.report(Errors.CREATING_AN_INSTANCE_OF_ABSTRACT_CLASS.on(call.getCallElement()));
            }

            @Override
            public void typeInferenceFailed(@NotNull BindingTrace trace, SolutionStatus status) {
                assert (!status.isSuccessful());
                trace.report(Errors.TYPE_INFERENCE_FAILED.on(call.getCallElement(), status));
            }

            @Override
            public void unsafeCall(@NotNull BindingTrace trace, @NotNull JetType type) {
                ASTNode callOperationNode = call.getCallOperationNode();
                if (callOperationNode != null) {
                    trace.report(Errors.UNSAFE_CALL.on(callOperationNode.getPsi(), type));
                } else {
                    PsiElement callElement = call.getCallElement();
                    if (callElement instanceof JetBinaryExpression) {
                        JetBinaryExpression binaryExpression = (JetBinaryExpression)callElement;
                        JetSimpleNameExpression operationReference = binaryExpression.getOperationReference();
                        String operationString = operationReference.getReferencedNameElementType() == JetTokens.IDENTIFIER ? operationReference.getText() : OperatorConventions.getNameForOperationSymbol((JetToken)operationReference.getReferencedNameElementType());
                        JetExpression right = binaryExpression.getRight();
                        if (right != null) {
                            trace.report(Errors.UNSAFE_INFIX_CALL.on(reference, binaryExpression.getLeft().getText(), operationString, right.getText()));
                        }
                    } else {
                        trace.report(Errors.UNSAFE_CALL.on((PsiElement)reference, type));
                    }
                }
            }

            @Override
            public void unnecessarySafeCall(@NotNull BindingTrace trace, @NotNull JetType type) {
                ASTNode callOperationNode = call.getCallOperationNode();
                assert (callOperationNode != null);
                trace.report(Errors.UNNECESSARY_SAFE_CALL.on(callOperationNode.getPsi(), type));
            }

            @Override
            public void danglingFunctionLiteralArgumentSuspected(@NotNull BindingTrace trace, @NotNull List<JetExpression> functionLiteralArguments) {
                for (JetExpression functionLiteralArgument : functionLiteralArguments) {
                    trace.report(Errors.DANGLING_FUNCTION_LITERAL_ARGUMENT_SUSPECTED.on(functionLiteralArgument));
                }
            }
        };
        TemporaryBindingTrace traceForFirstNonemptyCandidateSet = null;
        OverloadResolutionResultsImpl resultsForFirstNonemptyCandidateSet = null;
        for (ResolutionTask<D> task : prioritizedTasks) {
            TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(trace);
            OverloadResolutionResultsImpl<D> results = this.performResolutionGuardedForExtraFunctionLiteralArguments(temporaryTrace, scope, expectedType, task, tracing);
            if (results.isSuccess()) {
                temporaryTrace.commit();
                debugInfo.set(ResolutionDebugInfo.RESULT, results.getResultingCall());
                return results;
            }
            if (traceForFirstNonemptyCandidateSet != null || task.getCandidates().isEmpty()) continue;
            traceForFirstNonemptyCandidateSet = temporaryTrace;
            resultsForFirstNonemptyCandidateSet = results;
        }
        if (traceForFirstNonemptyCandidateSet != null) {
            traceForFirstNonemptyCandidateSet.commit();
            if (resultsForFirstNonemptyCandidateSet.singleResult()) {
                debugInfo.set(ResolutionDebugInfo.RESULT, resultsForFirstNonemptyCandidateSet.getResultingCall());
            }
        } else {
            trace.report(Errors.UNRESOLVED_REFERENCE.on(reference));
            this.checkTypesWithNoCallee(trace, scope, call);
        }
        return resultsForFirstNonemptyCandidateSet != null ? resultsForFirstNonemptyCandidateSet : OverloadResolutionResultsImpl.nameNotFound();
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> performResolutionGuardedForExtraFunctionLiteralArguments(@NotNull BindingTrace trace, @NotNull JetScope scope, @NotNull JetType expectedType, @NotNull ResolutionTask<D> task, @NotNull TracingStrategy tracing) {
        OverloadResolutionResultsImpl<D> results = this.performResolution(trace, scope, expectedType, task, tracing);
        EnumSet<OverloadResolutionResults.Code> someFailed = EnumSet.of(OverloadResolutionResults.Code.MANY_FAILED_CANDIDATES, OverloadResolutionResults.Code.SINGLE_CANDIDATE_ARGUMENT_MISMATCH);
        if (someFailed.contains((Object)results.getResultCode()) && !task.getCall().getFunctionLiteralArguments().isEmpty()) {
            ArrayList newCandidates = Lists.newArrayList();
            for (ResolvedCallImpl<D> candidate : task.getCandidates()) {
                newCandidates.add(ResolvedCallImpl.create(candidate.getCandidateDescriptor()));
            }
            ResolutionTask newTask = new ResolutionTask(newCandidates, new DelegatingCall(task.getCall()){

                @Override
                @NotNull
                public List<JetExpression> getFunctionLiteralArguments() {
                    return Collections.emptyList();
                }
            }, task.getDataFlowInfo());
            OverloadResolutionResultsImpl resultsWithFunctionLiteralsStripped = this.performResolution(TemporaryBindingTrace.create(trace), scope, expectedType, newTask, tracing);
            if (resultsWithFunctionLiteralsStripped.isSuccess() || resultsWithFunctionLiteralsStripped.isAmbiguity()) {
                tracing.danglingFunctionLiteralArgumentSuspected(trace, task.getCall().getFunctionLiteralArguments());
            }
        }
        return results;
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> performResolution(@NotNull BindingTrace trace, @NotNull JetScope scope, @NotNull JetType expectedType, @NotNull ResolutionTask<D> task, @NotNull TracingStrategy tracing) {
        for (ResolvedCallImpl<CallableDescriptor> resolvedCallImpl : task.getCandidates()) {
            D candidate = resolvedCallImpl.getCandidateDescriptor();
            TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(trace);
            resolvedCallImpl.setTrace(temporaryTrace);
            tracing.bindReference(temporaryTrace, resolvedCallImpl);
            if (ErrorUtils.isError(candidate)) {
                resolvedCallImpl.setStatus(ResolutionStatus.SUCCESS);
                this.checkTypesWithNoCallee(temporaryTrace, scope, task.getCall());
                continue;
            }
            boolean errorInArgumentMapping = ValueArgumentsToParametersMapper.mapValueArgumentsToParameters(task, tracing, resolvedCallImpl);
            if (errorInArgumentMapping) {
                resolvedCallImpl.setStatus(ResolutionStatus.OTHER_ERROR);
                this.checkTypesWithNoCallee(temporaryTrace, scope, task.getCall());
                continue;
            }
            List<JetTypeProjection> jetTypeArguments = task.getCall().getTypeArguments();
            if (jetTypeArguments.isEmpty()) {
                if (!candidate.getTypeParameters().isEmpty()) {
                    ConstraintSystemSolution solution;
                    ResolutionDebugInfo.Data debugInfo = trace.get(ResolutionDebugInfo.RESOLUTION_DEBUG_INFO, task.getCall().getCallElement());
                    ConstraintSystemWithPriorities constraintSystem = new ConstraintSystemWithPriorities(new DebugConstraintResolutionListener(resolvedCallImpl, debugInfo));
                    D candidateWithFreshVariables = FunctionDescriptorUtil.alphaConvertTypeParameters(candidate);
                    for (TypeParameterDescriptor typeParameterDescriptor : candidateWithFreshVariables.getTypeParameters()) {
                        constraintSystem.registerTypeVariable(typeParameterDescriptor, Variance.INVARIANT);
                    }
                    TypeSubstitutor substituteDontCare = ConstraintSystemImpl.makeConstantSubstitutor(candidateWithFreshVariables.getTypeParameters(), DONT_CARE);
                    for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : resolvedCallImpl.getValueArguments().entrySet()) {
                        ResolvedValueArgument valueArgument = entry.getValue();
                        ValueParameterDescriptor valueParameterDescriptor = candidateWithFreshVariables.getValueParameters().get(entry.getKey().getIndex());
                        JetType effectiveExpectedType = this.getEffectiveExpectedType(valueParameterDescriptor);
                        for (JetExpression expression : valueArgument.getArgumentExpressions()) {
                            TemporaryBindingTrace traceForUnknown = TemporaryBindingTrace.create(temporaryTrace);
                            ExpressionTypingServices temporaryServices = new ExpressionTypingServices(this.semanticServices, traceForUnknown);
                            JetType type = temporaryServices.getType(scope, expression, substituteDontCare.substitute(valueParameterDescriptor.getType(), Variance.INVARIANT));
                            if (type != null && !ErrorUtils.isErrorType(type)) {
                                constraintSystem.addSubtypingConstraint(ConstraintType.VALUE_ARGUMENT.assertSubtyping(type, effectiveExpectedType));
                                continue;
                            }
                            resolvedCallImpl.argumentHasNoType();
                        }
                    }
                    ReceiverDescriptor receiverArgument = resolvedCallImpl.getReceiverArgument();
                    ReceiverDescriptor receiverParameter = candidateWithFreshVariables.getReceiverParameter();
                    if (receiverArgument.exists() && receiverParameter.exists()) {
                        constraintSystem.addSubtypingConstraint(ConstraintType.RECEIVER.assertSubtyping(receiverArgument.getType(), receiverParameter.getType()));
                    }
                    if (expectedType != TypeUtils.NO_EXPECTED_TYPE) {
                        constraintSystem.addSubtypingConstraint(ConstraintType.EXPECTED_TYPE.assertSubtyping(candidateWithFreshVariables.getReturnType(), expectedType));
                    }
                    if ((solution = constraintSystem.solve()).getStatus().isSuccessful()) {
                        CallableDescriptor substitute = candidateWithFreshVariables.substitute(solution.getSubstitutor());
                        assert (substitute != null);
                        this.replaceValueParametersWithSubstitutedOnes(resolvedCallImpl, substitute);
                        resolvedCallImpl.setResultingDescriptor(substitute);
                        for (TypeParameterDescriptor typeParameterDescriptor : resolvedCallImpl.getCandidateDescriptor().getTypeParameters()) {
                            resolvedCallImpl.recordTypeArgument(typeParameterDescriptor, solution.getValue(candidateWithFreshVariables.getTypeParameters().get(typeParameterDescriptor.getIndex())));
                        }
                        this.checkValueArgumentTypes(scope, resolvedCallImpl);
                        resolvedCallImpl.setStatus(ResolutionStatus.SUCCESS);
                    } else {
                        tracing.typeInferenceFailed(temporaryTrace, solution.getStatus());
                        resolvedCallImpl.setStatus(ResolutionStatus.OTHER_ERROR.combine(this.checkAllValueArguments(scope, tracing, task, resolvedCallImpl)));
                    }
                } else {
                    resolvedCallImpl.setStatus(this.checkAllValueArguments(scope, tracing, task, resolvedCallImpl));
                }
            } else {
                ArrayList<JetType> typeArguments = new ArrayList<JetType>();
                for (JetTypeProjection projection : jetTypeArguments) {
                    JetTypeReference typeReference;
                    if (projection.getProjectionKind() != JetProjectionKind.NONE) {
                        temporaryTrace.report(Errors.PROJECTION_ON_NON_CLASS_TYPE_ARGUMENT.on(projection));
                    }
                    if ((typeReference = projection.getTypeReference()) == null) continue;
                    typeArguments.add(new TypeResolver(this.semanticServices, temporaryTrace, true).resolveType(scope, typeReference));
                }
                int expectedTypeArgumentCount = candidate.getTypeParameters().size();
                if (expectedTypeArgumentCount == jetTypeArguments.size()) {
                    this.checkGenericBoundsInAFunctionCall(jetTypeArguments, (List<JetType>)typeArguments, (CallableDescriptor)candidate, temporaryTrace);
                    Map<TypeConstructor, TypeProjection> substitutionContext = FunctionDescriptorUtil.createSubstitutionContext((FunctionDescriptor)candidate, typeArguments);
                    CallableDescriptor substitutedDescriptor = candidate.substitute(TypeSubstitutor.create(substitutionContext));
                    resolvedCallImpl.setResultingDescriptor(substitutedDescriptor);
                    this.replaceValueParametersWithSubstitutedOnes(resolvedCallImpl, substitutedDescriptor);
                    List<TypeParameterDescriptor> typeParameters = resolvedCallImpl.getCandidateDescriptor().getTypeParameters();
                    for (int i = 0; i < typeParameters.size(); ++i) {
                        TypeParameterDescriptor typeParameterDescriptor = typeParameters.get(i);
                        resolvedCallImpl.recordTypeArgument(typeParameterDescriptor, (JetType)typeArguments.get(i));
                    }
                    resolvedCallImpl.setStatus(this.checkAllValueArguments(scope, tracing, task, resolvedCallImpl));
                } else {
                    resolvedCallImpl.setStatus(ResolutionStatus.OTHER_ERROR);
                    tracing.wrongNumberOfTypeArguments(temporaryTrace, expectedTypeArgumentCount);
                }
            }
            task.performAdvancedChecks(candidate, temporaryTrace, tracing);
            JetSuperExpression superExpression = TaskPrioritizer.getReceiverSuper(resolvedCallImpl.getReceiverArgument());
            if (superExpression != null) {
                temporaryTrace.report(Errors.SUPER_IS_NOT_AN_EXPRESSION.on(superExpression, superExpression.getText()));
                resolvedCallImpl.setStatus(ResolutionStatus.OTHER_ERROR);
            }
            this.recordAutoCastIfNecessary(resolvedCallImpl.getReceiverArgument(), resolvedCallImpl.getTrace());
            this.recordAutoCastIfNecessary(resolvedCallImpl.getThisObject(), resolvedCallImpl.getTrace());
        }
        LinkedHashSet successfulCandidates = Sets.newLinkedHashSet();
        LinkedHashSet linkedHashSet = Sets.newLinkedHashSet();
        for (ResolvedCallImpl<D> candidateCall : task.getCandidates()) {
            ResolutionStatus status = candidateCall.getStatus();
            if (status.isSuccess()) {
                successfulCandidates.add(candidateCall);
                continue;
            }
            assert (status != ResolutionStatus.UNKNOWN_STATUS) : "No resolution for " + candidateCall.getCandidateDescriptor();
            linkedHashSet.add(candidateCall);
        }
        OverloadResolutionResultsImpl<D> results = this.computeResultAndReportErrors(trace, tracing, successfulCandidates, linkedHashSet);
        if (!results.singleResult()) {
            this.checkTypesWithNoCallee(trace, scope, task.getCall());
        }
        return results;
    }

    private JetType getEffectiveExpectedType(ValueParameterDescriptor valueParameterDescriptor) {
        JetType effectiveExpectedType = valueParameterDescriptor.getVarargElementType();
        if (effectiveExpectedType == null) {
            effectiveExpectedType = valueParameterDescriptor.getType();
        }
        return effectiveExpectedType;
    }

    private void recordAutoCastIfNecessary(ReceiverDescriptor receiver, BindingTrace trace) {
        if (receiver instanceof AutoCastReceiver) {
            AutoCastReceiver autoCastReceiver = (AutoCastReceiver)receiver;
            ReceiverDescriptor original = autoCastReceiver.getOriginal();
            if (original instanceof ExpressionReceiver) {
                ExpressionReceiver expressionReceiver = (ExpressionReceiver)original;
                if (autoCastReceiver.canCast()) {
                    trace.record(BindingContext.AUTOCAST, expressionReceiver.getExpression(), autoCastReceiver.getType());
                } else {
                    trace.report(Errors.AUTOCAST_IMPOSSIBLE.on(expressionReceiver.getExpression(), autoCastReceiver.getType(), expressionReceiver.getExpression().getText()));
                }
            } else assert (autoCastReceiver.canCast()) : "A non-expression receiver must always be autocastabe: " + original;
        }
    }

    private void checkTypesWithNoCallee(BindingTrace trace, JetScope scope, Call call) {
        ExpressionTypingServices typeInferrerServices = new ExpressionTypingServices(this.semanticServices, trace);
        for (ValueArgument valueArgument : call.getValueArguments()) {
            JetExpression argumentExpression = valueArgument.getArgumentExpression();
            if (argumentExpression == null) continue;
            typeInferrerServices.getType(scope, argumentExpression, TypeUtils.NO_EXPECTED_TYPE);
        }
        for (JetExpression jetExpression : call.getFunctionLiteralArguments()) {
            typeInferrerServices.getType(scope, jetExpression, TypeUtils.NO_EXPECTED_TYPE);
        }
        for (JetTypeProjection jetTypeProjection : call.getTypeArguments()) {
            new TypeResolver(this.semanticServices, trace, true).resolveType(scope, jetTypeProjection.getTypeReference());
        }
    }

    private <D extends CallableDescriptor> void replaceValueParametersWithSubstitutedOnes(ResolvedCallImpl<D> candidateCall, @NotNull D substitutedDescriptor) {
        HashMap parameterMap = Maps.newHashMap();
        for (ValueParameterDescriptor valueParameterDescriptor : substitutedDescriptor.getValueParameters()) {
            parameterMap.put(valueParameterDescriptor.getOriginal(), valueParameterDescriptor);
        }
        Map<ValueParameterDescriptor, ResolvedValueArgument> valueArguments = candidateCall.getValueArguments();
        HashMap originalValueArguments = Maps.newHashMap(valueArguments);
        valueArguments.clear();
        for (Map.Entry entry : originalValueArguments.entrySet()) {
            ValueParameterDescriptor substitutedVersion = (ValueParameterDescriptor)parameterMap.get(((ValueParameterDescriptor)entry.getKey()).getOriginal());
            assert (substitutedVersion != null) : (ValueParameterDescriptor)entry.getKey();
            valueArguments.put(substitutedVersion, (ResolvedValueArgument)entry.getValue());
        }
    }

    private <D extends CallableDescriptor> ResolutionStatus checkAllValueArguments(JetScope scope, TracingStrategy tracing, ResolutionTask<D> task, ResolvedCallImpl<D> candidateCall) {
        ResolutionStatus result = this.checkValueArgumentTypes(scope, candidateCall);
        result = result.combine(this.checkReceiver(tracing, candidateCall, candidateCall.getResultingDescriptor().getReceiverParameter(), candidateCall.getReceiverArgument(), task));
        result = result.combine(this.checkReceiver(tracing, candidateCall, candidateCall.getResultingDescriptor().getExpectedThisObject(), candidateCall.getThisObject(), task));
        return result;
    }

    private <D extends CallableDescriptor> ResolutionStatus checkReceiver(TracingStrategy tracing, ResolvedCallImpl<D> candidateCall, ReceiverDescriptor receiverParameter, ReceiverDescriptor receiverArgument, ResolutionTask<D> task) {
        ResolutionStatus result = ResolutionStatus.SUCCESS;
        if (receiverParameter.exists() && receiverArgument.exists()) {
            ASTNode callOperationNode = task.getCall().getCallOperationNode();
            boolean safeAccess = callOperationNode != null && callOperationNode.getElementType() == JetTokens.SAFE_ACCESS;
            JetType receiverArgumentType = receiverArgument.getType();
            AutoCastServiceImpl autoCastService = new AutoCastServiceImpl(task.getDataFlowInfo(), candidateCall.getTrace().getBindingContext());
            if (!(safeAccess || receiverParameter.getType().isNullable() || autoCastService.isNotNull(receiverArgument))) {
                tracing.unsafeCall(candidateCall.getTrace(), receiverArgumentType);
                result = ResolutionStatus.UNSAFE_CALL_ERROR;
            } else {
                JetType effectiveReceiverArgumentType;
                JetType jetType = effectiveReceiverArgumentType = safeAccess ? TypeUtils.makeNotNullable(receiverArgumentType) : receiverArgumentType;
                if (!this.semanticServices.getTypeChecker().isSubtypeOf(effectiveReceiverArgumentType, receiverParameter.getType())) {
                    tracing.wrongReceiverType(candidateCall.getTrace(), receiverParameter, receiverArgument);
                    result = ResolutionStatus.OTHER_ERROR;
                }
            }
            if (safeAccess && (receiverParameter.getType().isNullable() || !receiverArgumentType.isNullable())) {
                tracing.unnecessarySafeCall(candidateCall.getTrace(), receiverArgumentType);
            }
        }
        return result;
    }

    private <D extends CallableDescriptor> ResolutionStatus checkValueArgumentTypes(JetScope scope, ResolvedCallImpl<D> candidateCall) {
        ResolutionStatus result = ResolutionStatus.SUCCESS;
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> entry : candidateCall.getValueArguments().entrySet()) {
            ValueParameterDescriptor parameterDescriptor = entry.getKey();
            ResolvedValueArgument resolvedArgument = entry.getValue();
            JetType parameterType = this.getEffectiveExpectedType(parameterDescriptor);
            List<JetExpression> argumentExpressions = resolvedArgument.getArgumentExpressions();
            for (JetExpression argumentExpression : argumentExpressions) {
                ExpressionTypingServices temporaryServices = new ExpressionTypingServices(this.semanticServices, candidateCall.getTrace());
                JetType type = temporaryServices.getType(scope, argumentExpression, parameterType, this.dataFlowInfo);
                if (type == null || ErrorUtils.isErrorType(type)) {
                    candidateCall.argumentHasNoType();
                    continue;
                }
                if (this.semanticServices.getTypeChecker().isSubtypeOf(type, parameterType)) continue;
                result = ResolutionStatus.OTHER_ERROR;
            }
        }
        return result;
    }

    @NotNull
    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> computeResultAndReportErrors(BindingTrace trace, TracingStrategy tracing, Set<ResolvedCallImpl<D>> successfulCandidates, Set<ResolvedCallImpl<D>> failedCandidates) {
        if (successfulCandidates.size() > 0) {
            OverloadResolutionResultsImpl<D> results = this.chooseAndReportMaximallySpecific(successfulCandidates, true);
            if (results.isAmbiguity()) {
                if (this.allClean(results.getResultingCalls())) {
                    tracing.ambiguity(trace, results.getResultingCalls());
                }
                tracing.recordAmbiguity(trace, results.getResultingCalls());
            }
            return results;
        }
        if (!failedCandidates.isEmpty()) {
            if (failedCandidates.size() != 1) {
                for (EnumSet<ResolutionStatus> severityLevel : ResolutionStatus.SEVERITY_LEVELS) {
                    LinkedHashSet thisLevel = Sets.newLinkedHashSet();
                    for (ResolvedCallImpl<D> candidate : failedCandidates) {
                        if (!severityLevel.contains((Object)candidate.getStatus())) continue;
                        thisLevel.add(candidate);
                    }
                    if (thisLevel.isEmpty()) continue;
                    OverloadResolutionResultsImpl<D> results = this.chooseAndReportMaximallySpecific(thisLevel, false);
                    if (results.isSuccess()) {
                        ((ResolvedCallImpl)results.getResultingCall()).getTrace().commit();
                        return OverloadResolutionResultsImpl.singleFailedCandidate(results.getResultingCall());
                    }
                    tracing.noneApplicable(trace, results.getResultingCalls());
                    tracing.recordAmbiguity(trace, results.getResultingCalls());
                    return OverloadResolutionResultsImpl.manyFailedCandidates(results.getResultingCalls());
                }
                assert (false) : "Should not be reachable, cause every status must belong to some level";
                Set noOverrides = OverridingUtil.filterOverrides(failedCandidates, ResolvedCallImpl.MAP_TO_CANDIDATE);
                if (noOverrides.size() != 1) {
                    tracing.noneApplicable(trace, noOverrides);
                    tracing.recordAmbiguity(trace, noOverrides);
                    return OverloadResolutionResultsImpl.manyFailedCandidates(noOverrides);
                }
                failedCandidates = noOverrides;
            }
            ResolvedCallImpl<D> failed = failedCandidates.iterator().next();
            failed.getTrace().commit();
            return OverloadResolutionResultsImpl.singleFailedCandidate(failed);
        }
        tracing.unresolvedReference(trace);
        return OverloadResolutionResultsImpl.nameNotFound();
    }

    private <D extends CallableDescriptor> boolean allClean(Collection<ResolvedCallImpl<D>> results) {
        for (ResolvedCallImpl<D> result : results) {
            if (!result.isDirty()) continue;
            return false;
        }
        return true;
    }

    private <D extends CallableDescriptor> OverloadResolutionResultsImpl<D> chooseAndReportMaximallySpecific(Set<ResolvedCallImpl<D>> candidates, boolean discriminateGenerics) {
        if (candidates.size() != 1) {
            ResolvedCallImpl maximallySpecificGenericsDiscriminated;
            ResolvedCallImpl maximallySpecific;
            Set<Object> cleanCandidates = Sets.newLinkedHashSet(candidates);
            Iterator iterator = cleanCandidates.iterator();
            while (iterator.hasNext()) {
                ResolvedCallImpl candidate = (ResolvedCallImpl)iterator.next();
                if (!candidate.isDirty()) continue;
                iterator.remove();
            }
            if (cleanCandidates.isEmpty()) {
                cleanCandidates = candidates;
            }
            if ((maximallySpecific = this.overloadingConflictResolver.findMaximallySpecific(cleanCandidates, false)) != null) {
                return OverloadResolutionResultsImpl.success(maximallySpecific);
            }
            if (discriminateGenerics && (maximallySpecificGenericsDiscriminated = this.overloadingConflictResolver.findMaximallySpecific(cleanCandidates, true)) != null) {
                return OverloadResolutionResultsImpl.success(maximallySpecificGenericsDiscriminated);
            }
            Set noOverrides = OverridingUtil.filterOverrides(candidates, ResolvedCallImpl.MAP_TO_RESULT);
            return OverloadResolutionResultsImpl.ambiguity(noOverrides);
        }
        ResolvedCallImpl<D> result = candidates.iterator().next();
        TemporaryBindingTrace temporaryTrace = result.getTrace();
        temporaryTrace.commit();
        return OverloadResolutionResultsImpl.success(result);
    }

    private void checkGenericBoundsInAFunctionCall(List<JetTypeProjection> jetTypeArguments, List<JetType> typeArguments, CallableDescriptor functionDescriptor, BindingTrace trace) {
        HashMap context = Maps.newHashMap();
        List<TypeParameterDescriptor> typeParameters = functionDescriptor.getOriginal().getTypeParameters();
        int typeParametersSize = typeParameters.size();
        for (int i = 0; i < typeParametersSize; ++i) {
            TypeParameterDescriptor typeParameter = typeParameters.get(i);
            JetType typeArgument = typeArguments.get(i);
            context.put(typeParameter.getTypeConstructor(), new TypeProjection(typeArgument));
        }
        TypeSubstitutor substitutor = TypeSubstitutor.create(context);
        int typeParametersSize2 = typeParameters.size();
        for (int i = 0; i < typeParametersSize2; ++i) {
            TypeParameterDescriptor typeParameterDescriptor = typeParameters.get(i);
            JetType typeArgument = typeArguments.get(i);
            JetTypeReference typeReference = jetTypeArguments.get(i).getTypeReference();
            assert (typeReference != null);
            this.semanticServices.getClassDescriptorResolver(trace).checkBounds(typeReference, typeArgument, typeParameterDescriptor, substitutor);
        }
    }

    @NotNull
    public OverloadResolutionResults<FunctionDescriptor> resolveExactSignature(@NotNull JetScope scope, @NotNull ReceiverDescriptor receiver, @NotNull String name, @NotNull List<JetType> parameterTypes) {
        List<ResolvedCallImpl<FunctionDescriptor>> result = this.findCandidatesByExactSignature(scope, receiver, name, parameterTypes);
        BindingTraceContext trace = new BindingTraceContext();
        TemporaryBindingTrace temporaryBindingTrace = TemporaryBindingTrace.create(trace);
        LinkedHashSet candidates = Sets.newLinkedHashSet();
        for (ResolvedCallImpl<FunctionDescriptor> call : result) {
            call.setTrace(temporaryBindingTrace);
            candidates.add(call);
        }
        return this.computeResultAndReportErrors(trace, TracingStrategy.EMPTY, candidates, Collections.emptySet());
    }

    private List<ResolvedCallImpl<FunctionDescriptor>> findCandidatesByExactSignature(JetScope scope, ReceiverDescriptor receiver, String name, List<JetType> parameterTypes) {
        ArrayList result = Lists.newArrayList();
        if (receiver.exists()) {
            List extensionFunctionDescriptors = ResolvedCallImpl.convertCollection(scope.getFunctions(name));
            ArrayList nonlocal = Lists.newArrayList();
            ArrayList local = Lists.newArrayList();
            TaskPrioritizer.splitLexicallyLocalDescriptors(extensionFunctionDescriptors, scope.getContainingDeclaration(), local, nonlocal);
            if (this.findExtensionFunctions(local, receiver, parameterTypes, result)) {
                return result;
            }
            List<ResolvedCallImpl<FunctionDescriptor>> functionDescriptors = ResolvedCallImpl.convertCollection(receiver.getType().getMemberScope().getFunctions(name));
            if (this.lookupExactSignature(functionDescriptors, parameterTypes, result)) {
                return result;
            }
            this.findExtensionFunctions(nonlocal, receiver, parameterTypes, result);
            return result;
        }
        this.lookupExactSignature(ResolvedCallImpl.convertCollection(scope.getFunctions(name)), parameterTypes, result);
        return result;
    }

    private boolean lookupExactSignature(Collection<ResolvedCallImpl<FunctionDescriptor>> candidates, List<JetType> parameterTypes, List<ResolvedCallImpl<FunctionDescriptor>> result) {
        boolean found = false;
        for (ResolvedCallImpl<FunctionDescriptor> resolvedCall : candidates) {
            FunctionDescriptor functionDescriptor = resolvedCall.getResultingDescriptor();
            if (functionDescriptor.getReceiverParameter().exists() || !functionDescriptor.getTypeParameters().isEmpty() || !this.checkValueParameters(functionDescriptor, parameterTypes)) continue;
            result.add(resolvedCall);
            found = true;
        }
        return found;
    }

    private boolean findExtensionFunctions(Collection<ResolvedCallImpl<FunctionDescriptor>> candidates, ReceiverDescriptor receiver, List<JetType> parameterTypes, List<ResolvedCallImpl<FunctionDescriptor>> result) {
        boolean found = false;
        for (ResolvedCallImpl<FunctionDescriptor> resolvedCall : candidates) {
            FunctionDescriptor functionDescriptor = resolvedCall.getResultingDescriptor();
            ReceiverDescriptor functionReceiver = functionDescriptor.getReceiverParameter();
            if (!functionReceiver.exists() || !functionDescriptor.getTypeParameters().isEmpty() || !this.semanticServices.getTypeChecker().isSubtypeOf(receiver.getType(), functionReceiver.getType()) || !this.checkValueParameters(functionDescriptor, parameterTypes)) continue;
            result.add(resolvedCall);
            found = true;
        }
        return found;
    }

    private boolean checkValueParameters(@NotNull FunctionDescriptor functionDescriptor, @NotNull List<JetType> parameterTypes) {
        List<ValueParameterDescriptor> valueParameters = functionDescriptor.getValueParameters();
        if (valueParameters.size() != parameterTypes.size()) {
            return false;
        }
        for (int i = 0; i < valueParameters.size(); ++i) {
            ValueParameterDescriptor valueParameter = valueParameters.get(i);
            JetType expectedType = parameterTypes.get(i);
            if (TypeUtils.equalTypes(expectedType, valueParameter.getType())) continue;
            return false;
        }
        return true;
    }
}

