/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.Call;
import org.jetbrains.jet.lang.psi.JetArrayAccessExpression;
import org.jetbrains.jet.lang.psi.JetBinaryExpression;
import org.jetbrains.jet.lang.psi.JetCallElement;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeArgumentList;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetUnaryExpression;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.psi.JetValueArgumentName;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;

public class CallMaker {
    public static Call makeCallWithExpressions(@NotNull JetElement callElement, @NotNull ReceiverDescriptor explicitReceiver, @Nullable ASTNode callOperationNode, @NotNull JetExpression calleeExpression, @NotNull List<JetExpression> argumentExpressions) {
        ArrayList arguments = Lists.newArrayList();
        for (JetExpression argumentExpression : argumentExpressions) {
            arguments.add(CallMaker.makeValueArgument(argumentExpression, (PsiElement)calleeExpression));
        }
        return CallMaker.makeCall(callElement, explicitReceiver, callOperationNode, calleeExpression, arguments);
    }

    public static Call makeCall(JetElement callElement, ReceiverDescriptor explicitReceiver, @Nullable ASTNode callOperationNode, JetExpression calleeExpression, List<? extends ValueArgument> arguments) {
        return new CallImpl((PsiElement)callElement, explicitReceiver, callOperationNode, calleeExpression, arguments);
    }

    public static Call makeCall(@NotNull ReceiverDescriptor leftAsReceiver, JetBinaryExpression expression) {
        return CallMaker.makeCallWithExpressions(expression, leftAsReceiver, null, expression.getOperationReference(), Collections.singletonList(expression.getRight()));
    }

    public static Call makeCall(@NotNull ReceiverDescriptor baseAsReceiver, JetUnaryExpression expression) {
        return CallMaker.makeCall(expression, baseAsReceiver, null, expression.getOperationReference(), Collections.emptyList());
    }

    public static Call makeArraySetCall(@NotNull ReceiverDescriptor arrayAsReceiver, @NotNull JetArrayAccessExpression arrayAccessExpression, @NotNull JetExpression rightHandSide) {
        ArrayList arguments = Lists.newArrayList(arrayAccessExpression.getIndexExpressions());
        arguments.add(rightHandSide);
        return CallMaker.makeCallWithExpressions(arrayAccessExpression, arrayAsReceiver, null, arrayAccessExpression, arguments);
    }

    public static Call makeArrayGetCall(@NotNull ReceiverDescriptor arrayAsReceiver, @NotNull JetArrayAccessExpression arrayAccessExpression) {
        return CallMaker.makeCallWithExpressions(arrayAccessExpression, arrayAsReceiver, null, arrayAccessExpression, arrayAccessExpression.getIndexExpressions());
    }

    public static ValueArgument makeValueArgument(@NotNull JetExpression expression) {
        return CallMaker.makeValueArgument(expression, (PsiElement)expression);
    }

    public static ValueArgument makeValueArgument(@Nullable JetExpression expression, @NotNull PsiElement reportErrorsOn) {
        return new ExpressionValueArgument(expression, reportErrorsOn);
    }

    public static Call makePropertyCall(@NotNull ReceiverDescriptor explicitReceiver, @Nullable ASTNode callOperationNode, @NotNull JetSimpleNameExpression nameExpression) {
        return CallMaker.makeCallWithExpressions(nameExpression, explicitReceiver, callOperationNode, nameExpression, Collections.<JetExpression>emptyList());
    }

    public static Call makeCall(final @NotNull ReceiverDescriptor explicitReceiver, final @Nullable ASTNode callOperationNode, final @NotNull JetCallElement callElement) {
        return new Call(){

            @Override
            public ASTNode getCallOperationNode() {
                return callOperationNode;
            }

            @Override
            @NotNull
            public ReceiverDescriptor getExplicitReceiver() {
                return explicitReceiver;
            }

            @Override
            @Nullable
            public JetExpression getCalleeExpression() {
                return callElement.getCalleeExpression();
            }

            @Override
            @Nullable
            public JetValueArgumentList getValueArgumentList() {
                return callElement.getValueArgumentList();
            }

            @Override
            @NotNull
            public List<? extends ValueArgument> getValueArguments() {
                return callElement.getValueArguments();
            }

            @Override
            @NotNull
            public List<JetExpression> getFunctionLiteralArguments() {
                return callElement.getFunctionLiteralArguments();
            }

            @Override
            @NotNull
            public List<JetTypeProjection> getTypeArguments() {
                return callElement.getTypeArguments();
            }

            @Override
            @Nullable
            public JetTypeArgumentList getTypeArgumentList() {
                return callElement.getTypeArgumentList();
            }

            @Override
            @NotNull
            public PsiElement getCallElement() {
                return callElement;
            }

            public String toString() {
                return callElement.getText();
            }
        };
    }

    private static class CallImpl
    implements Call {
        private final PsiElement callElement;
        private final ReceiverDescriptor explicitReceiver;
        private ASTNode callOperationNode;
        private final JetExpression calleeExpression;
        private final List<? extends ValueArgument> valueArguments;

        protected CallImpl(@Nullable PsiElement callElement, @NotNull ReceiverDescriptor explicitReceiver, @Nullable ASTNode callOperationNode, @NotNull JetExpression calleeExpression, @NotNull List<? extends ValueArgument> valueArguments) {
            this.callElement = callElement;
            this.explicitReceiver = explicitReceiver;
            this.callOperationNode = callOperationNode;
            this.calleeExpression = calleeExpression;
            this.valueArguments = valueArguments;
        }

        @Override
        public ASTNode getCallOperationNode() {
            return this.callOperationNode;
        }

        @Override
        @NotNull
        public ReceiverDescriptor getExplicitReceiver() {
            return this.explicitReceiver;
        }

        @Override
        public JetExpression getCalleeExpression() {
            return this.calleeExpression;
        }

        @Override
        @NotNull
        public List<? extends ValueArgument> getValueArguments() {
            return this.valueArguments;
        }

        @Override
        @NotNull
        public PsiElement getCallElement() {
            return this.callElement;
        }

        @Override
        public JetValueArgumentList getValueArgumentList() {
            return null;
        }

        @Override
        @NotNull
        public List<JetExpression> getFunctionLiteralArguments() {
            return Collections.emptyList();
        }

        @Override
        @NotNull
        public List<JetTypeProjection> getTypeArguments() {
            return Collections.emptyList();
        }

        @Override
        public JetTypeArgumentList getTypeArgumentList() {
            return null;
        }

        public String toString() {
            return this.getCallElement().getText();
        }
    }

    private static class ExpressionValueArgument
    implements ValueArgument {
        private final JetExpression expression;
        private final PsiElement reportErrorsOn;

        private ExpressionValueArgument(@NotNull JetExpression expression) {
            this(expression, (PsiElement)expression);
        }

        private ExpressionValueArgument(@Nullable JetExpression expression, @NotNull PsiElement reportErrorsOn) {
            this.expression = expression;
            this.reportErrorsOn = expression == null ? reportErrorsOn : expression;
        }

        @Override
        public JetExpression getArgumentExpression() {
            return this.expression;
        }

        @Override
        public JetValueArgumentName getArgumentName() {
            return null;
        }

        @Override
        public boolean isNamed() {
            return false;
        }

        @Override
        @NotNull
        public PsiElement asElement() {
            return this.reportErrorsOn;
        }
    }
}

