/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve.calls;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.resolve.scopes.receivers.AbstractReceiverDescriptor;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptorVisitor;
import org.jetbrains.jet.lang.types.JetType;

public class AutoCastReceiver
extends AbstractReceiverDescriptor {
    private final ReceiverDescriptor original;
    private final boolean canCast;

    public AutoCastReceiver(@NotNull ReceiverDescriptor original, @NotNull JetType castTo, boolean canCast) {
        super(castTo);
        this.original = original;
        this.canCast = canCast;
    }

    public boolean canCast() {
        return this.canCast;
    }

    @NotNull
    public ReceiverDescriptor getOriginal() {
        return this.original;
    }

    @Override
    public <R, D> R accept(@NotNull ReceiverDescriptorVisitor<R, D> visitor, D data) {
        return this.original.accept(visitor, data);
    }

    public String toString() {
        return "(" + this.original + " as " + this.getType() + ")";
    }
}

