/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiNameIdentifierOwner;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.MutableClassDescriptorLite;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.NamespaceLike;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifierList;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeConstraint;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetTypedef;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.WriteThroughScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lexer.JetTokens;

public class TypeHierarchyResolver {
    private final TopDownAnalysisContext context;
    private LinkedList<MutableClassDescriptor> topologicalOrder;

    public TypeHierarchyResolver(TopDownAnalysisContext context) {
        this.context = context;
    }

    public void process(@NotNull JetScope outerScope, @NotNull NamespaceLike owner, @NotNull Collection<? extends PsiElement> declarations) {
        this.collectNamespacesAndClassifiers(outerScope, outerScope, owner, declarations);
        this.context.getImportsResolver().processTypeImports();
        this.createTypeConstructors();
        this.resolveTypesInClassHeaders();
        this.topologicalOrder = this.topologicallySortClassesAndObjects();
        this.detectAndDisconnectLoops();
        this.checkSupertypesForConsistency();
        this.checkTypesInClassHeaders();
    }

    private void collectNamespacesAndClassifiers(final @NotNull JetScope outerScope, final @NotNull JetScope outerScopeForStatic, final @NotNull NamespaceLike owner, @NotNull Collection<? extends PsiElement> declarations) {
        for (PsiElement psiElement : declarations) {
            psiElement.accept((PsiElementVisitor)new JetVisitorVoid(){

                @Override
                public void visitJetFile(JetFile file) {
                    NamespaceDescriptorImpl namespaceDescriptor = TypeHierarchyResolver.this.createNamespaceDescriptorPathIfNeeded(file, owner, outerScope);
                    TypeHierarchyResolver.this.context.getNamespaceDescriptors().put(file, namespaceDescriptor);
                    WriteThroughScope namespaceScope = new WriteThroughScope(outerScope, namespaceDescriptor.getMemberScope(), new TraceBasedRedeclarationHandler(TypeHierarchyResolver.this.context.getTrace()));
                    namespaceScope.changeLockLevel(WritableScope.LockLevel.BOTH);
                    TypeHierarchyResolver.this.context.getNamespaceScopes().put(file, namespaceScope);
                    TypeHierarchyResolver.this.collectNamespacesAndClassifiers(namespaceScope, namespaceScope, namespaceDescriptor, file.getDeclarations());
                }

                @Override
                public void visitClass(JetClass klass) {
                    MutableClassDescriptor mutableClassDescriptor = new MutableClassDescriptor(TypeHierarchyResolver.this.context.getTrace(), owner, outerScope, TypeHierarchyResolver.this.getClassKind(klass));
                    TypeHierarchyResolver.this.context.getTrace().record(BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, JetPsiUtil.getFQName(klass), mutableClassDescriptor);
                    if (klass.hasModifier(JetTokens.ENUM_KEYWORD)) {
                        MutableClassDescriptor classObjectDescriptor = new MutableClassDescriptor(TypeHierarchyResolver.this.context.getTrace(), mutableClassDescriptor, outerScope, ClassKind.OBJECT);
                        classObjectDescriptor.setName("class-object-for-" + klass.getName());
                        classObjectDescriptor.setModality(Modality.FINAL);
                        classObjectDescriptor.setVisibility(DescriptorResolver.resolveVisibilityFromModifiers(klass.getModifierList()));
                        classObjectDescriptor.setTypeParameterDescriptors(new ArrayList<TypeParameterDescriptor>(0));
                        classObjectDescriptor.createTypeConstructor();
                        this.createPrimaryConstructorForObject(null, classObjectDescriptor);
                        mutableClassDescriptor.setClassObjectDescriptor(classObjectDescriptor);
                    }
                    this.visitClassOrObject(klass, TypeHierarchyResolver.this.context.getClasses(), mutableClassDescriptor);
                    owner.addClassifierDescriptor(mutableClassDescriptor);
                }

                @Override
                public void visitObjectDeclaration(JetObjectDeclaration declaration) {
                    MutableClassDescriptor objectDescriptor = this.createClassDescriptorForObject(declaration, owner, outerScope, ClassKind.OBJECT);
                    TypeHierarchyResolver.this.context.getTrace().record(BindingContext.FQNAME_TO_CLASS_DESCRIPTOR, JetPsiUtil.getFQName(declaration), objectDescriptor);
                }

                @Override
                public void visitEnumEntry(JetEnumEntry enumEntry) {
                    MutableClassDescriptorLite classObjectDescriptor = ((MutableClassDescriptor)owner).getClassObjectDescriptor();
                    assert (classObjectDescriptor != null) : enumEntry.getParent().getText();
                    if (enumEntry.getPrimaryConstructorParameterList() == null) {
                        this.createClassDescriptorForObject(enumEntry, classObjectDescriptor, outerScopeForStatic, ClassKind.ENUM_ENTRY);
                        return;
                    }
                    MutableClassDescriptor mutableClassDescriptor = new MutableClassDescriptor(TypeHierarchyResolver.this.context.getTrace(), classObjectDescriptor, outerScope, ClassKind.ENUM_ENTRY);
                    this.visitClassOrObject(enumEntry, TypeHierarchyResolver.this.context.getClasses(), mutableClassDescriptor);
                    classObjectDescriptor.addClassifierDescriptor(mutableClassDescriptor);
                }

                private MutableClassDescriptor createClassDescriptorForObject(@NotNull JetClassOrObject declaration, @NotNull NamespaceLike owner2, JetScope scope, ClassKind classKind) {
                    MutableClassDescriptor mutableClassDescriptor = new MutableClassDescriptor(TypeHierarchyResolver.this.context.getTrace(), owner2, scope, classKind){

                        @Override
                        public NamespaceLike.ClassObjectStatus setClassObjectDescriptor(@NotNull MutableClassDescriptorLite classObjectDescriptor) {
                            return NamespaceLike.ClassObjectStatus.NOT_ALLOWED;
                        }
                    };
                    Map<JetClassOrObject, MutableClassDescriptor> map = classKind == ClassKind.OBJECT ? TypeHierarchyResolver.this.context.getObjects() : TypeHierarchyResolver.this.context.getClasses();
                    this.visitClassOrObject(declaration, map, mutableClassDescriptor);
                    this.createPrimaryConstructorForObject((JetDeclaration)((Object)declaration), mutableClassDescriptor);
                    owner2.addObjectDescriptor(mutableClassDescriptor);
                    TypeHierarchyResolver.this.context.getTrace().record(BindingContext.CLASS, declaration, mutableClassDescriptor);
                    return mutableClassDescriptor;
                }

                private void createPrimaryConstructorForObject(@Nullable JetDeclaration object, MutableClassDescriptor mutableClassDescriptor) {
                    ConstructorDescriptorImpl constructorDescriptor = new ConstructorDescriptorImpl(mutableClassDescriptor, Collections.<AnnotationDescriptor>emptyList(), true);
                    constructorDescriptor.initialize(Collections.<TypeParameterDescriptor>emptyList(), Collections.<ValueParameterDescriptor>emptyList(), Visibility.INTERNAL);
                    mutableClassDescriptor.setPrimaryConstructor(constructorDescriptor, TypeHierarchyResolver.this.context.getTrace());
                    if (object != null) {
                        TypeHierarchyResolver.this.context.getTrace().record(BindingContext.CONSTRUCTOR, object, constructorDescriptor);
                    }
                }

                private void visitClassOrObject(@NotNull JetClassOrObject declaration, Map<JetClassOrObject, MutableClassDescriptor> map, MutableClassDescriptor mutableClassDescriptor) {
                    mutableClassDescriptor.setName(JetPsiUtil.safeName(declaration.getName()));
                    map.put(declaration, mutableClassDescriptor);
                    JetScope classScope = mutableClassDescriptor.getScopeForMemberResolution();
                    JetScope scopeForStatic = declaration instanceof JetObjectDeclaration ? classScope : outerScopeForStatic;
                    TypeHierarchyResolver.this.collectNamespacesAndClassifiers(classScope, scopeForStatic, mutableClassDescriptor, declaration.getDeclarations());
                }

                @Override
                public void visitTypedef(JetTypedef typedef) {
                    TypeHierarchyResolver.this.context.getTrace().report(Errors.UNSUPPORTED.on(typedef, "TypeHierarchyResolver"));
                }

                @Override
                public void visitClassObject(JetClassObject classObject) {
                    JetObjectDeclaration objectDeclaration = classObject.getObjectDeclaration();
                    if (objectDeclaration != null) {
                        NamespaceLike.ClassObjectStatus status = owner.setClassObjectDescriptor(this.createClassDescriptorForObject(objectDeclaration, owner, outerScopeForStatic, ClassKind.OBJECT));
                        switch (status) {
                            case DUPLICATE: {
                                TypeHierarchyResolver.this.context.getTrace().report(Errors.MANY_CLASS_OBJECTS.on(classObject));
                                break;
                            }
                            case NOT_ALLOWED: {
                                TypeHierarchyResolver.this.context.getTrace().report(Errors.CLASS_OBJECT_NOT_ALLOWED.on(classObject));
                            }
                        }
                    }
                }
            });
        }
    }

    private NamespaceDescriptorImpl createNamespaceDescriptorPathIfNeeded(JetFile file, NamespaceLike owner, JetScope outerScope) {
        NamespaceLike currentOwner = owner;
        for (JetSimpleNameExpression nameExpression : file.getNamespaceHeader().getParentNamespaceNames()) {
            String namespaceName = JetPsiUtil.safeName(nameExpression.getReferencedName());
            NamespaceDescriptorImpl namespaceDescriptor = this.createNamespaceDescriptorIfNeeded(null, currentOwner, namespaceName);
            currentOwner = namespaceDescriptor;
            this.context.getTrace().record(BindingContext.REFERENCE_TARGET, nameExpression, currentOwner);
            this.context.getTrace().record(BindingContext.RESOLUTION_SCOPE, nameExpression, outerScope);
            outerScope = namespaceDescriptor.getMemberScope();
        }
        String name = JetPsiUtil.safeName(file.getNamespaceHeader().getName());
        this.context.getTrace().record(BindingContext.RESOLUTION_SCOPE, file.getNamespaceHeader(), outerScope);
        return this.createNamespaceDescriptorIfNeeded(file, currentOwner, name);
    }

    @NotNull
    private NamespaceDescriptorImpl createNamespaceDescriptorIfNeeded(@Nullable JetFile file, @NotNull NamespaceLike owner, String name) {
        NamespaceDescriptorImpl namespaceDescriptor = owner.getNamespace(name);
        if (namespaceDescriptor == null) {
            namespaceDescriptor = new NamespaceDescriptorImpl(owner.getOriginal(), Collections.<AnnotationDescriptor>emptyList(), name);
            this.context.getTrace().record(BindingContext.FQNAME_TO_NAMESPACE_DESCRIPTOR, DescriptorUtils.getFQName(namespaceDescriptor), namespaceDescriptor);
            WritableScopeImpl scope = new WritableScopeImpl(JetScope.EMPTY, namespaceDescriptor, new TraceBasedRedeclarationHandler(this.context.getTrace())).setDebugName("Namespace member scope");
            scope.changeLockLevel(WritableScope.LockLevel.BOTH);
            namespaceDescriptor.initialize(scope);
            this.context.getConfiguration().extendNamespaceScope(this.context.getTrace(), namespaceDescriptor, scope);
            owner.addNamespace(namespaceDescriptor);
            if (file != null) {
                this.context.getTrace().record(BindingContext.NAMESPACE, file, namespaceDescriptor);
            }
        }
        return namespaceDescriptor;
    }

    @NotNull
    private ClassKind getClassKind(@NotNull JetClass jetClass) {
        if (jetClass.isTrait()) {
            return ClassKind.TRAIT;
        }
        if (jetClass.hasModifier(JetTokens.ANNOTATION_KEYWORD)) {
            return ClassKind.ANNOTATION_CLASS;
        }
        if (jetClass.hasModifier(JetTokens.ENUM_KEYWORD)) {
            return ClassKind.ENUM_CLASS;
        }
        return ClassKind.CLASS;
    }

    private void createTypeConstructors() {
        MutableClassDescriptor descriptor;
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            JetClass jetClass = entry.getKey();
            descriptor = entry.getValue();
            this.context.getDescriptorResolver().resolveMutableClassDescriptor(jetClass, descriptor);
            descriptor.createTypeConstructor();
        }
        for (Map.Entry<JetNamedDeclaration, MutableClassDescriptor> entry : this.context.getObjects().entrySet()) {
            JetObjectDeclaration objectDeclaration = (JetObjectDeclaration)entry.getKey();
            descriptor = entry.getValue();
            descriptor.setModality(Modality.FINAL);
            descriptor.setVisibility(DescriptorResolver.resolveVisibilityFromModifiers(objectDeclaration.getModifierList()));
            descriptor.setTypeParameterDescriptors(new ArrayList<TypeParameterDescriptor>(0));
            descriptor.createTypeConstructor();
        }
    }

    private void resolveTypesInClassHeaders() {
        MutableClassDescriptor descriptor;
        JetClassOrObject jetClass;
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            jetClass = entry.getKey();
            descriptor = entry.getValue();
            this.context.getDescriptorResolver().resolveGenericBounds((JetTypeParameterListOwner)((Object)jetClass), descriptor.getScopeForSupertypeResolution(), descriptor.getTypeConstructor().getParameters());
            this.context.getDescriptorResolver().resolveSupertypes(jetClass, descriptor);
        }
        for (Map.Entry<JetNamedDeclaration, MutableClassDescriptor> entry : this.context.getObjects().entrySet()) {
            jetClass = (JetClassOrObject)((Object)entry.getKey());
            descriptor = entry.getValue();
            this.context.getDescriptorResolver().resolveSupertypes(jetClass, descriptor);
        }
    }

    private LinkedList<MutableClassDescriptor> topologicallySortClassesAndObjects() {
        LinkedList topologicalOrder = Lists.newLinkedList();
        HashSet visited = Sets.newHashSet();
        for (MutableClassDescriptor mutableClassDescriptor : this.context.getClasses().values()) {
            TypeHierarchyResolver.topologicallySort(mutableClassDescriptor, visited, topologicalOrder);
        }
        for (MutableClassDescriptor mutableClassDescriptor : this.context.getObjects().values()) {
            TypeHierarchyResolver.topologicallySort(mutableClassDescriptor, visited, topologicalOrder);
        }
        return topologicalOrder;
    }

    private void detectAndDisconnectLoops() {
        HashSet visited = Sets.newHashSet();
        HashSet beingProcessed = Sets.newHashSet();
        ArrayList currentPath = Lists.newArrayList();
        for (MutableClassDescriptor mutableClassDescriptor : this.topologicalOrder) {
            this.traverseTypeHierarchy(mutableClassDescriptor, visited, beingProcessed, currentPath);
        }
    }

    private static void topologicallySort(MutableClassDescriptor mutableClassDescriptor, Set<ClassDescriptor> visited, LinkedList<MutableClassDescriptor> topologicalOrder) {
        if (!visited.add(mutableClassDescriptor)) {
            return;
        }
        for (JetType supertype : mutableClassDescriptor.getSupertypes()) {
            ClassifierDescriptor declarationDescriptor = supertype.getConstructor().getDeclarationDescriptor();
            if (!(declarationDescriptor instanceof MutableClassDescriptor)) continue;
            MutableClassDescriptor classDescriptor = (MutableClassDescriptor)declarationDescriptor;
            TypeHierarchyResolver.topologicallySort(classDescriptor, visited, topologicalOrder);
        }
        topologicalOrder.addFirst(mutableClassDescriptor);
    }

    private void traverseTypeHierarchy(MutableClassDescriptor currentClass, Set<ClassDescriptor> visited, Set<ClassDescriptor> beingProcessed, List<ClassDescriptor> currentPath) {
        if (!visited.add(currentClass)) {
            if (beingProcessed.contains(currentClass)) {
                this.markCycleErrors(currentPath, currentClass);
                assert (!currentPath.isEmpty()) : "Cycle cannot be found on an empty currentPath";
                ClassDescriptor subclassOfCurrent = currentPath.get(currentPath.size() - 1);
                assert (subclassOfCurrent instanceof MutableClassDescriptor);
                Iterator<JetType> iterator = ((MutableClassDescriptor)subclassOfCurrent).getSupertypes().iterator();
                while (iterator.hasNext()) {
                    JetType type = iterator.next();
                    if (type.getConstructor() != currentClass.getTypeConstructor()) continue;
                    iterator.remove();
                    break;
                }
            }
            return;
        }
        beingProcessed.add(currentClass);
        currentPath.add(currentClass);
        for (JetType supertype : Lists.newArrayList(currentClass.getSupertypes())) {
            ClassifierDescriptor declarationDescriptor = supertype.getConstructor().getDeclarationDescriptor();
            if (!(declarationDescriptor instanceof MutableClassDescriptor)) continue;
            MutableClassDescriptor mutableClassDescriptor = (MutableClassDescriptor)declarationDescriptor;
            this.traverseTypeHierarchy(mutableClassDescriptor, visited, beingProcessed, currentPath);
        }
        beingProcessed.remove(currentClass);
        currentPath.remove(currentPath.size() - 1);
    }

    private void markCycleErrors(List<ClassDescriptor> currentPath, @NotNull ClassDescriptor current) {
        int size = currentPath.size();
        boolean found = false;
        for (int i = 0; i < size; ++i) {
            PsiNameIdentifierOwner namedElement;
            PsiElement nameIdentifier;
            ClassDescriptor classDescriptor = currentPath.get(i);
            if (classDescriptor == current) {
                found = true;
            }
            if (!found) continue;
            ClassDescriptor superclass = i < size - 1 ? currentPath.get(i + 1) : current;
            PsiElement psiElement = this.context.getTrace().get(BindingContext.DESCRIPTOR_TO_DECLARATION, classDescriptor);
            Object elementToMark = null;
            if (psiElement instanceof JetClassOrObject) {
                JetClassOrObject classOrObject = (JetClassOrObject)psiElement;
                for (JetDelegationSpecifier delegationSpecifier : classOrObject.getDelegationSpecifiers()) {
                    JetType supertype;
                    JetTypeReference typeReference = delegationSpecifier.getTypeReference();
                    if (typeReference == null || (supertype = this.context.getTrace().get(BindingContext.TYPE, typeReference)) == null || supertype.getConstructor() != superclass.getTypeConstructor()) continue;
                    elementToMark = typeReference;
                }
            }
            if (elementToMark == null && psiElement instanceof PsiNameIdentifierOwner && (nameIdentifier = (namedElement = (PsiNameIdentifierOwner)psiElement).getNameIdentifier()) != null) {
                elementToMark = nameIdentifier;
            }
            if (elementToMark == null) continue;
            this.context.getTrace().report(Errors.CYCLIC_INHERITANCE_HIERARCHY.on((PsiElement)elementToMark));
        }
    }

    private void checkSupertypesForConsistency() {
        for (MutableClassDescriptor mutableClassDescriptor : this.topologicalOrder) {
            Multimap<TypeConstructor, TypeProjection> multimap = TypeUtils.buildDeepSubstitutionMultimap(mutableClassDescriptor.getDefaultType());
            for (Map.Entry entry : multimap.asMap().entrySet()) {
                Collection projections = (Collection)entry.getValue();
                if (projections.size() <= 1) continue;
                TypeConstructor typeConstructor = (TypeConstructor)entry.getKey();
                ClassifierDescriptor declarationDescriptor = typeConstructor.getDeclarationDescriptor();
                assert (declarationDescriptor instanceof TypeParameterDescriptor) : declarationDescriptor;
                TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)declarationDescriptor;
                LinkedHashSet conflictingTypes = Sets.newLinkedHashSet();
                for (TypeProjection projection : projections) {
                    conflictingTypes.add(projection.getType());
                }
                switch (typeParameterDescriptor.getVariance()) {
                    case INVARIANT: {
                        break;
                    }
                    case IN_VARIANCE: {
                        Filter.REMOVE_IF_SUPERTYPE_IN_THE_SET.proceed(conflictingTypes);
                        break;
                    }
                    case OUT_VARIANCE: {
                        Filter.REMOVE_IF_SUBTYPE_IN_THE_SET.proceed(conflictingTypes);
                    }
                }
                if (conflictingTypes.size() <= 1) continue;
                DeclarationDescriptor containingDeclaration = typeParameterDescriptor.getContainingDeclaration();
                assert (containingDeclaration instanceof ClassDescriptor) : containingDeclaration;
                PsiElement psiElement = this.context.getTrace().get(BindingContext.DESCRIPTOR_TO_DECLARATION, mutableClassDescriptor);
                assert (psiElement instanceof JetClassOrObject) : psiElement;
                JetClassOrObject declaration = (JetClassOrObject)psiElement;
                JetDelegationSpecifierList delegationSpecifierList = declaration.getDelegationSpecifierList();
                assert (delegationSpecifierList != null);
                this.context.getTrace().report(Errors.INCONSISTENT_TYPE_PARAMETER_VALUES.on(delegationSpecifierList, typeParameterDescriptor, (ClassDescriptor)containingDeclaration, conflictingTypes));
            }
        }
    }

    private void checkTypesInClassHeaders() {
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            JetTypeReference extendsBound;
            JetType type;
            JetClass jetClass = entry.getKey();
            for (JetDelegationSpecifier delegationSpecifier : jetClass.getDelegationSpecifiers()) {
                JetTypeReference typeReference = delegationSpecifier.getTypeReference();
                if (typeReference == null || (type = this.context.getTrace().getBindingContext().get(BindingContext.TYPE, typeReference)) == null) continue;
                this.context.getDescriptorResolver().checkBounds(typeReference, type);
            }
            for (JetTypeParameter jetTypeParameter : jetClass.getTypeParameters()) {
                extendsBound = jetTypeParameter.getExtendsBound();
                if (extendsBound == null || (type = this.context.getTrace().getBindingContext().get(BindingContext.TYPE, extendsBound)) == null) continue;
                this.context.getDescriptorResolver().checkBounds(extendsBound, type);
            }
            for (JetTypeConstraint constraint : jetClass.getTypeConstaints()) {
                extendsBound = constraint.getBoundTypeReference();
                if (extendsBound == null || (type = this.context.getTrace().getBindingContext().get(BindingContext.TYPE, extendsBound)) == null) continue;
                this.context.getDescriptorResolver().checkBounds(extendsBound, type);
            }
        }
    }

    private static enum Filter {
        REMOVE_IF_SUBTYPE_IN_THE_SET{

            @Override
            public boolean removeNeeded(JetType subject, JetType other) {
                return JetTypeChecker.INSTANCE.isSubtypeOf(other, subject);
            }
        }
        ,
        REMOVE_IF_SUPERTYPE_IN_THE_SET{

            @Override
            public boolean removeNeeded(JetType subject, JetType other) {
                return JetTypeChecker.INSTANCE.isSubtypeOf(subject, other);
            }
        };


        private void proceed(Set<JetType> conflictingTypes) {
            Iterator<JetType> iterator = conflictingTypes.iterator();
            block0: while (iterator.hasNext()) {
                JetType type = iterator.next();
                for (JetType otherType : conflictingTypes) {
                    boolean subtypeOf = this.removeNeeded(type, otherType);
                    if (type == otherType || !subtypeOf) continue;
                    iterator.remove();
                    continue block0;
                }
            }
        }

        public abstract boolean removeNeeded(JetType var1, JetType var2);
    }
}

