/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.base.Predicate;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import java.io.PrintStream;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.Configuration;
import org.jetbrains.jet.lang.JetSemanticServices;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetSecondaryConstructor;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorResolver;
import org.jetbrains.jet.lang.resolve.ImportsResolver;
import org.jetbrains.jet.lang.resolve.ObservableBindingTrace;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;

class TopDownAnalysisContext {
    private final ObservableBindingTrace trace;
    private final JetSemanticServices semanticServices;
    private final Configuration configuration;
    private final DescriptorResolver descriptorResolver;
    private final ImportsResolver importsResolver;
    private final Map<JetClass, MutableClassDescriptor> classes = Maps.newLinkedHashMap();
    private final Map<JetObjectDeclaration, MutableClassDescriptor> objects = Maps.newLinkedHashMap();
    protected final Map<JetFile, WritableScope> namespaceScopes = Maps.newHashMap();
    protected final Map<JetFile, NamespaceDescriptorImpl> namespaceDescriptors = Maps.newHashMap();
    private final Map<JetDeclaration, JetScope> declaringScopes = Maps.newHashMap();
    private final Map<JetNamedFunction, SimpleFunctionDescriptor> functions = Maps.newLinkedHashMap();
    private final Map<JetSecondaryConstructor, ConstructorDescriptor> constructors = Maps.newLinkedHashMap();
    private final Map<JetProperty, PropertyDescriptor> properties = Maps.newLinkedHashMap();
    private final Set<PropertyDescriptor> primaryConstructorParameterProperties = Sets.newHashSet();
    private final Predicate<PsiFile> analyzeCompletely;
    private StringBuilder debugOutput;
    private boolean analyzingBootstrapLibrary = false;
    private boolean declaredLocally;

    public TopDownAnalysisContext(JetSemanticServices semanticServices, BindingTrace trace, Predicate<PsiFile> analyzeCompletely, @NotNull Configuration configuration, boolean declaredLocally) {
        this.trace = new ObservableBindingTrace(trace);
        this.semanticServices = semanticServices;
        this.descriptorResolver = semanticServices.getClassDescriptorResolver(trace);
        this.importsResolver = new ImportsResolver(this);
        this.analyzeCompletely = analyzeCompletely;
        this.configuration = configuration;
        this.declaredLocally = declaredLocally;
    }

    public void debug(Object message) {
        if (this.debugOutput != null) {
            this.debugOutput.append(message).append("\n");
        }
    }

    void enableDebugOutput() {
        if (this.debugOutput == null) {
            this.debugOutput = new StringBuilder();
        }
    }

    void printDebugOutput(PrintStream out) {
        if (this.debugOutput != null) {
            out.print(this.debugOutput);
        }
    }

    public boolean analyzingBootstrapLibrary() {
        return this.analyzingBootstrapLibrary;
    }

    public void setAnalyzingBootstrapLibrary(boolean analyzingBootstrapLibrary) {
        this.analyzingBootstrapLibrary = analyzingBootstrapLibrary;
    }

    public boolean completeAnalysisNeeded(@NotNull PsiElement element) {
        boolean result;
        PsiFile containingFile = element.getContainingFile();
        boolean bl = result = containingFile != null && this.analyzeCompletely.apply((Object)containingFile);
        if (!result) {
            this.debug(containingFile);
        }
        return result;
    }

    public ObservableBindingTrace getTrace() {
        return this.trace;
    }

    public JetSemanticServices getSemanticServices() {
        return this.semanticServices;
    }

    public DescriptorResolver getDescriptorResolver() {
        return this.descriptorResolver;
    }

    public ImportsResolver getImportsResolver() {
        return this.importsResolver;
    }

    public Map<JetClass, MutableClassDescriptor> getClasses() {
        return this.classes;
    }

    public Map<JetObjectDeclaration, MutableClassDescriptor> getObjects() {
        return this.objects;
    }

    public Map<JetFile, WritableScope> getNamespaceScopes() {
        return this.namespaceScopes;
    }

    public Map<JetFile, NamespaceDescriptorImpl> getNamespaceDescriptors() {
        return this.namespaceDescriptors;
    }

    public Set<PropertyDescriptor> getPrimaryConstructorParameterProperties() {
        return this.primaryConstructorParameterProperties;
    }

    public Map<JetSecondaryConstructor, ConstructorDescriptor> getConstructors() {
        return this.constructors;
    }

    public Map<JetProperty, PropertyDescriptor> getProperties() {
        return this.properties;
    }

    public Map<JetDeclaration, JetScope> getDeclaringScopes() {
        return this.declaringScopes;
    }

    public Map<JetNamedFunction, SimpleFunctionDescriptor> getFunctions() {
        return this.functions;
    }

    @NotNull
    public Configuration getConfiguration() {
        return this.configuration;
    }

    public boolean isDeclaredLocally() {
        return this.declaredLocally;
    }
}

