/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.intellij.util.Function;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeConstructor;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;

public class OverridingUtil {
    private OverridingUtil() {
    }

    public static <D extends CallableDescriptor> Set<D> filterOverrides(Set<D> candidateSet) {
        return OverridingUtil.filterOverrides(candidateSet, Function.ID);
    }

    public static <D> Set<D> filterOverrides(Set<D> candidateSet, Function<? super D, ? extends CallableDescriptor> transform) {
        LinkedHashSet candidates = Sets.newLinkedHashSet();
        block0: for (D meD : candidateSet) {
            CallableDescriptor other;
            CallableDescriptor me = (CallableDescriptor)transform.fun(meD);
            for (Object otherD : candidateSet) {
                other = (CallableDescriptor)transform.fun(otherD);
                if (me == other || !OverridingUtil.overrides(other, me)) continue;
                continue block0;
            }
            for (Object otherD : candidates) {
                other = (CallableDescriptor)transform.fun(otherD);
                if (me.getOriginal() != other.getOriginal() || OverridingUtil.isOverridableBy(other, me).isOverridable() != OverrideCompatibilityInfo.ErrorKind.OVERRIDABLE || OverridingUtil.isOverridableBy(me, other).isOverridable() != OverrideCompatibilityInfo.ErrorKind.OVERRIDABLE) continue;
                continue block0;
            }
            candidates.add(meD);
        }
        return candidates;
    }

    public static <Descriptor extends CallableDescriptor> boolean overrides(@NotNull Descriptor f, @NotNull Descriptor g) {
        HashSet overriddenDescriptors = Sets.newHashSet();
        OverridingUtil.getAllOverriddenDescriptors(f.getOriginal(), overriddenDescriptors);
        CallableDescriptor originalG = g.getOriginal();
        for (CallableDescriptor overriddenFunction : overriddenDescriptors) {
            if (!originalG.equals(overriddenFunction.getOriginal())) continue;
            return true;
        }
        return false;
    }

    private static void getAllOverriddenDescriptors(@NotNull CallableDescriptor current, @NotNull Set<CallableDescriptor> overriddenDescriptors) {
        if (overriddenDescriptors.contains(current)) {
            return;
        }
        for (CallableDescriptor callableDescriptor : current.getOriginal().getOverriddenDescriptors()) {
            OverridingUtil.getAllOverriddenDescriptors(callableDescriptor, overriddenDescriptors);
            overriddenDescriptors.add(callableDescriptor);
        }
    }

    @NotNull
    public static OverrideCompatibilityInfo isOverridableBy(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor) {
        if (superDescriptor instanceof FunctionDescriptor && subDescriptor instanceof PropertyDescriptor) {
            return OverrideCompatibilityInfo.memberKindMismatch();
        }
        if (superDescriptor instanceof PropertyDescriptor && subDescriptor instanceof FunctionDescriptor) {
            return OverrideCompatibilityInfo.memberKindMismatch();
        }
        if (!superDescriptor.getName().equals(subDescriptor.getName())) {
            return OverrideCompatibilityInfo.nameMismatch();
        }
        return OverridingUtil.isOverridableByImpl(superDescriptor, subDescriptor, true);
    }

    private static List<JetType> compiledValueParameters(CallableDescriptor callableDescriptor) {
        ReceiverDescriptor receiverParameter = callableDescriptor.getReceiverParameter();
        ArrayList<JetType> parameters = new ArrayList<JetType>();
        if (receiverParameter.exists()) {
            parameters.add(receiverParameter.getType());
        }
        for (ValueParameterDescriptor valueParameterDescriptor : callableDescriptor.getValueParameters()) {
            parameters.add(valueParameterDescriptor.getType());
        }
        return parameters;
    }

    private static int compiledValueParameterCount(CallableDescriptor callableDescriptor) {
        if (callableDescriptor.getReceiverParameter().exists()) {
            return 1 + callableDescriptor.getValueParameters().size();
        }
        return callableDescriptor.getValueParameters().size();
    }

    static OverrideCompatibilityInfo isOverridableByImpl(@NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor, boolean forOverride) {
        if (OverridingUtil.compiledValueParameterCount(superDescriptor) != OverridingUtil.compiledValueParameterCount(subDescriptor)) {
            return OverrideCompatibilityInfo.valueParameterNumberMismatch();
        }
        List<JetType> superValueParameters = OverridingUtil.compiledValueParameters(superDescriptor);
        List<JetType> subValueParameters = OverridingUtil.compiledValueParameters(subDescriptor);
        if (forOverride && superDescriptor.getTypeParameters().size() != subDescriptor.getTypeParameters().size()) {
            for (int i = 0; i < superValueParameters.size(); ++i) {
                JetType subValueParameterType;
                JetType superValueParameterType = OverridingUtil.getUpperBound(superValueParameters.get(i));
                if (JetTypeChecker.INSTANCE.equalTypes(superValueParameterType, subValueParameterType = OverridingUtil.getUpperBound(subValueParameters.get(i)))) continue;
                return OverrideCompatibilityInfo.typeParameterNumberMismatch();
            }
            return OverrideCompatibilityInfo.valueParameterTypeMismatch(null, null, OverrideCompatibilityInfo.ErrorKind.CONFLICT);
        }
        if (forOverride) {
            TypeParameterDescriptor subTypeParameter;
            TypeParameterDescriptor superTypeParameter;
            int i;
            List<TypeParameterDescriptor> superTypeParameters = superDescriptor.getTypeParameters();
            List<TypeParameterDescriptor> subTypeParameters = subDescriptor.getTypeParameters();
            HashBiMap axioms = HashBiMap.create();
            int typeParametersSize = superTypeParameters.size();
            for (i = 0; i < typeParametersSize; ++i) {
                superTypeParameter = superTypeParameters.get(i);
                subTypeParameter = subTypeParameters.get(i);
                axioms.put((Object)superTypeParameter.getTypeConstructor(), (Object)subTypeParameter.getTypeConstructor());
            }
            typeParametersSize = superTypeParameters.size();
            for (i = 0; i < typeParametersSize; ++i) {
                superTypeParameter = superTypeParameters.get(i);
                subTypeParameter = subTypeParameters.get(i);
                if (JetTypeChecker.INSTANCE.equalTypes(superTypeParameter.getUpperBoundsAsType(), subTypeParameter.getUpperBoundsAsType(), (BiMap<TypeConstructor, TypeConstructor>)axioms)) continue;
                return OverrideCompatibilityInfo.boundsMismatch(superTypeParameter, subTypeParameter);
            }
            int unsubstitutedValueParametersSize = superValueParameters.size();
            for (i = 0; i < unsubstitutedValueParametersSize; ++i) {
                JetType subValueParameter;
                JetType superValueParameter = superValueParameters.get(i);
                if (JetTypeChecker.INSTANCE.equalTypes(superValueParameter, subValueParameter = subValueParameters.get(i), (BiMap<TypeConstructor, TypeConstructor>)axioms)) continue;
                return OverrideCompatibilityInfo.valueParameterTypeMismatch(superValueParameter, subValueParameter, OverrideCompatibilityInfo.ErrorKind.INCOMPATIBLE);
            }
        } else {
            for (int i = 0; i < superValueParameters.size(); ++i) {
                JetType subValueParameterType;
                JetType superValueParameterType = OverridingUtil.getUpperBound(superValueParameters.get(i));
                if (JetTypeChecker.INSTANCE.equalTypes(superValueParameterType, subValueParameterType = OverridingUtil.getUpperBound(subValueParameters.get(i)))) continue;
                return OverrideCompatibilityInfo.valueParameterTypeMismatch(superValueParameterType, subValueParameterType, OverrideCompatibilityInfo.ErrorKind.INCOMPATIBLE);
            }
            return OverrideCompatibilityInfo.success();
        }
        return OverrideCompatibilityInfo.success();
    }

    private static JetType getUpperBound(JetType type) {
        if (type.getConstructor().getDeclarationDescriptor() instanceof ClassDescriptor) {
            return type;
        }
        if (type.getConstructor().getDeclarationDescriptor() instanceof TypeParameterDescriptor) {
            return ((TypeParameterDescriptor)type.getConstructor().getDeclarationDescriptor()).getUpperBoundsAsType();
        }
        throw new IllegalStateException("unknown type constructor: " + type.getConstructor().getClass().getName());
    }

    public static boolean isReturnTypeOkForOverride(@NotNull JetTypeChecker typeChecker, @NotNull CallableDescriptor superDescriptor, @NotNull CallableDescriptor subDescriptor) {
        List<TypeParameterDescriptor> superTypeParameters = superDescriptor.getTypeParameters();
        List<TypeParameterDescriptor> subTypeParameters = subDescriptor.getTypeParameters();
        HashMap substitutionContext = Maps.newHashMap();
        int typeParametersSize = superTypeParameters.size();
        for (int i = 0; i < typeParametersSize; ++i) {
            TypeParameterDescriptor superTypeParameter = superTypeParameters.get(i);
            TypeParameterDescriptor subTypeParameter = subTypeParameters.get(i);
            substitutionContext.put(superTypeParameter.getTypeConstructor(), new TypeProjection(subTypeParameter.getDefaultType()));
        }
        TypeSubstitutor typeSubstitutor = TypeSubstitutor.create(substitutionContext);
        JetType substitutedSuperReturnType = typeSubstitutor.substitute(superDescriptor.getReturnType(), Variance.OUT_VARIANCE);
        assert (substitutedSuperReturnType != null);
        return typeChecker.isSubtypeOf(subDescriptor.getReturnType(), substitutedSuperReturnType);
    }

    public static Collection<CallableMemberDescriptor> getOverridenDeclarations(CallableMemberDescriptor descriptor) {
        HashMap result = Maps.newHashMap();
        OverridingUtil.getOverridenDeclarations(descriptor, result);
        return result.values();
    }

    private static void getOverridenDeclarations(CallableMemberDescriptor descriptor, Map<ClassDescriptor, CallableMemberDescriptor> r) {
        if (descriptor.getKind().isReal()) {
            r.put((ClassDescriptor)descriptor.getContainingDeclaration(), descriptor);
        } else {
            if (descriptor.getOverriddenDescriptors().isEmpty()) {
                throw new IllegalStateException();
            }
            for (CallableMemberDescriptor callableMemberDescriptor : descriptor.getOverriddenDescriptors()) {
                OverridingUtil.getOverridenDeclarations(callableMemberDescriptor, r);
            }
        }
    }

    public static class OverrideCompatibilityInfo {
        private static final OverrideCompatibilityInfo SUCCESS = new OverrideCompatibilityInfo(ErrorKind.OVERRIDABLE, "SUCCESS");
        private final ErrorKind overridable;
        private final String message;

        @NotNull
        public static OverrideCompatibilityInfo success() {
            return SUCCESS;
        }

        @NotNull
        public static OverrideCompatibilityInfo nameMismatch() {
            return new OverrideCompatibilityInfo(ErrorKind.INCOMPATIBLE, "nameMismatch");
        }

        @NotNull
        public static OverrideCompatibilityInfo typeParameterNumberMismatch() {
            return new OverrideCompatibilityInfo(ErrorKind.INCOMPATIBLE, "typeParameterNumberMismatch");
        }

        @NotNull
        public static OverrideCompatibilityInfo valueParameterNumberMismatch() {
            return new OverrideCompatibilityInfo(ErrorKind.INCOMPATIBLE, "valueParameterNumberMismatch");
        }

        @NotNull
        public static OverrideCompatibilityInfo boundsMismatch(TypeParameterDescriptor superTypeParameter, TypeParameterDescriptor subTypeParameter) {
            return new OverrideCompatibilityInfo(ErrorKind.INCOMPATIBLE, "boundsMismatch");
        }

        @NotNull
        public static OverrideCompatibilityInfo valueParameterTypeMismatch(JetType superValueParameter, JetType subValueParameter, ErrorKind errorKind) {
            return new OverrideCompatibilityInfo(errorKind, "valueParameterTypeMismatch");
        }

        @NotNull
        public static OverrideCompatibilityInfo memberKindMismatch() {
            return new OverrideCompatibilityInfo(ErrorKind.INCOMPATIBLE, "memberKindMismatch");
        }

        @NotNull
        public static OverrideCompatibilityInfo returnTypeMismatch(JetType substitutedSuperReturnType, JetType unsubstitutedSubReturnType) {
            return new OverrideCompatibilityInfo(ErrorKind.CONFLICT, "returnTypeMismatch: " + unsubstitutedSubReturnType + " >< " + substitutedSuperReturnType);
        }

        @NotNull
        public static OverrideCompatibilityInfo varOverriddenByVal() {
            return new OverrideCompatibilityInfo(ErrorKind.INCOMPATIBLE, "varOverriddenByVal");
        }

        public OverrideCompatibilityInfo(ErrorKind success, String message) {
            this.overridable = success;
            this.message = message;
        }

        public ErrorKind isOverridable() {
            return this.overridable;
        }

        public String getMessage() {
            return this.message;
        }

        public static enum ErrorKind {
            OVERRIDABLE,
            INCOMPATIBLE,
            CONFLICT;

        }
    }
}

