/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.Sets;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.LinkedMultiMap;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.OverridingUtil;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.checker.JetTypeChecker;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.util.CommonSuppliers;

public class OverrideResolver {
    private final TopDownAnalysisContext context;

    public OverrideResolver(@NotNull TopDownAnalysisContext context) {
        this.context = context;
    }

    public void process() {
        this.generateOverrides();
        this.checkOverrides();
    }

    private void generateOverrides() {
        HashSet<MutableClassDescriptor> ourClasses = new HashSet<MutableClassDescriptor>();
        ourClasses.addAll(this.context.getClasses().values());
        ourClasses.addAll(this.context.getObjects().values());
        HashSet<ClassifierDescriptor> processed = new HashSet<ClassifierDescriptor>();
        for (MutableClassDescriptor clazz : ourClasses) {
            this.generateOverridesInAClass(clazz, processed, ourClasses);
        }
    }

    private void generateOverridesInAClass(final MutableClassDescriptor classDescriptor, Set<ClassifierDescriptor> processed, Set<MutableClassDescriptor> ourClasses) {
        if (!processed.add(classDescriptor)) {
            return;
        }
        if (!ourClasses.contains(classDescriptor)) {
            return;
        }
        for (JetType jetType : classDescriptor.getTypeConstructor().getSupertypes()) {
            ClassDescriptor superclass = (ClassDescriptor)jetType.getConstructor().getDeclarationDescriptor();
            if (!(superclass instanceof MutableClassDescriptor)) continue;
            this.generateOverridesInAClass((MutableClassDescriptor)superclass, processed, ourClasses);
        }
        List<CallableMemberDescriptor> functionsFromSupertypes = OverrideResolver.getDescriptorsFromSupertypes(classDescriptor);
        MultiMap<String, CallableMemberDescriptor> multiMap = OverrideResolver.groupDescriptorsByName(functionsFromSupertypes);
        MultiMap<String, CallableMemberDescriptor> functionsFromCurrentByName = OverrideResolver.groupDescriptorsByName(classDescriptor.getCallableMembers());
        LinkedHashSet functionNames = new LinkedHashSet();
        functionNames.addAll(multiMap.keySet());
        functionNames.addAll(functionsFromCurrentByName.keySet());
        for (String functionName : functionNames) {
            OverrideResolver.generateOverridesInFunctionGroup(functionName, multiMap.get((Object)functionName), functionsFromCurrentByName.get((Object)functionName), classDescriptor, new DescriptorSink(){

                @Override
                public void addToScope(@NotNull CallableMemberDescriptor fakeOverride) {
                    if (fakeOverride instanceof PropertyDescriptor) {
                        classDescriptor.getScopeForMemberLookupAsWritableScope().addPropertyDescriptor((PropertyDescriptor)fakeOverride);
                    } else if (fakeOverride instanceof SimpleFunctionDescriptor) {
                        classDescriptor.getScopeForMemberLookupAsWritableScope().addFunctionDescriptor((SimpleFunctionDescriptor)fakeOverride);
                    } else {
                        throw new IllegalStateException(fakeOverride.getClass().getName());
                    }
                }

                @Override
                public void conflict(@NotNull CallableMemberDescriptor fromSuper, @NotNull CallableMemberDescriptor fromCurrent) {
                    JetDeclaration jetProperty = (JetDeclaration)OverrideResolver.this.context.getTrace().get(BindingContext.DESCRIPTOR_TO_DECLARATION, fromCurrent);
                    OverrideResolver.this.context.getTrace().report(Errors.CONFLICTING_OVERLOADS.on(jetProperty, fromCurrent, fromCurrent.getContainingDeclaration().getName()));
                }
            });
        }
    }

    public static void generateOverridesInFunctionGroup(@NotNull String name, @NotNull Collection<? extends CallableMemberDescriptor> functionsFromSupertypes, @NotNull Collection<? extends CallableMemberDescriptor> functionsFromCurrent, @NotNull ClassDescriptor current, @NotNull DescriptorSink sink) {
        ArrayList fakeOverrides = Lists.newArrayList();
        for (CallableMemberDescriptor callableMemberDescriptor : functionsFromSupertypes) {
            boolean overrides = false;
            for (CallableMemberDescriptor callableMemberDescriptor2 : functionsFromCurrent) {
                OverridingUtil.OverrideCompatibilityInfo.ErrorKind overridable = OverridingUtil.isOverridableBy(callableMemberDescriptor, callableMemberDescriptor2).isOverridable();
                if (overridable == OverridingUtil.OverrideCompatibilityInfo.ErrorKind.OVERRIDABLE) {
                    callableMemberDescriptor2.addOverriddenDescriptor(callableMemberDescriptor);
                    overrides = true;
                    continue;
                }
                if (overridable != OverridingUtil.OverrideCompatibilityInfo.ErrorKind.CONFLICT) continue;
                sink.conflict(callableMemberDescriptor, callableMemberDescriptor2);
            }
            for (CallableMemberDescriptor callableMemberDescriptor3 : fakeOverrides) {
                if (OverridingUtil.isOverridableBy(callableMemberDescriptor, callableMemberDescriptor3).isOverridable() != OverridingUtil.OverrideCompatibilityInfo.ErrorKind.OVERRIDABLE) continue;
                callableMemberDescriptor3.addOverriddenDescriptor(callableMemberDescriptor);
                overrides = true;
            }
            if (overrides) continue;
            CallableMemberDescriptor fakeOverride = callableMemberDescriptor.copy(current, false, CallableMemberDescriptor.Kind.FAKE_OVERRIDE, false);
            fakeOverride.addOverriddenDescriptor(callableMemberDescriptor);
            fakeOverrides.add(fakeOverride);
            sink.addToScope(fakeOverride);
        }
    }

    private static <T extends DeclarationDescriptor> MultiMap<String, T> groupDescriptorsByName(Collection<T> properties) {
        LinkedMultiMap r = new LinkedMultiMap();
        for (DeclarationDescriptor property : properties) {
            r.putValue((Object)property.getName(), (Object)property);
        }
        return r;
    }

    private static List<CallableMemberDescriptor> getDescriptorsFromSupertypes(ClassDescriptor classDescriptor) {
        LinkedHashSet r = Sets.newLinkedHashSet();
        for (JetType jetType : classDescriptor.getTypeConstructor().getSupertypes()) {
            r.addAll(OverrideResolver.getDescriptorsOfType(jetType.getMemberScope()));
        }
        return new ArrayList<CallableMemberDescriptor>(r);
    }

    private static <T extends DeclarationDescriptor> List<CallableMemberDescriptor> getDescriptorsOfType(JetScope scope) {
        ArrayList r = Lists.newArrayList();
        for (DeclarationDescriptor decl : scope.getAllDescriptors()) {
            if (!(decl instanceof PropertyDescriptor) && !(decl instanceof SimpleFunctionDescriptor)) continue;
            r.add((CallableMemberDescriptor)decl);
        }
        return r;
    }

    private void checkOverrides() {
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            this.checkOverridesInAClass(entry.getValue(), entry.getKey());
        }
        for (Map.Entry<JetNamedDeclaration, MutableClassDescriptor> entry : this.context.getObjects().entrySet()) {
            this.checkOverridesInAClass(entry.getValue(), (JetClassOrObject)((Object)entry.getKey()));
        }
    }

    protected void checkOverridesInAClass(MutableClassDescriptor classDescriptor, JetClassOrObject klass) {
        block8: {
            CallableMemberDescriptor memberDescriptor;
            if (this.context.analyzingBootstrapLibrary()) {
                return;
            }
            for (CallableMemberDescriptor member : classDescriptor.getCallableMembers()) {
                this.checkOverride(member);
            }
            LinkedHashSet abstractNoImpl = Sets.newLinkedHashSet();
            LinkedHashSet manyImpl = Sets.newLinkedHashSet();
            OverrideResolver.collectMissingImplementations(classDescriptor, (Set<CallableMemberDescriptor>)abstractNoImpl, (Set<CallableMemberDescriptor>)manyImpl);
            PsiElement nameIdentifier = null;
            if (klass instanceof JetClass) {
                nameIdentifier = ((JetClass)klass).getNameIdentifier();
            } else if (klass instanceof JetObjectDeclaration && (nameIdentifier = ((JetObjectDeclaration)klass).getNameIdentifier()) == null) {
                nameIdentifier = ((JetObjectDeclaration)klass).getObjectKeyword();
            }
            if (nameIdentifier == null) {
                return;
            }
            Iterator i$ = manyImpl.iterator();
            if (i$.hasNext()) {
                memberDescriptor = (CallableMemberDescriptor)i$.next();
                this.context.getTrace().report(Errors.MANY_IMPL_MEMBER_NOT_IMPLEMENTED.on(nameIdentifier, klass, memberDescriptor));
            }
            if (classDescriptor.getModality() == Modality.ABSTRACT) {
                return;
            }
            i$ = abstractNoImpl.iterator();
            if (!i$.hasNext()) break block8;
            memberDescriptor = (CallableMemberDescriptor)i$.next();
            this.context.getTrace().report(Errors.ABSTRACT_MEMBER_NOT_IMPLEMENTED.on(nameIdentifier, klass, memberDescriptor));
        }
    }

    public static void collectMissingImplementations(MutableClassDescriptor classDescriptor, Set<CallableMemberDescriptor> abstractNoImpl, Set<CallableMemberDescriptor> manyImpl) {
        for (DeclarationDescriptor descriptor : classDescriptor.getScopeForMemberLookup().getAllDescriptors()) {
            if (!(descriptor instanceof CallableMemberDescriptor)) continue;
            OverrideResolver.collectMissingImplementations((CallableMemberDescriptor)descriptor, abstractNoImpl, manyImpl);
        }
    }

    private static void collectMissingImplementations(CallableMemberDescriptor descriptor, Set<CallableMemberDescriptor> abstractNoImpl, Set<CallableMemberDescriptor> manyImpl) {
        if (descriptor.getKind().isReal()) {
            if (descriptor.getModality() == Modality.ABSTRACT) {
                // empty if block
            }
        } else {
            Collection<CallableMemberDescriptor> overridenDeclarations = OverridingUtil.getOverridenDeclarations(descriptor);
            if (overridenDeclarations.size() == 0) {
                throw new IllegalStateException();
            }
            if (overridenDeclarations.size() == 1) {
                CallableMemberDescriptor single = overridenDeclarations.iterator().next();
                if (single.getModality() == Modality.ABSTRACT) {
                    abstractNoImpl.add(single);
                }
            } else {
                ArrayList nonAbstractManyImpl = Lists.newArrayList();
                for (CallableMemberDescriptor overriden : overridenDeclarations) {
                    if (overriden.getModality() == Modality.ABSTRACT) continue;
                    nonAbstractManyImpl.add(overriden);
                }
                if (nonAbstractManyImpl.size() > 1) {
                    manyImpl.addAll(nonAbstractManyImpl);
                }
            }
        }
    }

    public static Multimap<CallableMemberDescriptor, CallableMemberDescriptor> collectSuperMethods(MutableClassDescriptor classDescriptor) {
        LinkedHashSet inheritedFunctions = Sets.newLinkedHashSet();
        for (JetType supertype : classDescriptor.getSupertypes()) {
            for (DeclarationDescriptor descriptor : supertype.getMemberScope().getAllDescriptors()) {
                if (!(descriptor instanceof CallableMemberDescriptor)) continue;
                CallableMemberDescriptor memberDescriptor = (CallableMemberDescriptor)descriptor;
                inheritedFunctions.add(memberDescriptor);
            }
        }
        Set<CallableMemberDescriptor> filteredMembers = OverridingUtil.filterOverrides(inheritedFunctions);
        SetMultimap factoredMembers = CommonSuppliers.newLinkedHashSetHashSetMultimap();
        for (CallableMemberDescriptor one : filteredMembers) {
            if (factoredMembers.values().contains(one)) continue;
            for (CallableMemberDescriptor another : filteredMembers) {
                factoredMembers.put((Object)one, (Object)one);
                if (OverridingUtil.isOverridableBy(one, another).isOverridable() != OverridingUtil.OverrideCompatibilityInfo.ErrorKind.OVERRIDABLE && OverridingUtil.isOverridableBy(another, one).isOverridable() != OverridingUtil.OverrideCompatibilityInfo.ErrorKind.OVERRIDABLE) continue;
                factoredMembers.put((Object)one, (Object)another);
            }
        }
        return factoredMembers;
    }

    private void checkOverride(CallableMemberDescriptor declared) {
        JetNamedDeclaration member = (JetNamedDeclaration)this.context.getTrace().get(BindingContext.DESCRIPTOR_TO_DECLARATION, declared);
        if (member == null) {
            assert (this.context.getTrace().get(BindingContext.DELEGATED, declared).booleanValue());
            return;
        }
        if (declared.getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
            return;
        }
        JetModifierList modifierList = member.getModifierList();
        ASTNode overrideNode = modifierList != null ? modifierList.getModifierNode(JetTokens.OVERRIDE_KEYWORD) : null;
        boolean hasOverrideModifier = overrideNode != null;
        boolean finalOverriddenError = false;
        boolean typeMismatchError = false;
        boolean kindMismatchError = false;
        for (CallableMemberDescriptor callableMemberDescriptor : declared.getOverriddenDescriptors()) {
            if (callableMemberDescriptor == null || !hasOverrideModifier) continue;
            if (!callableMemberDescriptor.getModality().isOverridable() && !finalOverriddenError) {
                this.context.getTrace().report(Errors.OVERRIDING_FINAL_MEMBER.on(overrideNode.getPsi(), callableMemberDescriptor, callableMemberDescriptor.getContainingDeclaration()));
                finalOverriddenError = true;
            }
            if (!OverridingUtil.isReturnTypeOkForOverride(JetTypeChecker.INSTANCE, callableMemberDescriptor, declared) && !typeMismatchError) {
                this.context.getTrace().report(Errors.RETURN_TYPE_MISMATCH_ON_OVERRIDE.on(member, declared, callableMemberDescriptor));
                typeMismatchError = true;
            }
            if (!this.checkPropertyKind(callableMemberDescriptor, true) || !this.checkPropertyKind(declared, false) || kindMismatchError) continue;
            this.context.getTrace().report(Errors.VAR_OVERRIDDEN_BY_VAL.on((JetProperty)member, (PropertyDescriptor)declared, (PropertyDescriptor)callableMemberDescriptor));
            kindMismatchError = true;
        }
        if (hasOverrideModifier && declared.getOverriddenDescriptors().size() == 0) {
            this.context.getTrace().report(Errors.NOTHING_TO_OVERRIDE.on(member, declared));
        }
        PsiElement nameIdentifier = member.getNameIdentifier();
        if (!hasOverrideModifier && declared.getOverriddenDescriptors().size() > 0 && nameIdentifier != null) {
            CallableMemberDescriptor callableMemberDescriptor = declared.getOverriddenDescriptors().iterator().next();
            this.context.getTrace().report(Errors.VIRTUAL_MEMBER_HIDDEN.on(member, declared, callableMemberDescriptor, callableMemberDescriptor.getContainingDeclaration()));
        }
    }

    private boolean checkPropertyKind(CallableMemberDescriptor descriptor, boolean isVar) {
        if (descriptor instanceof PropertyDescriptor) {
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)descriptor;
            return propertyDescriptor.isVar() == isVar;
        }
        return false;
    }

    public static interface DescriptorSink {
        public void addToScope(@NotNull CallableMemberDescriptor var1);

        public void conflict(@NotNull CallableMemberDescriptor var1, @NotNull CallableMemberDescriptor var2);
    }
}

