/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.OverloadUtil;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;

public class OverloadResolver {
    private final TopDownAnalysisContext context;

    public OverloadResolver(@NotNull TopDownAnalysisContext context) {
        this.context = context;
    }

    public void process() {
        this.checkOverloads();
    }

    private void checkOverloads() {
        Pair<MultiMap<ClassDescriptor, ConstructorDescriptor>, MultiMap<Key, ConstructorDescriptor>> pair = this.constructorsGrouped();
        MultiMap inClasses = (MultiMap)pair.first;
        MultiMap inNamespaces = (MultiMap)pair.second;
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            this.checkOverloadsInAClass(entry.getValue(), entry.getKey(), inClasses.get((Object)entry.getValue()));
        }
        for (Map.Entry<JetNamedDeclaration, MutableClassDescriptor> entry : this.context.getObjects().entrySet()) {
            this.checkOverloadsInAClass(entry.getValue(), (JetClassOrObject)((Object)entry.getKey()), inClasses.get((Object)entry.getValue()));
        }
        this.checkOverloadsInANamespace((MultiMap<Key, ConstructorDescriptor>)inNamespaces);
    }

    private Pair<MultiMap<ClassDescriptor, ConstructorDescriptor>, MultiMap<Key, ConstructorDescriptor>> constructorsGrouped() {
        MultiMap inClasses = MultiMap.create();
        MultiMap inNamespaces = MultiMap.create();
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            MutableClassDescriptor klass = entry.getValue();
            DeclarationDescriptor containingDeclaration = klass.getContainingDeclaration();
            if (containingDeclaration instanceof NamespaceDescriptor) {
                NamespaceDescriptor namespaceDescriptor = (NamespaceDescriptor)containingDeclaration;
                inNamespaces.put((Object)new Key(namespaceDescriptor, klass.getName()), klass.getConstructors());
                continue;
            }
            if (containingDeclaration instanceof ClassDescriptor) {
                ClassDescriptor classDescriptor = (ClassDescriptor)containingDeclaration;
                inClasses.put((Object)classDescriptor, klass.getConstructors());
                continue;
            }
            throw new IllegalStateException();
        }
        return Pair.create((Object)inClasses, (Object)inNamespaces);
    }

    private void checkOverloadsInANamespace(MultiMap<Key, ConstructorDescriptor> inNamespaces) {
        NamespaceDescriptor namespaceDescriptor;
        DeclarationDescriptor containingDeclaration;
        MultiMap functionsByName = MultiMap.create();
        for (SimpleFunctionDescriptor function : this.context.getFunctions().values()) {
            containingDeclaration = function.getContainingDeclaration();
            if (!(containingDeclaration instanceof NamespaceDescriptor)) continue;
            namespaceDescriptor = (NamespaceDescriptor)containingDeclaration;
            functionsByName.putValue((Object)new Key(namespaceDescriptor, function.getName()), (Object)function);
        }
        for (PropertyDescriptor property : this.context.getProperties().values()) {
            containingDeclaration = property.getContainingDeclaration();
            if (!(containingDeclaration instanceof NamespaceDescriptor)) continue;
            namespaceDescriptor = (NamespaceDescriptor)containingDeclaration;
            functionsByName.putValue((Object)new Key(namespaceDescriptor, property.getName()), (Object)property);
        }
        for (Map.Entry entry : inNamespaces.entrySet()) {
            functionsByName.putValues(entry.getKey(), (Collection)entry.getValue());
        }
        for (Map.Entry e : functionsByName.entrySet()) {
            this.checkOverloadsWithSameName(((Key)((Object)e.getKey())).getFunctionName(), (Collection)e.getValue(), ((Key)((Object)e.getKey())).getNamespace());
        }
    }

    private String nameForErrorMessage(ClassDescriptor classDescriptor, JetClassOrObject jetClass) {
        String name = jetClass.getName();
        if (name != null) {
            return name;
        }
        if (jetClass instanceof JetObjectDeclaration) {
            name = classDescriptor.getContainingDeclaration().getName();
            return "class object " + name;
        }
        return "<unknown>";
    }

    private void checkOverloadsInAClass(MutableClassDescriptor classDescriptor, JetClassOrObject klass, Collection<ConstructorDescriptor> nestedClassConstructors) {
        MultiMap functionsByName = MultiMap.create();
        for (CallableMemberDescriptor function : classDescriptor.getCallableMembers()) {
            functionsByName.putValue((Object)function.getName(), (Object)function);
        }
        for (ConstructorDescriptor nestedClassConstructor : nestedClassConstructors) {
            functionsByName.putValue((Object)nestedClassConstructor.getContainingDeclaration().getName(), (Object)nestedClassConstructor);
        }
        for (Map.Entry e : functionsByName.entrySet()) {
            this.checkOverloadsWithSameName((String)e.getKey(), (Collection)e.getValue(), this.nameForErrorMessage(classDescriptor, klass));
        }
    }

    private void checkOverloadsWithSameName(String name, Collection<CallableMemberDescriptor> functions, @NotNull String functionContainer) {
        if (functions.size() == 1) {
            return;
        }
        for (CallableMemberDescriptor function : functions) {
            for (CallableMemberDescriptor function2 : functions) {
                OverloadUtil.OverloadCompatibilityInfo overloadable;
                if (function == function2 || (overloadable = OverloadUtil.isOverloadable(function, function2)).isSuccess()) continue;
                JetDeclaration member = (JetDeclaration)this.context.getTrace().get(BindingContext.DESCRIPTOR_TO_DECLARATION, function);
                if (member == null) {
                    assert (this.context.getTrace().get(BindingContext.DELEGATED, function).booleanValue());
                    return;
                }
                if (function instanceof PropertyDescriptor) {
                    this.context.getTrace().report(Errors.REDECLARATION.on(function, this.context.getTrace().getBindingContext()));
                    continue;
                }
                this.context.getTrace().report(Errors.CONFLICTING_OVERLOADS.on(member, function, functionContainer));
            }
        }
    }

    private static class Key
    extends Pair<String, String> {
        Key(String namespace, String name) {
            super((Object)namespace, (Object)name);
        }

        Key(NamespaceDescriptor namespaceDescriptor, String name) {
            this(DescriptorUtils.getFQName(namespaceDescriptor), name);
        }

        public String getNamespace() {
            return (String)this.first;
        }

        public String getFunctionName() {
            return (String)this.second;
        }
    }
}

