/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetDotQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.Importer;
import org.jetbrains.jet.lang.resolve.TemporaryBindingTrace;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.types.JetType;

public class ImportsResolver {
    private final TopDownAnalysisContext context;

    public ImportsResolver(@NotNull TopDownAnalysisContext context) {
        this.context = context;
    }

    public void processTypeImports() {
        this.processImports(true);
    }

    public void processMembersImports() {
        this.processImports(false);
    }

    private void processImports(boolean firstPhase) {
        ImportResolver importResolver = new ImportResolver(this.context.getTrace(), firstPhase);
        for (JetFile file : this.context.getNamespaceDescriptors().keySet()) {
            WritableScope namespaceScope = this.context.getNamespaceScopes().get((Object)file);
            Importer.DelayedImporter delayedImporter = new Importer.DelayedImporter(namespaceScope, firstPhase);
            if (!firstPhase) {
                namespaceScope.clearImports();
            }
            this.context.getConfiguration().addDefaultImports(this.context.getTrace(), namespaceScope, delayedImporter);
            HashMap resolvedDirectives = Maps.newHashMap();
            List<JetImportDirective> importDirectives = file.getImportDirectives();
            for (JetImportDirective importDirective : importDirectives) {
                Collection<? extends DeclarationDescriptor> descriptors = importResolver.processImportReference(importDirective, namespaceScope, delayedImporter);
                if (descriptors == null || descriptors.size() != 1) continue;
                resolvedDirectives.put(importDirective, descriptors.iterator().next());
            }
            delayedImporter.processImports();
            if (firstPhase) continue;
            for (JetImportDirective importDirective : importDirectives) {
                this.reportUselessImport(importDirective, namespaceScope, resolvedDirectives);
            }
        }
    }

    @Nullable
    private static JetSimpleNameExpression getLastReference(@NotNull JetExpression importedReference) {
        if (importedReference instanceof JetDotQualifiedExpression) {
            JetDotQualifiedExpression reference = (JetDotQualifiedExpression)importedReference;
            JetExpression selectorExpression = reference.getSelectorExpression();
            return selectorExpression != null ? (JetSimpleNameExpression)selectorExpression : null;
        }
        assert (importedReference instanceof JetSimpleNameExpression);
        return (JetSimpleNameExpression)importedReference;
    }

    @Nullable
    private static String getAliasName(@NotNull JetImportDirective importDirective) {
        String aliasName = importDirective.getAliasName();
        JetExpression importedReference = importDirective.getImportedReference();
        if (importedReference == null) {
            return null;
        }
        JetSimpleNameExpression referenceExpression = ImportsResolver.getLastReference(importedReference);
        if (aliasName == null) {
            aliasName = referenceExpression != null ? referenceExpression.getReferencedName() : null;
        }
        return aliasName;
    }

    private void reportUselessImport(@NotNull JetImportDirective importDirective, @NotNull WritableScope namespaceScope, @NotNull Map<JetImportDirective, DeclarationDescriptor> resolvedDirectives) {
        JetExpression importedReference = importDirective.getImportedReference();
        if (importedReference == null || !resolvedDirectives.containsKey((Object)importDirective)) {
            return;
        }
        String aliasName = ImportsResolver.getAliasName(importDirective);
        if (aliasName == null) {
            return;
        }
        DeclarationDescriptor wasResolved = resolvedDirectives.get((Object)importDirective);
        DeclarationDescriptor isResolved = null;
        if (wasResolved instanceof ClassDescriptor) {
            isResolved = namespaceScope.getClassifier(aliasName);
        } else if (wasResolved instanceof VariableDescriptor) {
            isResolved = namespaceScope.getLocalVariable(aliasName);
        } else if (wasResolved instanceof NamespaceDescriptor) {
            isResolved = namespaceScope.getNamespace(aliasName);
        }
        if (isResolved != null && isResolved != wasResolved) {
            this.context.getTrace().report(Errors.USELESS_HIDDEN_IMPORT.on(importedReference));
        }
        if (!importDirective.isAllUnder() && importedReference instanceof JetSimpleNameExpression && importDirective.getAliasName() == null) {
            this.context.getTrace().report(Errors.USELESS_SIMPLE_IMPORT.on(importedReference));
        }
    }

    public static class ImportResolver {
        private final BindingTrace trace;
        private final boolean firstPhase;

        public ImportResolver(BindingTrace trace, boolean firstPhase) {
            this.trace = trace;
            this.firstPhase = firstPhase;
        }

        @Nullable
        public Collection<? extends DeclarationDescriptor> processImportReference(@NotNull JetImportDirective importDirective, @NotNull JetScope scope, @NotNull Importer importer) {
            Collection<? extends DeclarationDescriptor> descriptors;
            if (importDirective.isAbsoluteInRootNamespace()) {
                this.trace.report(Errors.UNSUPPORTED.on((PsiElement)importDirective, "TypeHierarchyResolver"));
                return null;
            }
            JetExpression importedReference = importDirective.getImportedReference();
            if (importedReference == null) {
                return null;
            }
            if (importedReference instanceof JetQualifiedExpression) {
                descriptors = this.lookupDescriptorsForQualifiedExpression((JetQualifiedExpression)importedReference, scope);
            } else {
                assert (importedReference instanceof JetSimpleNameExpression);
                descriptors = this.lookupDescriptorsForSimpleNameReference((JetSimpleNameExpression)importedReference, scope, true);
            }
            JetSimpleNameExpression referenceExpression = ImportsResolver.getLastReference(importedReference);
            if (importDirective.isAllUnder()) {
                if (referenceExpression == null || !this.canImportMembersFrom(descriptors, referenceExpression)) {
                    return null;
                }
                for (DeclarationDescriptor declarationDescriptor : descriptors) {
                    importer.addAllUnderImport(declarationDescriptor);
                }
                return null;
            }
            String aliasName = ImportsResolver.getAliasName(importDirective);
            if (aliasName == null) {
                return null;
            }
            for (DeclarationDescriptor declarationDescriptor : descriptors) {
                importer.addAliasImport(declarationDescriptor, aliasName);
            }
            return descriptors;
        }

        @NotNull
        private Collection<? extends DeclarationDescriptor> lookupDescriptorsForQualifiedExpression(@NotNull JetQualifiedExpression importedReference, @NotNull JetScope outerScope) {
            Collection<? extends DeclarationDescriptor> declarationDescriptors;
            JetExpression receiverExpression = importedReference.getReceiverExpression();
            if (receiverExpression instanceof JetQualifiedExpression) {
                declarationDescriptors = this.lookupDescriptorsForQualifiedExpression((JetQualifiedExpression)receiverExpression, outerScope);
            } else {
                assert (receiverExpression instanceof JetSimpleNameExpression);
                declarationDescriptors = this.lookupDescriptorsForSimpleNameReference((JetSimpleNameExpression)receiverExpression, outerScope, true);
            }
            JetExpression selectorExpression = importedReference.getSelectorExpression();
            if (selectorExpression instanceof JetSimpleNameExpression) {
                JetSimpleNameExpression selector = (JetSimpleNameExpression)selectorExpression;
                JetSimpleNameExpression lastReference = ImportsResolver.getLastReference(receiverExpression);
                if (lastReference == null || !this.canImportMembersFrom(declarationDescriptors, lastReference)) {
                    return Collections.emptyList();
                }
                for (DeclarationDescriptor declarationDescriptor : declarationDescriptors) {
                    Collection<? extends DeclarationDescriptor> result;
                    if (declarationDescriptor instanceof NamespaceDescriptor && !(result = this.lookupDescriptorsForSimpleNameReference(selector, ((NamespaceDescriptor)declarationDescriptor).getMemberScope(), true)).isEmpty()) {
                        return result;
                    }
                    if (declarationDescriptor instanceof ClassDescriptor && !(result = this.lookupObjectMembers((ClassDescriptor)declarationDescriptor, selector)).isEmpty()) {
                        return result;
                    }
                    if (!(declarationDescriptor instanceof VariableDescriptor) || (result = this.lookupVariableMembers((VariableDescriptor)declarationDescriptor, selector)).isEmpty()) continue;
                    return result;
                }
            }
            return Collections.emptyList();
        }

        private boolean canImportMembersFrom(@NotNull Collection<? extends DeclarationDescriptor> descriptors, @NotNull JetSimpleNameExpression reference) {
            if (this.firstPhase) {
                return true;
            }
            if (descriptors.size() == 1) {
                return this.canImportMembersFrom(descriptors.iterator().next(), reference, this.trace);
            }
            TemporaryBindingTrace temporaryTrace = TemporaryBindingTrace.create(this.trace);
            boolean canImport = false;
            for (DeclarationDescriptor declarationDescriptor : descriptors) {
                canImport |= this.canImportMembersFrom(declarationDescriptor, reference, temporaryTrace);
            }
            if (!canImport) {
                temporaryTrace.commit();
            }
            return canImport;
        }

        private boolean canImportMembersFrom(@NotNull DeclarationDescriptor descriptor, @NotNull JetSimpleNameExpression reference, @NotNull BindingTrace trace) {
            assert (!this.firstPhase);
            if (descriptor instanceof NamespaceDescriptor) {
                return true;
            }
            if (descriptor instanceof ClassDescriptor) {
                ClassDescriptor classDescriptor = (ClassDescriptor)descriptor;
                JetType classObjectType = classDescriptor.getClassObjectType();
                if (classObjectType == null) {
                    trace.report(Errors.NO_CLASS_OBJECT.on(reference, classDescriptor));
                    return false;
                }
                return true;
            }
            if (descriptor instanceof VariableDescriptor && ((VariableDescriptor)descriptor).isObjectDeclaration()) {
                return true;
            }
            trace.report(Errors.CANNOT_IMPORT_FROM_ELEMENT.on(reference, descriptor));
            return false;
        }

        @NotNull
        private Collection<? extends DeclarationDescriptor> lookupObjectMembers(@NotNull ClassDescriptor classDescriptor, @NotNull JetSimpleNameExpression memberReference) {
            if (this.firstPhase) {
                ClassDescriptor objectDescriptor = DescriptorUtils.getObjectIfObjectOrClassObjectDescriptor(classDescriptor);
                if (objectDescriptor == null) {
                    return Collections.emptyList();
                }
                return this.getInnerClassesAndObjectsByName(objectDescriptor, memberReference);
            }
            JetType classObjectType = classDescriptor.getClassObjectType();
            if (classObjectType == null) {
                return Collections.emptyList();
            }
            return this.lookupDescriptorsForSimpleNameReference(memberReference, classObjectType.getMemberScope(), false);
        }

        @NotNull
        private Collection<? extends DeclarationDescriptor> getInnerClassesAndObjectsByName(@NotNull ClassDescriptor classDescriptor, @NotNull JetSimpleNameExpression memberReference) {
            assert (classDescriptor.getKind() == ClassKind.OBJECT);
            ClassDescriptor innerClass = classDescriptor.getInnerClassOrObject(memberReference.getReferencedName());
            if (innerClass == null) {
                return Collections.emptyList();
            }
            List<ClassDescriptor> descriptors = Collections.singletonList(innerClass);
            return this.filterResolutionResult(descriptors, memberReference, JetScope.EMPTY, false);
        }

        private Collection<? extends DeclarationDescriptor> lookupVariableMembers(@NotNull VariableDescriptor variableDescriptor, @NotNull JetSimpleNameExpression memberReference) {
            if (this.firstPhase) {
                return Collections.emptyList();
            }
            JetType variableType = variableDescriptor.getReturnType();
            if (variableType == null) {
                return Collections.emptyList();
            }
            return this.lookupDescriptorsForSimpleNameReference(memberReference, variableType.getMemberScope(), false);
        }

        @NotNull
        private Collection<? extends DeclarationDescriptor> lookupDescriptorsForSimpleNameReference(@NotNull JetSimpleNameExpression referenceExpression, @NotNull JetScope outerScope, boolean namespaceLevel) {
            ClassifierDescriptor classifierDescriptor;
            String referencedName = referenceExpression.getReferencedName();
            if (referencedName == null) {
                return Collections.emptyList();
            }
            ArrayList descriptors = Lists.newArrayList();
            NamespaceDescriptor namespaceDescriptor = outerScope.getNamespace(referencedName);
            if (namespaceDescriptor != null) {
                descriptors.add(namespaceDescriptor);
            }
            if ((classifierDescriptor = outerScope.getClassifier(referencedName)) != null) {
                descriptors.add(classifierDescriptor);
            }
            if (this.firstPhase) {
                descriptors.add(outerScope.getObjectDescriptor(referencedName));
            } else {
                descriptors.addAll(outerScope.getFunctions(referencedName));
                descriptors.addAll(outerScope.getProperties(referencedName));
                VariableDescriptor localVariable = outerScope.getLocalVariable(referencedName);
                if (localVariable != null) {
                    descriptors.add(localVariable);
                }
            }
            return this.filterResolutionResult(descriptors, referenceExpression, outerScope, namespaceLevel);
        }

        private Collection<? extends DeclarationDescriptor> filterResolutionResult(@NotNull Collection<? extends DeclarationDescriptor> descriptors, @NotNull JetSimpleNameExpression referenceExpression, @NotNull JetScope resolutionScope, boolean namespaceLevel) {
            if (this.firstPhase) {
                return Collections2.filter(descriptors, (Predicate)new Predicate<DeclarationDescriptor>(){

                    public boolean apply(@Nullable DeclarationDescriptor descriptor) {
                        return descriptor instanceof ClassDescriptor || descriptor instanceof NamespaceDescriptor;
                    }
                });
            }
            Collection filteredDescriptors = namespaceLevel ? descriptors : Collections2.filter(descriptors, (Predicate)new Predicate<DeclarationDescriptor>(){

                public boolean apply(@Nullable DeclarationDescriptor descriptor) {
                    return descriptor instanceof NamespaceDescriptor || descriptor instanceof ClassDescriptor || descriptor instanceof VariableDescriptor && ((VariableDescriptor)descriptor).isObjectDeclaration();
                }
            });
            this.storeResolutionResult(descriptors, filteredDescriptors, referenceExpression, resolutionScope);
            return filteredDescriptors;
        }

        private void storeResolutionResult(@NotNull Collection<? extends DeclarationDescriptor> descriptors, @NotNull Collection<? extends DeclarationDescriptor> canBeImportedDescriptors, @NotNull JetSimpleNameExpression referenceExpression, @NotNull JetScope resolutionScope) {
            assert (canBeImportedDescriptors.size() <= descriptors.size());
            if (this.resolveClassNamespaceAmbiguity(canBeImportedDescriptors, referenceExpression, resolutionScope)) {
                return;
            }
            if (descriptors.isEmpty()) {
                this.trace.record(BindingContext.RESOLUTION_SCOPE, referenceExpression, resolutionScope);
                this.trace.report(Errors.UNRESOLVED_REFERENCE.on(referenceExpression));
                return;
            }
            if (descriptors.size() == 1) {
                assert (canBeImportedDescriptors.size() <= 1);
                this.trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, descriptors.iterator().next());
                this.trace.record(BindingContext.RESOLUTION_SCOPE, referenceExpression, resolutionScope);
            } else if (canBeImportedDescriptors.size() == 1) {
                this.trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, canBeImportedDescriptors.iterator().next());
                this.trace.record(BindingContext.RESOLUTION_SCOPE, referenceExpression, resolutionScope);
            }
            if (canBeImportedDescriptors.isEmpty()) {
                assert (descriptors.size() >= 1);
                this.trace.report(Errors.CANNOT_BE_IMPORTED.on(referenceExpression, descriptors.iterator().next()));
            } else if (canBeImportedDescriptors.size() > 1) {
                this.trace.record(BindingContext.AMBIGUOUS_REFERENCE_TARGET, referenceExpression, descriptors);
            }
        }

        private boolean resolveClassNamespaceAmbiguity(Collection<? extends DeclarationDescriptor> filteredDescriptors, JetSimpleNameExpression referenceExpression, JetScope resolutionScope) {
            if (filteredDescriptors.size() == 2) {
                NamespaceDescriptor namespaceDescriptor = null;
                ClassDescriptor classDescriptor = null;
                for (DeclarationDescriptor declarationDescriptor : filteredDescriptors) {
                    if (declarationDescriptor instanceof NamespaceDescriptor) {
                        namespaceDescriptor = (NamespaceDescriptor)declarationDescriptor;
                        continue;
                    }
                    if (!(declarationDescriptor instanceof ClassDescriptor)) continue;
                    classDescriptor = (ClassDescriptor)declarationDescriptor;
                }
                if (namespaceDescriptor != null && classDescriptor != null && DescriptorUtils.getFQName(namespaceDescriptor).equals(DescriptorUtils.getFQName(classDescriptor))) {
                    this.trace.record(BindingContext.REFERENCE_TARGET, referenceExpression, classDescriptor);
                    this.trace.record(BindingContext.RESOLUTION_SCOPE, referenceExpression, resolutionScope);
                    return true;
                }
            }
            return false;
        }
    }
}

