/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Lists;
import com.intellij.openapi.util.Pair;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.types.JetType;

public interface Importer {
    public void addAllUnderImport(@NotNull DeclarationDescriptor var1);

    public void addAliasImport(@NotNull DeclarationDescriptor var1, @NotNull String var2);

    public void addScopeImport(@NotNull JetScope var1);

    public static class DelayedImporter
    extends StandardImporter {
        private final List<JetScope> scopesToImport = Lists.newArrayList();
        private final List<Pair<DeclarationDescriptor, String>> imports = Lists.newArrayList();

        public DelayedImporter(@NotNull WritableScope namespaceScope, boolean firstPhase) {
            super(namespaceScope, firstPhase);
        }

        @Override
        public void addAllUnderImport(@NotNull DeclarationDescriptor descriptor) {
            this.imports.add((Pair<DeclarationDescriptor, String>)Pair.create((Object)descriptor, null));
        }

        @Override
        public void addAliasImport(@NotNull DeclarationDescriptor descriptor, @NotNull String aliasName) {
            this.imports.add((Pair<DeclarationDescriptor, String>)Pair.create((Object)descriptor, (Object)aliasName));
        }

        @Override
        public void addScopeImport(@NotNull JetScope scope) {
            this.scopesToImport.add(scope);
        }

        public void processImports() {
            for (JetScope jetScope : this.scopesToImport) {
                this.importScope(jetScope);
            }
            for (Pair pair : this.imports) {
                boolean allUnderImport;
                DeclarationDescriptor descriptor = (DeclarationDescriptor)pair.getFirst();
                String aliasName = (String)pair.getSecond();
                boolean bl = allUnderImport = aliasName == null;
                if (allUnderImport) {
                    this.importAllUnderDeclaration(descriptor);
                    continue;
                }
                this.importDeclarationAlias(descriptor, aliasName);
            }
        }
    }

    public static class StandardImporter
    implements Importer {
        private final WritableScope namespaceScope;
        private final boolean firstPhase;

        public StandardImporter(WritableScope namespaceScope, boolean firstPhase) {
            this.namespaceScope = namespaceScope;
            this.firstPhase = firstPhase;
        }

        @Override
        public void addAllUnderImport(@NotNull DeclarationDescriptor descriptor) {
            this.importAllUnderDeclaration(descriptor);
        }

        @Override
        public void addAliasImport(@NotNull DeclarationDescriptor descriptor, @NotNull String aliasName) {
            this.importDeclarationAlias(descriptor, aliasName);
        }

        @Override
        public void addScopeImport(@NotNull JetScope scope) {
            this.importScope(scope);
        }

        protected void importScope(@NotNull JetScope scope) {
            this.namespaceScope.importScope(scope);
        }

        protected void importAllUnderDeclaration(@NotNull DeclarationDescriptor descriptor) {
            JetType classObjectType;
            if (descriptor instanceof NamespaceDescriptor) {
                this.namespaceScope.importScope(((NamespaceDescriptor)descriptor).getMemberScope());
            }
            if (this.firstPhase) {
                ClassDescriptor objectDescriptor;
                if (descriptor instanceof ClassDescriptor && (objectDescriptor = DescriptorUtils.getObjectIfObjectOrClassObjectDescriptor((ClassDescriptor)descriptor)) != null) {
                    Collection<ClassDescriptor> innerClassesAndObjects = objectDescriptor.getInnerClassesAndObjects();
                    for (DeclarationDescriptor declarationDescriptor : innerClassesAndObjects) {
                        this.namespaceScope.importClassifierAlias(declarationDescriptor.getName(), (ClassifierDescriptor)declarationDescriptor);
                    }
                }
                return;
            }
            if (descriptor instanceof VariableDescriptor) {
                JetType type = ((VariableDescriptor)descriptor).getType();
                this.namespaceScope.importScope(type.getMemberScope());
            } else if (descriptor instanceof ClassDescriptor && (classObjectType = ((ClassDescriptor)descriptor).getClassObjectType()) != null) {
                this.namespaceScope.importScope(classObjectType.getMemberScope());
            }
        }

        protected void importDeclarationAlias(@NotNull DeclarationDescriptor descriptor, @NotNull String aliasName) {
            if (descriptor instanceof ClassifierDescriptor) {
                this.namespaceScope.importClassifierAlias(aliasName, (ClassifierDescriptor)descriptor);
            } else if (descriptor instanceof NamespaceDescriptor) {
                this.namespaceScope.importNamespaceAlias(aliasName, (NamespaceDescriptor)descriptor);
            } else if (descriptor instanceof FunctionDescriptor) {
                this.namespaceScope.importFunctionAlias(aliasName, (FunctionDescriptor)descriptor);
            } else if (descriptor instanceof VariableDescriptor) {
                this.namespaceScope.importVariableAlias(aliasName, (VariableDescriptor)descriptor);
            }
        }
    }
}

