/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.JetSemanticServices;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ClassifierDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.LocalVariableDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.MutableValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.Visibility;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDelegationSpecifier;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetNullableType;
import org.jetbrains.jet.lang.psi.JetObjectDeclarationName;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetProjectionKind;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetSecondaryConstructor;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetTypeConstraint;
import org.jetbrains.jet.lang.psi.JetTypeElement;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.psi.JetTypeParameterListOwner;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetUserType;
import org.jetbrains.jet.lang.resolve.AnnotationResolver;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.DescriptorUtils;
import org.jetbrains.jet.lang.resolve.TraceBasedRedeclarationHandler;
import org.jetbrains.jet.lang.resolve.TypeResolver;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScopeImpl;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ExtensionReceiver;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.DeferredType;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetStandardClasses;
import org.jetbrains.jet.lang.types.JetStandardLibrary;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeProjection;
import org.jetbrains.jet.lang.types.TypeSubstitutor;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.Variance;
import org.jetbrains.jet.lexer.JetTokens;
import org.jetbrains.jet.util.lazy.LazyValue;
import org.jetbrains.jet.util.lazy.LazyValueWithDefault;

public class DescriptorResolver {
    private final JetSemanticServices semanticServices;
    private final TypeResolver typeResolver;
    private final TypeResolver typeResolverNotCheckingBounds;
    private final BindingTrace trace;
    private final AnnotationResolver annotationResolver;

    public DescriptorResolver(JetSemanticServices semanticServices, BindingTrace trace) {
        this.semanticServices = semanticServices;
        this.typeResolver = new TypeResolver(semanticServices, trace, true);
        this.typeResolverNotCheckingBounds = new TypeResolver(semanticServices, trace, false);
        this.trace = trace;
        this.annotationResolver = new AnnotationResolver(semanticServices, trace);
    }

    public void resolveMutableClassDescriptor(@NotNull JetClass classElement, @NotNull MutableClassDescriptor descriptor) {
        ArrayList typeParameters = Lists.newArrayList();
        int index = 0;
        for (JetTypeParameter typeParameter : classElement.getTypeParameters()) {
            TypeParameterDescriptor typeParameterDescriptor = TypeParameterDescriptor.createForFurtherModification(descriptor, this.annotationResolver.createAnnotationStubs(typeParameter.getModifierList()), !typeParameter.hasModifier(JetTokens.ERASED_KEYWORD), typeParameter.getVariance(), JetPsiUtil.safeName(typeParameter.getName()), index);
            this.trace.record(BindingContext.TYPE_PARAMETER, typeParameter, typeParameterDescriptor);
            typeParameters.add(typeParameterDescriptor);
            ++index;
        }
        descriptor.setTypeParameterDescriptors(typeParameters);
        Modality defaultModality = descriptor.getKind() == ClassKind.TRAIT ? Modality.ABSTRACT : Modality.FINAL;
        descriptor.setModality(DescriptorResolver.resolveModalityFromModifiers(classElement.getModifierList(), defaultModality));
        descriptor.setVisibility(DescriptorResolver.resolveVisibilityFromModifiers(classElement.getModifierList()));
        this.trace.record(BindingContext.CLASS, classElement, descriptor);
    }

    public void resolveSupertypes(@NotNull JetClassOrObject jetClass, @NotNull MutableClassDescriptor descriptor) {
        List<JetDelegationSpecifier> delegationSpecifiers = jetClass.getDelegationSpecifiers();
        if (delegationSpecifiers.isEmpty()) {
            descriptor.addSupertype(this.getDefaultSupertype(jetClass));
        } else {
            Collection<JetType> supertypes = this.resolveDelegationSpecifiers(descriptor.getScopeForSupertypeResolution(), delegationSpecifiers, this.typeResolverNotCheckingBounds);
            for (JetType supertype : supertypes) {
                descriptor.addSupertype(supertype);
            }
        }
    }

    private JetType getDefaultSupertype(JetClassOrObject jetClass) {
        if (jetClass instanceof JetEnumEntry) {
            JetClassOrObject parent = (JetClassOrObject)PsiTreeUtil.getParentOfType((PsiElement)jetClass, JetClassOrObject.class);
            ClassDescriptor parentDescriptor = this.trace.getBindingContext().get(BindingContext.CLASS, parent);
            if (parentDescriptor.getTypeConstructor().getParameters().isEmpty()) {
                return parentDescriptor.getDefaultType();
            }
            this.trace.report(Errors.NO_GENERICS_IN_SUPERTYPE_SPECIFIER.on(((JetEnumEntry)jetClass).getNameIdentifier()));
            return ErrorUtils.createErrorType("Supertype not specified");
        }
        return JetStandardClasses.getAnyType();
    }

    public Collection<JetType> resolveDelegationSpecifiers(JetScope extensibleScope, List<JetDelegationSpecifier> delegationSpecifiers, @NotNull TypeResolver resolver) {
        if (delegationSpecifiers.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (JetDelegationSpecifier delegationSpecifier : delegationSpecifiers) {
            JetTypeReference typeReference = delegationSpecifier.getTypeReference();
            if (typeReference != null) {
                result.add(resolver.resolveType(extensibleScope, typeReference));
                JetTypeElement typeElement = typeReference.getTypeElement();
                while (typeElement instanceof JetNullableType) {
                    JetNullableType nullableType = (JetNullableType)typeElement;
                    this.trace.report(Errors.NULLABLE_SUPERTYPE.on(nullableType));
                    typeElement = nullableType.getInnerType();
                }
                if (!(typeElement instanceof JetUserType)) continue;
                JetUserType userType = (JetUserType)typeElement;
                List<JetTypeProjection> typeArguments = userType.getTypeArguments();
                for (JetTypeProjection typeArgument : typeArguments) {
                    if (typeArgument.getProjectionKind() == JetProjectionKind.NONE) continue;
                    this.trace.report(Errors.PROJECTION_IN_IMMEDIATE_ARGUMENT_TO_SUPERTYPE.on(typeArgument));
                }
                continue;
            }
            result.add(ErrorUtils.createErrorType("No type reference"));
        }
        return result;
    }

    @NotNull
    public SimpleFunctionDescriptor resolveFunctionDescriptor(DeclarationDescriptor containingDescriptor, final JetScope scope, final JetNamedFunction function) {
        JetType returnType;
        final SimpleFunctionDescriptorImpl functionDescriptor = new SimpleFunctionDescriptorImpl(containingDescriptor, this.annotationResolver.resolveAnnotations(scope, function.getModifierList()), JetPsiUtil.safeName(function.getName()), CallableMemberDescriptor.Kind.DECLARATION);
        WritableScopeImpl innerScope = new WritableScopeImpl(scope, functionDescriptor, new TraceBasedRedeclarationHandler(this.trace)).setDebugName("Function descriptor header scope");
        innerScope.addLabeledDeclaration(functionDescriptor);
        List<TypeParameterDescriptor> typeParameterDescriptors = this.resolveTypeParameters(functionDescriptor, innerScope, function.getTypeParameters());
        innerScope.changeLockLevel(WritableScope.LockLevel.BOTH);
        this.resolveGenericBounds(function, innerScope, typeParameterDescriptors);
        JetType receiverType = null;
        JetTypeReference receiverTypeRef = function.getReceiverTypeRef();
        if (receiverTypeRef != null) {
            JetScope scopeForReceiver = function.hasTypeParameterListBeforeFunctionName() ? innerScope : scope;
            receiverType = this.typeResolver.resolveType(scopeForReceiver, receiverTypeRef);
        }
        List<ValueParameterDescriptor> valueParameterDescriptors = this.resolveValueParameters(functionDescriptor, innerScope, function.getValueParameters());
        innerScope.changeLockLevel(WritableScope.LockLevel.READING);
        JetTypeReference returnTypeRef = function.getReturnTypeRef();
        if (returnTypeRef != null) {
            returnType = this.typeResolver.resolveType(innerScope, returnTypeRef);
        } else if (function.hasBlockBody()) {
            returnType = JetStandardClasses.getUnitType();
        } else {
            JetExpression bodyExpression = function.getBodyExpression();
            if (bodyExpression != null) {
                returnType = DeferredType.create(this.trace, (LazyValue<JetType>)new LazyValueWithDefault<JetType>(ErrorUtils.createErrorType("Recursive dependency")){

                    @Override
                    protected JetType compute() {
                        return DescriptorResolver.this.semanticServices.getTypeInferrerServices(DescriptorResolver.this.trace).inferFunctionReturnType(scope, function, functionDescriptor);
                    }
                });
            } else {
                this.trace.report(Errors.FUNCTION_WITH_NO_TYPE_NO_BODY.on(function.asElement()));
                returnType = ErrorUtils.createErrorType("No type, no body");
            }
        }
        boolean hasBody = function.getBodyExpression() != null;
        Modality defaultModality = this.getDefaultModality(containingDescriptor, hasBody);
        Modality modality = DescriptorResolver.resolveModalityFromModifiers(function.getModifierList(), defaultModality);
        Visibility visibility = DescriptorResolver.resolveVisibilityFromModifiers(function.getModifierList());
        functionDescriptor.initialize(receiverType, DescriptorUtils.getExpectedThisObjectIfNeeded(containingDescriptor), typeParameterDescriptors, valueParameterDescriptors, returnType, modality, visibility);
        this.trace.record(BindingContext.FUNCTION, function, functionDescriptor);
        return functionDescriptor;
    }

    private Modality getDefaultModality(DeclarationDescriptor containingDescriptor, boolean isBodyPresent) {
        Modality defaultModality;
        if (containingDescriptor instanceof ClassDescriptor) {
            boolean isTrait = ((ClassDescriptor)containingDescriptor).getKind() == ClassKind.TRAIT;
            boolean isDefinitelyAbstract = isTrait && !isBodyPresent;
            Modality basicModality = isTrait ? Modality.OPEN : Modality.FINAL;
            defaultModality = isDefinitelyAbstract ? Modality.ABSTRACT : basicModality;
        } else {
            defaultModality = Modality.FINAL;
        }
        return defaultModality;
    }

    @NotNull
    private List<ValueParameterDescriptor> resolveValueParameters(FunctionDescriptor functionDescriptor, WritableScope parameterScope, List<JetParameter> valueParameters) {
        ArrayList<ValueParameterDescriptor> result = new ArrayList<ValueParameterDescriptor>();
        int valueParametersSize = valueParameters.size();
        for (int i = 0; i < valueParametersSize; ++i) {
            JetType type;
            JetParameter valueParameter = valueParameters.get(i);
            JetTypeReference typeReference = valueParameter.getTypeReference();
            if (typeReference == null) {
                this.trace.report(Errors.VALUE_PARAMETER_WITH_NO_TYPE_ANNOTATION.on(valueParameter));
                type = ErrorUtils.createErrorType("Type annotation was missing");
            } else {
                type = this.typeResolver.resolveType(parameterScope, typeReference);
            }
            MutableValueParameterDescriptor valueParameterDescriptor = this.resolveValueParameterDescriptor(functionDescriptor, valueParameter, i, type);
            parameterScope.addVariableDescriptor(valueParameterDescriptor);
            result.add(valueParameterDescriptor);
        }
        return result;
    }

    @NotNull
    public MutableValueParameterDescriptor resolveValueParameterDescriptor(DeclarationDescriptor declarationDescriptor, JetParameter valueParameter, int index, JetType type) {
        JetType varargElementType = null;
        JetType variableType = type;
        if (valueParameter.hasModifier(JetTokens.VARARG_KEYWORD)) {
            varargElementType = type;
            variableType = this.getVarargParameterType(type);
        }
        ValueParameterDescriptorImpl valueParameterDescriptor = new ValueParameterDescriptorImpl(declarationDescriptor, index, this.annotationResolver.createAnnotationStubs(valueParameter.getModifierList()), JetPsiUtil.safeName(valueParameter.getName()), valueParameter.isMutable(), variableType, valueParameter.getDefaultValue() != null, varargElementType);
        this.trace.record(BindingContext.VALUE_PARAMETER, valueParameter, valueParameterDescriptor);
        return valueParameterDescriptor;
    }

    private JetType getVarargParameterType(JetType type) {
        JetStandardLibrary standardLibrary = this.semanticServices.getStandardLibrary();
        JetType arrayType = standardLibrary.getPrimitiveArrayJetTypeByPrimitiveJetType(type);
        if (arrayType != null) {
            return arrayType;
        }
        return standardLibrary.getArrayType(type);
    }

    public List<TypeParameterDescriptor> resolveTypeParameters(DeclarationDescriptor containingDescriptor, WritableScope extensibleScope, List<JetTypeParameter> typeParameters) {
        ArrayList<TypeParameterDescriptor> result = new ArrayList<TypeParameterDescriptor>();
        int typeParametersSize = typeParameters.size();
        for (int i = 0; i < typeParametersSize; ++i) {
            JetTypeParameter typeParameter = typeParameters.get(i);
            result.add(this.resolveTypeParameter(containingDescriptor, extensibleScope, typeParameter, i));
        }
        return result;
    }

    private TypeParameterDescriptor resolveTypeParameter(DeclarationDescriptor containingDescriptor, WritableScope extensibleScope, JetTypeParameter typeParameter, int index) {
        TypeParameterDescriptor typeParameterDescriptor = TypeParameterDescriptor.createForFurtherModification(containingDescriptor, this.annotationResolver.createAnnotationStubs(typeParameter.getModifierList()), !typeParameter.hasModifier(JetTokens.ERASED_KEYWORD), typeParameter.getVariance(), JetPsiUtil.safeName(typeParameter.getName()), index);
        extensibleScope.addTypeParameterDescriptor(typeParameterDescriptor);
        this.trace.record(BindingContext.TYPE_PARAMETER, typeParameter, typeParameterDescriptor);
        return typeParameterDescriptor;
    }

    public void resolveGenericBounds(@NotNull JetTypeParameterListOwner declaration, JetScope scope, List<TypeParameterDescriptor> parameters) {
        List<JetTypeParameter> typeParameters = declaration.getTypeParameters();
        HashMap parameterByName = Maps.newHashMap();
        int typeParametersSize = typeParameters.size();
        for (int i = 0; i < typeParametersSize; ++i) {
            JetTypeParameter jetTypeParameter = typeParameters.get(i);
            TypeParameterDescriptor typeParameterDescriptor = parameters.get(i);
            parameterByName.put(typeParameterDescriptor.getName(), typeParameterDescriptor);
            JetTypeReference extendsBound = jetTypeParameter.getExtendsBound();
            if (extendsBound == null) continue;
            typeParameterDescriptor.addUpperBound(this.resolveAndCheckUpperBoundType(extendsBound, scope, false));
        }
        for (JetTypeConstraint constraint : declaration.getTypeConstaints()) {
            JetType bound;
            String referencedName;
            JetSimpleNameExpression subjectTypeParameterName = constraint.getSubjectTypeParameterName();
            if (subjectTypeParameterName == null || (referencedName = subjectTypeParameterName.getReferencedName()) == null) continue;
            TypeParameterDescriptor typeParameterDescriptor = (TypeParameterDescriptor)parameterByName.get(referencedName);
            JetTypeReference boundTypeReference = constraint.getBoundTypeReference();
            JetType jetType = bound = boundTypeReference != null ? this.resolveAndCheckUpperBoundType(boundTypeReference, scope, constraint.isClassObjectContraint()) : null;
            if (typeParameterDescriptor == null) {
                ClassifierDescriptor classifier = scope.getClassifier(referencedName);
                if (classifier != null) {
                    this.trace.report(Errors.NAME_IN_CONSTRAINT_IS_NOT_A_TYPE_PARAMETER.on(subjectTypeParameterName, constraint, declaration));
                    this.trace.record(BindingContext.REFERENCE_TARGET, subjectTypeParameterName, classifier);
                    continue;
                }
                this.trace.report(Errors.UNRESOLVED_REFERENCE.on(subjectTypeParameterName));
                continue;
            }
            this.trace.record(BindingContext.REFERENCE_TARGET, subjectTypeParameterName, typeParameterDescriptor);
            if (bound == null) continue;
            if (constraint.isClassObjectContraint()) {
                typeParameterDescriptor.addClassObjectBound(bound);
                continue;
            }
            typeParameterDescriptor.addUpperBound(bound);
        }
        for (TypeParameterDescriptor parameter : parameters) {
            PsiElement nameIdentifier;
            JetType classObjectType;
            PsiElement nameIdentifier2;
            parameter.addDefaultUpperBound();
            parameter.setInitialized();
            if (JetStandardClasses.isNothing(parameter.getUpperBoundsAsType()) && (nameIdentifier2 = typeParameters.get(parameter.getIndex()).getNameIdentifier()) != null) {
                this.trace.report(Errors.CONFLICTING_UPPER_BOUNDS.on(nameIdentifier2, parameter));
            }
            if ((classObjectType = parameter.getClassObjectType()) == null || !JetStandardClasses.isNothing(classObjectType) || (nameIdentifier = typeParameters.get(parameter.getIndex()).getNameIdentifier()) == null) continue;
            this.trace.report(Errors.CONFLICTING_CLASS_OBJECT_UPPER_BOUNDS.on(nameIdentifier, parameter));
        }
    }

    private JetType resolveAndCheckUpperBoundType(@NotNull JetTypeReference upperBound, @NotNull JetScope scope, boolean classObjectConstaint) {
        JetType jetType = this.typeResolverNotCheckingBounds.resolveType(scope, upperBound);
        if (!TypeUtils.canHaveSubtypes(this.semanticServices.getTypeChecker(), jetType)) {
            if (classObjectConstaint) {
                this.trace.report(Errors.FINAL_CLASS_OBJECT_UPPER_BOUND.on(upperBound, jetType));
            } else {
                this.trace.report(Errors.FINAL_UPPER_BOUND.on(upperBound, jetType));
            }
        }
        return jetType;
    }

    @NotNull
    public VariableDescriptor resolveLocalVariableDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull JetScope scope, @NotNull JetParameter parameter) {
        JetType type = this.resolveParameterType(scope, parameter);
        return this.resolveLocalVariableDescriptor(containingDeclaration, parameter, type);
    }

    private JetType resolveParameterType(JetScope scope, JetParameter parameter) {
        JetTypeReference typeReference = parameter.getTypeReference();
        JetType type = typeReference != null ? this.typeResolver.resolveType(scope, typeReference) : ErrorUtils.createErrorType("Annotation is absent");
        return type;
    }

    public VariableDescriptor resolveLocalVariableDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull JetParameter parameter, @NotNull JetType type) {
        LocalVariableDescriptor variableDescriptor = new LocalVariableDescriptor(containingDeclaration, this.annotationResolver.createAnnotationStubs(parameter.getModifierList()), JetPsiUtil.safeName(parameter.getName()), type, parameter.isMutable());
        this.trace.record(BindingContext.VALUE_PARAMETER, parameter, variableDescriptor);
        return variableDescriptor;
    }

    @NotNull
    public VariableDescriptor resolveLocalVariableDescriptor(DeclarationDescriptor containingDeclaration, JetScope scope, JetProperty property, DataFlowInfo dataFlowInfo) {
        VariableDescriptorImpl variableDescriptor = this.resolveLocalVariableDescriptorWithType(containingDeclaration, property, null);
        JetType type = this.getVariableType(scope, property, dataFlowInfo, false);
        variableDescriptor.setOutType(type);
        return variableDescriptor;
    }

    @NotNull
    public VariableDescriptorImpl resolveLocalVariableDescriptorWithType(DeclarationDescriptor containingDeclaration, JetProperty property, JetType type) {
        LocalVariableDescriptor variableDescriptor = new LocalVariableDescriptor(containingDeclaration, this.annotationResolver.createAnnotationStubs(property.getModifierList()), JetPsiUtil.safeName(property.getName()), type, property.isVar());
        this.trace.record(BindingContext.VARIABLE, property, variableDescriptor);
        return variableDescriptor;
    }

    @NotNull
    public VariableDescriptor resolveObjectDeclaration(@NotNull DeclarationDescriptor containingDeclaration, @NotNull JetClassOrObject objectDeclaration, @NotNull ClassDescriptor classDescriptor) {
        boolean isProperty;
        boolean bl = isProperty = containingDeclaration instanceof NamespaceDescriptor || containingDeclaration instanceof ClassDescriptor;
        if (isProperty) {
            return this.resolveObjectDeclarationAsPropertyDescriptor(containingDeclaration, objectDeclaration, classDescriptor);
        }
        return this.resolveObjectDeclarationAsLocalVariable(containingDeclaration, objectDeclaration, classDescriptor);
    }

    @NotNull
    public PropertyDescriptor resolveObjectDeclarationAsPropertyDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull JetClassOrObject objectDeclaration, @NotNull ClassDescriptor classDescriptor) {
        JetModifierList modifierList = objectDeclaration.getModifierList();
        Visibility visibility = DescriptorResolver.resolveVisibilityFromModifiers(objectDeclaration.getModifierList());
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(containingDeclaration, this.annotationResolver.createAnnotationStubs(modifierList), Modality.FINAL, visibility, false, true, JetPsiUtil.safeName(objectDeclaration.getName()), CallableMemberDescriptor.Kind.DECLARATION);
        propertyDescriptor.setType(classDescriptor.getDefaultType(), Collections.<TypeParameterDescriptor>emptyList(), DescriptorUtils.getExpectedThisObjectIfNeeded(containingDeclaration), ReceiverDescriptor.NO_RECEIVER);
        propertyDescriptor.initialize(this.createDefaultGetter(propertyDescriptor), null);
        JetObjectDeclarationName nameAsDeclaration = objectDeclaration.getNameAsDeclaration();
        if (nameAsDeclaration != null) {
            this.trace.record(BindingContext.OBJECT_DECLARATION, nameAsDeclaration, propertyDescriptor);
        }
        return propertyDescriptor;
    }

    @NotNull
    private VariableDescriptor resolveObjectDeclarationAsLocalVariable(@NotNull DeclarationDescriptor containingDeclaration, @NotNull JetClassOrObject objectDeclaration, @NotNull ClassDescriptor classDescriptor) {
        LocalVariableDescriptor variableDescriptor = new LocalVariableDescriptor(containingDeclaration, this.annotationResolver.createAnnotationStubs(objectDeclaration.getModifierList()), JetPsiUtil.safeName(objectDeclaration.getName()), classDescriptor.getDefaultType(), false);
        JetObjectDeclarationName nameAsDeclaration = objectDeclaration.getNameAsDeclaration();
        if (nameAsDeclaration != null) {
            this.trace.record(BindingContext.VARIABLE, nameAsDeclaration, variableDescriptor);
        }
        return variableDescriptor;
    }

    public JetScope getPropertyDeclarationInnerScope(@NotNull JetScope outerScope, @NotNull PropertyDescriptor propertyDescriptor, List<TypeParameterDescriptor> typeParameters, ReceiverDescriptor receiver) {
        WritableScopeImpl result = new WritableScopeImpl(outerScope, propertyDescriptor, new TraceBasedRedeclarationHandler(this.trace)).setDebugName("Property declaration inner scope");
        for (TypeParameterDescriptor typeParameterDescriptor : typeParameters) {
            result.addTypeParameterDescriptor(typeParameterDescriptor);
        }
        if (receiver.exists()) {
            result.setImplicitReceiver(receiver);
        }
        result.changeLockLevel(WritableScope.LockLevel.READING);
        return result;
    }

    @NotNull
    public PropertyDescriptor resolvePropertyDescriptor(@NotNull DeclarationDescriptor containingDeclaration, @NotNull JetScope scope, JetProperty property) {
        List<TypeParameterDescriptor> typeParameterDescriptors;
        JetScope scopeWithTypeParameters;
        JetModifierList modifierList = property.getModifierList();
        boolean isVar = property.isVar();
        boolean hasBody = DescriptorResolver.hasBody(property);
        Modality defaultModality = this.getDefaultModality(containingDeclaration, hasBody);
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(containingDeclaration, this.annotationResolver.resolveAnnotations(scope, modifierList), DescriptorResolver.resolveModalityFromModifiers(property.getModifierList(), defaultModality), DescriptorResolver.resolveVisibilityFromModifiers(property.getModifierList()), isVar, false, JetPsiUtil.safeName(property.getName()), CallableMemberDescriptor.Kind.DECLARATION);
        JetType receiverType = null;
        List<JetTypeParameter> typeParameters = property.getTypeParameters();
        if (typeParameters.isEmpty()) {
            scopeWithTypeParameters = scope;
            typeParameterDescriptors = Collections.emptyList();
        } else {
            WritableScopeImpl writableScope = new WritableScopeImpl(scope, containingDeclaration, new TraceBasedRedeclarationHandler(this.trace)).setDebugName("Scope with type parameters of a property");
            typeParameterDescriptors = this.resolveTypeParameters(containingDeclaration, writableScope, typeParameters);
            writableScope.changeLockLevel(WritableScope.LockLevel.READING);
            this.resolveGenericBounds(property, writableScope, typeParameterDescriptors);
            scopeWithTypeParameters = writableScope;
        }
        JetTypeReference receiverTypeRef = property.getReceiverTypeRef();
        if (receiverTypeRef != null) {
            receiverType = this.typeResolver.resolveType(scopeWithTypeParameters, receiverTypeRef);
        }
        ReceiverDescriptor receiverDescriptor = receiverType == null ? ReceiverDescriptor.NO_RECEIVER : new ExtensionReceiver(propertyDescriptor, receiverType);
        JetScope propertyScope = this.getPropertyDeclarationInnerScope(scope, propertyDescriptor, typeParameterDescriptors, receiverDescriptor);
        JetType type = this.getVariableType(propertyScope, property, DataFlowInfo.EMPTY, true);
        propertyDescriptor.setType(type, typeParameterDescriptors, DescriptorUtils.getExpectedThisObjectIfNeeded(containingDeclaration), receiverDescriptor);
        PropertyGetterDescriptor getter = this.resolvePropertyGetterDescriptor(scopeWithTypeParameters, property, propertyDescriptor);
        PropertySetterDescriptor setter = this.resolvePropertySetterDescriptor(scopeWithTypeParameters, property, propertyDescriptor);
        propertyDescriptor.initialize(getter, setter);
        this.trace.record(BindingContext.VARIABLE, property, propertyDescriptor);
        return propertyDescriptor;
    }

    static boolean hasBody(JetProperty property) {
        boolean hasBody;
        boolean bl = hasBody = property.getInitializer() != null;
        if (!hasBody) {
            JetPropertyAccessor getter = property.getGetter();
            if (getter != null && getter.getBodyExpression() != null) {
                hasBody = true;
            }
            JetPropertyAccessor setter = property.getSetter();
            if (!hasBody && setter != null && setter.getBodyExpression() != null) {
                hasBody = true;
            }
        }
        return hasBody;
    }

    @NotNull
    private JetType getVariableType(final @NotNull JetScope scope, @NotNull JetProperty property, final @NotNull DataFlowInfo dataFlowInfo, boolean allowDeferred) {
        JetTypeReference propertyTypeRef = property.getPropertyTypeRef();
        if (propertyTypeRef == null) {
            final JetExpression initializer = property.getInitializer();
            if (initializer == null) {
                PsiElement nameIdentifier = property.getNameIdentifier();
                if (nameIdentifier != null) {
                    this.trace.report(Errors.PROPERTY_WITH_NO_TYPE_NO_INITIALIZER.on(nameIdentifier));
                }
                return ErrorUtils.createErrorType("No type, no body");
            }
            LazyValueWithDefault<JetType> lazyValue = new LazyValueWithDefault<JetType>(ErrorUtils.createErrorType("Recursive dependency")){

                @Override
                protected JetType compute() {
                    return DescriptorResolver.this.semanticServices.getTypeInferrerServices(DescriptorResolver.this.trace).safeGetType(scope, initializer, TypeUtils.NO_EXPECTED_TYPE, dataFlowInfo);
                }
            };
            if (allowDeferred) {
                return DeferredType.create(this.trace, (LazyValue<JetType>)lazyValue);
            }
            return (JetType)lazyValue.get();
        }
        return this.typeResolver.resolveType(scope, propertyTypeRef);
    }

    @NotNull
    static Modality resolveModalityFromModifiers(@Nullable JetModifierList modifierList, @NotNull Modality defaultModality) {
        if (modifierList == null) {
            return defaultModality;
        }
        boolean hasAbstractModifier = modifierList.hasModifier(JetTokens.ABSTRACT_KEYWORD);
        boolean hasOverrideModifier = modifierList.hasModifier(JetTokens.OVERRIDE_KEYWORD);
        if (modifierList.hasModifier(JetTokens.OPEN_KEYWORD)) {
            if (hasAbstractModifier || defaultModality == Modality.ABSTRACT) {
                return Modality.ABSTRACT;
            }
            return Modality.OPEN;
        }
        if (hasAbstractModifier) {
            return Modality.ABSTRACT;
        }
        boolean hasFinalModifier = modifierList.hasModifier(JetTokens.FINAL_KEYWORD);
        if (hasOverrideModifier && !hasFinalModifier && defaultModality != Modality.ABSTRACT) {
            return Modality.OPEN;
        }
        if (hasFinalModifier) {
            return Modality.FINAL;
        }
        return defaultModality;
    }

    @NotNull
    static Visibility resolveVisibilityFromModifiers(@Nullable JetModifierList modifierList) {
        return DescriptorResolver.resolveVisibilityFromModifiers(modifierList, Visibility.INTERNAL);
    }

    @NotNull
    static Visibility resolveVisibilityFromModifiers(@Nullable JetModifierList modifierList, @NotNull Visibility defaultVisibility) {
        if (modifierList == null) {
            return defaultVisibility;
        }
        if (modifierList.hasModifier(JetTokens.PRIVATE_KEYWORD)) {
            return Visibility.PRIVATE;
        }
        if (modifierList.hasModifier(JetTokens.PUBLIC_KEYWORD)) {
            return Visibility.PUBLIC;
        }
        if (modifierList.hasModifier(JetTokens.PROTECTED_KEYWORD)) {
            if (modifierList.hasModifier(JetTokens.INTERNAL_KEYWORD)) {
                return Visibility.INTERNAL_PROTECTED;
            }
            return Visibility.PROTECTED;
        }
        return defaultVisibility;
    }

    @Nullable
    private PropertySetterDescriptor resolvePropertySetterDescriptor(@NotNull JetScope scope, @NotNull JetProperty property, @NotNull PropertyDescriptor propertyDescriptor) {
        JetPropertyAccessor setter = property.getSetter();
        PropertySetterDescriptor setterDescriptor = null;
        if (setter != null) {
            List<AnnotationDescriptor> annotations = this.annotationResolver.resolveAnnotations(scope, setter.getModifierList());
            JetParameter parameter = setter.getParameter();
            setterDescriptor = new PropertySetterDescriptor(propertyDescriptor, annotations, DescriptorResolver.resolveModalityFromModifiers(setter.getModifierList(), propertyDescriptor.getModality()), DescriptorResolver.resolveVisibilityFromModifiers(setter.getModifierList(), propertyDescriptor.getVisibility()), setter.getBodyExpression() != null, false, CallableMemberDescriptor.Kind.DECLARATION);
            if (parameter != null) {
                JetType type;
                JetTypeReference typeReference;
                JetExpression defaultValue = parameter.getDefaultValue();
                if (defaultValue != null) {
                    this.trace.report(Errors.SETTER_PARAMETER_WITH_DEFAULT_VALUE.on(defaultValue));
                }
                if ((typeReference = parameter.getTypeReference()) == null) {
                    type = propertyDescriptor.getType();
                } else {
                    type = this.typeResolver.resolveType(scope, typeReference);
                    JetType inType = propertyDescriptor.getType();
                    if (inType != null && !TypeUtils.equalTypes(type, inType)) {
                        this.trace.report(Errors.WRONG_SETTER_PARAMETER_TYPE.on(typeReference, inType));
                    }
                }
                MutableValueParameterDescriptor valueParameterDescriptor = this.resolveValueParameterDescriptor(setterDescriptor, parameter, 0, type);
                setterDescriptor.initialize(valueParameterDescriptor);
            } else {
                setterDescriptor.initializeDefault();
            }
            this.trace.record(BindingContext.PROPERTY_ACCESSOR, setter, setterDescriptor);
        } else if (property.isVar()) {
            setterDescriptor = this.createDefaultSetter(propertyDescriptor);
        }
        if (!property.isVar() && setter != null) {
            this.trace.report(Errors.VAL_WITH_SETTER.on(setter));
        }
        return setterDescriptor;
    }

    private PropertySetterDescriptor createDefaultSetter(PropertyDescriptor propertyDescriptor) {
        PropertySetterDescriptor setterDescriptor = new PropertySetterDescriptor(propertyDescriptor, Collections.<AnnotationDescriptor>emptyList(), propertyDescriptor.getModality(), propertyDescriptor.getVisibility(), false, true, CallableMemberDescriptor.Kind.DECLARATION);
        setterDescriptor.initializeDefault();
        return setterDescriptor;
    }

    @Nullable
    private PropertyGetterDescriptor resolvePropertyGetterDescriptor(@NotNull JetScope scope, @NotNull JetProperty property, @NotNull PropertyDescriptor propertyDescriptor) {
        PropertyGetterDescriptor getterDescriptor;
        JetPropertyAccessor getter = property.getGetter();
        if (getter != null) {
            JetType outType;
            List<AnnotationDescriptor> annotations = this.annotationResolver.resolveAnnotations(scope, getter.getModifierList());
            JetType returnType = outType = propertyDescriptor.getType();
            JetTypeReference returnTypeReference = getter.getReturnTypeReference();
            if (returnTypeReference != null) {
                returnType = this.typeResolver.resolveType(scope, returnTypeReference);
                if (outType != null && !TypeUtils.equalTypes(returnType, outType)) {
                    this.trace.report(Errors.WRONG_GETTER_RETURN_TYPE.on(returnTypeReference, propertyDescriptor.getReturnType()));
                }
            }
            getterDescriptor = new PropertyGetterDescriptor(propertyDescriptor, annotations, DescriptorResolver.resolveModalityFromModifiers(getter.getModifierList(), propertyDescriptor.getModality()), DescriptorResolver.resolveVisibilityFromModifiers(getter.getModifierList(), propertyDescriptor.getVisibility()), getter.getBodyExpression() != null, false, CallableMemberDescriptor.Kind.DECLARATION);
            getterDescriptor.initialize(returnType);
            this.trace.record(BindingContext.PROPERTY_ACCESSOR, getter, getterDescriptor);
        } else {
            getterDescriptor = this.createDefaultGetter(propertyDescriptor);
            getterDescriptor.initialize(propertyDescriptor.getType());
        }
        return getterDescriptor;
    }

    private PropertyGetterDescriptor createDefaultGetter(PropertyDescriptor propertyDescriptor) {
        PropertyGetterDescriptor getterDescriptor = new PropertyGetterDescriptor(propertyDescriptor, Collections.<AnnotationDescriptor>emptyList(), propertyDescriptor.getModality(), propertyDescriptor.getVisibility(), false, true, CallableMemberDescriptor.Kind.DECLARATION);
        return getterDescriptor;
    }

    @NotNull
    public ConstructorDescriptorImpl resolveSecondaryConstructorDescriptor(@NotNull JetScope scope, @NotNull ClassDescriptor classDescriptor, @NotNull JetSecondaryConstructor constructor) {
        return this.createConstructorDescriptor(scope, classDescriptor, false, constructor.getModifierList(), constructor, classDescriptor.getTypeConstructor().getParameters(), constructor.getValueParameters());
    }

    @NotNull
    private ConstructorDescriptorImpl createConstructorDescriptor(@NotNull JetScope scope, @NotNull ClassDescriptor classDescriptor, boolean isPrimary, @Nullable JetModifierList modifierList, @NotNull JetDeclaration declarationToTrace, List<TypeParameterDescriptor> typeParameters, @NotNull List<JetParameter> valueParameters) {
        ConstructorDescriptorImpl constructorDescriptor = new ConstructorDescriptorImpl(classDescriptor, this.annotationResolver.resolveAnnotations(scope, modifierList), isPrimary);
        this.trace.record(BindingContext.CONSTRUCTOR, declarationToTrace, constructorDescriptor);
        WritableScopeImpl parameterScope = new WritableScopeImpl(scope, classDescriptor, new TraceBasedRedeclarationHandler(this.trace)).setDebugName("Scope with value parameters of a constructor");
        parameterScope.changeLockLevel(WritableScope.LockLevel.BOTH);
        return constructorDescriptor.initialize(typeParameters, this.resolveValueParameters(constructorDescriptor, parameterScope, valueParameters), DescriptorResolver.resolveVisibilityFromModifiers(modifierList));
    }

    @Nullable
    public ConstructorDescriptorImpl resolvePrimaryConstructorDescriptor(@NotNull JetScope scope, @NotNull ClassDescriptor classDescriptor, @NotNull JetClass classElement) {
        if (classDescriptor.getKind() == ClassKind.ENUM_ENTRY && !classElement.hasPrimaryConstructor()) {
            return null;
        }
        return this.createConstructorDescriptor(scope, classDescriptor, true, classElement.getPrimaryConstructorModifierList(), classElement, classDescriptor.getTypeConstructor().getParameters(), classElement.getPrimaryConstructorParameters());
    }

    @NotNull
    public PropertyDescriptor resolvePrimaryConstructorParameterToAProperty(@NotNull ClassDescriptor classDescriptor, @NotNull JetScope scope, @NotNull JetParameter parameter) {
        ASTNode abstractNode;
        JetType type = this.resolveParameterType(scope, parameter);
        String name = parameter.getName();
        boolean isMutable = parameter.isMutable();
        JetModifierList modifierList = parameter.getModifierList();
        if (modifierList != null && (abstractNode = modifierList.getModifierNode(JetTokens.ABSTRACT_KEYWORD)) != null) {
            this.trace.report(Errors.ABSTRACT_PROPERTY_IN_PRIMARY_CONSTRUCTOR_PARAMETERS.on(parameter));
        }
        PropertyDescriptor propertyDescriptor = new PropertyDescriptor(classDescriptor, this.annotationResolver.resolveAnnotations(scope, modifierList), DescriptorResolver.resolveModalityFromModifiers(parameter.getModifierList(), Modality.FINAL), DescriptorResolver.resolveVisibilityFromModifiers(parameter.getModifierList()), isMutable, false, name == null ? "<no name>" : name, CallableMemberDescriptor.Kind.DECLARATION);
        propertyDescriptor.setType(type, Collections.<TypeParameterDescriptor>emptyList(), DescriptorUtils.getExpectedThisObjectIfNeeded(classDescriptor), ReceiverDescriptor.NO_RECEIVER);
        PropertyGetterDescriptor getter = this.createDefaultGetter(propertyDescriptor);
        PropertySetterDescriptor setter = this.createDefaultSetter(propertyDescriptor);
        propertyDescriptor.initialize(getter, setter);
        getter.initialize(propertyDescriptor.getType());
        this.trace.record(BindingContext.PRIMARY_CONSTRUCTOR_PARAMETER, parameter, propertyDescriptor);
        return propertyDescriptor;
    }

    public void checkBounds(@NotNull JetTypeReference typeReference, @NotNull JetType type) {
        if (ErrorUtils.isErrorType(type)) {
            return;
        }
        JetTypeElement typeElement = typeReference.getTypeElement();
        if (typeElement == null) {
            return;
        }
        List<TypeParameterDescriptor> parameters = type.getConstructor().getParameters();
        List<TypeProjection> arguments = type.getArguments();
        assert (parameters.size() == arguments.size());
        List<JetTypeReference> typeReferences = typeElement.getTypeArgumentsAsTypes();
        assert (typeReferences.size() == arguments.size()) : typeElement.getText();
        TypeSubstitutor substitutor = TypeSubstitutor.create(type);
        int projectionsSize = typeReferences.size();
        for (int i = 0; i < projectionsSize; ++i) {
            JetTypeReference argumentTypeReference = typeReferences.get(i);
            if (argumentTypeReference == null) continue;
            JetType typeArgument = arguments.get(i).getType();
            this.checkBounds(argumentTypeReference, typeArgument);
            TypeParameterDescriptor typeParameterDescriptor = parameters.get(i);
            this.checkBounds(argumentTypeReference, typeArgument, typeParameterDescriptor, substitutor);
        }
    }

    public void checkBounds(@NotNull JetTypeReference argumentTypeReference, @NotNull JetType typeArgument, @NotNull TypeParameterDescriptor typeParameterDescriptor, @NotNull TypeSubstitutor substitutor) {
        for (JetType bound : typeParameterDescriptor.getUpperBounds()) {
            JetType substitutedBound = substitutor.safeSubstitute(bound, Variance.INVARIANT);
            if (this.semanticServices.getTypeChecker().isSubtypeOf(typeArgument, substitutedBound)) continue;
            this.trace.report(Errors.UPPER_BOUND_VIOLATED.on(argumentTypeReference, substitutedBound));
        }
    }
}

