/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.intellij.psi.PsiElement;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.descriptors.ClassKind;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptorImpl;
import org.jetbrains.jet.lang.descriptors.MutableClassDescriptor;
import org.jetbrains.jet.lang.descriptors.MutableClassDescriptorLite;
import org.jetbrains.jet.lang.descriptors.NamespaceLike;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.diagnostics.Errors;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetEnumEntry;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetParameterList;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetSecondaryConstructor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.resolve.AnnotationResolver;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.WritableScope;

public class DeclarationResolver {
    private final AnnotationResolver annotationResolver;
    private final TopDownAnalysisContext context;

    public DeclarationResolver(TopDownAnalysisContext context) {
        this.context = context;
        this.annotationResolver = new AnnotationResolver(context.getSemanticServices(), context.getTrace());
    }

    public void process() {
        this.resolveConstructorHeaders();
        this.resolveAnnotationStubsOnClassesAndConstructors();
        this.resolveFunctionAndPropertyHeaders();
        this.context.getImportsResolver().processMembersImports();
    }

    private void resolveConstructorHeaders() {
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            JetClass jetClass = entry.getKey();
            MutableClassDescriptor classDescriptor = entry.getValue();
            this.processPrimaryConstructor(classDescriptor, jetClass);
            for (JetSecondaryConstructor jetConstructor : jetClass.getSecondaryConstructors()) {
                this.processSecondaryConstructor(classDescriptor, jetConstructor);
            }
        }
    }

    private void resolveAnnotationStubsOnClassesAndConstructors() {
        MutableClassDescriptor descriptor;
        AnnotationResolver annotationResolver = new AnnotationResolver(this.context.getSemanticServices(), this.context.getTrace());
        for (Map.Entry<JetClass, MutableClassDescriptor> entry : this.context.getClasses().entrySet()) {
            JetClass jetClass = entry.getKey();
            descriptor = entry.getValue();
            this.resolveAnnotationsForClassOrObject(annotationResolver, jetClass, descriptor);
        }
        for (Map.Entry<JetNamedDeclaration, MutableClassDescriptor> entry : this.context.getObjects().entrySet()) {
            JetObjectDeclaration objectDeclaration = (JetObjectDeclaration)entry.getKey();
            descriptor = entry.getValue();
            this.resolveAnnotationsForClassOrObject(annotationResolver, objectDeclaration, descriptor);
        }
    }

    private void resolveAnnotationsForClassOrObject(AnnotationResolver annotationResolver, JetClassOrObject jetClass, MutableClassDescriptor descriptor) {
        JetModifierList modifierList = jetClass.getModifierList();
        if (modifierList != null) {
            descriptor.getAnnotations().addAll(annotationResolver.resolveAnnotations(descriptor.getScopeForSupertypeResolution(), modifierList.getAnnotationEntries()));
        }
    }

    private void resolveFunctionAndPropertyHeaders() {
        MutableClassDescriptor classDescriptor;
        for (Map.Entry<JetFile, WritableScope> entry : this.context.getNamespaceScopes().entrySet()) {
            JetFile namespace = entry.getKey();
            WritableScope namespaceScope = entry.getValue();
            NamespaceLike namespaceDescriptor = this.context.getNamespaceDescriptors().get((Object)namespace);
            this.resolveFunctionAndPropertyHeaders(namespace.getDeclarations(), namespaceScope, namespaceScope, namespaceScope, namespaceDescriptor);
        }
        for (Map.Entry<Object, Object> entry : this.context.getClasses().entrySet()) {
            JetClass jetClass = (JetClass)entry.getKey();
            classDescriptor = (MutableClassDescriptor)entry.getValue();
            this.resolveFunctionAndPropertyHeaders(jetClass.getDeclarations(), classDescriptor.getScopeForMemberResolution(), classDescriptor.getScopeForInitializers(), classDescriptor.getScopeForMemberResolution(), classDescriptor);
        }
        for (Map.Entry<Object, Object> entry : this.context.getObjects().entrySet()) {
            JetObjectDeclaration object = (JetObjectDeclaration)entry.getKey();
            classDescriptor = (MutableClassDescriptor)entry.getValue();
            this.resolveFunctionAndPropertyHeaders(object.getDeclarations(), classDescriptor.getScopeForMemberResolution(), classDescriptor.getScopeForInitializers(), classDescriptor.getScopeForMemberResolution(), classDescriptor);
        }
    }

    private void resolveFunctionAndPropertyHeaders(@NotNull List<JetDeclaration> declarations, final @NotNull JetScope scopeForFunctions, final @NotNull JetScope scopeForPropertyInitializers, final @NotNull JetScope scopeForPropertyAccessors, final @NotNull NamespaceLike namespaceLike) {
        for (JetDeclaration declaration : declarations) {
            declaration.accept(new JetVisitorVoid(){

                @Override
                public void visitNamedFunction(JetNamedFunction function) {
                    SimpleFunctionDescriptor functionDescriptor = DeclarationResolver.this.context.getDescriptorResolver().resolveFunctionDescriptor(namespaceLike, scopeForFunctions, function);
                    namespaceLike.addFunctionDescriptor(functionDescriptor);
                    DeclarationResolver.this.context.getFunctions().put(function, functionDescriptor);
                    DeclarationResolver.this.context.getDeclaringScopes().put(function, scopeForFunctions);
                }

                @Override
                public void visitProperty(JetProperty property) {
                    PropertyDescriptor propertyDescriptor = DeclarationResolver.this.context.getDescriptorResolver().resolvePropertyDescriptor(namespaceLike, scopeForPropertyInitializers, property);
                    namespaceLike.addPropertyDescriptor(propertyDescriptor);
                    DeclarationResolver.this.context.getProperties().put(property, propertyDescriptor);
                    DeclarationResolver.this.context.getDeclaringScopes().put(property, scopeForPropertyInitializers);
                    if (property.getGetter() != null) {
                        DeclarationResolver.this.context.getDeclaringScopes().put(property.getGetter(), scopeForPropertyAccessors);
                    }
                    if (property.getSetter() != null) {
                        DeclarationResolver.this.context.getDeclaringScopes().put(property.getSetter(), scopeForPropertyAccessors);
                    }
                }

                @Override
                public void visitObjectDeclaration(JetObjectDeclaration declaration) {
                    PropertyDescriptor propertyDescriptor = DeclarationResolver.this.context.getDescriptorResolver().resolveObjectDeclarationAsPropertyDescriptor(namespaceLike, declaration, DeclarationResolver.this.context.getObjects().get(declaration));
                    namespaceLike.addPropertyDescriptor(propertyDescriptor);
                }

                @Override
                public void visitEnumEntry(JetEnumEntry enumEntry) {
                    if (enumEntry.getPrimaryConstructorParameterList() == null) {
                        MutableClassDescriptorLite classObjectDescriptor = ((MutableClassDescriptor)namespaceLike).getClassObjectDescriptor();
                        assert (classObjectDescriptor != null);
                        PropertyDescriptor propertyDescriptor = DeclarationResolver.this.context.getDescriptorResolver().resolveObjectDeclarationAsPropertyDescriptor(classObjectDescriptor, enumEntry, DeclarationResolver.this.context.getClasses().get(enumEntry));
                        classObjectDescriptor.addPropertyDescriptor(propertyDescriptor);
                    }
                }
            });
        }
    }

    private void processPrimaryConstructor(MutableClassDescriptor classDescriptor, JetClass klass) {
        if (classDescriptor.getKind() == ClassKind.TRAIT) {
            JetParameterList primaryConstructorParameterList = klass.getPrimaryConstructorParameterList();
            if (primaryConstructorParameterList != null) {
                this.context.getTrace().report(Errors.CONSTRUCTOR_IN_TRAIT.on((PsiElement)primaryConstructorParameterList));
            }
            if (!klass.hasPrimaryConstructor()) {
                return;
            }
        }
        JetScope memberScope = classDescriptor.getScopeForSupertypeResolution();
        ConstructorDescriptorImpl constructorDescriptor = this.context.getDescriptorResolver().resolvePrimaryConstructorDescriptor(memberScope, classDescriptor, klass);
        for (JetParameter parameter : klass.getPrimaryConstructorParameters()) {
            if (parameter.getValOrVarNode() == null) continue;
            PropertyDescriptor propertyDescriptor = this.context.getDescriptorResolver().resolvePrimaryConstructorParameterToAProperty(classDescriptor, memberScope, parameter);
            classDescriptor.addPropertyDescriptor(propertyDescriptor);
            this.context.getPrimaryConstructorParameterProperties().add(propertyDescriptor);
        }
        if (constructorDescriptor != null) {
            classDescriptor.setPrimaryConstructor(constructorDescriptor, this.context.getTrace());
        }
    }

    private void processSecondaryConstructor(MutableClassDescriptor classDescriptor, JetSecondaryConstructor constructor) {
        if (classDescriptor.getKind() == ClassKind.TRAIT) {
            this.context.getTrace().report(Errors.CONSTRUCTOR_IN_TRAIT.on(constructor.getNameNode().getPsi()));
        }
        ConstructorDescriptorImpl constructorDescriptor = this.context.getDescriptorResolver().resolveSecondaryConstructorDescriptor(classDescriptor.getScopeForMemberResolution(), classDescriptor, constructor);
        classDescriptor.addConstructor(constructorDescriptor, this.context.getTrace());
        this.context.getConstructors().put(constructor, constructorDescriptor);
        this.context.getDeclaringScopes().put(constructor, classDescriptor.getScopeForMemberLookup());
    }
}

