/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.cfg.JetFlowInformationProvider;
import org.jetbrains.jet.lang.cfg.pseudocode.JetControlFlowDataTraceFactory;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.psi.JetClass;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetDeclarationWithBody;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetProperty;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetSecondaryConstructor;
import org.jetbrains.jet.lang.resolve.TopDownAnalysisContext;
import org.jetbrains.jet.lang.types.JetStandardClasses;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;

public class ControlFlowAnalyzer {
    private TopDownAnalysisContext context;
    private final JetControlFlowDataTraceFactory flowDataTraceFactory;

    public ControlFlowAnalyzer(TopDownAnalysisContext context, JetControlFlowDataTraceFactory flowDataTraceFactory) {
        this.context = context;
        this.flowDataTraceFactory = flowDataTraceFactory;
    }

    public void process() {
        for (JetClass jetClass : this.context.getClasses().keySet()) {
            if (!this.context.completeAnalysisNeeded(jetClass)) continue;
            this.checkClassOrObject(jetClass);
        }
        for (JetObjectDeclaration jetObjectDeclaration : this.context.getObjects().keySet()) {
            if (!this.context.completeAnalysisNeeded(jetObjectDeclaration)) continue;
            this.checkClassOrObject(jetObjectDeclaration);
        }
        for (Map.Entry entry : this.context.getFunctions().entrySet()) {
            JetNamedFunction function = (JetNamedFunction)entry.getKey();
            SimpleFunctionDescriptor functionDescriptor = (SimpleFunctionDescriptor)entry.getValue();
            if (!this.context.completeAnalysisNeeded(function)) continue;
            JetType expectedReturnType = !function.hasBlockBody() && !function.hasDeclaredReturnType() ? TypeUtils.NO_EXPECTED_TYPE : functionDescriptor.getReturnType();
            this.checkFunction(function, expectedReturnType);
        }
        for (JetSecondaryConstructor jetSecondaryConstructor : this.context.getConstructors().keySet()) {
            if (!this.context.completeAnalysisNeeded(jetSecondaryConstructor)) continue;
            this.checkFunction(jetSecondaryConstructor, JetStandardClasses.getUnitType());
        }
        for (Map.Entry entry : this.context.getProperties().entrySet()) {
            JetProperty property = (JetProperty)entry.getKey();
            if (!this.context.completeAnalysisNeeded(property)) continue;
            PropertyDescriptor propertyDescriptor = (PropertyDescriptor)entry.getValue();
            this.checkProperty(property, propertyDescriptor);
        }
    }

    private void checkClassOrObject(JetClassOrObject klass) {
        JetFlowInformationProvider flowInformationProvider = new JetFlowInformationProvider((JetDeclaration)((Object)klass), (JetExpression)((Object)klass), this.flowDataTraceFactory, this.context.getTrace());
        flowInformationProvider.markUninitializedVariables((JetElement)((Object)klass), this.context.isDeclaredLocally());
    }

    private void checkProperty(JetProperty property, PropertyDescriptor propertyDescriptor) {
        for (JetPropertyAccessor accessor : property.getAccessors()) {
            PropertyAccessorDescriptor accessorDescriptor;
            PropertyAccessorDescriptor propertyAccessorDescriptor = accessorDescriptor = accessor.isGetter() ? propertyDescriptor.getGetter() : propertyDescriptor.getSetter();
            assert (accessorDescriptor != null);
            this.checkFunction(accessor, accessorDescriptor.getReturnType());
        }
    }

    private void checkFunction(JetDeclarationWithBody function, @NotNull JetType expectedReturnType) {
        assert (function instanceof JetDeclaration);
        JetExpression bodyExpression = function.getBodyExpression();
        if (bodyExpression == null) {
            return;
        }
        JetFlowInformationProvider flowInformationProvider = new JetFlowInformationProvider((JetDeclaration)((Object)function), bodyExpression, this.flowDataTraceFactory, this.context.getTrace());
        flowInformationProvider.checkDefiniteReturn(function, expectedReturnType);
        boolean isPropertyAccessor = function instanceof JetPropertyAccessor;
        flowInformationProvider.markUninitializedVariables(function.asElement(), this.context.isDeclaredLocally() || isPropertyAccessor);
        flowInformationProvider.markUnusedVariables(function.asElement());
        flowInformationProvider.markUnusedLiteralsInBlock(function.asElement());
    }
}

