/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.intellij.psi.PsiElement;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.descriptors.CallableDescriptor;
import org.jetbrains.jet.lang.descriptors.CallableMemberDescriptor;
import org.jetbrains.jet.lang.descriptors.ClassDescriptor;
import org.jetbrains.jet.lang.descriptors.ConstructorDescriptor;
import org.jetbrains.jet.lang.descriptors.DeclarationDescriptor;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.Modality;
import org.jetbrains.jet.lang.descriptors.NamespaceDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyAccessorDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertyGetterDescriptor;
import org.jetbrains.jet.lang.descriptors.PropertySetterDescriptor;
import org.jetbrains.jet.lang.descriptors.SimpleFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.TypeParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableAsFunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.VariableDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.diagnostics.Diagnostic;
import org.jetbrains.jet.lang.psi.JetAnnotationEntry;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetObjectDeclarationName;
import org.jetbrains.jet.lang.psi.JetParameter;
import org.jetbrains.jet.lang.psi.JetPropertyAccessor;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetTypeParameter;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.resolve.calls.ResolvedCall;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.types.DeferredType;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.util.Box;
import org.jetbrains.jet.util.slicedmap.BasicWritableSlice;
import org.jetbrains.jet.util.slicedmap.ReadOnlySlice;
import org.jetbrains.jet.util.slicedmap.RewritePolicy;
import org.jetbrains.jet.util.slicedmap.SlicedMap;
import org.jetbrains.jet.util.slicedmap.Slices;
import org.jetbrains.jet.util.slicedmap.WritableSlice;

public interface BindingContext {
    public static final WritableSlice<JetAnnotationEntry, AnnotationDescriptor> ANNOTATION = Slices.createSimpleSlice();
    public static final WritableSlice<JetExpression, CompileTimeConstant<?>> COMPILE_TIME_VALUE = Slices.createSimpleSlice();
    public static final WritableSlice<JetTypeReference, JetType> TYPE = Slices.createSimpleSlice();
    public static final WritableSlice<JetExpression, JetType> EXPRESSION_TYPE = new BasicWritableSlice<JetExpression, JetType>(RewritePolicy.DO_NOTHING);
    public static final WritableSlice<JetReferenceExpression, DeclarationDescriptor> REFERENCE_TARGET = new BasicWritableSlice<JetReferenceExpression, DeclarationDescriptor>(RewritePolicy.DO_NOTHING);
    public static final WritableSlice<JetElement, ResolvedCall<? extends CallableDescriptor>> RESOLVED_CALL = new BasicWritableSlice<JetElement, ResolvedCall<? extends CallableDescriptor>>(RewritePolicy.DO_NOTHING);
    public static final WritableSlice<JetReferenceExpression, Collection<? extends DeclarationDescriptor>> AMBIGUOUS_REFERENCE_TARGET = new BasicWritableSlice<JetReferenceExpression, Collection<? extends DeclarationDescriptor>>(RewritePolicy.DO_NOTHING);
    public static final WritableSlice<JetExpression, FunctionDescriptor> LOOP_RANGE_ITERATOR = Slices.createSimpleSlice();
    public static final WritableSlice<JetExpression, CallableDescriptor> LOOP_RANGE_HAS_NEXT = Slices.createSimpleSlice();
    public static final WritableSlice<JetExpression, FunctionDescriptor> LOOP_RANGE_NEXT = Slices.createSimpleSlice();
    public static final WritableSlice<JetExpression, ResolvedCall<FunctionDescriptor>> INDEXED_LVALUE_GET = Slices.createSimpleSlice();
    public static final WritableSlice<JetExpression, ResolvedCall<FunctionDescriptor>> INDEXED_LVALUE_SET = Slices.createSimpleSlice();
    public static final WritableSlice<JetExpression, JetType> AUTOCAST = Slices.createSimpleSlice();
    public static final WritableSlice<JetExpression, JetScope> RESOLUTION_SCOPE = Slices.createSimpleSlice();
    public static final WritableSlice<JetExpression, Boolean> VARIABLE_REASSIGNMENT = Slices.createSimpleSetSlice();
    public static final WritableSlice<ValueParameterDescriptor, Boolean> AUTO_CREATED_IT = Slices.createSimpleSetSlice();
    public static final WritableSlice<JetExpression, DeclarationDescriptor> VARIABLE_ASSIGNMENT = Slices.createSimpleSlice();
    public static final WritableSlice<JetExpression, Boolean> PROCESSED = Slices.createSimpleSetSlice();
    public static final WritableSlice<JetElement, Boolean> STATEMENT = Slices.createRemovableSetSlice();
    public static final WritableSlice<CallableMemberDescriptor, Boolean> DELEGATED = Slices.createRemovableSetSlice();
    public static final WritableSlice<VariableDescriptor, Boolean> MUST_BE_WRAPPED_IN_A_REF = Slices.createSimpleSetSlice();
    public static final WritableSlice<Box<DeferredType>, Boolean> DEFERRED_TYPE = Slices.createCollectiveSetSlice();
    public static final WritableSlice<PropertyDescriptor, Boolean> BACKING_FIELD_REQUIRED = new Slices.SetSlice<PropertyDescriptor>(RewritePolicy.DO_NOTHING){

        @Override
        public Boolean computeValue(SlicedMap map, PropertyDescriptor propertyDescriptor, Boolean backingFieldRequired, boolean valueNotFound) {
            if (propertyDescriptor.getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
                return false;
            }
            backingFieldRequired = valueNotFound ? false : backingFieldRequired;
            assert (backingFieldRequired != null);
            PsiElement declarationPsiElement = map.get(DESCRIPTOR_TO_DECLARATION, propertyDescriptor);
            if (declarationPsiElement instanceof JetParameter) {
                JetParameter jetParameter = (JetParameter)declarationPsiElement;
                return jetParameter.getValOrVarNode() != null || backingFieldRequired != false;
            }
            if (propertyDescriptor.getModality() == Modality.ABSTRACT) {
                return false;
            }
            PropertyGetterDescriptor getter = propertyDescriptor.getGetter();
            PropertySetterDescriptor setter = propertyDescriptor.getSetter();
            if (getter == null) {
                return true;
            }
            if (propertyDescriptor.isVar() && setter == null) {
                return true;
            }
            if (setter != null && !setter.hasBody() && setter.getModality() != Modality.ABSTRACT) {
                return true;
            }
            if (!getter.hasBody() && getter.getModality() != Modality.ABSTRACT) {
                return true;
            }
            return backingFieldRequired;
        }
    };
    public static final WritableSlice<PropertyDescriptor, Boolean> IS_INITIALIZED = Slices.createSimpleSetSlice();
    public static final WritableSlice<JetFunctionLiteralExpression, Boolean> BLOCK = new Slices.SetSlice<JetFunctionLiteralExpression>(RewritePolicy.DO_NOTHING){

        @Override
        public Boolean computeValue(SlicedMap map, JetFunctionLiteralExpression expression, Boolean isBlock, boolean valueNotFound) {
            isBlock = valueNotFound ? false : isBlock;
            assert (isBlock != null);
            return isBlock != false && !expression.getFunctionLiteral().hasParameterSpecification();
        }
    };
    public static final Slices.KeyNormalizer<DeclarationDescriptor> DECLARATION_DESCRIPTOR_NORMALIZER = new Slices.KeyNormalizer<DeclarationDescriptor>(){

        @Override
        public DeclarationDescriptor normalize(DeclarationDescriptor declarationDescriptor) {
            CallableMemberDescriptor callable;
            if (declarationDescriptor instanceof CallableMemberDescriptor && (callable = (CallableMemberDescriptor)declarationDescriptor).getKind() != CallableMemberDescriptor.Kind.DECLARATION) {
                Set<? extends CallableMemberDescriptor> overriddenDescriptors = callable.getOverriddenDescriptors();
                if (overriddenDescriptors.size() != 1) {
                    throw new IllegalStateException("cannot find declaration: fake descriptor has more then one overriden descriptor: " + declarationDescriptor);
                }
                return this.normalize(overriddenDescriptors.iterator().next());
            }
            if (declarationDescriptor instanceof VariableAsFunctionDescriptor) {
                VariableAsFunctionDescriptor descriptor = (VariableAsFunctionDescriptor)declarationDescriptor;
                return descriptor.getVariableDescriptor().getOriginal();
            }
            return declarationDescriptor.getOriginal();
        }
    };
    public static final ReadOnlySlice<DeclarationDescriptor, PsiElement> DESCRIPTOR_TO_DECLARATION = Slices.sliceBuilder().setKeyNormalizer(DECLARATION_DESCRIPTOR_NORMALIZER).build();
    public static final WritableSlice<PsiElement, NamespaceDescriptor> NAMESPACE = Slices.sliceBuilder().setOpposite((WritableSlice)DESCRIPTOR_TO_DECLARATION).build();
    public static final WritableSlice<PsiElement, ClassDescriptor> CLASS = Slices.sliceBuilder().setOpposite((WritableSlice)DESCRIPTOR_TO_DECLARATION).build();
    public static final WritableSlice<JetTypeParameter, TypeParameterDescriptor> TYPE_PARAMETER = Slices.sliceBuilder().setOpposite((WritableSlice)DESCRIPTOR_TO_DECLARATION).build();
    public static final WritableSlice<PsiElement, SimpleFunctionDescriptor> FUNCTION = Slices.sliceBuilder().setOpposite((WritableSlice)DESCRIPTOR_TO_DECLARATION).build();
    public static final WritableSlice<PsiElement, ConstructorDescriptor> CONSTRUCTOR = Slices.sliceBuilder().setOpposite((WritableSlice)DESCRIPTOR_TO_DECLARATION).build();
    public static final WritableSlice<PsiElement, VariableDescriptor> VARIABLE = Slices.sliceBuilder().setOpposite((WritableSlice)DESCRIPTOR_TO_DECLARATION).build();
    public static final WritableSlice<JetParameter, VariableDescriptor> VALUE_PARAMETER = Slices.sliceBuilder().setOpposite((WritableSlice)DESCRIPTOR_TO_DECLARATION).build();
    public static final WritableSlice<JetPropertyAccessor, PropertyAccessorDescriptor> PROPERTY_ACCESSOR = Slices.sliceBuilder().setOpposite((WritableSlice)DESCRIPTOR_TO_DECLARATION).build();
    public static final WritableSlice<PsiElement, PropertyDescriptor> PRIMARY_CONSTRUCTOR_PARAMETER = Slices.sliceBuilder().setOpposite((WritableSlice)DESCRIPTOR_TO_DECLARATION).build();
    public static final WritableSlice<JetObjectDeclarationName, PropertyDescriptor> OBJECT_DECLARATION = Slices.sliceBuilder().setOpposite((WritableSlice)DESCRIPTOR_TO_DECLARATION).build();
    public static final WritableSlice[] DECLARATIONS_TO_DESCRIPTORS = new WritableSlice[]{NAMESPACE, CLASS, TYPE_PARAMETER, FUNCTION, CONSTRUCTOR, VARIABLE, VALUE_PARAMETER, PROPERTY_ACCESSOR, PRIMARY_CONSTRUCTOR_PARAMETER, OBJECT_DECLARATION};
    public static final ReadOnlySlice<PsiElement, DeclarationDescriptor> DECLARATION_TO_DESCRIPTOR = Slices.sliceBuilder().setFurtherLookupSlices(DECLARATIONS_TO_DESCRIPTORS).build();
    public static final WritableSlice<JetReferenceExpression, PsiElement> LABEL_TARGET = Slices.sliceBuilder().build();
    public static final WritableSlice<JetParameter, PropertyDescriptor> VALUE_PARAMETER_AS_PROPERTY = Slices.sliceBuilder().build();
    public static final WritableSlice<String, ClassDescriptor> FQNAME_TO_CLASS_DESCRIPTOR = new BasicWritableSlice<String, ClassDescriptor>(RewritePolicy.DO_NOTHING, true);
    public static final WritableSlice<String, NamespaceDescriptor> FQNAME_TO_NAMESPACE_DESCRIPTOR = new BasicWritableSlice<String, NamespaceDescriptor>(RewritePolicy.DO_NOTHING);
    public static final WritableSlice<ClassDescriptor, Boolean> INCOMPLETE_HIERARCHY = Slices.createCollectiveSetSlice();
    @Deprecated
    public static final Void _static_initializer = BasicWritableSlice.initSliceDebugNames(BindingContext.class);

    public Collection<Diagnostic> getDiagnostics();

    @Nullable
    public <K, V> V get(ReadOnlySlice<K, V> var1, K var2);

    @NotNull
    public <K, V> Collection<K> getKeys(WritableSlice<K, V> var1);
}

