/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.resolve;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.JetSemanticServices;
import org.jetbrains.jet.lang.descriptors.FunctionDescriptor;
import org.jetbrains.jet.lang.descriptors.ValueParameterDescriptor;
import org.jetbrains.jet.lang.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.jet.lang.psi.JetAnnotationEntry;
import org.jetbrains.jet.lang.psi.JetConstantExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetStringTemplateExpression;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.resolve.BindingContext;
import org.jetbrains.jet.lang.resolve.BindingTrace;
import org.jetbrains.jet.lang.resolve.calls.CallMaker;
import org.jetbrains.jet.lang.resolve.calls.CallResolver;
import org.jetbrains.jet.lang.resolve.calls.OverloadResolutionResults;
import org.jetbrains.jet.lang.resolve.calls.ResolvedValueArgument;
import org.jetbrains.jet.lang.resolve.calls.autocasts.DataFlowInfo;
import org.jetbrains.jet.lang.resolve.constants.CompileTimeConstant;
import org.jetbrains.jet.lang.resolve.scopes.JetScope;
import org.jetbrains.jet.lang.resolve.scopes.receivers.ReceiverDescriptor;
import org.jetbrains.jet.lang.types.ErrorUtils;
import org.jetbrains.jet.lang.types.JetType;
import org.jetbrains.jet.lang.types.TypeUtils;
import org.jetbrains.jet.lang.types.expressions.ExpressionTypingServices;

public class AnnotationResolver {
    private final BindingTrace trace;
    private final JetSemanticServices semanticServices;
    private final CallResolver callResolver;

    public AnnotationResolver(JetSemanticServices semanticServices, BindingTrace trace) {
        this.trace = trace;
        this.callResolver = new CallResolver(semanticServices, DataFlowInfo.EMPTY);
        this.semanticServices = semanticServices;
    }

    @NotNull
    public List<AnnotationDescriptor> resolveAnnotations(@NotNull JetScope scope, @Nullable JetModifierList modifierList) {
        if (modifierList == null) {
            return Collections.emptyList();
        }
        return this.resolveAnnotations(scope, modifierList.getAnnotationEntries());
    }

    @NotNull
    public List<AnnotationDescriptor> resolveAnnotations(@NotNull JetScope scope, @NotNull List<JetAnnotationEntry> annotationEntryElements) {
        if (annotationEntryElements.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList result = Lists.newArrayList();
        for (JetAnnotationEntry entryElement : annotationEntryElements) {
            AnnotationDescriptor descriptor = new AnnotationDescriptor();
            this.resolveAnnotationStub(scope, entryElement, descriptor);
            result.add(descriptor);
        }
        return result;
    }

    public void resolveAnnotationStub(@NotNull JetScope scope, @NotNull JetAnnotationEntry entryElement, @NotNull AnnotationDescriptor descriptor) {
        OverloadResolutionResults<FunctionDescriptor> results = this.resolveType(scope, entryElement, descriptor);
        this.resolveArguments(results, descriptor);
    }

    @NotNull
    private OverloadResolutionResults<FunctionDescriptor> resolveType(@NotNull JetScope scope, @NotNull JetAnnotationEntry entryElement, @NotNull AnnotationDescriptor descriptor) {
        OverloadResolutionResults<FunctionDescriptor> results = this.callResolver.resolveCall(this.trace, scope, CallMaker.makeCall(ReceiverDescriptor.NO_RECEIVER, null, entryElement), TypeUtils.NO_EXPECTED_TYPE);
        JetType annotationType = results.getResultingDescriptor().getReturnType();
        if (results.isSuccess()) {
            descriptor.setAnnotationType(annotationType);
        } else {
            descriptor.setAnnotationType(ErrorUtils.createErrorType("Unresolved annotation type"));
        }
        return results;
    }

    private void resolveArguments(@NotNull OverloadResolutionResults<FunctionDescriptor> results, @NotNull AnnotationDescriptor descriptor) {
        ArrayList arguments = Lists.newArrayList();
        for (Map.Entry<ValueParameterDescriptor, ResolvedValueArgument> descriptorToArgument : results.getResultingCall().getValueArguments().entrySet()) {
            List<JetExpression> argumentExpressions = descriptorToArgument.getValue().getArgumentExpressions();
            ValueParameterDescriptor parameterDescriptor = descriptorToArgument.getKey();
            for (JetExpression argument : argumentExpressions) {
                arguments.add(this.resolveAnnotationArgument(argument, parameterDescriptor.getType()));
            }
        }
        descriptor.setValueArguments(arguments);
    }

    @Nullable
    public CompileTimeConstant<?> resolveAnnotationArgument(@NotNull JetExpression expression, final @NotNull JetType expectedType) {
        JetVisitor visitor = new JetVisitor<CompileTimeConstant<?>, Void>(){

            @Override
            public CompileTimeConstant<?> visitConstantExpression(JetConstantExpression expression, Void nothing) {
                ExpressionTypingServices typeInferrerServices = AnnotationResolver.this.semanticServices.getTypeInferrerServices(AnnotationResolver.this.trace);
                JetType type = typeInferrerServices.getType(JetScope.EMPTY, expression, expectedType, DataFlowInfo.EMPTY);
                if (type == null) {
                    // empty if block
                }
                return AnnotationResolver.this.trace.get(BindingContext.COMPILE_TIME_VALUE, expression);
            }

            @Override
            public CompileTimeConstant<?> visitParenthesizedExpression(JetParenthesizedExpression expression, Void nothing) {
                JetExpression innerExpression = expression.getExpression();
                if (innerExpression == null) {
                    return null;
                }
                return (CompileTimeConstant)innerExpression.accept(this, null);
            }

            @Override
            public CompileTimeConstant<?> visitStringTemplateExpression(JetStringTemplateExpression expression, Void nothing) {
                return AnnotationResolver.this.trace.get(BindingContext.COMPILE_TIME_VALUE, expression);
            }

            @Override
            public CompileTimeConstant<?> visitJetElement(JetElement element, Void nothing) {
                return null;
            }
        };
        return (CompileTimeConstant)expression.accept(visitor, null);
    }

    @NotNull
    public List<AnnotationDescriptor> createAnnotationStubs(@Nullable JetModifierList modifierList) {
        if (modifierList == null) {
            return Collections.emptyList();
        }
        return this.createAnnotationStubs(modifierList.getAnnotationEntries());
    }

    @NotNull
    public List<AnnotationDescriptor> createAnnotationStubs(List<JetAnnotationEntry> annotations) {
        ArrayList result = Lists.newArrayList();
        for (JetAnnotationEntry annotation : annotations) {
            AnnotationDescriptor annotationDescriptor = new AnnotationDescriptor();
            result.add(annotationDescriptor);
            this.trace.record(BindingContext.ANNOTATION, annotation, annotationDescriptor);
        }
        return result;
    }
}

