/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetProjectionKind;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lexer.JetTokens;

public class JetTypeProjection
extends JetDeclaration {
    public JetTypeProjection(@NotNull ASTNode node) {
        super(node);
    }

    @NotNull
    public JetProjectionKind getProjectionKind() {
        ASTNode projectionNode = this.getProjectionNode();
        if (projectionNode == null) {
            return JetProjectionKind.NONE;
        }
        if (projectionNode.getElementType() == JetTokens.IN_KEYWORD) {
            return JetProjectionKind.IN;
        }
        if (projectionNode.getElementType() == JetTokens.OUT_KEYWORD) {
            return JetProjectionKind.OUT;
        }
        if (projectionNode.getElementType() == JetTokens.MUL) {
            return JetProjectionKind.STAR;
        }
        throw new IllegalStateException(projectionNode.getText());
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        visitor.visitTypeProjection(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data) {
        return visitor.visitTypeProjection(this, data);
    }

    @Nullable
    public JetTypeReference getTypeReference() {
        return (JetTypeReference)this.findChildByType(JetNodeTypes.TYPE_REFERENCE);
    }

    @Nullable
    public ASTNode getProjectionNode() {
        PsiElement star;
        JetModifierList modifierList = this.getModifierList();
        if (modifierList != null) {
            ASTNode node = modifierList.getModifierNode(JetTokens.IN_KEYWORD);
            if (node != null) {
                return node;
            }
            node = modifierList.getModifierNode(JetTokens.OUT_KEYWORD);
            if (node != null) {
                return node;
            }
        }
        if ((star = this.findChildByType(JetTokens.MUL)) != null) {
            return star.getNode();
        }
        return null;
    }
}

