/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.parsing.JetExpressionParsing;
import org.jetbrains.jet.lang.psi.JetCallExpression;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetQualifiedExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lexer.JetTokens;

public class JetSimpleNameExpression
extends JetReferenceExpression {
    public static final TokenSet REFERENCE_TOKENS = TokenSet.orSet((TokenSet[])new TokenSet[]{JetTokens.LABELS, TokenSet.create((IElementType[])new IElementType[]{JetTokens.IDENTIFIER, JetTokens.FIELD_IDENTIFIER, JetTokens.THIS_KEYWORD, JetTokens.SUPER_KEYWORD})});

    public JetSimpleNameExpression(@NotNull ASTNode node) {
        super(node);
    }

    @Nullable
    public JetExpression getReceiverExpression() {
        JetCallExpression callExpression;
        PsiElement parent = this.getParent();
        if (parent instanceof JetQualifiedExpression && !this.isImportDirectiveExpression()) {
            JetQualifiedExpression qualifiedExpression = (JetQualifiedExpression)parent;
            if (!this.isFirstPartInQualifiedExpression(qualifiedExpression)) {
                return qualifiedExpression.getReceiverExpression();
            }
        } else if (parent instanceof JetCallExpression && (parent = (callExpression = (JetCallExpression)parent).getParent()) instanceof JetQualifiedExpression) {
            JetQualifiedExpression qualifiedExpression = (JetQualifiedExpression)parent;
            return qualifiedExpression.getReceiverExpression();
        }
        return null;
    }

    private boolean isFirstPartInQualifiedExpression(JetQualifiedExpression qualifiedExpression) {
        if (qualifiedExpression.getParent() instanceof JetQualifiedExpression) {
            return this.isFirstPartInQualifiedExpression((JetQualifiedExpression)qualifiedExpression.getParent());
        }
        return qualifiedExpression.getFirstChild() == this;
    }

    public boolean isImportDirectiveExpression() {
        PsiElement parent = this.getParent();
        if (parent == null) {
            return false;
        }
        return parent instanceof JetImportDirective || parent.getParent() instanceof JetImportDirective;
    }

    @JetElement.IfNotParsed
    @Nullable
    public String getReferencedName() {
        String text = this.getReferencedNameElement().getNode().getText();
        return text != null ? JetPsiUtil.unquoteIdentifierOrFieldReference(text) : null;
    }

    @NotNull
    public PsiElement getReferencedNameElement() {
        PsiElement element = this.findChildByType(REFERENCE_TOKENS);
        if (element == null) {
            element = this.findChildByType(JetExpressionParsing.ALL_OPERATIONS);
        }
        if (element != null) {
            return element;
        }
        return this;
    }

    @JetElement.IfNotParsed
    @Nullable
    public IElementType getReferencedNameElementType() {
        return this.getReferencedNameElement().getNode().getElementType();
    }

    @NotNull
    public PsiReference[] getReferences() {
        return ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, (PsiReferenceService.Hints)PsiReferenceService.Hints.NO_HINTS);
    }

    @Nullable
    public PsiReference getReference() {
        PsiReference[] references = this.getReferences();
        if (references.length == 1) {
            return references[0];
        }
        return null;
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        visitor.visitSimpleNameExpression(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data) {
        return visitor.visitSimpleNameExpression(this, data);
    }
}

