/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.impl.CheckUtil;
import com.intellij.psi.impl.source.codeStyle.CodeEditUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetBinaryExpressionWithTypeRHS;
import org.jetbrains.jet.lang.psi.JetBindingPattern;
import org.jetbrains.jet.lang.psi.JetBlockExpression;
import org.jetbrains.jet.lang.psi.JetClassBody;
import org.jetbrains.jet.lang.psi.JetClassObject;
import org.jetbrains.jet.lang.psi.JetClassOrObject;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFunctionLiteral;
import org.jetbrains.jet.lang.psi.JetIfExpression;
import org.jetbrains.jet.lang.psi.JetImportDirective;
import org.jetbrains.jet.lang.psi.JetNamedFunction;
import org.jetbrains.jet.lang.psi.JetNamespaceHeader;
import org.jetbrains.jet.lang.psi.JetObjectDeclaration;
import org.jetbrains.jet.lang.psi.JetParenthesizedExpression;
import org.jetbrains.jet.lang.psi.JetPattern;
import org.jetbrains.jet.lang.psi.JetPrefixExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.psi.JetWhenCondition;
import org.jetbrains.jet.lang.psi.JetWhenConditionIsPattern;
import org.jetbrains.jet.lang.psi.JetWhenEntry;
import org.jetbrains.jet.lang.psi.JetWhenExpression;
import org.jetbrains.jet.lang.psi.JetWildcardPattern;
import org.jetbrains.jet.lexer.JetTokens;

public class JetPsiUtil {
    public static final String NO_NAME_PROVIDED = "<no name provided>";

    @Nullable
    public static JetExpression deparenthesize(@NotNull JetExpression expression) {
        JetExpression baseExpression;
        if (expression instanceof JetBinaryExpressionWithTypeRHS) {
            JetSimpleNameExpression operationSign = ((JetBinaryExpressionWithTypeRHS)expression).getOperationSign();
            if (((Object)((Object)JetTokens.COLON)).equals(operationSign.getReferencedNameElementType())) {
                expression = ((JetBinaryExpressionWithTypeRHS)expression).getLeft();
            }
        } else if (expression instanceof JetPrefixExpression && JetTokens.LABELS.contains(((JetPrefixExpression)expression).getOperationReference().getReferencedNameElementType()) && (baseExpression = ((JetPrefixExpression)expression).getBaseExpression()) != null) {
            expression = baseExpression;
        }
        if (expression instanceof JetParenthesizedExpression) {
            JetExpression innerExpression = ((JetParenthesizedExpression)expression).getExpression();
            return innerExpression != null ? JetPsiUtil.deparenthesize(innerExpression) : null;
        }
        return expression;
    }

    @NotNull
    public static String safeName(String name) {
        return name == null ? NO_NAME_PROVIDED : name;
    }

    @NotNull
    public static Set<JetElement> findRootExpressions(@NotNull Collection<JetElement> unreachableElements) {
        HashSet<JetElement> rootElements = new HashSet<JetElement>();
        final HashSet shadowedElements = new HashSet();
        JetVisitorVoid shadowAllChildren = new JetVisitorVoid(){

            @Override
            public void visitJetElement(JetElement element) {
                if (shadowedElements.add(element)) {
                    element.acceptChildren(this);
                }
            }
        };
        for (JetElement element : unreachableElements) {
            if (shadowedElements.contains((Object)element)) continue;
            element.acceptChildren(shadowAllChildren);
            rootElements.removeAll(shadowedElements);
            rootElements.add(element);
        }
        return rootElements;
    }

    @Nullable
    public static JetNamedFunction getSurroundingFunction(@Nullable PsiElement element) {
        while (element != null) {
            if (element instanceof JetNamedFunction) {
                return (JetNamedFunction)element;
            }
            if (element instanceof JetClassOrObject || element instanceof JetFile) {
                return null;
            }
            element = element.getParent();
        }
        return null;
    }

    @NotNull
    public static String unquoteIdentifier(@NotNull String quoted) {
        if (quoted.indexOf(96) < 0) {
            return quoted;
        }
        if (quoted.startsWith("`") && quoted.endsWith("`") && quoted.length() >= 2) {
            return quoted.substring(1, quoted.length() - 1);
        }
        return quoted;
    }

    @NotNull
    public static String unquoteIdentifierOrFieldReference(@NotNull String quoted) {
        if (quoted.indexOf(96) < 0) {
            return quoted;
        }
        if (quoted.startsWith("$")) {
            return "$" + JetPsiUtil.unquoteIdentifier(quoted.substring(1));
        }
        return JetPsiUtil.unquoteIdentifier(quoted);
    }

    private static String getFQName(JetNamespaceHeader header) {
        StringBuilder builder = new StringBuilder();
        for (JetSimpleNameExpression nameExpression : header.getParentNamespaceNames()) {
            builder.append(nameExpression.getReferencedName());
            builder.append(".");
        }
        builder.append(header.getName());
        return builder.toString();
    }

    public static String getFQName(JetFile file) {
        return JetPsiUtil.getFQName(file.getNamespaceHeader());
    }

    public static String getFQName(JetClassOrObject jetClass) {
        PsiElement parent = jetClass.getParent();
        if (parent instanceof JetFile) {
            return JetPsiUtil.makeFQName(JetPsiUtil.getFQName((JetFile)parent), jetClass);
        }
        while (parent instanceof JetClassBody) {
            if (!((parent = parent.getParent()) instanceof JetObjectDeclaration) || !(parent.getParent() instanceof JetClassObject)) continue;
            parent = parent.getParent().getParent();
        }
        if (parent instanceof JetClassOrObject) {
            return JetPsiUtil.makeFQName(JetPsiUtil.getFQName((JetClassOrObject)parent), jetClass);
        }
        return jetClass.getName();
    }

    @JetElement.IfNotParsed
    @Nullable
    public static String getImportPath(JetImportDirective importDirective) {
        JetExpression importedReference = importDirective.getImportedReference();
        if (importedReference == null) {
            return null;
        }
        String text = importedReference.getText();
        return text.replaceAll(" ", "") + (importDirective.isAllUnder() ? ".*" : "");
    }

    private static String makeFQName(String prefix, JetClassOrObject jetClass) {
        return (prefix == null || prefix.length() == 0 ? "" : prefix + ".") + jetClass.getName();
    }

    public static boolean isIrrefutable(JetWhenEntry entry) {
        if (entry.isElse()) {
            return true;
        }
        for (JetWhenCondition condition : entry.getConditions()) {
            JetBindingPattern bindingPattern;
            if (!(condition instanceof JetWhenConditionIsPattern)) continue;
            JetPattern pattern = ((JetWhenConditionIsPattern)condition).getPattern();
            if (pattern instanceof JetWildcardPattern) {
                return true;
            }
            if (!(pattern instanceof JetBindingPattern) || (bindingPattern = (JetBindingPattern)pattern).getVariableDeclaration().getPropertyTypeRef() != null || bindingPattern.getCondition() != null) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static <T extends PsiElement> T getDirectParentOfTypeForBlock(@NotNull JetBlockExpression block, @NotNull Class<T> aClass) {
        JetFunctionLiteral functionLiteral;
        JetIfExpression ifExpression;
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)block, aClass);
        if (parent instanceof JetIfExpression && ((ifExpression = (JetIfExpression)parent).getElse() == block || ifExpression.getThen() == block)) {
            return (T)parent;
        }
        if (parent instanceof JetWhenExpression) {
            JetWhenExpression whenExpression = (JetWhenExpression)parent;
            for (JetWhenEntry whenEntry : whenExpression.getEntries()) {
                if (whenEntry.getExpression() != block) continue;
                return (T)parent;
            }
        }
        if (parent instanceof JetFunctionLiteral && (functionLiteral = (JetFunctionLiteral)parent).getBodyExpression() == block) {
            return (T)parent;
        }
        return null;
    }

    public static boolean isImplicitlyUsed(@NotNull JetElement element) {
        PsiElement parent = element.getParent();
        if (!(parent instanceof JetBlockExpression)) {
            return true;
        }
        JetBlockExpression block = (JetBlockExpression)parent;
        List<JetElement> statements = block.getStatements();
        if (statements.get(statements.size() - 1) == element) {
            JetExpression expression = JetPsiUtil.getDirectParentOfTypeForBlock(block, JetIfExpression.class);
            if (expression == null) {
                expression = JetPsiUtil.getDirectParentOfTypeForBlock(block, JetWhenExpression.class);
            }
            if (expression == null) {
                expression = JetPsiUtil.getDirectParentOfTypeForBlock(block, JetFunctionLiteral.class);
            }
            if (expression != null) {
                return JetPsiUtil.isImplicitlyUsed(expression);
            }
        }
        return false;
    }

    public static void deleteClass(@NotNull JetClassOrObject clazz) {
        CheckUtil.checkWritable((PsiElement)clazz);
        JetFile file = (JetFile)clazz.getContainingFile();
        List<JetDeclaration> declarations = file.getDeclarations();
        if (declarations.size() == 1) {
            file.delete();
        } else {
            PsiElement parent = clazz.getParent();
            CodeEditUtil.removeChild((ASTNode)parent.getNode(), (ASTNode)clazz.getNode());
        }
    }
}

