/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetModifierList;
import org.jetbrains.jet.lang.psi.JetNamedDeclaration;
import org.jetbrains.jet.lang.psi.JetTypeReference;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lexer.JetTokens;

public class JetParameter
extends JetNamedDeclaration {
    public JetParameter(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        visitor.visitParameter(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data) {
        return visitor.visitParameter(this, data);
    }

    @Nullable
    public JetTypeReference getTypeReference() {
        return (JetTypeReference)this.findChildByType(JetNodeTypes.TYPE_REFERENCE);
    }

    @Nullable
    public JetExpression getDefaultValue() {
        boolean passedEQ = false;
        for (ASTNode child = this.getNode().getFirstChildNode(); child != null; child = child.getTreeNext()) {
            if (child.getElementType() == JetTokens.EQ) {
                passedEQ = true;
            }
            if (!passedEQ || !(child.getPsi() instanceof JetExpression)) continue;
            return (JetExpression)child.getPsi();
        }
        return null;
    }

    public boolean isMutable() {
        return this.findChildByType(JetTokens.VAR_KEYWORD) != null;
    }

    public boolean isVarArg() {
        JetModifierList modifierList = this.getModifierList();
        return modifierList != null && modifierList.getModifierNode(JetTokens.VARARG_KEYWORD) != null;
    }

    @Nullable
    public ASTNode getValOrVarNode() {
        ASTNode val = this.getNode().findChildByType((IElementType)JetTokens.VAL_KEYWORD);
        if (val != null) {
            return val;
        }
        return this.getNode().findChildByType((IElementType)JetTokens.VAR_KEYWORD);
    }
}

