/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.StubBasedPsiElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.StubElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetFile;
import org.jetbrains.jet.lang.psi.JetFunction;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetTypeParameterList;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.psi.stubs.PsiJetFunctionStub;
import org.jetbrains.jet.lang.psi.stubs.elements.JetStubElementTypes;
import org.jetbrains.jet.lexer.JetTokens;

public class JetNamedFunction
extends JetFunction
implements StubBasedPsiElement<PsiJetFunctionStub<?>> {
    public JetNamedFunction(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        visitor.visitNamedFunction(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data) {
        return visitor.visitNamedFunction(this, data);
    }

    public boolean hasTypeParameterListBeforeFunctionName() {
        JetTypeParameterList typeParameterList = this.getTypeParameterList();
        if (typeParameterList == null) {
            return false;
        }
        PsiElement nameIdentifier = this.getNameIdentifier();
        if (nameIdentifier == null) {
            return false;
        }
        return nameIdentifier.getTextOffset() > typeParameterList.getTextOffset();
    }

    @Override
    public boolean hasBlockBody() {
        return this.getEqualsToken() == null;
    }

    @Nullable
    public PsiElement getEqualsToken() {
        return this.findChildByType(JetTokens.EQ);
    }

    @NotNull
    public JetElement getStartOfSignatureElement() {
        return this;
    }

    @NotNull
    public JetElement getEndOfSignatureElement() {
        JetElement r = this.getReturnTypeRef();
        if (r != null) {
            return r;
        }
        r = this.getValueParameterList();
        if (r != null) {
            return r;
        }
        return this;
    }

    @Nullable
    public String getQualifiedName() {
        PsiElement parent;
        StubElement stub = this.getStub();
        if (stub != null) {
            // empty if block
        }
        if ((parent = this.getParent()) instanceof JetFile) {
            JetFile jetFile = (JetFile)parent;
            String fileFQN = JetPsiUtil.getFQName(jetFile);
            if (!fileFQN.isEmpty()) {
                return fileFQN + "." + this.getName();
            }
            return this.getName();
        }
        return null;
    }

    public IStubElementType getElementType() {
        return JetStubElementTypes.FUNCTION;
    }

    public PsiJetFunctionStub<?> getStub() {
        return null;
    }
}

