/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.lang.psi.JetDeclaration;
import org.jetbrains.jet.lang.psi.JetPsiFactory;
import org.jetbrains.jet.lang.psi.JetPsiUtil;
import org.jetbrains.jet.lang.psi.JetStatementExpression;
import org.jetbrains.jet.lexer.JetTokens;

public abstract class JetNamedDeclaration
extends JetDeclaration
implements PsiNameIdentifierOwner,
JetStatementExpression {
    public JetNamedDeclaration(@NotNull ASTNode node) {
        super(node);
    }

    public String getName() {
        PsiElement identifier = this.getNameIdentifier();
        if (identifier != null) {
            String text = identifier.getText();
            return text != null ? JetPsiUtil.unquoteIdentifier(text) : null;
        }
        return null;
    }

    public PsiElement getNameIdentifier() {
        return this.findChildByType(JetTokens.IDENTIFIER);
    }

    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        return this.getNameIdentifier().replace(JetPsiFactory.createNameIdentifier(this.getProject(), name));
    }

    public int getTextOffset() {
        PsiElement identifier = this.getNameIdentifier();
        return identifier != null ? identifier.getTextRange().getStartOffset() : this.getTextRange().getStartOffset();
    }
}

