/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetContainerNode;
import org.jetbrains.jet.lang.psi.JetElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetSimpleNameExpression;

public class JetLabelQualifiedExpression
extends JetExpression {
    public JetLabelQualifiedExpression(@NotNull ASTNode node) {
        super(node);
    }

    @Nullable
    public JetSimpleNameExpression getTargetLabel() {
        JetContainerNode qualifier = (JetContainerNode)this.findChildByType(JetNodeTypes.LABEL_QUALIFIER);
        if (qualifier == null) {
            return null;
        }
        return (JetSimpleNameExpression)qualifier.findChildByType(JetNodeTypes.LABEL_REFERENCE);
    }

    @JetElement.IfNotParsed
    @Nullable
    public JetExpression getLabeledExpression() {
        return (JetExpression)((Object)this.findChildByClass(JetExpression.class));
    }

    @Nullable
    public String getLabelName() {
        JetSimpleNameExpression labelElement = this.getTargetLabel();
        assert (labelElement == null || labelElement.getText().startsWith("@"));
        return labelElement == null ? null : labelElement.getText().substring(1);
    }
}

