/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.intellij.lang.ASTNode;
import com.intellij.psi.PsiElement;
import com.intellij.util.SmartList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetCallElement;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetFunctionLiteralExpression;
import org.jetbrains.jet.lang.psi.JetPrefixExpression;
import org.jetbrains.jet.lang.psi.JetTypeArgumentList;
import org.jetbrains.jet.lang.psi.JetTypeProjection;
import org.jetbrains.jet.lang.psi.JetValueArgumentList;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lang.psi.ValueArgument;
import org.jetbrains.jet.lexer.JetTokens;

public class JetCallExpression
extends JetExpression
implements JetCallElement {
    public JetCallExpression(@NotNull ASTNode node) {
        super(node);
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        visitor.visitCallExpression(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data) {
        return visitor.visitCallExpression(this, data);
    }

    @Override
    @Nullable
    public JetExpression getCalleeExpression() {
        return (JetExpression)((Object)this.findChildByClass(JetExpression.class));
    }

    @Override
    @Nullable
    public JetValueArgumentList getValueArgumentList() {
        return (JetValueArgumentList)this.findChildByType(JetNodeTypes.VALUE_ARGUMENT_LIST);
    }

    @Override
    @Nullable
    public JetTypeArgumentList getTypeArgumentList() {
        return (JetTypeArgumentList)this.findChildByType(JetNodeTypes.TYPE_ARGUMENT_LIST);
    }

    @Override
    @NotNull
    public List<JetExpression> getFunctionLiteralArguments() {
        SmartList result = new SmartList();
        for (ASTNode node = (calleeExpression = this.getCalleeExpression()) instanceof JetFunctionLiteralExpression ? calleeExpression.getNode().getTreeNext() : this.getNode().getFirstChildNode(); node != null; node = node.getTreeNext()) {
            JetExpression labeledExpression;
            JetPrefixExpression prefixExpression;
            PsiElement psi = node.getPsi();
            if (psi instanceof JetFunctionLiteralExpression) {
                result.add((JetFunctionLiteralExpression)psi);
                continue;
            }
            if (!(psi instanceof JetPrefixExpression) || !JetTokens.LABELS.contains((prefixExpression = (JetPrefixExpression)psi).getOperationReference().getReferencedNameElementType()) || !((labeledExpression = prefixExpression.getBaseExpression()) instanceof JetFunctionLiteralExpression)) continue;
            result.add(labeledExpression);
        }
        return result;
    }

    @Override
    @NotNull
    public List<? extends ValueArgument> getValueArguments() {
        JetValueArgumentList list = this.getValueArgumentList();
        return list != null ? list.getArguments() : Collections.emptyList();
    }

    @Override
    @NotNull
    public List<JetTypeProjection> getTypeArguments() {
        JetTypeArgumentList list = this.getTypeArgumentList();
        return list != null ? list.getArguments() : Collections.emptyList();
    }
}

