/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jet.lang.psi;

import com.google.common.collect.Lists;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceService;
import com.intellij.psi.impl.source.resolve.reference.ReferenceProvidersRegistry;
import com.intellij.psi.util.PsiTreeUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jet.JetNodeTypes;
import org.jetbrains.jet.lang.psi.JetContainerNode;
import org.jetbrains.jet.lang.psi.JetExpression;
import org.jetbrains.jet.lang.psi.JetReferenceExpression;
import org.jetbrains.jet.lang.psi.JetVisitor;
import org.jetbrains.jet.lang.psi.JetVisitorVoid;
import org.jetbrains.jet.lexer.JetTokens;

public class JetArrayAccessExpression
extends JetReferenceExpression {
    public JetArrayAccessExpression(@NotNull ASTNode node) {
        super(node);
    }

    @NotNull
    public PsiReference[] getReferences() {
        return ReferenceProvidersRegistry.getReferencesFromProviders((PsiElement)this, (PsiReferenceService.Hints)PsiReferenceService.Hints.NO_HINTS);
    }

    @Override
    public void accept(@NotNull JetVisitorVoid visitor) {
        visitor.visitArrayAccessExpression(this);
    }

    @Override
    public <R, D> R accept(@NotNull JetVisitor<R, D> visitor, D data) {
        return visitor.visitArrayAccessExpression(this, data);
    }

    @NotNull
    public JetExpression getArrayExpression() {
        JetExpression baseExpression = (JetExpression)((Object)this.findChildByClass(JetExpression.class));
        assert (baseExpression != null);
        return baseExpression;
    }

    @NotNull
    public List<JetExpression> getIndexExpressions() {
        JetContainerNode container = this.getIndicesNode();
        if (container == null) {
            return Collections.emptyList();
        }
        return PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)container, JetExpression.class);
    }

    @NotNull
    public JetContainerNode getIndicesNode() {
        return (JetContainerNode)this.findChildByType(JetNodeTypes.INDICES);
    }

    public List<TextRange> getBracketRanges() {
        TextRange lBracket = this.getIndicesNode().findChildByType(JetTokens.LBRACKET).getTextRange();
        TextRange rBracket = this.getIndicesNode().findChildByType(JetTokens.RBRACKET).getTextRange();
        return Lists.newArrayList((Object[])new TextRange[]{lBracket, rBracket});
    }
}

